/*
 * All content copyright http://www.j2eefast.com, unless
 * otherwise indicated. All rights reserved.
 * No deletion without permission
 */
package com.j2eefast.framework.oss.cloud;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.j2eefast.common.core.exception.RxcException;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.request.UploadFileRequest;
import com.qcloud.cos.sign.Credentials;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.io.InputStream;

/**
 * 腾讯云存储
 */
public class QcloudCloudStorageService extends CloudStorageService {
	private COSClient client;

	public QcloudCloudStorageService(CloudStorageConfig config) {
		this.config = config;

		// 初始化
		init();
	}

	private void init() {
		Credentials credentials = new Credentials(config.getQcloudAppId(), config.getQcloudSecretId(),
				config.getQcloudSecretKey());

		// 初始化客户端配置
		ClientConfig clientConfig = new ClientConfig();
		// 设置bucket所在的区域，华南：gz 华北：tj 华东：sh
		clientConfig.setRegion(config.getQcloudRegion());

		client = new COSClient(clientConfig, credentials);
	}

	@Override
	public String upload(byte[] data, String path) {
		// 腾讯云必需要以"/"开头
		if (!path.startsWith("/")) {
			path = "/" + path;
		}
		// 上传到腾讯云
		UploadFileRequest request = new UploadFileRequest(config.getQcloudBucketName(), path, data);
		String response = client.uploadFile(request);

		JSONObject jsonObject = JSONUtil.parseObj(response);
		if (jsonObject.getInt("code") != 0) {
			throw new RxcException("文件上传失败，" + jsonObject.getStr("message"));
		}

		return config.getQcloudDomain() + path;
	}

	@Override
	public String upload(InputStream inputStream, String path) {
		try {
			byte[] data = IOUtils.toByteArray(inputStream);
			return this.upload(data, path);
		} catch (IOException e) {
			throw new RxcException("上传文件失败", e);
		}
	}

	@Override
	public InputStream download(String path) {
		return null;
	}

	@Override
	public void delFileOss(String path) {

	}

	@Override
	public String uploadSuffix(byte[] data, String suffix) {
		return upload(data, getPath(config.getQcloudurlPrefix(), suffix));
	}

	@Override
	public String uploadSuffix(InputStream inputStream, String suffix) {
		return upload(inputStream, getPath(config.getQcloudurlPrefix(), suffix));
	}

	@Override
	public void shutdown() {

	}
}
