/*!
 *  __  __    _    ____ _   _ ___ _______   __
 * |  \/  |  / \  / ___| \ | |_ _|  ___\ \ / /
 * | |\/| | / _ \| |  _|  \| || || |_   \ V / 
 * | |  | |/ ___ \ |_| | |\  || ||  _|   | |  
 * |_|  |_/_/   \_\____|_| \_|___|_|     |_|  
 *
 * jquery.magnify - v1.5.1
 * A jQuery plugin to view images just like in windows
 * https://github.com/nzbin/magnify#readme
 *
 * Copyright (c) 2017 nzbin
 * Released under the MIT License
 */
!function(t){"function"==typeof define&&define.amd?define(["jquery"],t):"object"==typeof exports?t(require("jquery")):t(jQuery)}(function(C){"use strict";function o(t){return C(t).attr("data-src")?C(t).attr("data-src"):C(t).attr("href")}function S(t,i,e,a){var s=a?t.h:t.w,o=a?t.w:t.h;(o>i.h||s>i.w)&&e.addClass("is-grab"),o<=i.h&&s<=i.w&&e.removeClass("is-grab")}function t(){return!!("ontouchstart"in window||window.DocumentTouch&&document instanceof window.DocumentTouch)}function D(){return"Microsoft Internet Explorer"==navigator.appName&&0<navigator.appVersion.indexOf("MSIE 8.0")||"Microsoft Internet Explorer"==navigator.appName&&0<navigator.appVersion.indexOf("MSIE 7.0")}function a(t,i){this.options=C.extend(!0,{},r,i),i&&C.isArray(i.footToolbar)&&(this.options.footToolbar=i.footToolbar),i&&C.isArray(i.headToolbar)&&(this.options.headToolbar=i.headToolbar),this.$el=C(t),this.isOpened=!1,this.isMaximized=!1,this.isRotated=!1,this.rotateAngle=0,this.isDoResize=!1,this.imageData={},this.modalData={width:null,height:null,left:null,top:null},this.init(t,this.options)}var f=C(window),I=C(document),e="click",s="resize",n="keydown",h="wheel mousewheel DOMMouseScroll",W=t()?"touchstart":"mousedown",E=t()?"touchmove":"mousemove",O=t()?"touchend":"mouseup",H=".magnify",r={draggable:!0,resizable:!0,movable:!0,keyboard:!0,title:!0,modalWidth:320,modalHeight:320,fixedContent:!0,fixedModalSize:!1,initMaximized:!1,gapThreshold:.02,ratioThreshold:.1,minRatio:.05,maxRatio:16,headToolbar:["maximize","close"],footToolbar:["zoomIn","zoomOut","prev","fullscreen","next","actualSize","rotateRight"],icons:{minimize:'<svg viewBox="0 0 1024 1024" class="svg-inline-icon">                <path fill="currentColor" d="M1024 749.714v109.714c0 50.286                -41.143 91.429-91.429 91.429h-841.143c-50.286 0-91.429-41.143                -91.429-91.429v-109.714c0-50.286 41.143-91.429 91.429-91.429                h841.143c50.286 0 91.429 41.143 91.429 91.429z"></path>                </svg>',maximize:'<svg viewBox="0 0 1024 1024" class="svg-inline-icon">                <path fill="currentColor" d="M146.286 804.571h731.429v-438.857                h-731.429v438.857zM1024 164.571v694.857c0 50.286-41.143 91.429                -91.429 91.429h-841.143c-50.286 0-91.429-41.143-91.429-91.429v                -694.857c0-50.286 41.143-91.429 91.429-91.429h841.143c50.286 0                 91.429 41.143 91.429 91.429z"></path>                </svg>',close:'<svg viewBox="0 0 804.5714285714286 1024" class="svg-inline-icon">              <path fill="currentColor" d="M741.714 755.429c0 14.286-5.714               28.571-16 38.857l-77.714 77.714c-10.286 10.286-24.571 16-38.857 16              s-28.571-5.714-38.857-16l-168-168-168 168c-10.286 10.286-24.571 16              -38.857 16s-28.571-5.714-38.857-16l-77.714-77.714c-10.286-10.286              -16-24.571-16-38.857s5.714-28.571 16-38.857l168-168-168-168c-10.286              -10.286-16-24.571-16-38.857s5.714-28.571 16-38.857l77.714-77.714              c10.286-10.286 24.571-16 38.857-16s28.571 5.714 38.857 16l168 168               168-168c10.286-10.286 24.571-16 38.857-16s28.571 5.714 38.857               16l77.714 77.714c10.286 10.286 16 24.571 16 38.857s-5.714 28.571              -16 38.857l-168 168 168 168c10.286 10.286 16 24.571 16 38.857z"></path>              </svg>',zoomIn:'<svg viewBox="0 0 950.8571428571428 1024" class="svg-inline-icon">              <path fill="currentColor" d="M585.143 457.143v36.571c0 9.714-8.571               18.286-18.286 18.286h-128v128c0 9.714-8.571 18.286-18.286 18.286              h-36.571c-9.714 0-18.286-8.571-18.286-18.286v-128h-128c-9.714 0              -18.286-8.571-18.286-18.286v-36.571c0-9.714 8.571-18.286 18.286              -18.286h128v-128c0-9.714 8.571-18.286 18.286-18.286h36.571c9.714 0               18.286 8.571 18.286 18.286v128h128c9.714 0 18.286 8.571 18.286               18.286zM658.286 475.429c0-141.143-114.857-256-256-256s-256 114.857              -256 256 114.857 256 256 256 256-114.857 256-256zM950.857 950.857              c0 40.571-32.571 73.143-73.143 73.143-19.429 0-38.286-8-51.429              -21.714l-196-195.429c-66.857 46.286-146.857 70.857-228 70.857              -222.286 0-402.286-180-402.286-402.286s180-402.286 402.286-402.286               402.286 180 402.286 402.286c0 81.143-24.571 161.143-70.857 228              l196 196c13.143 13.143 21.143 32 21.143 51.429z"></path>              </svg>',zoomOut:'<svg viewBox="0 0 950.8571428571428 1024" class="svg-inline-icon">              <path fill="currentColor" d="M585.143 457.143v36.571c0 9.714-8.571               18.286-18.286 18.286h-329.143c-9.714 0-18.286-8.571-18.286-18.286              v-36.571c0-9.714 8.571-18.286 18.286-18.286h329.143c9.714 0 18.286               8.571 18.286 18.286zM658.286 475.429c0-141.143-114.857-256-256-256              s-256 114.857-256 256 114.857 256 256 256 256-114.857 256-256z              M950.857 950.857c0 40.571-32.571 73.143-73.143 73.143-19.429 0              -38.286-8-51.429-21.714l-196-195.429c-66.857 46.286-146.857 70.857              -228 70.857-222.286 0-402.286-180-402.286-402.286s180-402.286               402.286-402.286 402.286 180 402.286 402.286c0 81.143-24.571 161.143              -70.857 228l196 196c13.143 13.143 21.143 32 21.143 51.429z"></path>              </svg>',prev:'<svg viewBox="0 0 914.2857142857142 1024" class="svg-inline-icon">            <path fill="currentColor" d="M877.714 512v73.143c0 38.857-25.714             73.143-66.857 73.143h-402.286l167.429 168c13.714 13.143 21.714 32             21.714 51.429s-8 38.286-21.714 51.429l-42.857 43.429c-13.143 13.143            -32 21.143-51.429 21.143s-38.286-8-52-21.143l-372-372.571c-13.143            -13.143-21.143-32-21.143-51.429s8-38.286 21.143-52l372-371.429c13.714            -13.714 32.571-21.714 52-21.714s37.714 8 51.429 21.714l42.857 42.286            c13.714 13.714 21.714 32.571 21.714 52s-8 38.286-21.714 52l-167.429             167.429h402.286c41.143 0 66.857 34.286 66.857 73.143z"></path>            </svg>',next:'<svg viewBox="0 0 841.1428571428571 1024" class="svg-inline-icon">            <path fill="currentColor" d="M841.143 548.571c0 19.429-7.429 38.286            -21.143 52l-372 372c-13.714 13.143-32.571 21.143-52 21.143s-37.714            -8-51.429-21.143l-42.857-42.857c-13.714-13.714-21.714-32.571-21.714            -52s8-38.286 21.714-52l167.429-167.429h-402.286c-41.143 0-66.857            -34.286-66.857-73.143v-73.143c0-38.857 25.714-73.143 66.857-73.143            h402.286l-167.429-168c-13.714-13.143-21.714-32-21.714-51.429s8            -38.286 21.714-51.429l42.857-42.857c13.714-13.714 32-21.714 51.429            -21.714s38.286 8 52 21.714l372 372c13.714 13.143 21.143 32 21.143             51.429z"></path>            </svg>',fullscreen:'<svg viewBox="0 0 1097.142857142857 1024" class="svg-inline-icon">                  <path fill="currentColor" d="M365.714 329.143c0 60.571-49.143                   109.714-109.714 109.714s-109.714-49.143-109.714-109.714 49.143                  -109.714 109.714-109.714 109.714 49.143 109.714 109.714z                  M950.857 548.571v256h-804.571v-109.714l182.857-182.857 91.429                   91.429 292.571-292.571zM1005.714 146.286h-914.286c-9.714 0                  -18.286 8.571-18.286 18.286v694.857c0 9.714 8.571 18.286                   18.286 18.286h914.286c9.714 0 18.286-8.571 18.286-18.286                  v-694.857c0-9.714-8.571-18.286-18.286-18.286zM1097.143 164.571                  v694.857c0 50.286-41.143 91.429-91.429 91.429h-914.286c-50.286                   0-91.429-41.143-91.429-91.429v-694.857c0-50.286 41.143-91.429                   91.429-91.429h914.286c50.286 0 91.429 41.143 91.429 91.429z"></path>                  </svg>',actualSize:'<svg viewBox="0 0 877.7142857142857 1024" class="svg-inline-icon">                  <path fill="currentColor" d="M733.143 309.143l-202.857 202.857                   202.857 202.857 82.286-82.286c10.286-10.857 26.286-13.714 40-8                   13.143 5.714 22.286 18.857 22.286 33.714v256c0 20-16.571 36.571                  -36.571 36.571h-256c-14.857 0-28-9.143-33.714-22.857-5.714                  -13.143-2.857-29.143 8-39.429l82.286-82.286-202.857-202.857                  -202.857 202.857 82.286 82.286c10.857 10.286 13.714 26.286 8                   39.429-5.714 13.714-18.857 22.857-33.714 22.857h-256c-20 0                  -36.571-16.571-36.571-36.571v-256c0-14.857 9.143-28 22.857                  -33.714 13.143-5.714 29.143-2.857 39.429 8l82.286 82.286                   202.857-202.857-202.857-202.857-82.286 82.286c-6.857 6.857                  -16 10.857-25.714 10.857-4.571 0-9.714-1.143-13.714-2.857                  -13.714-5.714-22.857-18.857-22.857-33.714v-256c0-20 16.571                  -36.571 36.571-36.571h256c14.857 0 28 9.143 33.714 22.857                   5.714 13.143 2.857 29.143-8 39.429l-82.286 82.286 202.857                   202.857 202.857-202.857-82.286-82.286c-10.857-10.286-13.714                  -26.286-8-39.429 5.714-13.714 18.857-22.857 33.714-22.857h256                  c20 0 36.571 16.571 36.571 36.571v256c0 14.857-9.143 28-22.286                   33.714-4.571 1.714-9.714 2.857-14.286 2.857-9.714 0-18.857-4                  -25.714-10.857z"></path>                  </svg>',rotateLeft:'<svg viewBox="0 0 877.7142857142857 1024" class="svg-inline-icon">                  <path fill="currentColor" d="M877.714 512c0 241.714-197.143                   438.857-438.857 438.857-130.857 0-254.286-57.714-337.714-158.286                  -5.714-7.429-5.143-18.286 1.143-24.571l78.286-78.857c4-3.429                   9.143-5.143 14.286-5.143 5.143 0.571 10.286 2.857 13.143 6.857                   56 72.571 140 113.714 230.857 113.714 161.143 0 292.571-131.429                   292.571-292.571s-131.429-292.571-292.571-292.571c-74.857 0                  -145.714 28.571-198.857 78.286l78.286 78.857c10.857 10.286                   13.714 26.286 8 39.429-5.714 13.714-18.857 22.857-33.714 22.857                  h-256c-20 0-36.571-16.571-36.571-36.571v-256c0-14.857 9.143-28                   22.857-33.714 13.143-5.714 29.143-2.857 39.429 8l74.286 73.714                  c80.571-76 189.714-121.143 302.286-121.143 241.714 0 438.857                   197.143 438.857 438.857z"></path>                  </svg>',rotateRight:'<svg viewBox="0 0 877.7142857142857 1024" class="svg-inline-icon">                    <path fill="currentColor" d="M877.714 146.286v256c0 20-16.571                     36.571-36.571 36.571h-256c-14.857 0-28-9.143-33.714-22.857                    -5.714-13.143-2.857-29.143 8-39.429l78.857-78.857c-53.714                    -49.714-124.571-78.286-199.429-78.286-161.143 0-292.571                     131.429-292.571 292.571s131.429 292.571 292.571 292.571                    c90.857 0 174.857-41.143 230.857-113.714 2.857-4 8-6.286                     13.143-6.857 5.143 0 10.286 1.714 14.286 5.143l78.286 78.857                    c6.857 6.286 6.857 17.143 1.143 24.571-83.429 100.571-206.857                     158.286-337.714 158.286-241.714 0-438.857-197.143-438.857                    -438.857s197.143-438.857 438.857-438.857c112.571 0 221.714                     45.143 302.286 121.143l74.286-73.714c10.286-10.857 26.286                    -13.714 40-8 13.143 5.714 22.286 18.857 22.286 33.714z"></path>                    </svg>'},i18n:{minimize:"minimize",maximize:"maximize",close:"close",zoomIn:"zoom-in(+)",zoomOut:"zoom-out(-)",prev:"prev(←)",next:"next(→)",fullscreen:"fullscreen",actualSize:"actual-size(Ctrl+Alt+0)",rotateLeft:"rotate-left(Ctrl+,)",rotateRight:"rotate-right(Ctrl+.)"},multiInstances:!0,initEvent:"click",initAnimation:!0,fixedModalPos:!1,zIndex:1090,dragHandle:!1,callbacks:{beforeOpen:C.noop,opened:C.noop,beforeClose:C.noop,closed:C.noop,beforeChange:C.noop,changed:C.noop},progressiveLoading:!0},R={isMoving:!1,isResizing:!1,zIndex:r.zIndex},l=null;a.prototype={init:function(t,i){var e=o(t);this.groupName=null;var a=C(t).attr("data-group"),s=I.find('[data-group="'+a+'"]');void 0!==a?(this.groupName=a,this.getImgGroup(s,e)):this.getImgGroup(l.not("[data-group]"),e),this.open(),this.loadImg(e),i.draggable&&this.draggable(this.$magnify,this.dragHandle,".magnify-button"),i.movable&&this.movable(this.$stage,D()?".magnify-image":this.$image),i.resizable&&this.resizable(this.$magnify,this.$stage,D()?".magnify-image":this.$image,i.modalWidth,i.modalHeight)},_createBtns:function(t,e){var a="";return C.each(t,function(t,i){a+=e[i]}),a},_createTitle:function(){return this.options.title?'<div class="magnify-title"></div>':""},render:function(){var t={minimize:'<button class="magnify-button magnify-button-minimize" title="'+this.options.i18n.minimize+'">'+this.options.icons.minimize+"</button>",maximize:'<button class="magnify-button magnify-button-maximize" title="'+this.options.i18n.maximize+'">'+this.options.icons.maximize+"</button>",close:'<button class="magnify-button magnify-button-close" title="'+this.options.i18n.close+'">'+this.options.icons.close+"</button>",zoomIn:'<button class="magnify-button magnify-button-zoom-in" title="'+this.options.i18n.zoomIn+'">'+this.options.icons.zoomIn+"</button>",zoomOut:'<button class="magnify-button magnify-button-zoom-out" title="'+this.options.i18n.zoomOut+'">'+this.options.icons.zoomOut+"</button>",prev:'<button class="magnify-button magnify-button-prev" title="'+this.options.i18n.prev+'">'+this.options.icons.prev+"</button>",next:'<button class="magnify-button magnify-button-next" title="'+this.options.i18n.next+'">'+this.options.icons.next+"</button>",fullscreen:'<button class="magnify-button magnify-button-fullscreen" title="'+this.options.i18n.fullscreen+'">'+this.options.icons.fullscreen+"</button>",actualSize:'<button class="magnify-button magnify-button-actual-size" title="'+this.options.i18n.actualSize+'">'+this.options.icons.actualSize+"</button>",rotateLeft:'<button class="magnify-button magnify-button-rotate-left" title="'+this.options.i18n.rotateLeft+'">'+this.options.icons.rotateLeft+"</button>",rotateRight:'<button class="magnify-button magnify-button-rotate-right" title="'+this.options.i18n.rotateRight+'">'+this.options.icons.rotateRight+"</button>"};return'<div class="magnify-modal">        <div class="magnify-header">          <div class="magnify-toolbar magnify-head-toolbar">'+this._createBtns(this.options.headToolbar,t)+"          </div>"+this._createTitle()+'        </div>        <div class="magnify-stage">          <img class="magnify-image" src="" alt="" />        </div>        <div class="magnify-footer">          <div class="magnify-toolbar magnify-foot-toolbar">'+this._createBtns(this.options.footToolbar,t)+"          </div>        </div>      </div>"},build:function(){var t=this.render(),i=C(t);this.$magnify=i,this.$header=i.find(".magnify-header"),this.$headToolbar=i.find(".magnify-head-toolbar"),this.$footer=i.find(".magnify-footer"),this.$footToolbar=i.find(".magnify-foot-toolbar"),this.$stage=i.find(".magnify-stage"),this.$title=i.find(".magnify-title"),this.$image=i.find(".magnify-image"),this.$close=i.find(".magnify-button-close"),this.$maximize=i.find(".magnify-button-maximize"),this.$minimize=i.find(".magnify-button-minimize"),this.$zoomIn=i.find(".magnify-button-zoom-in"),this.$zoomOut=i.find(".magnify-button-zoom-out"),this.$actualSize=i.find(".magnify-button-actual-size"),this.$fullscreen=i.find(".magnify-button-fullscreen"),this.$rotateLeft=i.find(".magnify-button-rotate-left"),this.$rotateRight=i.find(".magnify-button-rotate-right"),this.$prev=i.find(".magnify-button-prev"),this.$next=i.find(".magnify-button-next"),this.$stage.addClass("stage-ready"),this.$image.addClass("image-ready"),this.$magnify.css("z-index",R.zIndex),this.options.dragHandle&&".magnify-modal"!==this.options.dragHandle?this.dragHandle=this.$magnify.find(this.options.dragHandle):this.dragHandle=this.$magnify},open:function(){if(this.options.multiInstances||C(".magnify-modal").eq(0).remove(),!C(".magnify-modal").length&&this.options.fixedContent&&(C("html").css({overflow:"hidden"}),document.body.scrollHeight>(window.innerHeight||document.documentElement.clientHeight))){var t=function(){var t=document.createElement("div");t.style.cssText="width: 99px; height: 99px; overflow: scroll; position: absolute; top: -9999px;",document.body.appendChild(t);var i=t.offsetWidth-t.clientWidth;return document.body.removeChild(t),i}();t&&C("html").css({"padding-right":t})}this.build(),this._triggerHook("beforeOpen",this.$el),C("body").append(this.$magnify),this.addEvents(),this.setModalPos(this.$magnify),this._triggerHook("opened",this.$el)},close:function(t){this._triggerHook("beforeClose",this.$el),this.$magnify.remove(),this.isOpened=!1,this.isMaximized=!1,this.isRotated=!1,this.rotateAngle=0;var i=!C(".magnify-modal").length;i&&this.options.fixedContent&&C("html").css({overflow:"","padding-right":""}),i&&this.options.multiInstances&&(R.zIndex=this.options.zIndex),C(".magnify-modal").length||(I.off(n+H),f.off(s+H)),this._triggerHook("closed",this.$el)},setModalPos:function(t){var i=f.width(),e=f.height(),a=I.scrollLeft(),s=I.scrollTop(),o=this.options.modalWidth,n=this.options.modalHeight;this.options.initMaximized?(t.addClass("magnify-maximize"),t.css({width:"100%",height:"100%",left:0,top:0}),this.isOpened=!0,this.isMaximized=!0):t.css({width:o,height:n,left:(i-o)/2+a+"px",top:(e-n)/2+s+"px"})},setModalSize:function(t){var i=this,e=f.width(),a=f.height(),s=I.scrollLeft(),o=I.scrollTop(),n={left:this.$stage.css("left"),right:this.$stage.css("right"),top:this.$stage.css("top"),bottom:this.$stage.css("bottom"),borderLeft:this.$stage.css("border-left-width"),borderRight:this.$stage.css("border-right-width"),borderTop:this.$stage.css("border-top-width"),borderBottom:this.$stage.css("border-bottom-width")},h=t.width+parseFloat(n.left)+parseFloat(n.right)+parseFloat(n.borderLeft)+parseFloat(n.borderRight),r=t.height+parseFloat(n.top)+parseFloat(n.bottom)+parseFloat(n.borderTop)+parseFloat(n.borderBottom),l=(0<this.options.gapThreshold?this.options.gapThreshold:0)+1,g=Math.min(e/(h*l),a/(r*l),1),m=Math.max(h*g,this.options.modalWidth),c=Math.max(r*g,this.options.modalHeight),d={width:(m=this.options.fixedModalSize?this.options.modalWidth:Math.round(m))+"px",height:(c=this.options.fixedModalSize?this.options.modalHeight:Math.round(c))+"px",left:(e-m)/2+s+"px",top:(a-c)/2+o+"px"};this.options.initAnimation?this.$magnify.animate(d,function(){i.setImageSize(t)}):(this.$magnify.css(d),this.setImageSize(t)),this.isOpened=!0},getImageScaleToStage:function(t,i){return this.isRotated?Math.min(t/this.img.height,i/this.img.width,1):Math.min(t/this.img.width,i/this.img.height,1)},setImageSize:function(t){var i=D()?this.$stage.find(".magnify-image"):this.$image,e={w:this.$stage.width(),h:this.$stage.height()},a=this.getImageScaleToStage(e.w,e.h);i.css({width:Math.ceil(t.width*a)+"px",height:Math.ceil(t.height*a)+"px",left:(e.w-Math.ceil(t.width*a))/2+"px",top:(e.h-Math.ceil(t.height*a))/2+"px"}),D()&&i.find("group").css({width:Math.floor(t.width*a)+"px",height:Math.floor(t.height*a)+"px"}),C.extend(this.imageData,{initWidth:t.width*a,initHeight:t.height*a,initLeft:(e.w-t.width*a)/2,initTop:(e.h-t.height*a)/2,width:t.width*a,height:t.height*a,left:(e.w-t.width*a)/2,top:(e.h-t.height*a)/2}),S({w:i.width(),h:i.height()},{w:this.$stage.width(),h:this.$stage.height()},this.$stage,this.isRotated),this.imgLoaded||(this.$magnify.find(".magnify-loader").remove(),this.$stage.removeClass("stage-ready"),this.$image.removeClass("image-ready"),this.options.initAnimation&&!this.options.progressiveLoading&&i.fadeIn(),this.imgLoaded=!0)},loadImg:function(t,i,e){var a=this;this.$image.removeAttr("style").attr("src",""),this.isRotated=!1,this.rotateAngle=0,this.imgLoaded=!1,this.$magnify.append('<div class="magnify-loader"></div>'),this.$stage.addClass("stage-ready"),this.$image.addClass("image-ready"),this.options.initAnimation&&!this.options.progressiveLoading&&this.$image.hide(),D()?this.$stage.html('<img class="magnify-image" id="magnify-image" src="'+t+'" alt="" />'):this.$image.attr("src",t),function(t,i,e){var a=new Image;a.onload=function(){i(a)},a.onerror=function(){e(a)},a.src=t}(t,function(t){a.img=t,a.imageData={originalWidth:t.width,originalHeight:t.height},a.isMaximized||a.isOpened&&a.options.fixedModalPos?a.setImageSize(t):a.setModalSize(t),i&&i.call()},function(){a.$magnify.find(".magnify-loader").remove(),e&&e.call()}),this.options.title&&this.setImgTitle(t)},getImgGroup:function(t,a){var s=this;s.groupData=[],C(t).each(function(t,i){var e=o(this);s.groupData.push({src:e,caption:C(this).attr("data-caption")}),a===e&&(s.groupIndex=t)})},setImgTitle:function(t){var i=this.groupData[this.groupIndex].caption||function(t){return t.replace(/^.*?\/*([^/?]*)\.[a-z]+(\?.+|$)/gi,"$1")}(t);this.$title.html(i)},jump:function(t){this._triggerHook("beforeChange",this.groupIndex),this.groupIndex=this.groupIndex+t,this.jumpTo(this.groupIndex)},jumpTo:function(t){var i=this;0<=(t%=this.groupData.length)?t%=this.groupData.length:t<0&&(t=(this.groupData.length+t)%this.groupData.length),this.groupIndex=t,this.loadImg(this.groupData[t].src,function(){i._triggerHook("changed",t)},function(){i._triggerHook("changed",t)})},wheel:function(t){t.preventDefault();var i=1;t.originalEvent.deltaY?i=0<t.originalEvent.deltaY?1:-1:t.originalEvent.wheelDelta?i=-t.originalEvent.wheelDelta/120:t.originalEvent.detail&&(i=0<t.originalEvent.detail?1:-1);var e=-i*this.options.ratioThreshold,a={x:t.originalEvent.clientX-this.$stage.offset().left+I.scrollLeft(),y:t.originalEvent.clientY-this.$stage.offset().top+I.scrollTop()};this.zoom(e,a,t)},zoom:function(t,i,e){this.$image=D()?this.$stage.find(".magnify-image"):this.$image,t=t<0?1/(1-t):1+t,(t=this.$image.width()/this.imageData.originalWidth*t)>this.options.maxRatio||t<this.options.minRatio||this.zoomTo(t,i,e)},zoomTo:function(t,i,e){var a=D()?this.$stage.find(".magnify-image"):this.$image,s=this.$stage,o=this.imageData.width,n=this.imageData.height,h=this.imageData.left,r=this.imageData.top,l={w:s.width(),h:s.height(),x:s.offset().left,y:s.offset().top},g=this.imageData.originalWidth*t,m=this.imageData.originalHeight*t,c=i.x-(i.x-h)/o*g,d=i.y-(i.y-r)/n*m,f=this.isRotated?(g-m)/2:0,p=this.isRotated?m:g,u=this.isRotated?g:m,v=l.w-g,y=l.h-m;d=u<=l.h?(l.h-m)/2:f<d?f:y-f<d?d:y-f,c=p<=l.w?(l.w-g)/2:-f<c?-f:v+f<c?c:v+f,Math.abs(this.imageData.initWidth-g)<.05*this.imageData.initWidth?this.setImageSize(this.img):(a.css({width:Math.round(g)+"px",height:Math.round(m)+"px",left:Math.round(c)+"px",top:Math.round(d)+"px"}),D()&&a.find("group").css({width:Math.ceil(g)+"px",height:Math.ceil(m)+"px"}),S({w:Math.round(p),h:Math.round(u)},{w:l.w,h:l.h},this.$stage)),C.extend(this.imageData,{width:g,height:m,left:c,top:d})},rotate:function(t){this.rotateAngle=this.rotateAngle+t,this.rotateAngle/90%2==0?this.isRotated=!1:this.isRotated=!0,this.rotateTo(this.rotateAngle)},rotateTo:function(t){(D()?this.$stage.find(".magnify-image"):this.$image).rotate({angle:t}),this.setImageSize({width:this.imageData.originalWidth,height:this.imageData.originalHeight}),this.$stage.removeClass("is-grab")},resize:function(){var t=this;return function(e,a){var s=null;return function(){var t=this,i=arguments;clearTimeout(s),s=setTimeout(function(){e.apply(t,i)},a)}}(function(){t.isOpened&&(t.isMaximized?t.setImageSize({width:t.imageData.originalWidth,height:t.imageData.originalHeight}):t.setModalSize({width:t.imageData.originalWidth,height:t.imageData.originalHeight}))},500)},maximize:function(){if(this.isMaximized){this.$magnify.removeClass("magnify-maximize");var t=(f.width()-this.options.modalWidth)/2+I.scrollLeft(),i=(f.height()-this.options.modalHeight)/2+I.scrollTop();this.$magnify.css({width:this.modalData.width?this.modalData.width:this.options.modalWidth,height:this.modalData.height?this.modalData.height:this.options.modalHeight,left:this.modalData.left?this.modalData.left:t,top:this.modalData.top?this.modalData.top:i}),this.isMaximized=!1}else this.modalData={width:this.$magnify.width(),height:this.$magnify.height(),left:this.$magnify.offset().left,top:this.$magnify.offset().top},this.$magnify.addClass("magnify-maximize"),this.$magnify.css({width:"100%",height:"100%",left:0,top:0}),this.isMaximized=!0;this.setImageSize({width:this.imageData.originalWidth,height:this.imageData.originalHeight})},fullscreen:function(){!function(t){t.requestFullscreen?t.requestFullscreen():t.mozRequestFullScreen?t.mozRequestFullScreen():t.webkitRequestFullscreen?t.webkitRequestFullscreen():t.msRequestFullscreen&&t.msRequestFullscreen()}(this.$magnify[0])},keydown:function(t){var i=this;if(!this.options.keyboard)return!1;var e=t.keyCode||t.which||t.charCode,a=t.ctrlKey||t.metaKey,s=t.altKey||t.metaKey;switch(e){case 37:i.jump(-1);break;case 39:i.jump(1);break;case 187:i.zoom(3*i.options.ratioThreshold,{x:i.$stage.width()/2,y:i.$stage.height()/2},t);break;case 189:i.zoom(3*-i.options.ratioThreshold,{x:i.$stage.width()/2,y:i.$stage.height()/2},t);break;case 61:i.zoom(3*i.options.ratioThreshold,{x:i.$stage.width()/2,y:i.$stage.height()/2},t);break;case 173:i.zoom(3*-i.options.ratioThreshold,{x:i.$stage.width()/2,y:i.$stage.height()/2},t);break;case 48:a&&s&&i.zoomTo(1,{x:i.$stage.width()/2,y:i.$stage.height()/2},t);break;case 188:a&&i.rotate(-90);break;case 190:a&&i.rotate(90);break;case 81:this.close()}},addEvents:function(){var i=this;this.$close.off(e+H).on(e+H,function(t){i.close()}),this.$stage.off(h+H).on(h+H,function(t){i.wheel(t)}),this.$zoomIn.off(e+H).on(e+H,function(t){i.zoom(3*i.options.ratioThreshold,{x:i.$stage.width()/2,y:i.$stage.height()/2},t)}),this.$zoomOut.off(e+H).on(e+H,function(t){i.zoom(3*-i.options.ratioThreshold,{x:i.$stage.width()/2,y:i.$stage.height()/2},t)}),this.$actualSize.off(e+H).on(e+H,function(t){i.zoomTo(1,{x:i.$stage.width()/2,y:i.$stage.height()/2},t)}),this.$prev.off(e+H).on(e+H,function(){i.jump(-1)}),this.$fullscreen.off(e+H).on(e+H,function(){i.fullscreen()}),this.$next.off(e+H).on(e+H,function(){i.jump(1)}),this.$rotateLeft.off(e+H).on(e+H,function(){i.rotate(-90)}),this.$rotateRight.off(e+H).on(e+H,function(){i.rotate(90)}),this.$maximize.off(e+H).on(e+H,function(){i.maximize()}),I.off(n+H).on(n+H,function(t){i.keydown(t)}),f.on(s+H,i.resize())},_triggerHook:function(t,i){this.options.callbacks[t]&&this.options.callbacks[t].apply(this,C.isArray(i)?i:[i])}},C.fn.magnify=function(i){for(var t in l=C(this),i)"string"!=typeof i[t]||isNaN(i[t])||(i[t]=parseFloat(i[t]));var e=C.extend(!0,{},r,i);return R.zIndex=e.zIndex,"string"==typeof i||("dblclick"===e.initEvent&&l.off("click"+H).on("click"+H,function(t){t.preventDefault(),t.stopPropagation()}),l.off(e.initEvent+H).on(e.initEvent+H,function(t){t.preventDefault(),t.stopPropagation(),C(this).data("magnify",new a(this,i))})),l},I.on(e+H,"[data-magnify]",function(t){l=C("[data-magnify]"),t.preventDefault(),C(this).data("magnify",new a(this,r))});C.extend(a.prototype,{draggable:function(o,t,i){var n=this,h=!1,r=0,l=0,g=0,m=0,e=function(t){if((t=t||window.event).preventDefault(),h&&!R.isMoving&&!R.isResizing&&!n.isMaximized){var i="touchmove"===t.type?t.originalEvent.targetTouches[0].pageX:t.clientX,e="touchmove"===t.type?t.originalEvent.targetTouches[0].pageY:t.clientY,a=i-r,s=e-l;C(o).css({left:a+g+"px",top:s+m+"px"})}},a=function(t){I.off(E+H,e).off(O+H,a),h=!1};C(t).on(W+H,function(t){t=t||window.event;if(C(t.target).closest(i).length)return!0;n.options.multiInstances&&o.css("z-index",++R.zIndex),h=!0,r="touchstart"===t.type?t.originalEvent.targetTouches[0].pageX:t.clientX,l="touchstart"===t.type?t.originalEvent.targetTouches[0].pageY:t.clientY,g=C(o).offset().left,m=C(o).offset().top,I.on(E+H,e).on(O+H,a)})}});C.extend(a.prototype,{movable:function(r,l){var g=this,m=!1,c=0,d=0,f=0,p=0,u=0,v=0,y=0,n=function(t){(t=t||window.event).preventDefault();var i=D()?C(r).find(l):C(l);if(m){var e="touchmove"===t.type?t.originalEvent.targetTouches[0].pageX:t.clientX,a="touchmove"===t.type?t.originalEvent.targetTouches[0].pageY:t.clientY,s=e-c,o=a-d,n=s+f,h=o+p;0<v?y<o+p?h=y:o+p<-v+y&&(h=-v+y):h=p,0<u?-y<s+f?n=-y:s+f<-u-y&&(n=-u-y):n=f,i.css({left:n+"px",top:h+"px"}),C.extend(g.imageData,{left:n,top:h})}},h=function(t){I.off(E+H,n).off(O+H,h),m=!1,R.isMoving=!1,C("html, body, .magnify-modal, .magnify-stage, .magnify-button, .magnify-resizable-handle").removeClass("is-grabbing")};C(r).on(W+H,function(t){(t=t||window.event).preventDefault();var i=D()?C(r).find(l):C(l),e=i.width(),a=i.height(),s=C(r).width(),o=C(r).height();c="touchstart"===t.type?t.originalEvent.targetTouches[0].pageX:t.clientX,d="touchstart"===t.type?t.originalEvent.targetTouches[0].pageY:t.clientY,y=g.isRotated?(e-a)/2:0,u=g.isRotated?a-s:e-s,v=g.isRotated?e-o:a-o,m=0<u||0<v,R.isMoving=0<u||0<v,f=i.position().left-(D()?0:y),p=i.position().top+(D()?0:y),r.hasClass("is-grab")&&C("html,body,.magnify-modal,.magnify-stage,.magnify-button,.magnify-resizable-handle").addClass("is-grabbing"),I.on(E+H,n).on(O+H,h)})}});C.extend(a.prototype,{resizable:function(r,f,p,u,v){var l=this,t=C('<div class="magnify-resizable-handle magnify-resizable-handle-e"></div>'),i=C('<div class="magnify-resizable-handle magnify-resizable-handle-w"></div>'),e=C('<div class="magnify-resizable-handle magnify-resizable-handle-s"></div>'),a=C('<div class="magnify-resizable-handle magnify-resizable-handle-n"></div>'),s=C('<div class="magnify-resizable-handle magnify-resizable-handle-se"></div>'),o=C('<div class="magnify-resizable-handle magnify-resizable-handle-sw"></div>'),n=C('<div class="magnify-resizable-handle magnify-resizable-handle-ne"></div>'),h=C('<div class="magnify-resizable-handle magnify-resizable-handle-nw"></div>'),g={e:t,s:e,se:s,n:a,w:i,nw:h,ne:n,sw:o};C(r).append(t,i,e,a,s,o,n,h);var m=!1,c=0,d=0,y={w:0,h:0,l:0,t:0},_={w:0,h:0,l:0,t:0},b={w:0,h:0,l:0,t:0},x=0,w=0,z=0,$="",M=function(t){(t=t||window.event).preventDefault();var i=D()?C(f).find(p):C(p);if(m&&!l.isMaximized){var e="touchmove"===t.type?t.originalEvent.targetTouches[0].pageX:t.clientX,a="touchmove"===t.type?t.originalEvent.targetTouches[0].pageY:t.clientY,s=e-c,o=a-d,n=function(t,i,e){var a=-i+y.w>u?i+y.l:y.l+y.w-u,s=-e+y.h>v?e+y.t:y.t+y.h-v;return{e:{width:Math.max(i+y.w,u)+"px"},s:{height:Math.max(e+y.h,v)+"px"},se:{width:Math.max(i+y.w,u)+"px",height:Math.max(e+y.h,v)+"px"},w:{width:Math.max(-i+y.w,u)+"px",left:a+"px"},n:{height:Math.max(-e+y.h,v)+"px",top:s+"px"},nw:{width:Math.max(-i+y.w,u)+"px",height:Math.max(-e+y.h,v)+"px",top:s+"px",left:a+"px"},ne:{width:Math.max(i+y.w,u)+"px",height:Math.max(-e+y.h,v)+"px",top:s+"px"},sw:{width:Math.max(-i+y.w,u)+"px",height:Math.max(e+y.h,v)+"px",left:a+"px"}}[t]}($,s,o);C(r).css(n);var h=function(t,i,e){var a=D()?C(f).find(p):C(p),s=D()?a.position().left+x:a.position().left,o=D()?a.position().top-x:a.position().top,n=i+y.w>u?_.w-w+i-x:u-(y.w-_.w)-w-x,h=e+y.h>v?_.h-z+e+x:v-(y.h-_.h)-z+x,r=-i+y.w>u?_.w-w-i-x:u-(y.w-_.w)-w-x,l=-e+y.h>v?_.h-z-e+x:v-(y.h-_.h)-z+x,g=(0<n?s:s<0?s:0)-x,m=(0<h?o:o<0?o:0)+x,c=(0<r?s:s<0?s:0)-x,d=(0<l?o:o<0?o:0)+x;return{e:{left:-x<=n?(n-x)/2+"px":n<g?g+"px":n+"px"},s:{top:x<=h?(h+x)/2+"px":h<m?m+"px":h+"px"},se:{top:x<=h?(h+x)/2+"px":h<m?m+"px":h+"px",left:-x<=n?(n-x)/2+"px":n<g?g+"px":n+"px"},w:{left:-x<=r?(r-x)/2+"px":r<c?c+"px":r+"px"},n:{top:x<=l?(l+x)/2+"px":l<d?d+"px":l+"px"},nw:{top:x<=l?(l+x)/2+"px":l<d?d+"px":l+"px",left:-x<=r?(r-x)/2+"px":r<c?c+"px":r+"px"},ne:{top:x<=l?(l+x)/2+"px":l<d?d+"px":l+"px",left:-x<=n?(n-x)/2+"px":n<g?g+"px":n+"px"},sw:{top:x<=h?(h+x)/2+"px":h<m?m+"px":h+"px",left:-x<=r?(r-x)/2+"px":r<c?c+"px":r+"px"}}[t]}($,s,o);i.css(h),l.isDoResize=!0}},T=function(t){I.off(E+H,M).off(O+H,T),R.isResizing&&S({w:w,h:z},{w:C(f).width(),h:C(f).height()},f),m=!1,R.isResizing=!1,C("html, body, .magnify-modal, .magnify-stage, .magnify-button").css("cursor","");var i=l.getImageScaleToStage(C(f).width(),C(f).height());C.extend(l.imageData,{initWidth:l.img.width*i,initHeight:l.img.height*i,initLeft:(C(f).width()-l.img.width*i)/2,initTop:(C(f).height()-l.img.height*i)/2})};C.each(g,function(i,t){t.on(W+H,function(t){!function(t,i){(i=i||window.event).preventDefault();var e=D()?C(f).find(p):C(p);m=!0,R.isResizing=!0,c="touchstart"===i.type?i.originalEvent.targetTouches[0].pageX:i.clientX,d="touchstart"===i.type?i.originalEvent.targetTouches[0].pageY:i.clientY,y={w:C(r).width(),h:C(r).height(),l:C(r).offset().left,t:C(r).offset().top},_={w:C(f).width(),h:C(f).height(),l:C(f).offset().left,t:C(f).offset().top},b={w:e.width(),h:e.height(),l:e.position().left,t:e.position().top},x=l.isRotated?(b.w-b.h)/2:0,w=l.isRotated?b.h:b.w,z=l.isRotated?b.w:b.h,$=t,C("html,body,.magnify-modal,.magnify-stage,.magnify-button").css("cursor",t+"-resize"),I.on(E+H,M).on(O+H,T)}(i,t)})})}})}),function($){for(var supportedCSS,supportedCSSOrigin,styles=document.getElementsByTagName("head")[0].style,toCheck="transformProperty WebkitTransform OTransform msTransform MozTransform".split(" "),a=0,bf;a<toCheck.length;a++)void 0!==styles[toCheck[a]]&&(supportedCSS=toCheck[a]);supportedCSS&&(supportedCSSOrigin=supportedCSS.replace(/[tT]ransform/,"TransformOrigin"),"T"==supportedCSSOrigin[0]&&(supportedCSSOrigin[0]="t")),eval('IE = "v"=="\v"'),jQuery.fn.extend({rotate:function(t){if(0!==this.length&&void 0!==t){"number"==typeof t&&(t={angle:t});for(var i=[],e=0,a=this.length;e<a;e++){var s=this.get(e);if(s.Wilq32&&s.Wilq32.PhotoEffect)s.Wilq32.PhotoEffect._handleRotation(t);else{var o=$.extend(!0,{},t),n=new Wilq32.PhotoEffect(s,o)._rootObj;i.push($(n))}}return i}},getRotateAngle:function(){for(var t=[0],i=0,e=this.length;i<e;i++){var a=this.get(i);a.Wilq32&&a.Wilq32.PhotoEffect&&(t[i]=a.Wilq32.PhotoEffect._angle)}return t},stopRotate:function(){for(var t=0,i=this.length;t<i;t++){var e=this.get(t);e.Wilq32&&e.Wilq32.PhotoEffect&&clearTimeout(e.Wilq32.PhotoEffect._timer)}}}),Wilq32=window.Wilq32||{},Wilq32.PhotoEffect=supportedCSS?function(t,i){t.Wilq32={PhotoEffect:this},this._img=this._rootObj=this._eventObj=t,this._handleRotation(i)}:function(t,i){if(this._img=t,this._onLoadDelegate=[i],this._rootObj=document.createElement("span"),this._rootObj.style.display="inline-block",this._rootObj.Wilq32={PhotoEffect:this},t.parentNode.insertBefore(this._rootObj,t),t.complete)this._Loader();else{var e=this;jQuery(this._img).bind("load",function(){e._Loader()})}},Wilq32.PhotoEffect.prototype={_setupParameters:function(t){this._parameters=this._parameters||{},"number"!=typeof this._angle&&(this._angle=0),"number"==typeof t.angle&&(this._angle=t.angle),this._parameters.animateTo="number"==typeof t.animateTo?t.animateTo:this._angle,this._parameters.step=t.step||this._parameters.step||null,this._parameters.easing=t.easing||this._parameters.easing||this._defaultEasing,this._parameters.duration="duration"in t?t.duration:t.duration||this._parameters.duration||1e3,this._parameters.callback=t.callback||this._parameters.callback||this._emptyFunction,this._parameters.center=t.center||this._parameters.center||["50%","50%"],"string"==typeof this._parameters.center[0]?this._rotationCenterX=parseInt(this._parameters.center[0],10)/100*this._imgWidth*this._aspectW:this._rotationCenterX=this._parameters.center[0],"string"==typeof this._parameters.center[1]?this._rotationCenterY=parseInt(this._parameters.center[1],10)/100*this._imgHeight*this._aspectH:this._rotationCenterY=this._parameters.center[1],t.bind&&t.bind!=this._parameters.bind&&this._BindEvents(t.bind)},_emptyFunction:function(){},_defaultEasing:function(t,i,e,a,s){return-a*((i=i/s-1)*i*i*i-1)+e},_handleRotation:function(t,i){supportedCSS||this._img.complete||i?(this._setupParameters(t),this._angle==this._parameters.animateTo?this._rotate(this._angle):this._animateStart()):this._onLoadDelegate.push(t)},_BindEvents:function(t){if(t&&this._eventObj){if(this._parameters.bind){var i=this._parameters.bind;for(var e in i)i.hasOwnProperty(e)&&jQuery(this._eventObj).unbind(e,i[e])}for(var e in this._parameters.bind=t)t.hasOwnProperty(e)&&jQuery(this._eventObj).bind(e,t[e])}},_Loader:IE?function(){var t,i=this._img.width,e=this._img.height;for(this._imgWidth=i,this._imgHeight=e,this._img.parentNode.removeChild(this._img),this._vimage=this.createVMLNode("image"),this._vimage.src=this._img.src,this._vimage.style.height=e+"px",this._vimage.style.width=i+"px",this._vimage.style.position="absolute",this._vimage.style.top="0px",this._vimage.style.left="0px",this._aspectW=this._aspectH=1,this._container=this.createVMLNode("group"),this._container.style.width=i,this._container.style.height=e,this._container.style.position="absolute",this._container.style.top="0px",this._container.style.left="0px",this._container.setAttribute("coordsize",i-1+","+(e-1)),this._container.appendChild(this._vimage),this._rootObj.appendChild(this._container),this._rootObj.style.position="relative",this._rootObj.style.width=i+"px",this._rootObj.style.height=e+"px",this._rootObj.setAttribute("id",this._img.getAttribute("id")),this._rootObj.className=this._img.className,this._eventObj=this._rootObj;t=this._onLoadDelegate.shift();)this._handleRotation(t,!0)}:function(){this._rootObj.setAttribute("id",this._img.getAttribute("id")),this._rootObj.className=this._img.className,this._imgWidth=this._img.naturalWidth,this._imgHeight=this._img.naturalHeight;var t,i=Math.sqrt(this._imgHeight*this._imgHeight+this._imgWidth*this._imgWidth);for(this._width=3*i,this._height=3*i,this._aspectW=this._img.offsetWidth/this._img.naturalWidth,this._aspectH=this._img.offsetHeight/this._img.naturalHeight,this._img.parentNode.removeChild(this._img),this._canvas=document.createElement("canvas"),this._canvas.setAttribute("width",this._width),this._canvas.style.position="relative",this._canvas.style.left=-this._img.height*this._aspectW+"px",this._canvas.style.top=-this._img.width*this._aspectH+"px",this._canvas.Wilq32=this._rootObj.Wilq32,this._rootObj.appendChild(this._canvas),this._rootObj.style.width=this._img.width*this._aspectW+"px",this._rootObj.style.height=this._img.height*this._aspectH+"px",this._eventObj=this._canvas,this._cnv=this._canvas.getContext("2d");t=this._onLoadDelegate.shift();)this._handleRotation(t,!0)},_animateStart:function(){this._timer&&clearTimeout(this._timer),this._animateStartTime=+new Date,this._animateStartAngle=this._angle,this._animate()},_animate:function(){var t=+new Date,i=t-this._animateStartTime>this._parameters.duration;if(i&&!this._parameters.animatedGif)clearTimeout(this._timer);else{if(this._canvas||this._vimage||this._img){var e=this._parameters.easing(0,t-this._animateStartTime,this._animateStartAngle,this._parameters.animateTo-this._animateStartAngle,this._parameters.duration);this._rotate(~~(10*e)/10)}this._parameters.step&&this._parameters.step(this._angle);var a=this;this._timer=setTimeout(function(){a._animate.call(a)},10)}this._parameters.callback&&i&&(this._angle=this._parameters.animateTo,this._rotate(this._angle),this._parameters.callback.call(this._rootObj))},_rotate:(bf=Math.PI/180,IE?function(t){this._angle=t,this._container.style.rotation=t%360+"deg",this._vimage.style.top=-(this._rotationCenterY-this._imgHeight/2)+"px",this._vimage.style.left=-(this._rotationCenterX-this._imgWidth/2)+"px",this._container.style.top=this._rotationCenterY-this._imgHeight/2+"px",this._container.style.left=this._rotationCenterX-this._imgWidth/2+"px"}:supportedCSS?function(t){this._angle=t,this._img.style[supportedCSS]="rotate("+t%360+"deg)",this._img.style[supportedCSSOrigin]=this._parameters.center.join(" ")}:function(t){t=(this._angle=t)%360*bf,this._canvas.width=this._width,this._canvas.height=this._height,this._cnv.translate(this._imgWidth*this._aspectW,this._imgHeight*this._aspectH),this._cnv.translate(this._rotationCenterX,this._rotationCenterY),this._cnv.rotate(t),this._cnv.translate(-this._rotationCenterX,-this._rotationCenterY),this._cnv.scale(this._aspectW,this._aspectH),this._cnv.drawImage(this._img,0,0)})},IE&&(Wilq32.PhotoEffect.prototype.createVMLNode=function(){document.createStyleSheet().addRule(".rvml","behavior:url(#default#VML)");try{return document.namespaces.rvml||document.namespaces.add("rvml","urn:schemas-microsoft-com:vml"),function(t){return document.createElement("<rvml:"+t+' class="rvml">')}}catch(t){return function(t){return document.createElement("<"+t+' xmlns="urn:schemas-microsoft.com:vml" class="rvml">')}}}())}(jQuery);