<?php

namespace app\home\controller;


use think\Lang;
/**
 * ============================================================================
 * DSMall多用户商城
 * ============================================================================
 * 版权所有 2014-2028 长沙德尚网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.csdeshang.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 控制器
 */
class  Article extends BaseMall
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH.'home/lang/'.config('default_lang').'/article.lang.php');

    }

    /**
     * 文章列表显示页面
     */
    public function index()
    {
        $ac_id=intval(input('param.ac_id'));
        if (empty($ac_id)) {
            $this->error(lang('param_error'));//'缺少参数:文章类别编号'
        }
        /**
         * 得到导航ID
         */
        $nav_id = intval(input('param.nav_id'));
        $this->assign('index_sign', $nav_id);
        /**
         * 根据类别编号获取文章类别信息
         */
        $articleclass_model = model('articleclass');
        $condition = array();
        if (!empty($ac_id)) {
            $condition['ac_id'] = $ac_id;
        }
        $article_class = $articleclass_model->getOneArticleclass($ac_id);
        $this->assign('class_name', $article_class['ac_name']);
        if (empty($article_class) || !is_array($article_class)) {
            $this->error(lang('article_article_class_not_exists'));//'该文章分类并不存在'
        }
        $default_count = 5;//定义最新文章列表显示文章的数量
        /**
         * 分类导航
         */
        $nav_link = array(
            array(
                'title' => lang('homepage'), 'link' => HOME_SITE_URL
            ), array(
                'title' => $article_class['ac_name']
            )
        );
        $this->assign('nav_link_list', $nav_link);

        /**
         * 左侧分类导航
         */
        $condition = array();
        $condition['ac_parent_id'] = $article_class['ac_id'];
        $sub_class_list = $articleclass_model->getArticleclassList($condition);
        if (empty($sub_class_list) || !is_array($sub_class_list)) {
            $condition['ac_parent_id'] = $article_class['ac_parent_id'];
            $sub_class_list = $articleclass_model->getArticleclassList($condition);
        }
        $this->assign('sub_class_list', $sub_class_list);
        /**
         * 文章列表
         */
        $child_class_list = $articleclass_model->getChildClass($ac_id);
        $ac_ids = array();
        if (!empty($child_class_list) && is_array($child_class_list)) {
            foreach ($child_class_list as $v) {
                $ac_ids[] = $v['ac_id'];
            }
        }
        $ac_ids = implode(',', $ac_ids);
        $article_model = model('article');
        $condition = array();
        $condition['ac_id'] = array('in',$ac_ids);
        $condition['article_show'] = '1';
        $article_list = $article_model->getArticleList($condition, 10);
        $this->assign('article', $article_list);
        $this->assign('show_page', $article_model->page_info->render());
        /**
         * 最新文章列表
         */
        $count = count($article_list);
        $new_article_list = array();
        if (!empty($article_list) && is_array($article_list)) {
            for ($i = 0; $i < ($count > $default_count ? $default_count : $count); $i++) {
                $new_article_list[] = $article_list[$i];
            }
        }
        $this->assign('new_article_list', $new_article_list);
        
        //SEO 设置
        $seo = model('seo')->type('article')->param(array('article_class' => $article_class['ac_name']))->show();
        $this->_assign_seo($seo);
        
        return $this->fetch($this->template_dir.'article_list');
    }

    /**
     * 单篇文章显示页面
     */
    public function show()
    {
        $article_id=intval(input('param.article_id'));
        if (empty($article_id)) {
            $this->error(lang('param_error'));//'缺少参数:文章编号'
        }
        /**
         * 根据文章编号获取文章信息
         */
        $article_model = model('article');
        $condition = array();
        $condition['article_id'] = $article_id;
        $article = $article_model->getOneArticle($condition);
        if (empty($article) || !is_array($article) || $article['article_show'] == '0') {
            $this->error(lang('article_show_not_exists'));//'该文章并不存在'
        }
        $this->assign('article', $article);

        /**
         * 根据类别编号获取文章类别信息
         */
        $articleclass_model = model('articleclass');
        $condition = array();
        $article_class = $articleclass_model->getOneArticleclass($article['ac_id']);
        if (empty($article_class) || !is_array($article_class)) {
            $this->error(lang('article_show_delete'));//'该文章已随所属类别被删除'
        }
        $default_count = 5;//定义最新文章列表显示文章的数量
        /**
         * 分类导航
         */
        $nav_link = array(
            array(
                'title' => lang('homepage'), 'link' => HOME_SITE_URL
            ), array(
                'title' => $article_class['ac_name'],
                'link' => url('Article/index', array('ac_id' => $article_class['ac_id']))
            ), array(
                'title' => lang('article_show_article_content')
            )
        );
        $this->assign('nav_link_list', $nav_link);
        /**
         * 左侧分类导航
         */
        $condition = array();
        $condition['ac_parent_id'] = $article_class['ac_id'];
        $sub_class_list = $articleclass_model->getArticleclassList($condition);
        if (empty($sub_class_list) || !is_array($sub_class_list)) {
            $condition['ac_parent_id'] = $article_class['ac_parent_id'];
            $sub_class_list = $articleclass_model->getArticleclassList($condition);
        }
        $this->assign('sub_class_list', $sub_class_list);
        /**
         * 文章列表
         */
        $child_class_list = $articleclass_model->getChildClass($article_class['ac_id']);
        $ac_ids = array();
        if (!empty($child_class_list) && is_array($child_class_list)) {
            foreach ($child_class_list as $v) {
                $ac_ids[] = $v['ac_id'];
            }
        }
        $ac_ids = implode(',', $ac_ids);
        $article_model = model('article');
        $condition = array();
        $condition['ac_id'] = array('in',$ac_ids);
        $condition['article_show'] = '1';
        $article_list = $article_model->getArticleList($condition);
        /**
         * 寻找上一篇与下一篇
         */
        $pre_article = $next_article = array();
        if (!empty($article_list) && is_array($article_list)) {
            $pos = 0;
            foreach ($article_list as $k => $v) {
                if ($v['article_id'] == $article['article_id']) {
                    $pos = $k;
                    break;
                }
            }
            if ($pos > 0 && is_array($article_list[$pos - 1])) {
                $pre_article = $article_list[$pos - 1];
            }
            if ($pos < count($article_list) - 1 and is_array($article_list[$pos + 1])) {
                $next_article = $article_list[$pos + 1];
            }
        }
        $this->assign('pre_article', $pre_article);
        $this->assign('next_article', $next_article);
        /**
         * 最新文章列表
         */
        $count = count($article_list);
        $new_article_list = array();
        if (!empty($article_list) && is_array($article_list)) {
            for ($i = 0; $i < ($count > $default_count ? $default_count : $count); $i++) {
                $new_article_list[] = $article_list[$i];
            }
        }
        $this->assign('new_article_list', $new_article_list);

        $seo_param = array();
        $seo_param['name'] = $article['article_title'];
        $seo_param['article_class'] = $article_class['ac_name'];
        $seo_param['description'] = ds_substing(htmlspecialchars_decode($article['article_content']));
        //SEO 设置
        $seo = model('seo')->type('article_content')->param($seo_param)->show();
        $this->_assign_seo($seo);
        
        return $this->fetch($this->template_dir.'article_show');
    }
}