<?php

namespace app\home\controller;

use think\Lang;

/**
 * ============================================================================
 * DSMall多用户商城
 * ============================================================================
 * 版权所有 2014-2028 长沙德尚网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.csdeshang.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 控制器
 */
class Memberexampaper extends BaseMember {

    public function _initialize() {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/' . config('default_lang') . '/memberexampaper.lang.php');
    }

    //平台试卷列表
    public function index() {
        $exampaper_model = model('exampaper');
        $condition = array();
        $exampaper_list = $exampaper_model->getExampaperList($condition);
        $this->assign('exampaper_list', $exampaper_list);
        return $this->fetch($this->template_dir . 'index');
    }

    /**
     * 答题
     */
    public function answer() {
        $exampaper_id = intval(input('param.exampaper_id'));
        $exampaper_model = model('exampaper');
        $exampaper = $exampaper_model->getOneExampaper(array('exampaper_id' => $exampaper_id));
        if (empty($exampaper)) {
            $this->error(lang('param_error'));
        }

        if (!request()->isPost()) {
            if ($exampaper['exampaper_type'] == 0) {
                //普通测试题
                $exampaper['section_list'] = unserialize($exampaper['exampaper_setting']);
            } else {
                //随机题  根据配置自动生成题目
                $exampaper_setting = unserialize($exampaper['exampaper_setting']);
                $section_list = array();
                $exambank_model = model('exambank');
                foreach ($exampaper_setting as $value) {
                    //检索   根据条件 生成题目
                    $condition = array();
                    if (in_array($value['section_type'], array(1, 2, 3, 4, 5))) {
                        $condition['examtype_id'] = $value['section_type'];
                    }
                    if (in_array($value['section_level'], array(0, 1, 2, 3, 4))) {
                        $condition['exambank_level'] = $value['section_level'];
                    }
                    $limit = $value['section_nums']; #题目数量
                    $exambank_list = db('exambank')->where($condition)->limit($limit)->select();

                    $section_score = $value['section_score']; #每题得分
                    //题目
                    $items = array();
                    $i = 0;
                    foreach ($exambank_list as $key => $exambank) {
                        $items[$i]['exambank_score'] = $section_score;
                        $items[$i]['examtype_id'] = $exambank['examtype_id'];
                        $items[$i]['exambank_id'] = $exambank['exambank_id'];
                        $items[$i]['exambank_question'] = $exambank['exambank_question'];
                        $items[$i]['exambank_answer'] = $exambank['exambank_answer'];
                        $items[$i]['exambank_select'] = $exambank['exambank_select'];
                        $items[$i]['exambank_selectnum'] = $exambank['exambank_selectnum'];
                        $items[$i]['exambank_describe'] = $exambank['exambank_describe'];
                        $items[$i]['exambank_level'] = $exambank['exambank_level'];
                    }

                    $section_list[] = array(
                        'section_name' => $value['section_name'],
                        'section_remark' => $value['section_remark'],
                        'items' => $items,
                    );
                }
                $exampaper['section_list'] = $section_list;
                $exampaper['section_list_serialize'] = serialize($section_list);
            }
            $this->assign('exampaper', $exampaper);

            //SEO 设置
            $seo = array(
                'html_title' => config('site_name') . '-' . $exampaper['exampaper_name'],
                'seo_keywords' => $exampaper['exampaper_name'],
                'seo_description' => $exampaper['exampaper_name'],
            );
            $this->_assign_seo($seo);
            return $this->fetch($this->template_dir . 'answer');
        } else {
            $exampaperlog_model = model('exampaperlog');
            // 用户提交的答案
            $member_answer = input('param.member_answer/a');
            if ($exampaper['exampaper_type'] == 0) {
                //普通测试题  答案和数据整合一起
                $section_list = unserialize($exampaper['exampaper_setting']);
            } else {
                // 随机题 获取生成的数据 整合一起 录入到试卷
                $section_list = unserialize($_POST['section_list_serialize']);
            }
            foreach ($section_list as $section_key => $section_value) {
                foreach ($section_value['items'] as $item_key => $item_value) {
                    //$section_list 新增答案  存放至数组
                    $section_list[$section_key]['items'][$item_key]['member_answer'] = $this->get_member_answer($item_value['examtype_id'], isset($member_answer[$item_value['exambank_id']]) ? $member_answer[$item_value['exambank_id']] : '');
                }
            }
            $data = array(
                'member_id' => session('member_id'),
                'member_name' => session('member_name'),
                'exampaper_id' => $exampaper_id,
                'store_id' => $exampaper['store_id'],
                'exampaperlog_data' => serialize($section_list),
                'exampaperlog_state' => 1,
                'exampaperlog_ip' => request()->ip(),
                'exampaperlog_begintime' => input('param.exampaperlog_begintime'),
                'exampaperlog_endtime' => TIMESTAMP,
            );
            $result = $exampaperlog_model->addExampaperlog($data);

            $this->success('提交成功');
        }
    }

    private function get_member_answer($examtype_id, $member_answer) {
        if (empty($member_answer)) {
            return '';
        }
        if (in_array($examtype_id, array(1, 2, 3, 5))) {
            //单选  判断  问答
            return implode('', $member_answer);
        } elseif ($examtype_id == 4) {
            //填空
            return implode('+', $member_answer);
        }
    }

    /**
     * 历史考试记录
     */
    public function log() {
        $exampaperlog_model = model('exampaperlog');
        $condition = array();
        $condition['member_id'] = session('member_id');
        $exampaperlog_list = $exampaperlog_model->getExampaperlogList($condition, 10);
        $this->assign('exampaperlog_list', $exampaperlog_list);
        $this->assign('show_page', $exampaperlog_model->page_info->render());
        $this->setMemberCurMenu('member_exampaper');
        $this->setMemberCurItem('log');
        return $this->fetch($this->template_dir . 'log');
    }

    /**
     * 查看考试试卷
     */
    public function check() {
        //获取试卷答案
        $exampaperlog_id = intval(input('param.exampaperlog_id'));
        $exampaperlog_model = model('exampaperlog');
        $condition = array(
            'exampaperlog_id' => $exampaperlog_id,
            'member_id' => session('member_id'),
        );
        $exampaperlog = $exampaperlog_model->getOneExampaperlog($condition);
        $section_list = unserialize($exampaperlog['exampaperlog_data']);
        $exampaperlog['section_list'] = $section_list;
        $this->assign('exampaperlog', $exampaperlog);
        //获取试卷题目
        $exampaper_model = model('exampaper');
        $exampaper = $exampaper_model->getOneExampaper(array('exampaper_id' => $exampaperlog['exampaper_id']));
        $this->assign('exampaper', $exampaper);
        return $this->fetch($this->template_dir . 'check');
    }

    protected function getMemberItemList() {
        $menu_array = array(
            array(
                'name' => 'log', 'text' => lang('member_exampaper_log'), 'url' => url('Memberexampaper/log')
            )
        );
        return $menu_array;
    }

}
