package com.zebra.system.domain;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.zebra.common.core.domain.BaseEntity;

import lombok.Getter;
import lombok.Setter;

/**
 * 菜单权限表 sys_menu
 *
 * @author zebra
 */
@Getter
@Setter
public class SysMenu extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** 菜单ID */
	private Long menuId;

	/** 菜单名称 */
	private String menuName;

	/** 父菜单名称 */
	private String parentName;

	/** 父菜单ID */
	private Long parentId;

	/** 显示顺序 */
	private String orderNum;

	/** 菜单URL */
	private String url;

	/** 打开方式：menuItem页签 menuBlank新窗口 */
	private String target;

	/** 类型:0目录,1菜单,2按钮 */
	private String menuType;

	/** 菜单状态:0显示,1隐藏 */
	private String visible;

	/** 权限字符串 */
	private String perms;

	/** 菜单图标 */
	private String icon;

	/** 子菜单 */
	private List<SysMenu> children = new ArrayList<SysMenu>();

	@Override
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("menuId", getMenuId())
				.append("menuName", getMenuName()).append("parentId", getParentId()).append("orderNum", getOrderNum())
				.append("url", getUrl()).append("target", getTarget()).append("menuType", getMenuType())
				.append("visible", getVisible()).append("perms", getPerms()).append("icon", getIcon())
				.append("createBy", getCreateBy()).append("createTime", getCreateTime())
				.append("updateBy", getUpdateBy()).append("updateTime", getUpdateTime()).append("remark", getRemark())
				.toString();
	}
}
