package com.zebra.quartz.domain;

import java.util.Date;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.zebra.common.annotation.Excel;
import com.zebra.common.constant.ScheduleConstants;
import com.zebra.common.core.domain.BaseEntity;
import com.zebra.common.utils.StringUtils;
import com.zebra.quartz.util.CronUtils;

/**
 * 定时任务调度表 sys_job
 *
 * @author ruoyi
 */
public class SysJob extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** 任务ID */
	@Excel(name = "任务序号")
	private Long jobId;

	/** 任务名称 */
	@Excel(name = "任务名称")
	private String jobName;

	/** 任务组名 */
	@Excel(name = "任务组名")
	private String jobGroup;

	/** 任务方法 */
	@Excel(name = "任务方法")
	private String methodName;

	/** 方法参数 */
	@Excel(name = "方法参数")
	private String methodParams;

	/** cron执行表达式 */
	@Excel(name = "执行表达式 ")
	private String cronExpression;

	/** cron计划策略 */
	@Excel(name = "计划策略 ")
	private String misfirePolicy = ScheduleConstants.MISFIRE_DEFAULT;

	/** 是否并发执行（0允许 1禁止） */
	@Excel(name = "并发执行", readConverterExp = "0=允许,1=禁止")
	private String concurrent;

	/** 任务状态（0正常 1暂停） */
	@Excel(name = "任务状态", readConverterExp = "0=正常,1=暂停")
	private String status;

	public Long getJobId() {
		return jobId;
	}

	public void setJobId(Long jobId) {
		this.jobId = jobId;
	}

	public String getJobName() {
		return jobName;
	}

	public void setJobName(String jobName) {
		this.jobName = jobName;
	}

	public String getJobGroup() {
		return jobGroup;
	}

	public void setJobGroup(String jobGroup) {
		this.jobGroup = jobGroup;
	}

	public String getMethodName() {
		return methodName;
	}

	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}

	public String getMethodParams() {
		return methodParams;
	}

	public void setMethodParams(String methodParams) {
		this.methodParams = methodParams;
	}

	public String getCronExpression() {
		return cronExpression;
	}

	public void setCronExpression(String cronExpression) {
		this.cronExpression = cronExpression;
	}

	public Date getNextValidTime() {
		if (StringUtils.isNotEmpty(cronExpression)) {
			return CronUtils.getNextExecution(cronExpression);
		}
		return null;
	}

	public String getMisfirePolicy() {
		return misfirePolicy;
	}

	public void setMisfirePolicy(String misfirePolicy) {
		this.misfirePolicy = misfirePolicy;
	}

	public String getConcurrent() {
		return concurrent;
	}

	public void setConcurrent(String concurrent) {
		this.concurrent = concurrent;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("jobId", getJobId())
				.append("jobName", getJobName()).append("jobGroup", getJobGroup()).append("methodName", getMethodName())
				.append("methodParams", getMethodParams()).append("cronExpression", getCronExpression())
				.append("nextValidTime", getNextValidTime()).append("misfirePolicy", getMisfirePolicy())
				.append("concurrent", getConcurrent()).append("status", getStatus()).append("createBy", getCreateBy())
				.append("createTime", getCreateTime()).append("updateBy", getUpdateBy())
				.append("updateTime", getUpdateTime()).append("remark", getRemark()).toString();
	}
}