/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.Buffer;

public class HttpInput
extends ServletInputStream {
    protected final HttpParser _parser;
    protected final long _maxIdleTime;

    public HttpInput(HttpParser parser, long maxIdleTime) {
        this._parser = parser;
        this._maxIdleTime = maxIdleTime;
    }

    @Override
    public int read() throws IOException {
        int c = -1;
        Buffer content = this._parser.blockForContent(this._maxIdleTime);
        if (content != null) {
            c = 0xFF & content.get();
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l = -1;
        Buffer content = this._parser.blockForContent(this._maxIdleTime);
        if (content != null) {
            l = content.get(b, off, len);
        }
        return l;
    }
}

