/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import org.eclipse.jetty.http.AbstractGenerator;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.ByteArrayOutputStream2;

public class HttpOutput
extends ServletOutputStream {
    protected final AbstractGenerator _generator;
    protected final long _maxIdleTime;
    protected final ByteArrayBuffer _buf = new ByteArrayBuffer(AbstractGenerator.NO_BYTES);
    private boolean _closed;
    String _characterEncoding;
    Writer _converter;
    char[] _chars;
    ByteArrayOutputStream2 _bytes;

    public HttpOutput(AbstractGenerator generator, long maxIdleTime) {
        this._generator = generator;
        this._maxIdleTime = maxIdleTime;
    }

    public boolean isWritten() {
        return this._generator.getContentWritten() > 0L;
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void reopen() {
        this._closed = false;
    }

    @Override
    public void flush() throws IOException {
        this._generator.flush(this._maxIdleTime);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this._buf.wrap(b, off, len);
        this.write(this._buf);
        this._buf.wrap(AbstractGenerator.NO_BYTES);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this._buf.wrap(b);
        this.write(this._buf);
        this._buf.wrap(AbstractGenerator.NO_BYTES);
    }

    @Override
    public void write(int b) throws IOException {
        if (this._closed) {
            throw new IOException("Closed");
        }
        if (!this._generator.isOpen()) {
            throw new EofException();
        }
        while (this._generator.isBufferFull()) {
            this._generator.blockForOutput(this._maxIdleTime);
            if (this._closed) {
                throw new IOException("Closed");
            }
            if (this._generator.isOpen()) continue;
            throw new EofException();
        }
        if (this._generator.addContent((byte)b)) {
            this.flush();
        }
        if (this._generator.isAllContentWritten()) {
            this.flush();
            this.close();
        }
    }

    private void write(Buffer buffer) throws IOException {
        if (this._closed) {
            throw new IOException("Closed");
        }
        if (!this._generator.isOpen()) {
            throw new EofException();
        }
        while (this._generator.isBufferFull()) {
            this._generator.blockForOutput(this._maxIdleTime);
            if (this._closed) {
                throw new IOException("Closed");
            }
            if (this._generator.isOpen()) continue;
            throw new EofException();
        }
        this._generator.addContent(buffer, false);
        if (this._generator.isBufferFull()) {
            this.flush();
        }
        if (this._generator.isAllContentWritten()) {
            this.flush();
            this.close();
        }
        while (buffer.length() > 0 && this._generator.isOpen()) {
            this._generator.blockForOutput(this._maxIdleTime);
        }
    }

    @Override
    public void print(String s) throws IOException {
        this.write(s.getBytes());
    }
}

