/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

public abstract class AbstractSessionManager
extends AbstractLifeCycle
implements SessionManager {
    public Set<SessionTrackingMode> __defaultSessionTrackingModes = Collections.unmodifiableSet(new HashSet<SessionTrackingMode>(Arrays.asList(SessionTrackingMode.COOKIE, SessionTrackingMode.URL)));
    public static final int __distantFuture = 628992000;
    private static final HttpSessionContext __nullSessionContext = new NullSessionContext();
    protected int _dftMaxIdleSecs = -1;
    protected SessionHandler _sessionHandler;
    protected boolean _httpOnly = false;
    protected SessionIdManager _sessionIdManager;
    protected boolean _secureCookies = false;
    protected Object _sessionAttributeListeners;
    protected Object _sessionListeners;
    protected ClassLoader _loader;
    protected ContextHandler.Context _context;
    protected String _sessionCookie = "JSESSIONID";
    protected String _sessionIdPathParameterName = "jsessionid";
    protected String _sessionIdPathParameterNamePrefix = ";" + this._sessionIdPathParameterName + "=";
    protected String _sessionDomain;
    protected String _sessionPath;
    protected int _maxCookieAge = -1;
    protected int _refreshCookieAge;
    protected boolean _nodeIdInSessionId;
    protected boolean _checkingRemoteSessionIdEncoding;
    protected String _sessionComment;
    public Set<SessionTrackingMode> _sessionTrackingModes;
    private boolean _usingCookies;
    private boolean _usingURLs;
    protected final CounterStatistic _sessionsStats = new CounterStatistic();
    protected final SampleStatistic _sessionTimeStats = new SampleStatistic();
    private SessionCookieConfig _cookieConfig = new SessionCookieConfig(){

        @Override
        public String getComment() {
            return AbstractSessionManager.this._sessionComment;
        }

        @Override
        public String getDomain() {
            return AbstractSessionManager.this._sessionDomain;
        }

        @Override
        public int getMaxAge() {
            return AbstractSessionManager.this._maxCookieAge;
        }

        @Override
        public String getName() {
            return AbstractSessionManager.this._sessionCookie;
        }

        @Override
        public String getPath() {
            return AbstractSessionManager.this._sessionPath;
        }

        @Override
        public boolean isHttpOnly() {
            return AbstractSessionManager.this._httpOnly;
        }

        @Override
        public boolean isSecure() {
            return AbstractSessionManager.this._secureCookies;
        }

        @Override
        public void setComment(String comment) {
            AbstractSessionManager.this._sessionComment = comment;
        }

        @Override
        public void setDomain(String domain) {
            AbstractSessionManager.this._sessionDomain = domain;
        }

        @Override
        public void setHttpOnly(boolean httpOnly) {
            AbstractSessionManager.this._httpOnly = httpOnly;
        }

        @Override
        public void setMaxAge(int maxAge) {
            AbstractSessionManager.this._maxCookieAge = maxAge;
        }

        @Override
        public void setName(String name) {
            AbstractSessionManager.this._sessionCookie = name;
        }

        @Override
        public void setPath(String path) {
            AbstractSessionManager.this._sessionPath = path;
        }

        @Override
        public void setSecure(boolean secure) {
            AbstractSessionManager.this._secureCookies = secure;
        }
    };

    public AbstractSessionManager() {
        this.setSessionTrackingModes(this.__defaultSessionTrackingModes);
    }

    @Override
    public HttpCookie access(HttpSession session, boolean secure) {
        long now = System.currentTimeMillis();
        Session s = ((SessionIf)session).getSession();
        s.access(now);
        if (this.isUsingCookies() && (s.isIdChanged() || this.getSessionCookieConfig().getMaxAge() > 0 && this.getRefreshCookieAge() > 0 && (now - s.getCookieSetTime()) / 1000L > (long)this.getRefreshCookieAge())) {
            HttpCookie cookie = this.getSessionCookie(session, this._context == null ? "/" : this._context.getContextPath(), secure);
            s.cookieSet();
            s.setIdChanged(false);
            return cookie;
        }
        return null;
    }

    @Override
    public void addEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners = LazyList.add(this._sessionAttributeListeners, listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners = LazyList.add(this._sessionListeners, listener);
        }
    }

    @Override
    public void clearEventListeners() {
        this._sessionAttributeListeners = null;
        this._sessionListeners = null;
    }

    @Override
    public void complete(HttpSession session) {
        Session s = ((SessionIf)session).getSession();
        s.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStart() throws Exception {
        this._context = ContextHandler.getCurrentContext();
        this._loader = Thread.currentThread().getContextClassLoader();
        if (this._sessionIdManager == null) {
            Server server;
            Server server2 = server = this.getSessionHandler().getServer();
            synchronized (server2) {
                this._sessionIdManager = server.getSessionIdManager();
                if (this._sessionIdManager == null) {
                    this._sessionIdManager = new HashSessionIdManager();
                    server.setSessionIdManager(this._sessionIdManager);
                }
            }
        }
        if (!this._sessionIdManager.isStarted()) {
            this._sessionIdManager.start();
        }
        if (this._context != null) {
            String tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionCookie");
            if (tmp != null) {
                this._sessionCookie = tmp;
            }
            if ((tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionIdPathParameterName")) != null) {
                this.setSessionIdPathParameterName(tmp);
            }
            if (this._maxCookieAge == -1 && (tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.MaxAge")) != null) {
                this._maxCookieAge = Integer.parseInt(tmp.trim());
            }
            if (this._sessionDomain == null) {
                this._sessionDomain = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionDomain");
            }
            if (this._sessionPath == null) {
                this._sessionPath = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionPath");
            }
            if ((tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.CheckingRemoteSessionIdEncoding")) != null) {
                this._checkingRemoteSessionIdEncoding = Boolean.parseBoolean(tmp);
            }
        }
        super.doStart();
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        this.invalidateSessions();
        this._loader = null;
    }

    @Override
    public boolean getHttpOnly() {
        return this._httpOnly;
    }

    @Override
    public HttpSession getHttpSession(String nodeId) {
        String cluster_id = this.getIdManager().getClusterId(nodeId);
        Session session = this.getSession(cluster_id);
        if (session != null && !session.getNodeId().equals(nodeId)) {
            session.setIdChanged(true);
        }
        return session;
    }

    @Override
    public SessionIdManager getIdManager() {
        return this._sessionIdManager;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    @Deprecated
    public int getMaxSessions() {
        return this.getSessionsMax();
    }

    public int getSessionsMax() {
        return (int)this._sessionsStats.getMax();
    }

    public int getSessionsTotal() {
        return (int)this._sessionsStats.getTotal();
    }

    @Deprecated
    public SessionIdManager getMetaManager() {
        return this.getIdManager();
    }

    @Deprecated
    public int getMinSessions() {
        return 0;
    }

    public int getRefreshCookieAge() {
        return this._refreshCookieAge;
    }

    @Override
    public HttpCookie getSessionCookie(HttpSession session, String contextPath, boolean requestIsSecure) {
        if (this.isUsingCookies()) {
            String sessionPath = this._sessionPath == null ? contextPath : this._sessionPath;
            sessionPath = sessionPath == null || sessionPath.length() == 0 ? "/" : sessionPath;
            String id = this.getNodeId(session);
            HttpCookie cookie = null;
            cookie = this._sessionComment == null ? new HttpCookie(this._sessionCookie, id, this._sessionDomain, sessionPath, this._cookieConfig.getMaxAge(), this._cookieConfig.isHttpOnly(), this._cookieConfig.isSecure()) : new HttpCookie(this._sessionCookie, id, this._sessionDomain, sessionPath, this._cookieConfig.getMaxAge(), this._cookieConfig.isHttpOnly(), this._cookieConfig.isSecure(), this._sessionComment, 1);
            return cookie;
        }
        return null;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public abstract Map getSessionMap();

    public int getSessions() {
        return (int)this._sessionsStats.getCurrent();
    }

    @Override
    public String getSessionIdPathParameterName() {
        return this._sessionIdPathParameterName;
    }

    @Override
    public String getSessionIdPathParameterNamePrefix() {
        return this._sessionIdPathParameterNamePrefix;
    }

    @Override
    public boolean isValid(HttpSession session) {
        Session s = ((SessionIf)session).getSession();
        return s.isValid();
    }

    @Override
    public String getClusterId(HttpSession session) {
        Session s = ((SessionIf)session).getSession();
        return s.getClusterId();
    }

    @Override
    public String getNodeId(HttpSession session) {
        Session s = ((SessionIf)session).getSession();
        return s.getNodeId();
    }

    @Override
    public HttpSession newHttpSession(HttpServletRequest request) {
        Session session = this.newSession(request);
        session.setMaxInactiveInterval(this._dftMaxIdleSecs);
        this.addSession(session, true);
        return session;
    }

    @Override
    public void removeEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners = LazyList.remove(this._sessionAttributeListeners, listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners = LazyList.remove(this._sessionListeners, listener);
        }
    }

    @Deprecated
    public void resetStats() {
        this.statsReset();
    }

    public void statsReset() {
        this._sessionsStats.reset(this.getSessions());
        this._sessionTimeStats.reset();
    }

    public void setHttpOnly(boolean httpOnly) {
        this._httpOnly = httpOnly;
    }

    @Override
    public void setIdManager(SessionIdManager metaManager) {
        this._sessionIdManager = metaManager;
    }

    @Override
    public void setMaxInactiveInterval(int seconds) {
        this._dftMaxIdleSecs = seconds;
    }

    public void setRefreshCookieAge(int ageInSeconds) {
        this._refreshCookieAge = ageInSeconds;
    }

    public void setSecureCookies(boolean secureCookies) {
        this._secureCookies = secureCookies;
    }

    public void setSessionCookie(String cookieName) {
        this._sessionCookie = cookieName;
    }

    public void setSessionDomain(String domain) {
        this._sessionDomain = domain;
    }

    @Override
    public void setSessionHandler(SessionHandler sessionHandler) {
        this._sessionHandler = sessionHandler;
    }

    @Override
    public void setSessionIdPathParameterName(String param) {
        this._sessionIdPathParameterName = param == null || "none".equals(param) ? null : param;
        this._sessionIdPathParameterNamePrefix = param == null || "none".equals(param) ? null : ";" + this._sessionIdPathParameterName + "=";
    }

    protected abstract void addSession(Session var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(Session session, boolean created) {
        SessionIdManager sessionIdManager = this._sessionIdManager;
        synchronized (sessionIdManager) {
            this._sessionIdManager.addSession(session);
            this.addSession(session);
        }
        if (created) {
            this._sessionsStats.increment();
            if (this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent(session);
                for (int i = 0; i < LazyList.size(this._sessionListeners); ++i) {
                    ((HttpSessionListener)LazyList.get(this._sessionListeners, i)).sessionCreated(event);
                }
            }
        }
    }

    public abstract Session getSession(String var1);

    protected abstract void invalidateSessions();

    protected abstract Session newSession(HttpServletRequest var1);

    public boolean isNodeIdInSessionId() {
        return this._nodeIdInSessionId;
    }

    public void setNodeIdInSessionId(boolean nodeIdInSessionId) {
        this._nodeIdInSessionId = nodeIdInSessionId;
    }

    public void removeSession(HttpSession session, boolean invalidate) {
        Session s = ((SessionIf)session).getSession();
        this.removeSession(s, invalidate);
    }

    public void removeSession(Session session, boolean invalidate) {
        boolean removed = this.removeSession(session.getClusterId());
        if (removed) {
            this._sessionsStats.decrement();
            this._sessionTimeStats.set(Math.round((double)(System.currentTimeMillis() - session.getCreationTime()) / 1000.0));
            this._sessionIdManager.removeSession(session);
            if (invalidate) {
                this._sessionIdManager.invalidateAll(session.getClusterId());
            }
            if (invalidate && this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent(session);
                int i = LazyList.size(this._sessionListeners);
                while (i-- > 0) {
                    ((HttpSessionListener)LazyList.get(this._sessionListeners, i)).sessionDestroyed(event);
                }
            }
        }
    }

    protected abstract boolean removeSession(String var1);

    public long getSessionTimeMax() {
        return this._sessionTimeStats.getMax();
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.__defaultSessionTrackingModes;
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return Collections.unmodifiableSet(this._sessionTrackingModes);
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this._sessionTrackingModes = new HashSet<SessionTrackingMode>(sessionTrackingModes);
        this._usingCookies = this._sessionTrackingModes.contains((Object)SessionTrackingMode.COOKIE);
        this._usingURLs = this._sessionTrackingModes.contains((Object)SessionTrackingMode.URL);
    }

    @Override
    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    @Override
    public boolean isUsingURLs() {
        return this._usingURLs;
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        return this._cookieConfig;
    }

    public long getSessionTimeTotal() {
        return this._sessionTimeStats.getTotal();
    }

    public double getSessionTimeMean() {
        return this._sessionTimeStats.getMean();
    }

    public double getSessionTimeStdDev() {
        return this._sessionTimeStats.getStdDev();
    }

    @Override
    public boolean isCheckingRemoteSessionIdEncoding() {
        return this._checkingRemoteSessionIdEncoding;
    }

    @Override
    public void setCheckingRemoteSessionIdEncoding(boolean remote) {
        this._checkingRemoteSessionIdEncoding = remote;
    }

    public abstract class Session
    implements SessionIf,
    Serializable {
        protected final String _clusterId;
        protected final String _nodeId;
        protected final Map<String, Object> _attributes = new HashMap<String, Object>();
        protected boolean _idChanged;
        protected final long _created;
        protected long _cookieSet;
        protected long _accessed;
        protected long _lastAccessed;
        protected boolean _invalid;
        protected boolean _doInvalidate;
        protected long _maxIdleMs;
        protected boolean _newSession;
        protected int _requests;

        protected Session(HttpServletRequest request) {
            this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs > 0 ? (long)(AbstractSessionManager.this._dftMaxIdleSecs * 1000) : -1L;
            this._newSession = true;
            this._created = System.currentTimeMillis();
            this._clusterId = AbstractSessionManager.this._sessionIdManager.newSessionId(request, this._created);
            this._nodeId = AbstractSessionManager.this._sessionIdManager.getNodeId(this._clusterId, request);
            this._accessed = this._created;
            this._lastAccessed = this._created;
            this._requests = 1;
            Log.debug("new session & id " + this._nodeId + " " + this._clusterId);
        }

        protected Session(long created, long accessed, String clusterId) {
            this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs > 0 ? (long)(AbstractSessionManager.this._dftMaxIdleSecs * 1000) : -1L;
            this._created = created;
            this._clusterId = clusterId;
            this._nodeId = AbstractSessionManager.this._sessionIdManager.getNodeId(this._clusterId, null);
            this._accessed = accessed;
            this._lastAccessed = accessed;
            this._requests = 1;
            Log.debug("new session " + this._nodeId + " " + this._clusterId);
        }

        protected boolean isNotAvailable() {
            return this._invalid;
        }

        @Override
        public Session getSession() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getAttribute(String name) {
            Session session = this;
            synchronized (session) {
                if (this.isNotAvailable()) {
                    throw new IllegalStateException();
                }
                return this._attributes.get(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration getAttributeNames() {
            Session session = this;
            synchronized (session) {
                if (this.isNotAvailable()) {
                    throw new IllegalStateException();
                }
                List<Object> names = this._attributes == null ? Collections.EMPTY_LIST : new ArrayList<String>(this._attributes.keySet());
                return Collections.enumeration(names);
            }
        }

        public long getCookieSetTime() {
            return this._cookieSet;
        }

        @Override
        public long getCreationTime() throws IllegalStateException {
            if (this.isNotAvailable()) {
                throw new IllegalStateException();
            }
            return this._created;
        }

        @Override
        public String getId() throws IllegalStateException {
            return AbstractSessionManager.this._nodeIdInSessionId ? this._nodeId : this._clusterId;
        }

        protected String getNodeId() {
            return this._nodeId;
        }

        protected String getClusterId() {
            return this._clusterId;
        }

        @Override
        public long getLastAccessedTime() throws IllegalStateException {
            if (this.isNotAvailable()) {
                throw new IllegalStateException();
            }
            return this._lastAccessed;
        }

        @Override
        public int getMaxInactiveInterval() {
            if (this.isNotAvailable()) {
                throw new IllegalStateException();
            }
            return (int)(this._maxIdleMs / 1000L);
        }

        @Override
        public ServletContext getServletContext() {
            return AbstractSessionManager.this._context;
        }

        @Override
        @Deprecated
        public HttpSessionContext getSessionContext() throws IllegalStateException {
            if (this.isNotAvailable()) {
                throw new IllegalStateException();
            }
            return __nullSessionContext;
        }

        @Override
        @Deprecated
        public Object getValue(String name) throws IllegalStateException {
            return this.getAttribute(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public String[] getValueNames() throws IllegalStateException {
            Session session = this;
            synchronized (session) {
                if (this.isNotAvailable()) {
                    throw new IllegalStateException();
                }
                if (this._attributes == null) {
                    return new String[0];
                }
                String[] a = new String[this._attributes.size()];
                return this._attributes.keySet().toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void access(long time) {
            Session session = this;
            synchronized (session) {
                if (!this._invalid) {
                    this._newSession = false;
                    this._lastAccessed = this._accessed;
                    this._accessed = time;
                    if (this._maxIdleMs > 0L && this._lastAccessed > 0L && this._lastAccessed + this._maxIdleMs < time) {
                        this.invalidate();
                    } else {
                        ++this._requests;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void complete() {
            Session session = this;
            synchronized (session) {
                --this._requests;
                if (this._doInvalidate && this._requests <= 0) {
                    this.doInvalidate();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void timeout() throws IllegalStateException {
            AbstractSessionManager.this.removeSession(this, true);
            Session session = this;
            synchronized (session) {
                if (!this._invalid) {
                    if (this._requests <= 0) {
                        this.doInvalidate();
                    } else {
                        this._doInvalidate = true;
                    }
                }
            }
        }

        @Override
        public void invalidate() throws IllegalStateException {
            AbstractSessionManager.this.removeSession(this, true);
            this.doInvalidate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doInvalidate() throws IllegalStateException {
            try {
                Log.debug("invalidate ", this._clusterId);
                if (this.isNotAvailable()) {
                    throw new IllegalStateException();
                }
                while (this._attributes != null && this._attributes.size() > 0) {
                    ArrayList<String> keys;
                    Session session = this;
                    synchronized (session) {
                        keys = new ArrayList<String>(this._attributes.keySet());
                    }
                    for (String key : keys) {
                        Object value;
                        Session session2 = this;
                        synchronized (session2) {
                            value = this._attributes.remove(key);
                        }
                        this.unbindValue(key, value);
                        if (AbstractSessionManager.this._sessionAttributeListeners == null) continue;
                        HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, key, value);
                        for (int i = 0; i < LazyList.size(AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                            ((HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this._sessionAttributeListeners, i)).attributeRemoved(event);
                        }
                    }
                }
            }
            finally {
                this._invalid = true;
            }
        }

        public boolean isIdChanged() {
            return this._idChanged;
        }

        @Override
        public boolean isNew() throws IllegalStateException {
            if (this.isNotAvailable()) {
                throw new IllegalStateException();
            }
            return this._newSession;
        }

        @Override
        @Deprecated
        public void putValue(String name, Object value) throws IllegalStateException {
            this.setAttribute(name, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAttribute(String name) {
            Object old;
            Session session = this;
            synchronized (session) {
                if (this.isNotAvailable()) {
                    throw new IllegalStateException();
                }
                if (this._attributes == null) {
                    return;
                }
                old = this._attributes.remove(name);
            }
            if (old != null) {
                this.unbindValue(name, old);
                if (AbstractSessionManager.this._sessionAttributeListeners != null) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, name, old);
                    for (int i = 0; i < LazyList.size(AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                        ((HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this._sessionAttributeListeners, i)).attributeRemoved(event);
                    }
                }
            }
        }

        @Override
        @Deprecated
        public void removeValue(String name) throws IllegalStateException {
            this.removeAttribute(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttribute(String name, Object value) {
            Object old_value = null;
            Session session = this;
            synchronized (session) {
                if (value == null) {
                    this.removeAttribute(name);
                    return;
                }
                if (this.isNotAvailable()) {
                    throw new IllegalStateException();
                }
                old_value = this._attributes.put(name, value);
            }
            if (old_value == null || !value.equals(old_value)) {
                this.unbindValue(name, old_value);
                this.bindValue(name, value);
                if (AbstractSessionManager.this._sessionAttributeListeners != null) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, name, old_value == null ? value : old_value);
                    for (int i = 0; i < LazyList.size(AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                        HttpSessionAttributeListener l = (HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this._sessionAttributeListeners, i);
                        if (old_value == null) {
                            l.attributeAdded(event);
                            continue;
                        }
                        l.attributeReplaced(event);
                    }
                }
            }
        }

        public void setIdChanged(boolean changed) {
            this._idChanged = changed;
        }

        @Override
        public void setMaxInactiveInterval(int secs) {
            this._maxIdleMs = (long)secs * 1000L;
        }

        public String toString() {
            return this.getClass().getName() + ":" + this.getId() + "@" + this.hashCode();
        }

        protected void bindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent(this, name));
            }
        }

        protected boolean isValid() {
            return !this._invalid;
        }

        protected void cookieSet() {
            this._cookieSet = this._accessed;
        }

        protected void unbindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent(this, name));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void willPassivate() {
            Session session = this;
            synchronized (session) {
                HttpSessionEvent event = new HttpSessionEvent(this);
                for (Object value : this._attributes.values()) {
                    if (!(value instanceof HttpSessionActivationListener)) continue;
                    HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                    listener.sessionWillPassivate(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void didActivate() {
            Session session = this;
            synchronized (session) {
                HttpSessionEvent event = new HttpSessionEvent(this);
                for (Object value : this._attributes.values()) {
                    if (!(value instanceof HttpSessionActivationListener)) continue;
                    HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                    listener.sessionDidActivate(event);
                }
            }
        }
    }

    public static interface SessionIf
    extends HttpSession {
        public Session getSession();
    }

    public static class NullSessionContext
    implements HttpSessionContext {
        private NullSessionContext() {
        }

        @Deprecated
        public Enumeration getIds() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        @Override
        @Deprecated
        public HttpSession getSession(String id) {
            return null;
        }
    }
}

