/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;

public abstract class WebSocketServlet
extends HttpServlet {
    WebSocketFactory _websocket;

    @Override
    public void init() throws ServletException {
        String bs = this.getInitParameter("bufferSize");
        this._websocket = new WebSocketFactory(bs == null ? 8192 : Integer.parseInt(bs));
        String mit = this.getInitParameter("maxIdleTime");
        if (mit != null) {
            this._websocket.setMaxIdleTime(Integer.parseInt(mit));
        }
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("WebSocket".equals(request.getHeader("Upgrade"))) {
            boolean hixie = request.getHeader("Sec-WebSocket-Key1") != null;
            String protocol = request.getHeader(hixie ? "Sec-WebSocket-Protocol" : "WebSocket-Protocol");
            if (protocol == null) {
                protocol = request.getHeader("Sec-WebSocket-Protocol");
            }
            WebSocket websocket = this.doWebSocketConnect(request, protocol);
            String host = request.getHeader("Host");
            String origin = request.getHeader("Origin");
            origin = this.checkOrigin(request, host, origin);
            if (websocket != null) {
                this._websocket.upgrade(request, response, websocket, origin, protocol);
            } else {
                if (hixie) {
                    response.setHeader("Connection", "close");
                }
                response.sendError(503);
            }
        } else {
            super.service(request, response);
        }
    }

    protected String checkOrigin(HttpServletRequest request, String host, String origin) {
        if (origin == null) {
            origin = host;
        }
        return origin;
    }

    protected abstract WebSocket doWebSocketConnect(HttpServletRequest var1, String var2);
}

