/**
 * Created by JetBrains WebStorm.
 * User: shenlixia01
 * Date: 11-8-12
 * Time: 下午3:45
 * To change this template use File | Settings | File Templates.
 */
module( 'commands.delete' );

test( 'chrome删除后切换源码再切换回来，光标没了', function() {
    var editor = new baidu.editor.Editor( {'plugins':['source']} );
    var div = document.body.appendChild( document.createElement( 'div' ) );
    editor.render( div );
    editor.setContent( 'hello' );
    var range = editor.selection.getRange();
    range.selectNode( editor.body.firstChild ).select();
    editor.execCommand( 'delete' );
    stop();
    expect( 2 );
    //source 包含超时操作，ie下必须有同步操作，否则会报错
    editor.execCommand( 'source' );
    editor.execCommand( 'source' );
    range = editor.selection.getRange();
    equal( range.startContainer.nodeType, 1, '光标定位在p里' );
    equal( range.startContainer.tagName.toLowerCase(), 'p', 'startContainer为p' );
    te.dom.push( div );
    start();

} );

/*trace1061*/
test( '删除时不会删除block元素', function() {
    var editor = te.obj[0];
    editor.setContent( '<h1>hello</h1>' );
    var range = te.obj[1];
    range.selectNode( editor.body.firstChild ).select();
    editor.execCommand( 'delete' );
    equal( editor.body.lastChild.tagName.toLowerCase(), 'p', 'h1替换为p' );
    if ( !baidu.editor.browser.ie )
        equal( editor.body.lastChild.innerHTML, '<br>', '内容被删除了' );
    else
        equal( editor.body.lastChild.innerHTML, '', '内容被删除了' );
    range = editor.selection.getRange();
    equal( range.startContainer.tagName.toLowerCase(), 'p', '光标位置' );
} );


test( '闭合的时候删除不可用', function() {
    var editor = te.obj[0];
    editor.setContent( '<h1>hello</h1>' );
    var range = te.obj[1];
    range.setStart( editor.body.firstChild, 0 ).collapse().select();
    equal( editor.queryCommandState( 'delete' ), -1, '闭合时state为-1' );
} );

test( '删除部分文本', function() {
    var editor = te.obj[0];
    editor.setContent( '<p><strong>hello world</strong></p>' );
    var range = te.obj[1];
    var strong = editor.body.firstChild.firstChild;
    range.setStart( strong.firstChild, 3 ).setEnd( strong.firstChild, 5 ).select();
    equal( editor.queryCommandState( 'delete' ), 0, '不闭合时state为0' );
    editor.execCommand( 'delete' );
    ua.manualDeleteFillData( baidu.editor );
    equal( strong.innerHTML, 'hel world' );
} );

test( '删除inline的标签', function() {
    var editor = te.obj[0];
    editor.setContent( '<p><strong><em>hello world</em><span>wasai</span></strong></p>' );
    var range = te.obj[1];
    var strong = editor.body.firstChild.firstChild;
    range.selectNode( strong ).select();
    equal( editor.queryCommandState( 'delete' ), 0, '不闭合时state为0' );
    editor.execCommand( 'delete' );
    ua.manualDeleteFillData( baidu.editor );
    equal( editor.body.firstChild.tagName.toLowerCase(), 'p', 'strong 以及子inline节点都被删除' );
    if ( !baidu.editor.browser.ie )
        equal( editor.body.lastChild.innerHTML, '<br>', '内容被删除了' );
    else
        equal( editor.body.lastChild.innerHTML, '', '内容被删除了' );
} );

/*trace 1089*/
test( '跨行选择2个块元素', function() {
    var editor = te.obj[0];
    editor.setContent( '<p><strong>hello world<span>wasai</span></strong></p><div><em><span>hello 2</span></em></div>' );
    var range = te.obj[1];
    var body = editor.body;
    range.setStart( body.firstChild, 0 ).setEnd( body.lastChild,1 ).select();
    editor.execCommand( 'delete' );
    range = editor.selection.getRange();
    equal( body.childNodes.length, 1, 'div被删除，保留p' );
    var br = baidu.editor.browser.ie?"":"<br>";
    equal( ua.getChildHTML( body ), '<p>'+br+'</p>' );

} );

test( '跨行选择，选择后面块元素的部分内容', function() {
    var editor = te.obj[0];
    editor.setContent( '<p><strong>hello world<span>wasai</span></strong></p><div><em><span>hello 2</span></em></div>' );
    var range = te.obj[1];
    var body = editor.body;
    range.setStart( body.firstChild, 0 ).setEnd( body.lastChild.firstChild.firstChild.firstChild, 2 ).select();
    editor.execCommand( 'delete' );
    range = editor.selection.getRange();
    equal( body.childNodes.length, 1, 'p被删除，保留div' );
    if ( baidu.editor.browser.gecko )
        equal( range.startContainer.innerHTML, 'llo 2', 'llo 2为startContainer' );
    else
        equal( range.startContainer.data, 'llo 2', 'llo 2为startContainer' );
    equal( body.firstChild.tagName.toLowerCase(), 'div', 'tagname is p' );
    equal( ua.getChildHTML( body.firstChild ), '<em><span>llo 2</span></em>' );

} );

/*trace 1104*/
test( ' 全选后删除', function() {
    var editor = te.obj[0];
    if ( baidu.editor.browser.ie )
        editor.setContent( '<p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p>' );
    else
        editor.setContent( '<p><br></p><p><br></p><p><br></p><p><br></p><p><br></p><p><br></p><p><br></p><p><br></p><p><br></p>' );
    editor.execCommand( 'selectall' );
    editor.execCommand( 'delete' );
    equal( editor.body.childNodes.length, 1, '删除后只剩一个bolock元素' );
    equal( editor.body.firstChild.tagName.toLowerCase(), 'p', '删除后只剩一个p' );
    if ( !baidu.editor.browser.ie )
        equal( editor.body.lastChild.innerHTML, '<br>', '内容被删除了' );
    else
        equal( editor.body.lastChild.innerHTML, '', '内容被删除了' );
} );


test( ' 删除所有列表', function() {
    var editor = te.obj[0];
    editor.setContent('<ol><li>hello1</li><li>你好</li></ol>');
    var body = editor.body;
    editor.execCommand( 'selectall' );
    editor.execCommand( 'delete' );
    equal( body.childNodes.length, 1, '删除后只剩一个ol元素' );
    var br = baidu.editor.browser.ie?"":"<br>";
    equal( ua.getChildHTML(body), '<p>'+br+'</p>', '删除后只剩一个p' );
} );

test( ' 删除部分列表', function() {
    var editor = te.obj[0];
    editor.setContent('<ol><li>hello1</li><li>你好</li><li>hello3</li></ol>');
    var body = editor.body;
    var range = te.obj[1];
    range.setStart(body.firstChild,1).setEnd(body.firstChild,2).select();
    editor.execCommand( 'delete' );
    equal( body.childNodes.length, 1, '删除后只剩一个ol元素' );
    var br = baidu.editor.browser.ie?"":"<br>";
    equal( ua.getChildHTML(body), '<ol><li><p>hello1'+br+'</p></li><li><p>hello3'+br+'</p></li></ol>', '第二个li被删除' );
} );

