module( 'plugins.source.source' );


/*trace 986*/
test( '切换源码，视频地址被添加了网站前缀', function() {
    var editor = te.obj[0];
    /*涉及到video的一些特殊处理，因此直接设置编辑器的html不是很可行，所以这里用了video这个插件*/
    editor.execCommand('insertvideo',{url:'www.baidu.com'});
    editor.execCommand( 'source' );
    editor.execCommand( 'source' );
    var reg = new RegExp(/\*src="www.baidu.com"\*/);
    var str = 'src="www.baidu.com"';
    var img = editor.document.getElementsByTagName('img')[0];
    equal($(img).attr('_url'),'www.baidu.com','检查超链接前是否添加了网站的路径');
} );

/*trace 852*/
test('切换源码，源码中多处空行',function(){
    var editor = te.obj[0];
    editor.setContent('<p>hello<a href="http://www.baidu.com/">baidu</a></p>');
    editor.execCommand('source');
    editor.execCommand('source');
    editor.execCommand('source');
    equal(editor.getContent(),'<p>hello<a href="http://www.baidu.com/">baidu</a></p>','切换源码不会多空行');
});

/*trace 710*/
test('设置源码内容没有p标签，切换源码后会自动添加',function(){
    var editor = te.obj[0];
    editor.setContent('<strong><em>helloworld你好啊</em></strong>大家好，<strong><i>你在干嘛呢</i></strong><em><strong>。谢谢，不用谢</strong></em>~~%199<p>hello</p>');
    editor.execCommand('source');
    editor.execCommand('source');
    equal(editor.getContent(),'<p><strong><em>helloworld你好啊</em></strong>大家好，<strong><em>你在干嘛呢</em></strong><em><strong>。谢谢，不用谢</strong></em>~~%199</p><p>hello</p>');
});


