/**
 * Generated by build-library.php, Please DO NOT modify!
 */

/* $Id: 61417295a6f732df5a19ed4f2e78468511273e73 */

static const char* swoole_library_source_constants =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "define('SWOOLE_LIBRARY', true);\n";

static const char* swoole_library_source_std_exec =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "function swoole_exec(string $command, &$output = null, &$returnVar = null)\n"
    "{\n"
    "    $result = Swoole\\Coroutine::exec($command);\n"
    "    if ($result) {\n"
    "        $outputList = explode(PHP_EOL, $result['output']);\n"
    "        foreach ($outputList as &$value) {\n"
    "            $value = rtrim($value);\n"
    "        }\n"
    "        if (($endLine = end($outputList)) === '') {\n"
    "            array_pop($outputList);\n"
    "            $endLine = end($outputList);\n"
    "        }\n"
    "        if ($output) {\n"
    "            $output = array_merge($output, $outputList);\n"
    "        } else {\n"
    "            $output = $outputList;\n"
    "        }\n"
    "        $returnVar = $result['code'];\n"
    "        return $endLine;\n"
    "    }\n"
    "    return false;\n"
    "}\n"
    "\n"
    "function swoole_shell_exec(string $cmd)\n"
    "{\n"
    "    $result = Swoole\\Coroutine::exec($cmd);\n"
    "    if ($result && $result['output'] !== '') {\n"
    "        return $result['output'];\n"
    "    }\n"
    "    return null;\n"
    "}\n";

static const char* swoole_library_source_core_constant =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "class Constant\n"
    "{\n"
    "    public const EVENT_RECEIVE = 'receive';\n"
    "\n"
    "    public const EVENT_CONNECT = 'connect';\n"
    "\n"
    "    public const EVENT_CLOSE = 'close';\n"
    "\n"
    "    public const EVENT_PACKET = 'packet';\n"
    "\n"
    "    public const EVENT_REQUEST = 'request';\n"
    "\n"
    "    public const EVENT_MESSAGE = 'message';\n"
    "\n"
    "    public const EVENT_OPEN = 'open';\n"
    "\n"
    "    public const EVENT_HANDSHAKE = 'handshake';\n"
    "\n"
    "    public const EVENT_TASK = 'task';\n"
    "\n"
    "    public const EVENT_FINISH = 'finish';\n"
    "\n"
    "    public const EVENT_START = 'start';\n"
    "\n"
    "    public const EVENT_SHUTDOWN = 'shutdown';\n"
    "\n"
    "    public const EVENT_WORKER_START = 'workerStart';\n"
    "\n"
    "    public const EVENT_WORKER_EXIT = 'workerExit';\n"
    "\n"
    "    public const EVENT_WORKER_ERROR = 'workerError';\n"
    "\n"
    "    public const EVENT_WORKER_STOP = 'workerStop';\n"
    "\n"
    "    public const EVENT_PIPE_MESSAGE = 'pipeMessage';\n"
    "\n"
    "    public const EVENT_MANAGER_START = 'managerStart';\n"
    "\n"
    "    public const EVENT_MANAGER_STOP = 'managerStop';\n"
    "\n"
    "    public const EVENT_ERROR = 'error';\n"
    "\n"
    "    /* {{{ OPTION */\n"
    "    public const OPTION_ENABLE_SIGNALFD = 'enable_signalfd';\n"
    "\n"
    "    public const OPTION_DNS_CACHE_REFRESH_TIME = 'dns_cache_refresh_time';\n"
    "\n"
    "    public const OPTION_SOCKET_BUFFER_SIZE = 'socket_buffer_size';\n"
    "\n"
    "    public const OPTION_SOCKET_SEND_TIMEOUT = 'socket_send_timeout';\n"
    "\n"
    "    public const OPTION_LOG_LEVEL = 'log_level';\n"
    "\n"
    "    public const OPTION_THREAD_NUM = 'thread_num';\n"
    "\n"
    "    public const OPTION_MIN_THREAD_NUM = 'min_thread_num';\n"
    "\n"
    "    public const OPTION_MAX_THREAD_NUM = 'max_thread_num';\n"
    "\n"
    "    public const OPTION_DISPLAY_ERRORS = 'display_errors';\n"
    "\n"
    "    public const OPTION_SOCKET_DONTWAIT = 'socket_dontwait';\n"
    "\n"
    "    public const OPTION_DNS_LOOKUP_RANDOM = 'dns_lookup_random';\n"
    "\n"
    "    public const OPTION_DNS_SERVER = 'dns_server';\n"
    "\n"
    "    public const OPTION_USE_ASYNC_RESOLVER = 'use_async_resolver';\n"
    "\n"
    "    public const OPTION_ENABLE_COROUTINE = 'enable_coroutine';\n"
    "\n"
    "    public const OPTION_ENABLE_REUSE_PORT = 'enable_reuse_port';\n"
    "\n"
    "    public const OPTION_SSL_METHOD = 'ssl_method';\n"
    "\n"
    "    public const OPTION_SSL_PROTOCOLS = 'ssl_protocols';\n"
    "\n"
    "    public const OPTION_SSL_COMPRESS = 'ssl_compress';\n"
    "\n"
    "    public const OPTION_SSL_CERT_FILE = 'ssl_cert_file';\n"
    "\n"
    "    public const OPTION_SSL_KEY_FILE = 'ssl_key_file';\n"
    "\n"
    "    public const OPTION_SSL_PASSPHRASE = 'ssl_passphrase';\n"
    "\n"
    "    public const OPTION_SSL_HOST_NAME = 'ssl_host_name';\n"
    "\n"
    "    public const OPTION_SSL_VERIFY_PEER = 'ssl_verify_peer';\n"
    "\n"
    "    public const OPTION_SSL_ALLOW_SELF_SIGNED = 'ssl_allow_self_signed';\n"
    "\n"
    "    public const OPTION_SSL_CAFILE = 'ssl_cafile';\n"
    "\n"
    "    public const OPTION_SSL_CAPATH = 'ssl_capath';\n"
    "\n"
    "    public const OPTION_SSL_VERIFY_DEPTH = 'ssl_verify_depth';\n"
    "\n"
    "    public const OPTION_OPEN_EOF_CHECK = 'open_eof_check';\n"
    "\n"
    "    public const OPTION_OPEN_EOF_SPLIT = 'open_eof_split';\n"
    "\n"
    "    public const OPTION_PACKAGE_EOF = 'package_eof';\n"
    "\n"
    "    public const OPTION_OPEN_MQTT_PROTOCOL = 'open_mqtt_protocol';\n"
    "\n"
    "    public const OPTION_OPEN_LENGTH_CHECK = 'open_length_check';\n"
    "\n"
    "    public const OPTION_PACKAGE_LENGTH_TYPE = 'package_length_type';\n"
    "\n"
    "    public const OPTION_PACKAGE_LENGTH_OFFSET = 'package_length_offset';\n"
    "\n"
    "    public const OPTION_PACKAGE_BODY_OFFSET = 'package_body_offset';\n"
    "\n"
    "    public const OPTION_PACKAGE_LENGTH_FUNC = 'package_length_func';\n"
    "\n"
    "    public const OPTION_PACKAGE_MAX_LENGTH = 'package_max_length';\n"
    "\n"
    "    public const OPTION_BUFFER_HIGH_WATERMARK = 'buffer_high_watermark';\n"
    "\n"
    "    public const OPTION_BUFFER_LOW_WATERMARK = 'buffer_low_watermark';\n"
    "\n"
    "    public const OPTION_BIND_PORT = 'bind_port';\n"
    "\n"
    "    public const OPTION_BIND_ADDRESS = 'bind_address';\n"
    "\n"
    "    public const OPTION_OPEN_TCP_NODELAY = 'open_tcp_nodelay';\n"
    "\n"
    "    public const OPTION_SOCKS5_HOST = 'socks5_host';\n"
    "\n"
    "    public const OPTION_SOCKS5_PORT = 'socks5_port';\n"
    "\n"
    "    public const OPTION_SOCKS5_USERNAME = 'socks5_username';\n"
    "\n"
    "    public const OPTION_SOCKS5_PASSWORD = 'socks5_password';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_HOST = 'http_proxy_host';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_PORT = 'http_proxy_port';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_USERNAME = 'http_proxy_username';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_USER = 'http_proxy_user';\n"
    "\n"
    "    public const OPTION_HTTP_PROXY_PASSWORD = 'http_proxy_password';\n"
    "\n"
    "    public const OPTION_TIMEOUT = 'timeout';\n"
    "\n"
    "    public const OPTION_CONNECT_TIMEOUT = 'connect_timeout';\n"
    "\n"
    "    public const OPTION_READ_TIMEOUT = 'read_timeout';\n"
    "\n"
    "    public const OPTION_WRITE_TIMEOUT = 'write_timeout';\n"
    "\n"
    "    public const OPTION_SSL_DISABLE_COMPRESSION = 'ssl_disable_compression';\n"
    "\n"
    "    public const OPTION_MAX_COROUTINE = 'max_coroutine';\n"
    "\n"
    "    public const OPTION_HOOK_FLAGS = 'hook_flags';\n"
    "\n"
    "    public const OPTION_ENABLE_PREEMPTIVE_SCHEDULER = 'enable_preemptive_scheduler';\n"
    "\n"
    "    public const OPTION_C_STACK_SIZE = 'c_stack_size';\n"
    "\n"
    "    public const OPTION_STACK_SIZE = 'stack_size';\n"
    "\n"
    "    public const OPTION_SOCKET_CONNECT_TIMEOUT = 'socket_connect_timeout';\n"
    "\n"
    "    public const OPTION_SOCKET_TIMEOUT = 'socket_timeout';\n"
    "\n"
    "    public const OPTION_SOCKET_READ_TIMEOUT = 'socket_read_timeout';\n"
    "\n"
    "    public const OPTION_SOCKET_WRITE_TIMEOUT = 'socket_write_timeout';\n"
    "\n"
    "    public const OPTION_TRACE_FLAGS = 'trace_flags';\n"
    "\n"
    "    public const OPTION_DNS_CACHE_EXPIRE = 'dns_cache_expire';\n"
    "\n"
    "    public const OPTION_DNS_CACHE_CAPACITY = 'dns_cache_capacity';\n"
    "\n"
    "    public const OPTION_AIO_CORE_WORKER_NUM = 'aio_core_worker_num';\n"
    "\n"
    "    public const OPTION_AIO_WORKER_NUM = 'aio_worker_num';\n"
    "\n"
    "    public const OPTION_AIO_MAX_WAIT_TIME = 'aio_max_wait_time';\n"
    "\n"
    "    public const OPTION_AIO_MAX_IDLE_TIME = 'aio_max_idle_time';\n"
    "\n"
    "    public const OPTION_RECONNECT = 'reconnect';\n"
    "\n"
    "    public const OPTION_DEFER = 'defer';\n"
    "\n"
    "    public const OPTION_KEEP_ALIVE = 'keep_alive';\n"
    "\n"
    "    public const OPTION_WEBSOCKET_MASK = 'websocket_mask';\n"
    "\n"
    "    public const OPTION_WEBSOCKET_COMPRESSION = 'websocket_compression';\n"
    "\n"
    "    public const OPTION_HTTP_PARSE_COOKIE = 'http_parse_cookie';\n"
    "\n"
    "    public const OPTION_HTTP_PARSE_POST = 'http_parse_post';\n"
    "\n"
    "    public const OPTION_HTTP_PARSE_FILES = 'http_parse_files';\n"
    "\n"
    "    public const OPTION_HTTP_COMPRESSION = 'http_compression';\n"
    "\n"
    "    public const OPTION_HTTP_COMPRESSION_LEVEL = 'http_compression_level';\n"
    "\n"
    "    public const OPTION_HTTP_GZIP_LEVEL = 'http_gzip_level';\n"
    "\n"
    "    public const OPTION_UPLOAD_TMP_DIR = 'upload_tmp_dir';\n"
    "\n"
    "    public const OPTION_HOST = 'host';\n"
    "\n"
    "    public const OPTION_PORT = 'port';\n"
    "\n"
    "    public const OPTION_SSL = 'ssl';\n"
    "\n"
    "    public const OPTION_USER = 'user';\n"
    "\n"
    "    public const OPTION_PASSWORD = 'password';\n"
    "\n"
    "    public const OPTION_DATABASE = 'database';\n"
    "\n"
    "    public const OPTION_CHARSET = 'charset';\n"
    "\n"
    "    public const OPTION_STRICT_TYPE = 'strict_type';\n"
    "\n"
    "    public const OPTION_FETCH_MODE = 'fetch_mode';\n"
    "\n"
    "    public const OPTION_SERIALIZE = 'serialize';\n"
    "\n"
    "    public const OPTION_COMPATIBILITY_MODE = 'compatibility_mode';\n"
    "\n"
    "    public const OPTION_CHROOT = 'chroot';\n"
    "\n"
    "    public const OPTION_GROUP = 'group';\n"
    "\n"
    "    public const OPTION_DAEMONIZE = 'daemonize';\n"
    "\n"
    "    public const OPTION_DEBUG_MODE = 'debug_mode';\n"
    "\n"
    "    public const OPTION_PID_FILE = 'pid_file';\n"
    "\n"
    "    public const OPTION_REACTOR_NUM = 'reactor_num';\n"
    "\n"
    "    public const OPTION_SINGLE_THREAD = 'single_thread';\n"
    "\n"
    "    public const OPTION_WORKER_NUM = 'worker_num';\n"
    "\n"
    "    public const OPTION_MAX_WAIT_TIME = 'max_wait_time';\n"
    "\n"
    "    public const OPTION_MAX_CORO_NUM = 'max_coro_num';\n"
    "\n"
    "    public const OPTION_SEND_TIMEOUT = 'send_timeout';\n"
    "\n"
    "    public const OPTION_DISPATCH_MODE = 'dispatch_mode';\n"
    "\n"
    "    public const OPTION_SEND_YIELD = 'send_yield';\n"
    "\n"
    "    public const OPTION_DISPATCH_FUNC = 'dispatch_func';\n"
    "\n"
    "    public const OPTION_LOG_FILE = 'log_file';\n"
    "\n"
    "    public const OPTION_DISCARD_TIMEOUT_REQUEST = 'discard_timeout_request';\n"
    "\n"
    "    public const OPTION_ENABLE_UNSAFE_EVENT = 'enable_unsafe_event';\n"
    "\n"
    "    public const OPTION_ENABLE_DELAY_RECEIVE = 'enable_delay_receive';\n"
    "\n"
    "    public const OPTION_TASK_USE_OBJECT = 'task_use_object';\n"
    "\n"
    "    public const OPTION_TASK_ENABLE_COROUTINE = 'task_enable_coroutine';\n"
    "\n"
    "    public const OPTION_TASK_WORKER_NUM = 'task_worker_num';\n"
    "\n"
    "    public const OPTION_TASK_IPC_MODE = 'task_ipc_mode';\n"
    "\n"
    "    public const OPTION_TASK_TMPDIR = 'task_tmpdir';\n"
    "\n"
    "    public const OPTION_TASK_MAX_REQUEST = 'task_max_request';\n"
    "\n"
    "    public const OPTION_TASK_MAX_REQUEST_GRACE = 'task_max_request_grace';\n"
    "\n"
    "    public const OPTION_MAX_CONNECTION = 'max_connection';\n"
    "\n"
    "    public const OPTION_MAX_CONN = 'max_conn';\n"
    "\n"
    "    public const OPTION_HEARTBEAT_CHECK_INTERVAL = 'heartbeat_check_interval';\n"
    "\n"
    "    public const OPTION_HEARTBEAT_IDLE_TIME = 'heartbeat_idle_time';\n"
    "\n"
    "    public const OPTION_MAX_REQUEST = 'max_request';\n"
    "\n"
    "    public const OPTION_MAX_REQUEST_GRACE = 'max_request_grace';\n"
    "\n"
    "    public const OPTION_RELOAD_ASYNC = 'reload_async';\n"
    "\n"
    "    public const OPTION_OPEN_CPU_AFFINITY = 'open_cpu_affinity';\n"
    "\n"
    "    public const OPTION_CPU_AFFINITY_IGNORE = 'cpu_affinity_ignore';\n"
    "\n"
    "    public const OPTION_ENABLE_STATIC_HANDLER = 'enable_static_handler';\n"
    "\n"
    "    public const OPTION_DOCUMENT_ROOT = 'document_root';\n"
    "\n"
    "    public const OPTION_STATIC_HANDLER_LOCATIONS = 'static_handler_locations';\n"
    "\n"
    "    public const OPTION_BUFFER_INPUT_SIZE = 'buffer_input_size';\n"
    "\n"
    "    public const OPTION_BUFFER_OUTPUT_SIZE = 'buffer_output_size';\n"
    "\n"
    "    public const OPTION_MESSAGE_QUEUE_KEY = 'message_queue_key';\n"
    "\n"
    "    public const OPTION_BACKLOG = 'backlog';\n"
    "\n"
    "    public const OPTION_KERNEL_SOCKET_RECV_BUFFER_SIZE = 'kernel_socket_recv_buffer_size';\n"
    "\n"
    "    public const OPTION_KERNEL_SOCKET_SEND_BUFFER_SIZE = 'kernel_socket_send_buffer_size';\n"
    "\n"
    "    public const OPTION_TCP_DEFER_ACCEPT = 'tcp_defer_accept';\n"
    "\n"
    "    public const OPTION_OPEN_TCP_KEEPALIVE = 'open_tcp_keepalive';\n"
    "\n"
    "    public const OPTION_OPEN_HTTP_PROTOCOL = 'open_http_protocol';\n"
    "\n"
    "    public const OPTION_OPEN_WEBSOCKET_PROTOCOL = 'open_websocket_protocol';\n"
    "\n"
    "    public const OPTION_WEBSOCKET_SUBPROTOCOL = 'websocket_subprotocol';\n"
    "\n"
    "    public const OPTION_OPEN_WEBSOCKET_CLOSE_FRAME = 'open_websocket_close_frame';\n"
    "\n"
    "    public const OPTION_OPEN_HTTP2_PROTOCOL = 'open_http2_protocol';\n"
    "\n"
    "    public const OPTION_OPEN_REDIS_PROTOCOL = 'open_redis_protocol';\n"
    "\n"
    "    public const OPTION_TCP_KEEPIDLE = 'tcp_keepidle';\n"
    "\n"
    "    public const OPTION_TCP_KEEPINTERVAL = 'tcp_keepinterval';\n"
    "\n"
    "    public const OPTION_TCP_KEEPCOUNT = 'tcp_keepcount';\n"
    "\n"
    "    public const OPTION_TCP_FASTOPEN = 'tcp_fastopen';\n"
    "\n"
    "    public const OPTION_PACKAGE_BODY_START = 'package_body_start';\n"
    "\n"
    "    public const OPTION_SSL_CLIENT_CERT_FILE = 'ssl_client_cert_file';\n"
    "\n"
    "    public const OPTION_SSL_PREFER_SERVER_CIPHERS = 'ssl_prefer_server_ciphers';\n"
    "\n"
    "    public const OPTION_SSL_CIPHERS = 'ssl_ciphers';\n"
    "\n"
    "    public const OPTION_SSL_ECDH_CURVE = 'ssl_ecdh_curve';\n"
    "\n"
    "    public const OPTION_SSL_DHPARAM = 'ssl_dhparam';\n"
    "\n"
    "    public const OPTION_OPEN_SSL = 'open_ssl';\n"
    "\n"
    "    /* }}} OPTION */\n"
    "}\n";

static const char* swoole_library_source_core_exception_array_key_not_exists =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Exception;\n"
    "\n"
    "class ArrayKeyNotExists extends \\RuntimeException\n"
    "{\n"
    "}\n";

static const char* swoole_library_source_core_string_object =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "class StringObject\n"
    "{\n"
    "    /**\n"
    "     * @var string\n"
    "     */\n"
    "    protected $string;\n"
    "\n"
    "    /**\n"
    "     * StringObject constructor.\n"
    "     */\n"
    "    public function __construct(string $string = '')\n"
    "    {\n"
    "        $this->string = $string;\n"
    "    }\n"
    "\n"
    "    public function __toString(): string\n"
    "    {\n"
    "        return $this->string;\n"
    "    }\n"
    "\n"
    "    public function length(): int\n"
    "    {\n"
    "        return strlen($this->string);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function indexOf(string $needle, int $offset = 0)\n"
    "    {\n"
    "        return strpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function lastIndexOf(string $needle, int $offset = 0)\n"
    "    {\n"
    "        return strrpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function pos(string $needle, int $offset = 0)\n"
    "    {\n"
    "        return strpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function rpos(string $needle, int $offset = 0)\n"
    "    {\n"
    "        return strrpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function ipos(string $needle)\n"
    "    {\n"
    "        return stripos($this->string, $needle);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function lower(): self\n"
    "    {\n"
    "        return new static(strtolower($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function upper(): self\n"
    "    {\n"
    "        return new static(strtoupper($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function trim(): self\n"
    "    {\n"
    "        return new static(trim($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function ltrim(): self\n"
    "    {\n"
    "        return new static(ltrim($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function rtrim(): self\n"
    "    {\n"
    "        return new static(rtrim($this->string));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function substr(int $offset, ?int $length = null)\n"
    "    {\n"
    "        return new static(substr($this->string, ...func_get_args()));\n"
    "    }\n"
    "\n"
    "    public function repeat(int $n): StringObject\n"
    "    {\n"
    "        return new static(str_repeat($this->string, $n));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param $str\n"
    "     */\n"
    "    public function append($str): StringObject\n"
    "    {\n"
    "        if (is_string($str)) {\n"
    "            $this->string .= $str;\n"
    "        } else {\n"
    "            $this->string .= strval($str);\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param null|int $count\n"
    "     * @return static\n"
    "     */\n"
    "    public function replace(string $search, string $replace, &$count = null)\n"
    "    {\n"
    "        return new static(str_replace($search, $replace, $this->string, $count));\n"
    "    }\n"
    "\n"
    "    public function startsWith(string $needle): bool\n"
    "    {\n"
    "        return strpos($this->string, $needle) === 0;\n"
    "    }\n"
    "\n"
    "    public function endsWith(string $needle): bool\n"
    "    {\n"
    "        return strrpos($this->string, $needle) === (strlen($this->string) - strlen($needle));\n"
    "    }\n"
    "\n"
    "    public function equals($str, bool $strict = false): bool\n"
    "    {\n"
    "        if ($str instanceof StringObject) {\n"
    "            $str = strval($str);\n"
    "        }\n"
    "        if ($strict) {\n"
    "            return $this->string === $str;\n"
    "        }\n"
    "        return $this->string == $str;\n"
    "    }\n"
    "\n"
    "    public function contains(string $subString): bool\n"
    "    {\n"
    "        return strpos($this->string, $subString) !== false;\n"
    "    }\n"
    "\n"
    "    public function split(string $delimiter, int $limit = PHP_INT_MAX): ArrayObject\n"
    "    {\n"
    "        return static::detectArrayType(explode($delimiter, $this->string, $limit));\n"
    "    }\n"
    "\n"
    "    public function char(int $index): string\n"
    "    {\n"
    "        if ($index > strlen($this->string)) {\n"
    "            return '';\n"
    "        }\n"
    "        return $this->string[$index];\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function chunkSplit(int $chunkLength = 76, string $chunkEnd = '')\n"
    "    {\n"
    "        return new static(chunk_split($this->string, ...func_get_args()));\n"
    "    }\n"
    "\n"
    "    public function chunk(int $splitLength = 1): ArrayObject\n"
    "    {\n"
    "        return static::detectArrayType(str_split($this->string, ...func_get_args()));\n"
    "    }\n"
    "\n"
    "    public function toString(): string\n"
    "    {\n"
    "        return $this->string;\n"
    "    }\n"
    "\n"
    "    protected static function detectArrayType(array $value): ArrayObject\n"
    "    {\n"
    "        return new ArrayObject($value);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_multibyte_string_object =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "class MultibyteStringObject extends StringObject\n"
    "{\n"
    "    public function length(): int\n"
    "    {\n"
    "        return mb_strlen($this->string);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function indexOf(string $needle, int $offset = 0, ?string $encoding = null)\n"
    "    {\n"
    "        return mb_strpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function lastIndexOf(string $needle, int $offset = 0, ?string $encoding = null)\n"
    "    {\n"
    "        return mb_strrpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function pos(string $needle, int $offset = 0, ?string $encoding = null)\n"
    "    {\n"
    "        return mb_strpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function rpos(string $needle, int $offset = 0, ?string $encoding = null)\n"
    "    {\n"
    "        return mb_strrpos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return false|int\n"
    "     */\n"
    "    public function ipos(string $needle, ?string $encoding = null)\n"
    "    {\n"
    "        return mb_stripos($this->string, ...func_get_args());\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function substr(int $offset, ?int $length = null, ?string $encoding = null)\n"
    "    {\n"
    "        return new static(mb_substr($this->string, ...func_get_args()));\n"
    "    }\n"
    "\n"
    "    public function chunk(int $splitLength = 1, ?int $limit = null): ArrayObject\n"
    "    {\n"
    "        return static::detectArrayType(mb_split($this->string, ...func_get_args()));\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_array_object =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "use ArrayAccess;\n"
    "use Countable;\n"
    "use Iterator;\n"
    "use RuntimeException;\n"
    "use Serializable;\n"
    "use Swoole\\Exception\\ArrayKeyNotExists;\n"
    "\n"
    "class ArrayObject implements ArrayAccess, Serializable, Countable, Iterator\n"
    "{\n"
    "    /**\n"
    "     * @var array\n"
    "     */\n"
    "    protected $array;\n"
    "\n"
    "    /**\n"
    "     * ArrayObject constructor.\n"
    "     */\n"
    "    public function __construct(array $array = [])\n"
    "    {\n"
    "        $this->array = $array;\n"
    "    }\n"
    "\n"
    "    public function __toArray(): array\n"
    "    {\n"
    "        return $this->array;\n"
    "    }\n"
    "\n"
    "    public function toArray(): array\n"
    "    {\n"
    "        return $this->array;\n"
    "    }\n"
    "\n"
    "    public function isEmpty(): bool\n"
    "    {\n"
    "        return empty($this->array);\n"
    "    }\n"
    "\n"
    "    public function count(): int\n"
    "    {\n"
    "        return count($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function current()\n"
    "    {\n"
    "        return current($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function key()\n"
    "    {\n"
    "        return key($this->array);\n"
    "    }\n"
    "\n"
    "    public function valid(): bool\n"
    "    {\n"
    "        return array_key_exists($this->key(), $this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function rewind()\n"
    "    {\n"
    "        return reset($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function next()\n"
    "    {\n"
    "        return next($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @return ArrayObject|StringObject\n"
    "     */\n"
    "    public function get($key)\n"
    "    {\n"
    "        if (!$this->exists($key)) {\n"
    "            throw new ArrayKeyNotExists($key);\n"
    "        }\n"
    "        return static::detectType($this->array[$key]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function last()\n"
    "    {\n"
    "        $key = array_key_last($this->array);\n"
    "        if ($key === null) {\n"
    "            return null;\n"
    "        }\n"
    "        return $this->get($key);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return null|int|string\n"
    "     */\n"
    "    public function firstKey()\n"
    "    {\n"
    "        return array_key_first($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return null|int|string\n"
    "     */\n"
    "    public function lastKey()\n"
    "    {\n"
    "        return array_key_last($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function first()\n"
    "    {\n"
    "        $key = array_key_first($this->array);\n"
    "        if ($key === null) {\n"
    "            return null;\n"
    "        }\n"
    "        return $this->get($key);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @param mixed $value\n"
    "     * @return $this\n"
    "     */\n"
    "    public function set($key, $value): self\n"
    "    {\n"
    "        $this->array[$key] = $value;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @return $this\n"
    "     */\n"
    "    public function delete($key): self\n"
    "    {\n"
    "        unset($this->array[$key]);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return $this\n"
    "     */\n"
    "    public function remove($value, bool $strict = true, bool $loop = false): self\n"
    "    {\n"
    "        do {\n"
    "            $key = $this->search($value, $strict);\n"
    "            if ($key === false) {\n"
    "                break;\n"
    "            }\n"
    "            unset($this->array[$key]);\n"
    "        } while ($loop);\n"
    "\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function clear(): self\n"
    "    {\n"
    "        $this->array = [];\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @return null|mixed\n"
    "     */\n"
    "    public function offsetGet($key)\n"
    "    {\n"
    "        if (!array_key_exists($key, $this->array)) {\n"
    "            return null;\n"
    "        }\n"
    "        return $this->array[$key];\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @param mixed $value\n"
    "     */\n"
    "    public function offsetSet($key, $value): void\n"
    "    {\n"
    "        $this->array[$key] = $value;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     */\n"
    "    public function offsetUnset($key): void\n"
    "    {\n"
    "        unset($this->array[$key]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     * @return bool\n"
    "     */\n"
    "    public function offsetExists($key)\n"
    "    {\n"
    "        return isset($this->array[$key]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $key\n"
    "     */\n"
    "    public function exists($key): bool\n"
    "    {\n"
    "        return array_key_exists($key, $this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     */\n"
    "    public function contains($value, bool $strict = true): bool\n"
    "    {\n"
    "        return in_array($value, $this->array, $strict);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function indexOf($value, bool $strict = true)\n"
    "    {\n"
    "        return $this->search($value, $strict);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function lastIndexOf($value, bool $strict = true)\n"
    "    {\n"
    "        $array = $this->array;\n"
    "        for (end($array); ($currentKey = key($array)) !== null; prev($array)) {\n"
    "            $currentValue = current($array);\n"
    "            if ($currentValue == $value) {\n"
    "                if ($strict && $currentValue !== $value) {\n"
    "                    continue;\n"
    "                }\n"
    "                break;\n"
    "            }\n"
    "        }\n"
    "        return $currentKey;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $needle\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function search($needle, bool $strict = true)\n"
    "    {\n"
    "        return array_search($needle, $this->array, $strict);\n"
    "    }\n"
    "\n"
    "    public function join(string $glue = ''): StringObject\n"
    "    {\n"
    "        return static::detectStringType(implode($glue, $this->array));\n"
    "    }\n"
    "\n"
    "    public function serialize(): StringObject\n"
    "    {\n"
    "        return static::detectStringType(serialize($this->array));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param string $string\n"
    "     * @return $this\n"
    "     */\n"
    "    public function unserialize($string): self\n"
    "    {\n"
    "        $this->array = (array) unserialize((string) $string);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return float|int\n"
    "     */\n"
    "    public function sum()\n"
    "    {\n"
    "        return array_sum($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return float|int\n"
    "     */\n"
    "    public function product()\n"
    "    {\n"
    "        return array_product($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return int\n"
    "     */\n"
    "    public function push($value)\n"
    "    {\n"
    "        return $this->pushBack($value);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return int\n"
    "     */\n"
    "    public function pushFront($value)\n"
    "    {\n"
    "        return array_unshift($this->array, $value);\n"
    "    }\n"
    "\n"
    "    public function append(...$values): ArrayObject\n"
    "    {\n"
    "        array_push($this->array, ...$values);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return int\n"
    "     */\n"
    "    public function pushBack($value)\n"
    "    {\n"
    "        return array_push($this->array, $value);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return $this\n"
    "     */\n"
    "    public function insert(int $offset, $value): self\n"
    "    {\n"
    "        if (is_array($value) || is_object($value) || is_null($value)) {\n"
    "            $value = [$value];\n"
    "        }\n"
    "        array_splice($this->array, $offset, 0, $value);\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function pop()\n"
    "    {\n"
    "        return $this->popBack();\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function popFront()\n"
    "    {\n"
    "        return array_shift($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function popBack()\n"
    "    {\n"
    "        return array_pop($this->array);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $offset\n"
    "     * @param int $length\n"
    "     * @return static\n"
    "     */\n"
    "    public function slice($offset, int $length = null, bool $preserve_keys = false): self\n"
    "    {\n"
    "        return new static(array_slice($this->array, ...func_get_args()));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return ArrayObject|mixed|StringObject\n"
    "     */\n"
    "    public function randomGet()\n"
    "    {\n"
    "        return static::detectType($this->array[array_rand($this->array, 1)]);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function each(callable $fn): self\n"
    "    {\n"
    "        if (array_walk($this->array, $fn) === false) {\n"
    "            throw new RuntimeException('array_walk() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param array $args\n"
    "     * @return static\n"
    "     */\n"
    "    public function map(callable $fn, ...$args): self\n"
    "    {\n"
    "        return new static(array_map($fn, $this->array, ...$args));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param null $initial\n"
    "     * @return mixed\n"
    "     */\n"
    "    public function reduce(callable $fn, $initial = null)\n"
    "    {\n"
    "        return array_reduce($this->array, $fn, $initial);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param array $args\n"
    "     * @return static\n"
    "     */\n"
    "    public function keys(...$args): self\n"
    "    {\n"
    "        return new static(array_keys($this->array, ...$args));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function values(): self\n"
    "    {\n"
    "        return new static(array_values($this->array));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $column_key\n"
    "     * @param mixed $index\n"
    "     * @return static\n"
    "     */\n"
    "    public function column($column_key, $index = null): self\n"
    "    {\n"
    "        return new static(array_column($this->array, $column_key, $index));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function unique(int $sort_flags = SORT_STRING): self\n"
    "    {\n"
    "        return new static(array_unique($this->array, $sort_flags));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function reverse(bool $preserve_keys = false): self\n"
    "    {\n"
    "        return new static(array_reverse($this->array, $preserve_keys));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function chunk(int $size, bool $preserve_keys = false): self\n"
    "    {\n"
    "        return new static(array_chunk($this->array, $size, $preserve_keys));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Swap keys and values in an array.\n"
    "     * @return static\n"
    "     */\n"
    "    public function flip(): self\n"
    "    {\n"
    "        return new static(array_flip($this->array));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    public function filter(callable $fn, int $flag = 0): self\n"
    "    {\n"
    "        return new static(array_filter($this->array, $fn, $flag));\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * | Function name     | Sorts by | Maintains key association   | Order of sort               | Related functions |\n"
    "     * | :---------------- | :------- | :-------------------------- | :-------------------------- | :---------------- |\n"
    "     * | array_multisort() | value    | associative yes, numeric no | first array or sort options  | array_walk()      |\n"
    "     * | asort()           | value    | yes                         | low to high                 | arsort()          |\n"
    "     * | arsort()          | value    | yes                         | high to low                 | asort()           |\n"
    "     * | krsort()          | key      | yes                         | high to low                 | ksort()           |\n"
    "     * | ksort()           | key      | yes                         | low to high                 | asort()           |\n"
    "     * | natcasesort()     | value    | yes                         | natural, case insensitive   | natsort()         |\n"
    "     * | natsort()         | value    | yes                         | natural                     | natcasesort()     |\n"
    "     * | rsort()           | value    | no                          | high to low                 | sort()            |\n"
    "     * | shuffle()          | value    | no                          | random                      | array_rand()      |\n"
    "     * | sort()            | value    | no                          | low to high                 | rsort()           |\n"
    "     * | uasort()          | value    | yes                         | user defined                 | uksort()          |\n"
    "     * | uksort()          | key      | yes                         | user defined                 | uasort()          |\n"
    "     * | usort()           | value    | no                          | user defined                 | uasort()          |\n"
    "     */\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function asort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (asort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('asort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function arsort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (arsort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('arsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function krsort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (krsort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('krsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function ksort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (ksort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('ksort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function natcasesort(): self\n"
    "    {\n"
    "        if (natcasesort($this->array) !== true) {\n"
    "            throw new RuntimeException('natcasesort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function natsort(): self\n"
    "    {\n"
    "        if (natsort($this->array) !== true) {\n"
    "            throw new RuntimeException('natsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function rsort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (rsort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('rsort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function shuffle(): self\n"
    "    {\n"
    "        if (shuffle($this->array) !== true) {\n"
    "            throw new RuntimeException('shuffle() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function sort(int $sort_flags = SORT_REGULAR): self\n"
    "    {\n"
    "        if (sort($this->array, $sort_flags) !== true) {\n"
    "            throw new RuntimeException('sort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function uasort(callable $value_compare_func): self\n"
    "    {\n"
    "        if (uasort($this->array, $value_compare_func) !== true) {\n"
    "            throw new RuntimeException('uasort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function uksort(callable $value_compare_func): self\n"
    "    {\n"
    "        if (uksort($this->array, $value_compare_func) !== true) {\n"
    "            throw new RuntimeException('uksort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return $this\n"
    "     */\n"
    "    public function usort(callable $value_compare_func): self\n"
    "    {\n"
    "        if (usort($this->array, $value_compare_func) !== true) {\n"
    "            throw new RuntimeException('usort() failed');\n"
    "        }\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @return ArrayObject|mixed|StringObject\n"
    "     */\n"
    "    protected static function detectType($value)\n"
    "    {\n"
    "        if (is_string($value)) {\n"
    "            return static::detectStringType($value);\n"
    "        }\n"
    "        if (is_array($value)) {\n"
    "            return static::detectArrayType($value);\n"
    "        }\n"
    "        return $value;\n"
    "    }\n"
    "\n"
    "    protected static function detectStringType(string $value): StringObject\n"
    "    {\n"
    "        return new StringObject($value);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @return static\n"
    "     */\n"
    "    protected static function detectArrayType(array $value): self\n"
    "    {\n"
    "        return new static($value);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_object_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "use TypeError;\n"
    "\n"
    "class ObjectProxy\n"
    "{\n"
    "    /** @var object */\n"
    "    protected $__object;\n"
    "\n"
    "    public function __construct($object)\n"
    "    {\n"
    "        if (!is_object($object)) {\n"
    "            throw new TypeError('Non-object given');\n"
    "        }\n"
    "        $this->__object = $object;\n"
    "    }\n"
    "\n"
    "    public function __getObject()\n"
    "    {\n"
    "        return $this->__object;\n"
    "    }\n"
    "\n"
    "    public function __get(string $name)\n"
    "    {\n"
    "        return $this->__object->{$name};\n"
    "    }\n"
    "\n"
    "    public function __set(string $name, $value): void\n"
    "    {\n"
    "        $this->__object->{$name} = $value;\n"
    "    }\n"
    "\n"
    "    public function __isset($name)\n"
    "    {\n"
    "        return isset($this->__object->{$name});\n"
    "    }\n"
    "\n"
    "    public function __unset(string $name): void\n"
    "    {\n"
    "        unset($this->__object->{$name});\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        return $this->__object->{$name}(...$arguments);\n"
    "    }\n"
    "\n"
    "    public function __invoke(...$arguments)\n"
    "    {\n"
    "        /** @var mixed $object */\n"
    "        $object = $this->__object;\n"
    "        return $object(...$arguments);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_wait_group =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "use BadMethodCallException;\n"
    "use InvalidArgumentException;\n"
    "\n"
    "class WaitGroup\n"
    "{\n"
    "    protected $chan;\n"
    "\n"
    "    protected $count = 0;\n"
    "\n"
    "    protected $waiting = false;\n"
    "\n"
    "    public function __construct(int $delta = 0)\n"
    "    {\n"
    "        $this->chan = new Channel(1);\n"
    "        if ($delta > 0) {\n"
    "            $this->add($delta);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function add(int $delta = 1): void\n"
    "    {\n"
    "        if ($this->waiting) {\n"
    "            throw new BadMethodCallException('WaitGroup misuse: add called concurrently with wait');\n"
    "        }\n"
    "        $count = $this->count + $delta;\n"
    "        if ($count < 0) {\n"
    "            throw new InvalidArgumentException('WaitGroup misuse: negative counter');\n"
    "        }\n"
    "        $this->count = $count;\n"
    "    }\n"
    "\n"
    "    public function done(): void\n"
    "    {\n"
    "        $count = $this->count - 1;\n"
    "        if ($count < 0) {\n"
    "            throw new BadMethodCallException('WaitGroup misuse: negative counter');\n"
    "        }\n"
    "        $this->count = $count;\n"
    "        if ($count === 0 && $this->waiting) {\n"
    "            $this->chan->push(true);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function wait(float $timeout = -1): bool\n"
    "    {\n"
    "        if ($this->waiting) {\n"
    "            throw new BadMethodCallException('WaitGroup misuse: reused before previous wait has returned');\n"
    "        }\n"
    "        if ($this->count > 0) {\n"
    "            $this->waiting = true;\n"
    "            $done = $this->chan->pop($timeout);\n"
    "            $this->waiting = false;\n"
    "            return $done;\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_server =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "use Swoole\\Coroutine;\n"
    "use Swoole\\Coroutine\\Server\\Connection;\n"
    "use Swoole\\Exception;\n"
    "\n"
    "/* compatibility constant */\n"
    "define('SWOOLE_COROUTINE_SOCKET_HAVE_SSL_HANDSHAKE', method_exists(Socket::class, 'sslHandshake'));\n"
    "\n"
    "class Server\n"
    "{\n"
    "    /** @var string */\n"
    "    public $host = '';\n"
    "\n"
    "    /** @var int */\n"
    "    public $port = 0;\n"
    "\n"
    "    /** @var int */\n"
    "    public $type = AF_INET;\n"
    "\n"
    "    /** @var int */\n"
    "    public $fd = -1;\n"
    "\n"
    "    /** @var int */\n"
    "    public $errCode = 0;\n"
    "\n"
    "    /** @var array */\n"
    "    public $setting = [];\n"
    "\n"
    "    /** @var bool */\n"
    "    protected $running = false;\n"
    "\n"
    "    /** @var null|callable */\n"
    "    protected $fn;\n"
    "\n"
    "    /** @var Socket */\n"
    "    protected $socket;\n"
    "\n"
    "    /**\n"
    "     * Server constructor.\n"
    "     * @throws Exception\n"
    "     */\n"
    "    public function __construct(string $host, int $port = 0, bool $ssl = false, bool $reuse_port = false)\n"
    "    {\n"
    "        $_host = swoole_string($host);\n"
    "        if ($_host->contains('::')) {\n"
    "            $this->type = AF_INET6;\n"
    "        } elseif ($_host->startsWith('unix:/')) {\n"
    "            $host = $_host->substr(5)->__toString();\n"
    "            $this->type = AF_UNIX;\n"
    "        } else {\n"
    "            $this->type = AF_INET;\n"
    "        }\n"
    "        $this->host = $host;\n"
    "\n"
    "        $socket = new Socket($this->type, SOCK_STREAM, 0);\n"
    "        if ($reuse_port and defined('SO_REUSEPORT')) {\n"
    "            $socket->setOption(SOL_SOCKET, SO_REUSEPORT, true);\n"
    "        }\n"
    "        if (!$socket->bind($this->host, $port)) {\n"
    "            throw new Exception(\"bind({$this->host}:{$port}) failed\", $socket->errCode);\n"
    "        }\n"
    "        if (!$socket->listen()) {\n"
    "            throw new Exception('listen() failed', $socket->errCode);\n"
    "        }\n"
    "        $this->port = $socket->getsockname()['port'] ?? 0;\n"
    "        $this->fd = $socket->fd;\n"
    "        $this->socket = $socket;\n"
    "        $this->setting['open_ssl'] = $ssl;\n"
    "    }\n"
    "\n"
    "    public function set(array $setting): void\n"
    "    {\n"
    "        $this->setting = array_merge($this->setting, $setting);\n"
    "    }\n"
    "\n"
    "    public function handle(callable $fn): void\n"
    "    {\n"
    "        $this->fn = $fn;\n"
    "    }\n"
    "\n"
    "    public function shutdown(): bool\n"
    "    {\n"
    "        $this->running = false;\n"
    "        return $this->socket->cancel();\n"
    "    }\n"
    "\n"
    "    public function start(): bool\n"
    "    {\n"
    "        $this->running = true;\n"
    "        if ($this->fn === null) {\n"
    "            $this->errCode = SOCKET_EINVAL;\n"
    "            return false;\n"
    "        }\n"
    "        $socket = $this->socket;\n"
    "        if (!$socket->setProtocol($this->setting)) {\n"
    "            $this->errCode = SOCKET_EINVAL;\n"
    "            return false;\n"
    "        }\n"
    "\n"
    "        while ($this->running) {\n"
    "            /** @var Socket $conn */\n"
    "            $conn = null;\n"
    "            $conn = $socket->accept();\n"
    "            if ($conn) {\n"
    "                $conn->setProtocol($this->setting);\n"
    "                if (SWOOLE_COROUTINE_SOCKET_HAVE_SSL_HANDSHAKE && $this->setting['open_ssl'] ?? false) {\n"
    "                    $fn = static function ($fn, $connection) {\n"
    "                        /* @var $connection Connection */\n"
    "                        if (!$connection->exportSocket()->sslHandshake()) {\n"
    "                            return;\n"
    "                        }\n"
    "                        $fn($connection);\n"
    "                    };\n"
    "                    $arguments = [$this->fn, new Connection($conn)];\n"
    "                } else {\n"
    "                    $fn = $this->fn;\n"
    "                    $arguments = [new Connection($conn)];\n"
    "                }\n"
    "                if (Coroutine::create($fn, ...$arguments) < 0) {\n"
    "                    goto _wait;\n"
    "                }\n"
    "            } else {\n"
    "                if ($socket->errCode == SOCKET_EMFILE or $socket->errCode == SOCKET_ENFILE) {\n"
    "                    _wait:\n"
    "                    Coroutine::sleep(1);\n"
    "                    continue;\n"
    "                }\n"
    "                if ($socket->errCode == SOCKET_ETIMEDOUT) {\n"
    "                    continue;\n"
    "                }\n"
    "                if ($socket->errCode == SOCKET_ECANCELED) {\n"
    "                    break;\n"
    "                }\n"
    "                trigger_error(\"accept failed, Error: {$socket->errMsg}[{$socket->errCode}]\", E_USER_WARNING);\n"
    "                break;\n"
    "            }\n"
    "        }\n"
    "\n"
    "        return true;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_server_connection =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine\\Server;\n"
    "\n"
    "use Swoole\\Coroutine\\Socket;\n"
    "\n"
    "class Connection\n"
    "{\n"
    "    protected $socket;\n"
    "\n"
    "    public function __construct(Socket $conn)\n"
    "    {\n"
    "        $this->socket = $conn;\n"
    "    }\n"
    "\n"
    "    public function recv(float $timeout = 0)\n"
    "    {\n"
    "        return $this->socket->recvPacket($timeout);\n"
    "    }\n"
    "\n"
    "    public function send(string $data)\n"
    "    {\n"
    "        return $this->socket->sendAll($data);\n"
    "    }\n"
    "\n"
    "    public function close(): bool\n"
    "    {\n"
    "        return $this->socket->close();\n"
    "    }\n"
    "\n"
    "    public function exportSocket(): Socket\n"
    "    {\n"
    "        return $this->socket;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_connection_pool =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole;\n"
    "\n"
    "use RuntimeException;\n"
    "use Swoole\\Coroutine\\Channel;\n"
    "use Throwable;\n"
    "\n"
    "class ConnectionPool\n"
    "{\n"
    "    public const DEFAULT_SIZE = 64;\n"
    "\n"
    "    /** @var Channel */\n"
    "    protected $pool;\n"
    "\n"
    "    /** @var callable */\n"
    "    protected $constructor;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $size;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $num;\n"
    "\n"
    "    /** @var null|string */\n"
    "    protected $proxy;\n"
    "\n"
    "    public function __construct(callable $constructor, int $size = self::DEFAULT_SIZE, ?string $proxy = null)\n"
    "    {\n"
    "        $this->pool = new Channel($this->size = $size);\n"
    "        $this->constructor = $constructor;\n"
    "        $this->num = 0;\n"
    "        $this->proxy = $proxy;\n"
    "    }\n"
    "\n"
    "    public function fill(): void\n"
    "    {\n"
    "        while ($this->size > $this->num) {\n"
    "            $this->make();\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function get()\n"
    "    {\n"
    "        if ($this->pool === null) {\n"
    "            throw new RuntimeException('Pool has been closed');\n"
    "        }\n"
    "        if ($this->pool->isEmpty() && $this->num < $this->size) {\n"
    "            $this->make();\n"
    "        }\n"
    "        return $this->pool->pop();\n"
    "    }\n"
    "\n"
    "    public function put($connection): void\n"
    "    {\n"
    "        if ($this->pool === null) {\n"
    "            return;\n"
    "        }\n"
    "        if ($connection !== null) {\n"
    "            $this->pool->push($connection);\n"
    "        } else {\n"
    "            /* connection broken */\n"
    "            $this->num -= 1;\n"
    "            $this->make();\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function close(): void\n"
    "    {\n"
    "        $this->pool->close();\n"
    "        $this->pool = null;\n"
    "        $this->num = 0;\n"
    "    }\n"
    "\n"
    "    protected function make(): void\n"
    "    {\n"
    "        $this->num++;\n"
    "        try {\n"
    "            if ($this->proxy) {\n"
    "                $connection = new $this->proxy($this->constructor);\n"
    "            } else {\n"
    "                $constructor = $this->constructor;\n"
    "                $connection = $constructor();\n"
    "            }\n"
    "        } catch (Throwable $throwable) {\n"
    "            $this->num--;\n"
    "            throw $throwable;\n"
    "        }\n"
    "        $this->put($connection);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_object_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use Error;\n"
    "\n"
    "class ObjectProxy extends \\Swoole\\ObjectProxy\n"
    "{\n"
    "    public function __clone()\n"
    "    {\n"
    "        throw new Error('Trying to clone an uncloneable database proxy object');\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_config =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "class MysqliConfig\n"
    "{\n"
    "    /** @var string */\n"
    "    protected $host = '127.0.0.1';\n"
    "\n"
    "    /** @var int */\n"
    "    protected $port = 3306;\n"
    "\n"
    "    /** @var null|string */\n"
    "    protected $unixSocket = '';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $dbname = 'test';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $charset = 'utf8mb4';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $username = 'root';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $password = 'root';\n"
    "\n"
    "    /** @var array */\n"
    "    protected $options = [];\n"
    "\n"
    "    public function getHost(): string\n"
    "    {\n"
    "        return $this->host;\n"
    "    }\n"
    "\n"
    "    public function withHost($host): self\n"
    "    {\n"
    "        $this->host = $host;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPort(): int\n"
    "    {\n"
    "        return $this->port;\n"
    "    }\n"
    "\n"
    "    public function getUnixSocket(): string\n"
    "    {\n"
    "        return $this->unixSocket;\n"
    "    }\n"
    "\n"
    "    public function withUnixSocket(?string $unixSocket): self\n"
    "    {\n"
    "        $this->unixSocket = $unixSocket;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withPort(int $port): self\n"
    "    {\n"
    "        $this->port = $port;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getDbname(): string\n"
    "    {\n"
    "        return $this->dbname;\n"
    "    }\n"
    "\n"
    "    public function withDbname(string $dbname): self\n"
    "    {\n"
    "        $this->dbname = $dbname;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getCharset(): string\n"
    "    {\n"
    "        return $this->charset;\n"
    "    }\n"
    "\n"
    "    public function withCharset(string $charset): self\n"
    "    {\n"
    "        $this->charset = $charset;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getUsername(): string\n"
    "    {\n"
    "        return $this->username;\n"
    "    }\n"
    "\n"
    "    public function withUsername(string $username): self\n"
    "    {\n"
    "        $this->username = $username;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPassword(): string\n"
    "    {\n"
    "        return $this->password;\n"
    "    }\n"
    "\n"
    "    public function withPassword(string $password): self\n"
    "    {\n"
    "        $this->password = $password;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getOptions(): array\n"
    "    {\n"
    "        return $this->options;\n"
    "    }\n"
    "\n"
    "    public function withOptions(array $options): self\n"
    "    {\n"
    "        $this->options = $options;\n"
    "        return $this;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_exception =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use Exception;\n"
    "\n"
    "class MysqliException extends Exception\n"
    "{\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_pool =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use mysqli;\n"
    "use Swoole\\ConnectionPool;\n"
    "\n"
    "/**\n"
    " * @method mysqli|MysqliProxy get()\n"
    " * @method void put(mysqli|MysqliProxy $connection)\n"
    " */\n"
    "class MysqliPool extends ConnectionPool\n"
    "{\n"
    "    /** @var MysqliConfig */\n"
    "    protected $config;\n"
    "\n"
    "    public function __construct(MysqliConfig $config, int $size = self::DEFAULT_SIZE)\n"
    "    {\n"
    "        $this->config = $config;\n"
    "        parent::__construct(function () {\n"
    "            $mysqli = new mysqli();\n"
    "            foreach ($this->config->getOptions() as $option => $value) {\n"
    "                $mysqli->set_opt($option, $value);\n"
    "            }\n"
    "            $mysqli->real_connect(\n"
    "                $this->config->getHost(),\n"
    "                $this->config->getUsername(),\n"
    "                $this->config->getPassword(),\n"
    "                $this->config->getDbname(),\n"
    "                $this->config->getPort(),\n"
    "                $this->config->getUnixSocket()\n"
    "            );\n"
    "            if ($mysqli->connect_errno) {\n"
    "                throw new MysqliException($mysqli->connect_error, $mysqli->connect_errno);\n"
    "            }\n"
    "            return $mysqli;\n"
    "        }, $size, MysqliProxy::class);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use mysqli;\n"
    "\n"
    "class MysqliProxy extends ObjectProxy\n"
    "{\n"
    "    public const IO_METHOD_REGEX = '/^autocommit|begin_transaction|change_user|close|commit|kill|multi_query|ping|prepare|query|real_connect|real_query|reap_async_query|refresh|release_savepoint|rollback|savepoint|select_db|send_query|set_charset|ssl_set$/i';\n"
    "\n"
    "    public const IO_ERRORS = [\n"
    "        2002, // MYSQLND_CR_CONNECTION_ERROR\n"
    "        2006, // MYSQLND_CR_SERVER_GONE_ERROR\n"
    "        2013, // MYSQLND_CR_SERVER_LOST\n"
    "    ];\n"
    "\n"
    "    /** @var mysqli */\n"
    "    protected $__object;\n"
    "\n"
    "    /** @var string */\n"
    "    protected $charsetContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $setOptContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $changeUserContext;\n"
    "\n"
    "    /** @var callable */\n"
    "    protected $constructor;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $round = 0;\n"
    "\n"
    "    public function __construct(callable $constructor)\n"
    "    {\n"
    "        parent::__construct($constructor());\n"
    "        $this->constructor = $constructor;\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        for ($n = 3; $n--;) {\n"
    "            $ret = @$this->__object->{$name}(...$arguments);\n"
    "            if ($ret === false) {\n"
    "                /* non-IO method */\n"
    "                if (!preg_match(static::IO_METHOD_REGEX, $name)) {\n"
    "                    break;\n"
    "                }\n"
    "                /* no more chances or non-IO failures */\n"
    "                if (\n"
    "                    !in_array($this->__object->errno, static::IO_ERRORS, true) ||\n"
    "                    $n === 0\n"
    "                ) {\n"
    "                    throw new MysqliException($this->__object->error, $this->__object->errno);\n"
    "                }\n"
    "                $this->reconnect();\n"
    "                continue;\n"
    "            }\n"
    "            if (strcasecmp($name, 'prepare') === 0) {\n"
    "                $ret = new MysqliStatementProxy($ret, $arguments[0], $this);\n"
    "            } elseif (strcasecmp($name, 'stmt_init') === 0) {\n"
    "                $ret = new MysqliStatementProxy($ret, null, $this);\n"
    "            }\n"
    "            break;\n"
    "        }\n"
    "        /* @noinspection PhpUndefinedVariableInspection */\n"
    "        return $ret;\n"
    "    }\n"
    "\n"
    "    public function getRound(): int\n"
    "    {\n"
    "        return $this->round;\n"
    "    }\n"
    "\n"
    "    public function reconnect(): void\n"
    "    {\n"
    "        $constructor = $this->constructor;\n"
    "        parent::__construct($constructor());\n"
    "        $this->round++;\n"
    "        /* restore context */\n"
    "        if ($this->charsetContext) {\n"
    "            $this->__object->set_charset($this->charsetContext);\n"
    "        }\n"
    "        if ($this->setOptContext) {\n"
    "            foreach ($this->setOptContext as $opt => $val) {\n"
    "                $this->__object->set_opt($opt, $val);\n"
    "            }\n"
    "        }\n"
    "        if ($this->changeUserContext) {\n"
    "            $this->__object->change_user(...$this->changeUserContext);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function options(int $option, $value): bool\n"
    "    {\n"
    "        $this->setOptContext[$option] = $value;\n"
    "        return $this->__object->options($option, $value);\n"
    "    }\n"
    "\n"
    "    public function set_opt(int $option, $value): bool\n"
    "    {\n"
    "        return $this->options($option, $value);\n"
    "    }\n"
    "\n"
    "    public function set_charset(string $charset): bool\n"
    "    {\n"
    "        $this->charsetContext = $charset;\n"
    "        return $this->__object->set_charset($charset);\n"
    "    }\n"
    "\n"
    "    public function change_user(string $user, string $password, string $database): bool\n"
    "    {\n"
    "        $this->changeUserContext = [$user, $password, $database];\n"
    "        return $this->__object->change_user($user, $password, $database);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_mysqli_statement_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use mysqli;\n"
    "use mysqli_stmt;\n"
    "\n"
    "class MysqliStatementProxy extends ObjectProxy\n"
    "{\n"
    "    public const IO_METHOD_REGEX = '/^close|execute|fetch|prepare$/i';\n"
    "\n"
    "    /** @var mysqli_stmt */\n"
    "    protected $__object;\n"
    "\n"
    "    /** @var null|string */\n"
    "    protected $queryString;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $attrSetContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $bindParamContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $bindResultContext;\n"
    "\n"
    "    /** @var Mysqli|MysqliProxy */\n"
    "    protected $parent;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $parentRound;\n"
    "\n"
    "    public function __construct(mysqli_stmt $object, ?string $queryString, MysqliProxy $parent)\n"
    "    {\n"
    "        parent::__construct($object);\n"
    "        $this->queryString = $queryString;\n"
    "        $this->parent = $parent;\n"
    "        $this->parentRound = $parent->getRound();\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        for ($n = 3; $n--;) {\n"
    "            $ret = @$this->__object->{$name}(...$arguments);\n"
    "            if ($ret === false) {\n"
    "                /* non-IO method */\n"
    "                if (!preg_match(static::IO_METHOD_REGEX, $name)) {\n"
    "                    break;\n"
    "                }\n"
    "                /* no more chances or non-IO failures or in transaction */\n"
    "                if (\n"
    "                    !in_array($this->__object->errno, $this->parent::IO_ERRORS, true) ||\n"
    "                    $n === 0\n"
    "                ) {\n"
    "                    throw new MysqliException($this->__object->error, $this->__object->errno);\n"
    "                }\n"
    "                if ($this->parent->getRound() === $this->parentRound) {\n"
    "                    /* if not equal, parent has reconnected */\n"
    "                    $this->parent->reconnect();\n"
    "                }\n"
    "                $parent = $this->parent->__getObject();\n"
    "                $this->__object = $this->queryString ? @$parent->prepare($this->queryString) : @$parent->stmt_init();\n"
    "                if ($this->__object === false) {\n"
    "                    throw new MysqliException($parent->error, $parent->errno);\n"
    "                }\n"
    "                if ($this->bindParamContext) {\n"
    "                    $this->__object->bind_param($this->bindParamContext[0], ...$this->bindParamContext[1]);\n"
    "                }\n"
    "                if ($this->bindResultContext) {\n"
    "                    $this->__object->bind_result($this->bindResultContext);\n"
    "                }\n"
    "                if ($this->attrSetContext) {\n"
    "                    foreach ($this->attrSetContext as $attr => $value) {\n"
    "                        $this->__object->attr_set($attr, $value);\n"
    "                    }\n"
    "                }\n"
    "                continue;\n"
    "            }\n"
    "            if (strcasecmp($name, 'prepare') === 0) {\n"
    "                $this->queryString = $arguments[0];\n"
    "            }\n"
    "            break;\n"
    "        }\n"
    "        /* @noinspection PhpUndefinedVariableInspection */\n"
    "        return $ret;\n"
    "    }\n"
    "\n"
    "    public function attr_set($attr, $mode): bool\n"
    "    {\n"
    "        $this->attrSetContext[$attr] = $mode;\n"
    "        return $this->__object->attr_set($attr, $mode);\n"
    "    }\n"
    "\n"
    "    public function bind_param($types, &...$arguments): bool\n"
    "    {\n"
    "        $this->bindParamContext = [$types, $arguments];\n"
    "        return $this->__object->bind_param($types, ...$arguments);\n"
    "    }\n"
    "\n"
    "    public function bind_result(&...$arguments): bool\n"
    "    {\n"
    "        $this->bindResultContext = $arguments;\n"
    "        return $this->__object->bind_result(...$arguments);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_pdo_config =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "class PDOConfig\n"
    "{\n"
    "    public const DRIVER_MYSQL = 'mysql';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $driver = self::DRIVER_MYSQL;\n"
    "\n"
    "    /** @var string */\n"
    "    protected $host = '127.0.0.1';\n"
    "\n"
    "    /** @var int */\n"
    "    protected $port = 3306;\n"
    "\n"
    "    /** @var null|string */\n"
    "    protected $unixSocket;\n"
    "\n"
    "    /** @var string */\n"
    "    protected $dbname = 'test';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $charset = 'utf8mb4';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $username = 'root';\n"
    "\n"
    "    /** @var string */\n"
    "    protected $password = 'root';\n"
    "\n"
    "    /** @var array */\n"
    "    protected $options = [];\n"
    "\n"
    "    public function getDriver(): string\n"
    "    {\n"
    "        return $this->driver;\n"
    "    }\n"
    "\n"
    "    public function withDriver(string $driver): self\n"
    "    {\n"
    "        $this->driver = $driver;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getHost(): string\n"
    "    {\n"
    "        return $this->host;\n"
    "    }\n"
    "\n"
    "    public function withHost($host): self\n"
    "    {\n"
    "        $this->host = $host;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPort(): int\n"
    "    {\n"
    "        return $this->port;\n"
    "    }\n"
    "\n"
    "    public function hasUnixSocket(): bool\n"
    "    {\n"
    "        return isset($this->unixSocket);\n"
    "    }\n"
    "\n"
    "    public function getUnixSocket(): string\n"
    "    {\n"
    "        return $this->unixSocket;\n"
    "    }\n"
    "\n"
    "    public function withUnixSocket(?string $unixSocket): self\n"
    "    {\n"
    "        $this->unixSocket = $unixSocket;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function withPort(int $port): self\n"
    "    {\n"
    "        $this->port = $port;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getDbname(): string\n"
    "    {\n"
    "        return $this->dbname;\n"
    "    }\n"
    "\n"
    "    public function withDbname(string $dbname): self\n"
    "    {\n"
    "        $this->dbname = $dbname;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getCharset(): string\n"
    "    {\n"
    "        return $this->charset;\n"
    "    }\n"
    "\n"
    "    public function withCharset(string $charset): self\n"
    "    {\n"
    "        $this->charset = $charset;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getUsername(): string\n"
    "    {\n"
    "        return $this->username;\n"
    "    }\n"
    "\n"
    "    public function withUsername(string $username): self\n"
    "    {\n"
    "        $this->username = $username;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPassword(): string\n"
    "    {\n"
    "        return $this->password;\n"
    "    }\n"
    "\n"
    "    public function withPassword(string $password): self\n"
    "    {\n"
    "        $this->password = $password;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getOptions(): array\n"
    "    {\n"
    "        return $this->options;\n"
    "    }\n"
    "\n"
    "    public function withOptions(array $options): self\n"
    "    {\n"
    "        $this->options = $options;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * Returns the list of available drivers\n"
    "     *\n"
    "     * @return string[]\n"
    "     */\n"
    "    public static function getAvailableDrivers()\n"
    "    {\n"
    "        return [\n"
    "            self::DRIVER_MYSQL,\n"
    "        ];\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_pdo_pool =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use PDO;\n"
    "use Swoole\\ConnectionPool;\n"
    "\n"
    "/**\n"
    " * @method PDO|PDOProxy get()\n"
    " * @method void put(PDO|PDOProxy $connection)\n"
    " */\n"
    "class PDOPool extends ConnectionPool\n"
    "{\n"
    "    /** @var int */\n"
    "    protected $size = 64;\n"
    "\n"
    "    /** @var PDOConfig */\n"
    "    protected $config;\n"
    "\n"
    "    public function __construct(PDOConfig $config, int $size = self::DEFAULT_SIZE)\n"
    "    {\n"
    "        $this->config = $config;\n"
    "        parent::__construct(function () {\n"
    "            return new PDO(\n"
    "                \"{$this->config->getDriver()}:\" .\n"
    "                (\n"
    "                    $this->config->hasUnixSocket() ?\n"
    "                    \"unix_socket={$this->config->getUnixSocket()};\" :\n"
    "                    \"host={$this->config->getHost()};\" . \"port={$this->config->getPort()};\"\n"
    "                ) .\n"
    "                \"dbname={$this->config->getDbname()};\" .\n"
    "                \"charset={$this->config->getCharset()}\",\n"
    "                $this->config->getUsername(),\n"
    "                $this->config->getPassword(),\n"
    "                $this->config->getOptions()\n"
    "            );\n"
    "        }, $size, PDOProxy::class);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_pdo_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use PDO;\n"
    "use PDOException;\n"
    "\n"
    "class PDOProxy extends ObjectProxy\n"
    "{\n"
    "    public const IO_METHOD_REGEX = '/^query|prepare|exec|beginTransaction|commit|rollback$/i';\n"
    "\n"
    "    public const IO_ERRORS = [\n"
    "        2002, // MYSQLND_CR_CONNECTION_ERROR\n"
    "        2006, // MYSQLND_CR_SERVER_GONE_ERROR\n"
    "        2013, // MYSQLND_CR_SERVER_LOST\n"
    "    ];\n"
    "\n"
    "    /** @var PDO */\n"
    "    protected $__object;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $setAttributeContext;\n"
    "\n"
    "    /** @var callable */\n"
    "    protected $constructor;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $round = 0;\n"
    "\n"
    "    public function __construct(callable $constructor)\n"
    "    {\n"
    "        parent::__construct($constructor());\n"
    "        $this->__object->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_SILENT);\n"
    "        $this->constructor = $constructor;\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        for ($n = 3; $n--;) {\n"
    "            $ret = @$this->__object->{$name}(...$arguments);\n"
    "            if ($ret === false) {\n"
    "                /* non-IO method */\n"
    "                if (!preg_match(static::IO_METHOD_REGEX, $name)) {\n"
    "                    break;\n"
    "                }\n"
    "                $errorInfo = $this->__object->errorInfo();\n"
    "                /* no more chances or non-IO failures */\n"
    "                if (\n"
    "                    !in_array($errorInfo[1], static::IO_ERRORS, true) ||\n"
    "                    $n === 0 ||\n"
    "                    $this->__object->inTransaction()\n"
    "                ) {\n"
    "                    $exception = new PDOException($errorInfo[2], $errorInfo[1]);\n"
    "                    $exception->errorInfo = $errorInfo;\n"
    "                    throw $exception;\n"
    "                }\n"
    "                $this->reconnect();\n"
    "                continue;\n"
    "            }\n"
    "            if (\n"
    "                strcasecmp($name, 'prepare') === 0 ||\n"
    "                strcasecmp($name, 'query') === 0\n"
    "            ) {\n"
    "                $ret = new PDOStatementProxy($ret, $this);\n"
    "            }\n"
    "            break;\n"
    "        }\n"
    "        /* @noinspection PhpUndefinedVariableInspection */\n"
    "        return $ret;\n"
    "    }\n"
    "\n"
    "    public function getRound(): int\n"
    "    {\n"
    "        return $this->round;\n"
    "    }\n"
    "\n"
    "    public function reconnect(): void\n"
    "    {\n"
    "        $constructor = $this->constructor;\n"
    "        parent::__construct($constructor());\n"
    "        $this->round++;\n"
    "        /* restore context */\n"
    "        if ($this->setAttributeContext) {\n"
    "            foreach ($this->setAttributeContext as $attribute => $value) {\n"
    "                $this->__object->setAttribute($attribute, $value);\n"
    "            }\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function setAttribute(int $attribute, $value): bool\n"
    "    {\n"
    "        $this->setAttributeContext[$attribute] = $value;\n"
    "        return $this->__object->setAttribute($attribute, $value);\n"
    "    }\n"
    "\n"
    "    public function inTransaction(): bool\n"
    "    {\n"
    "        return $this->__object->inTransaction();\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_pdo_statement_proxy =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use PDO;\n"
    "use PDOException;\n"
    "use PDOStatement;\n"
    "\n"
    "class PDOStatementProxy extends ObjectProxy\n"
    "{\n"
    "    /** @var PDOStatement */\n"
    "    protected $__object;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $setAttributeContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $setFetchModeContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $bindParamContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $bindColumnContext;\n"
    "\n"
    "    /** @var null|array */\n"
    "    protected $bindValueContext;\n"
    "\n"
    "    /** @var PDO|PDOProxy */\n"
    "    protected $parent;\n"
    "\n"
    "    /** @var int */\n"
    "    protected $parentRound;\n"
    "\n"
    "    public function __construct(PDOStatement $object, PDOProxy $parent)\n"
    "    {\n"
    "        parent::__construct($object);\n"
    "        $this->parent = $parent;\n"
    "        $this->parentRound = $parent->getRound();\n"
    "    }\n"
    "\n"
    "    public function __call(string $name, array $arguments)\n"
    "    {\n"
    "        for ($n = 3; $n--;) {\n"
    "            $ret = @$this->__object->{$name}(...$arguments);\n"
    "            if ($ret === false) {\n"
    "                /* no IO */\n"
    "                if (strtolower($name) !== 'execute') {\n"
    "                    break;\n"
    "                }\n"
    "                /* no more chances or non-IO failures or in transaction */\n"
    "                if (\n"
    "                    !in_array($this->__object->errorInfo()[1], $this->parent::IO_ERRORS, true) ||\n"
    "                    $n === 0 ||\n"
    "                    $this->parent->inTransaction()\n"
    "                ) {\n"
    "                    $errorInfo = $this->__object->errorInfo();\n"
    "\n"
    "                    // '00000' means “no error.”, as specified by ANSI SQL and ODBC.\n"
    "                    if ($errorInfo[0] !== '00000') {\n"
    "                        $exception = new PDOException($errorInfo[2], $errorInfo[1]);\n"
    "                        $exception->errorInfo = $errorInfo;\n"
    "                        throw $exception;\n"
    "                    }\n"
    "                }\n"
    "                if ($this->parent->getRound() === $this->parentRound) {\n"
    "                    /* if not equal, parent has reconnected */\n"
    "                    $this->parent->reconnect();\n"
    "                }\n"
    "                $parent = $this->parent->__getObject();\n"
    "                $this->__object = $parent->prepare($this->__object->queryString);\n"
    "                if ($this->__object === false) {\n"
    "                    $errorInfo = $parent->errorInfo();\n"
    "                    $exception = new PDOException($errorInfo[2], $errorInfo[1]);\n"
    "                    $exception->errorInfo = $errorInfo;\n"
    "                    throw $exception;\n"
    "                }\n"
    "                if ($this->setAttributeContext) {\n"
    "                    foreach ($this->setAttributeContext as $attribute => $value) {\n"
    "                        $this->__object->setAttribute($attribute, $value);\n"
    "                    }\n"
    "                }\n"
    "                if ($this->setFetchModeContext) {\n"
    "                    $this->__object->setFetchMode(...$this->setFetchModeContext);\n"
    "                }\n"
    "                if ($this->bindParamContext) {\n"
    "                    foreach ($this->bindParamContext as $param => $item) {\n"
    "                        $this->__object->bindParam($param, ...$item);\n"
    "                    }\n"
    "                }\n"
    "                if ($this->bindColumnContext) {\n"
    "                    foreach ($this->bindColumnContext as $column => $item) {\n"
    "                        $this->__object->bindColumn($column, ...$item);\n"
    "                    }\n"
    "                }\n"
    "                if ($this->bindValueContext) {\n"
    "                    foreach ($this->bindValueContext as $value => $item) {\n"
    "                        $this->__object->bindParam($value, ...$item);\n"
    "                    }\n"
    "                }\n"
    "                continue;\n"
    "            }\n"
    "            break;\n"
    "        }\n"
    "        /* @noinspection PhpUndefinedVariableInspection */\n"
    "        return $ret;\n"
    "    }\n"
    "\n"
    "    public function setAttribute(int $attribute, $value): bool\n"
    "    {\n"
    "        $this->setAttributeContext[$attribute] = $value;\n"
    "        return $this->__object->setAttribute($attribute, $value);\n"
    "    }\n"
    "\n"
    "    public function setFetchMode(int $mode, $classNameObject = null, array $ctorarfg = []): bool\n"
    "    {\n"
    "        $this->setFetchModeContext = [$mode, $classNameObject, $ctorarfg];\n"
    "        if (!isset($classNameObject)) {\n"
    "            return $this->__object->setFetchMode($mode);\n"
    "        }\n"
    "        return $this->__object->setFetchMode($mode, $classNameObject, $ctorarfg);\n"
    "    }\n"
    "\n"
    "    public function bindParam($parameter, &$variable, $data_type = PDO::PARAM_STR, $length = null, $driver_options = null): bool\n"
    "    {\n"
    "        $this->bindParamContext[$parameter] = [$variable, $data_type, $length, $driver_options];\n"
    "        return $this->__object->bindParam($parameter, $variable, $data_type, $length, $driver_options);\n"
    "    }\n"
    "\n"
    "    public function bindColumn($column, &$param, $type = null, $maxlen = null, $driverdata = null): bool\n"
    "    {\n"
    "        $this->bindColumnContext[$column] = [$param, $type, $maxlen, $driverdata];\n"
    "        return $this->__object->bindColumn($column, $param, $type, $maxlen, $driverdata);\n"
    "    }\n"
    "\n"
    "    public function bindValue($parameter, $value, $data_type = PDO::PARAM_STR): bool\n"
    "    {\n"
    "        $this->bindValueContext[$parameter] = [$value, $data_type];\n"
    "        return $this->__object->bindValue($parameter, $value, $data_type);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_redis_config =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "class RedisConfig\n"
    "{\n"
    "    /** @var string */\n"
    "    protected $host = '127.0.0.1';\n"
    "\n"
    "    /** @var int */\n"
    "    protected $port = 6379;\n"
    "\n"
    "    /** @var float */\n"
    "    protected $timeout = 0.0;\n"
    "\n"
    "    /** @var string */\n"
    "    protected $reserved = '';\n"
    "\n"
    "    /** @var int */\n"
    "    protected $retry_interval = 0;\n"
    "\n"
    "    /** @var float */\n"
    "    protected $read_timeout = 0.0;\n"
    "\n"
    "    /** @var string */\n"
    "    protected $auth = '';\n"
    "\n"
    "    /** @var int */\n"
    "    protected $dbIndex = 0;\n"
    "\n"
    "    public function getHost()\n"
    "    {\n"
    "        return $this->host;\n"
    "    }\n"
    "\n"
    "    public function withHost($host): self\n"
    "    {\n"
    "        $this->host = $host;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getPort(): int\n"
    "    {\n"
    "        return $this->port;\n"
    "    }\n"
    "\n"
    "    public function withPort(int $port): self\n"
    "    {\n"
    "        $this->port = $port;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getTimeout(): float\n"
    "    {\n"
    "        return $this->timeout;\n"
    "    }\n"
    "\n"
    "    public function withTimeout(float $timeout): self\n"
    "    {\n"
    "        $this->timeout = $timeout;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getReserved(): string\n"
    "    {\n"
    "        return $this->reserved;\n"
    "    }\n"
    "\n"
    "    public function withReserved(string $reserved): self\n"
    "    {\n"
    "        $this->reserved = $reserved;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getRetryInterval(): int\n"
    "    {\n"
    "        return $this->retry_interval;\n"
    "    }\n"
    "\n"
    "    public function withRetryInterval(int $retry_interval): self\n"
    "    {\n"
    "        $this->retry_interval = $retry_interval;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getReadTimeout(): float\n"
    "    {\n"
    "        return $this->read_timeout;\n"
    "    }\n"
    "\n"
    "    public function withReadTimeout(float $read_timeout): self\n"
    "    {\n"
    "        $this->read_timeout = $read_timeout;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getAuth(): string\n"
    "    {\n"
    "        return $this->auth;\n"
    "    }\n"
    "\n"
    "    public function withAuth(string $auth): self\n"
    "    {\n"
    "        $this->auth = $auth;\n"
    "        return $this;\n"
    "    }\n"
    "\n"
    "    public function getDbIndex(): int\n"
    "    {\n"
    "        return $this->dbIndex;\n"
    "    }\n"
    "\n"
    "    public function withDbIndex(int $dbIndex): self\n"
    "    {\n"
    "        $this->dbIndex = $dbIndex;\n"
    "        return $this;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_database_redis_pool =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Database;\n"
    "\n"
    "use Redis;\n"
    "use Swoole\\ConnectionPool;\n"
    "\n"
    "/**\n"
    " * @method Redis get()\n"
    " * @method void put(Redis $connection)\n"
    " */\n"
    "class RedisPool extends ConnectionPool\n"
    "{\n"
    "    /** @var RedisConfig */\n"
    "    protected $config;\n"
    "\n"
    "    public function __construct(RedisConfig $config, int $size = self::DEFAULT_SIZE)\n"
    "    {\n"
    "        $this->config = $config;\n"
    "        parent::__construct(function () {\n"
    "            $redis = new Redis();\n"
    "            /* Compatible with different versions of Redis extension as much as possible */\n"
    "            $arguments = [\n"
    "                $this->config->getHost(),\n"
    "                $this->config->getPort(),\n"
    "            ];\n"
    "            if ($this->config->getTimeout() !== 0.0) {\n"
    "                $arguments[] = $this->config->getTimeout();\n"
    "            }\n"
    "            if ($this->config->getRetryInterval() !== 0) {\n"
    "                /* reserved should always be NULL */\n"
    "                $arguments[] = null;\n"
    "                $arguments[] = $this->config->getRetryInterval();\n"
    "            }\n"
    "            if ($this->config->getReadTimeout() !== 0.0) {\n"
    "                $arguments[] = $this->config->getReadTimeout();\n"
    "            }\n"
    "            $redis->connect(...$arguments);\n"
    "            if ($this->config->getAuth()) {\n"
    "                $redis->auth($this->config->getAuth());\n"
    "            }\n"
    "            if ($this->config->getDbIndex() !== 0) {\n"
    "                $redis->select($this->config->getDbIndex());\n"
    "            }\n"
    "            return $redis;\n"
    "        }, $size);\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_http_status =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Http;\n"
    "\n"
    "abstract class Status\n"
    "{\n"
    "    public const CONTINUE = 100;\n"
    "\n"
    "    public const SWITCHING_PROTOCOLS = 101;\n"
    "\n"
    "    public const PROCESSING = 102;\n"
    "\n"
    "    public const OK = 200;\n"
    "\n"
    "    public const CREATED = 201;\n"
    "\n"
    "    public const ACCEPTED = 202;\n"
    "\n"
    "    public const NON_AUTHORITATIVE_INFORMATION = 203;\n"
    "\n"
    "    public const NO_CONTENT = 204;\n"
    "\n"
    "    public const RESET_CONTENT = 205;\n"
    "\n"
    "    public const PARTIAL_CONTENT = 206;\n"
    "\n"
    "    public const MULTI_STATUS = 207;\n"
    "\n"
    "    public const ALREADY_REPORTED = 208;\n"
    "\n"
    "    public const IM_USED = 226;\n"
    "\n"
    "    public const MULTIPLE_CHOICES = 300;\n"
    "\n"
    "    public const MOVED_PERMANENTLY = 301;\n"
    "\n"
    "    public const FOUND = 302;\n"
    "\n"
    "    public const SEE_OTHER = 303;\n"
    "\n"
    "    public const NOT_MODIFIED = 304;\n"
    "\n"
    "    public const USE_PROXY = 305;\n"
    "\n"
    "    public const SWITCH_PROXY = 306;\n"
    "\n"
    "    public const TEMPORARY_REDIRECT = 307;\n"
    "\n"
    "    public const PERMANENT_REDIRECT = 308;\n"
    "\n"
    "    public const BAD_REQUEST = 400;\n"
    "\n"
    "    public const UNAUTHORIZED = 401;\n"
    "\n"
    "    public const PAYMENT_REQUIRED = 402;\n"
    "\n"
    "    public const FORBIDDEN = 403;\n"
    "\n"
    "    public const NOT_FOUND = 404;\n"
    "\n"
    "    public const METHOD_NOT_ALLOWED = 405;\n"
    "\n"
    "    public const NOT_ACCEPTABLE = 406;\n"
    "\n"
    "    public const PROXY_AUTHENTICATION_REQUIRED = 407;\n"
    "\n"
    "    public const REQUEST_TIME_OUT = 408;\n"
    "\n"
    "    public const CONFLICT = 409;\n"
    "\n"
    "    public const GONE = 410;\n"
    "\n"
    "    public const LENGTH_REQUIRED = 411;\n"
    "\n"
    "    public const PRECONDITION_FAILED = 412;\n"
    "\n"
    "    public const REQUEST_ENTITY_TOO_LARGE = 413;\n"
    "\n"
    "    public const REQUEST_URI_TOO_LARGE = 414;\n"
    "\n"
    "    public const UNSUPPORTED_MEDIA_TYPE = 415;\n"
    "\n"
    "    public const REQUESTED_RANGE_NOT_SATISFIABLE = 416;\n"
    "\n"
    "    public const EXPECTATION_FAILED = 417;\n"
    "\n"
    "    public const MISDIRECTED_REQUEST = 421;\n"
    "\n"
    "    public const UNPROCESSABLE_ENTITY = 422;\n"
    "\n"
    "    public const LOCKED = 423;\n"
    "\n"
    "    public const FAILED_DEPENDENCY = 424;\n"
    "\n"
    "    public const UNORDERED_COLLECTION = 425;\n"
    "\n"
    "    public const UPGRADE_REQUIRED = 426;\n"
    "\n"
    "    public const PRECONDITION_REQUIRED = 428;\n"
    "\n"
    "    public const TOO_MANY_REQUESTS = 429;\n"
    "\n"
    "    public const REQUEST_HEADER_FIELDS_TOO_LARGE = 431;\n"
    "\n"
    "    public const UNAVAILABLE_FOR_LEGAL_REASONS = 451;\n"
    "\n"
    "    public const INTERNAL_SERVER_ERROR = 500;\n"
    "\n"
    "    public const NOT_IMPLEMENTED = 501;\n"
    "\n"
    "    public const BAD_GATEWAY = 502;\n"
    "\n"
    "    public const SERVICE_UNAVAILABLE = 503;\n"
    "\n"
    "    public const GATEWAY_TIME_OUT = 504;\n"
    "\n"
    "    public const HTTP_VERSION_NOT_SUPPORTED = 505;\n"
    "\n"
    "    public const VARIANT_ALSO_NEGOTIATES = 506;\n"
    "\n"
    "    public const INSUFFICIENT_STORAGE = 507;\n"
    "\n"
    "    public const LOOP_DETECTED = 508;\n"
    "\n"
    "    public const NOT_EXTENDED = 510;\n"
    "\n"
    "    public const NETWORK_AUTHENTICATION_REQUIRED = 511;\n"
    "\n"
    "    protected static $reasonPhrases = [\n"
    "        self::CONTINUE => 'Continue',\n"
    "        self::SWITCHING_PROTOCOLS => 'Switching Protocols',\n"
    "        self::PROCESSING => 'Processing',\n"
    "        self::OK => 'OK',\n"
    "        self::CREATED => 'Created',\n"
    "        self::ACCEPTED => 'Accepted',\n"
    "        self::NON_AUTHORITATIVE_INFORMATION => 'Non-Authoritative Information',\n"
    "        self::NO_CONTENT => 'No Content',\n"
    "        self::RESET_CONTENT => 'Reset Content',\n"
    "        self::PARTIAL_CONTENT => 'Partial Content',\n"
    "        self::MULTI_STATUS => 'Multi-status',\n"
    "        self::ALREADY_REPORTED => 'Already Reported',\n"
    "        self::IM_USED => 'IM Used',\n"
    "        self::MULTIPLE_CHOICES => 'Multiple Choices',\n"
    "        self::MOVED_PERMANENTLY => 'Moved Permanently',\n"
    "        self::FOUND => 'Found',\n"
    "        self::SEE_OTHER => 'See Other',\n"
    "        self::NOT_MODIFIED => 'Not Modified',\n"
    "        self::USE_PROXY => 'Use Proxy',\n"
    "        self::SWITCH_PROXY => 'Switch Proxy',\n"
    "        self::TEMPORARY_REDIRECT => 'Temporary Redirect',\n"
    "        self::PERMANENT_REDIRECT => 'Permanent Redirect',\n"
    "        self::BAD_REQUEST => 'Bad Request',\n"
    "        self::UNAUTHORIZED => 'Unauthorized',\n"
    "        self::PAYMENT_REQUIRED => 'Payment Required',\n"
    "        self::FORBIDDEN => 'Forbidden',\n"
    "        self::NOT_FOUND => 'Not Found',\n"
    "        self::METHOD_NOT_ALLOWED => 'Method Not Allowed',\n"
    "        self::NOT_ACCEPTABLE => 'Not Acceptable',\n"
    "        self::PROXY_AUTHENTICATION_REQUIRED => 'Proxy Authentication Required',\n"
    "        self::REQUEST_TIME_OUT => 'Request Time-out',\n"
    "        self::CONFLICT => 'Conflict',\n"
    "        self::GONE => 'Gone',\n"
    "        self::LENGTH_REQUIRED => 'Length Required',\n"
    "        self::PRECONDITION_FAILED => 'Precondition Failed',\n"
    "        self::REQUEST_ENTITY_TOO_LARGE => 'Request Entity Too Large',\n"
    "        self::REQUEST_URI_TOO_LARGE => 'Request-URI Too Large',\n"
    "        self::UNSUPPORTED_MEDIA_TYPE => 'Unsupported Media Type',\n"
    "        self::REQUESTED_RANGE_NOT_SATISFIABLE => 'Requested range not satisfiable',\n"
    "        self::EXPECTATION_FAILED => 'Expectation Failed',\n"
    "        self::MISDIRECTED_REQUEST => 'Unprocessable Entity',\n"
    "        self::UNPROCESSABLE_ENTITY => 'Unprocessable Entity',\n"
    "        self::LOCKED => 'Locked',\n"
    "        self::FAILED_DEPENDENCY => 'Failed Dependency',\n"
    "        self::UNORDERED_COLLECTION => 'Unordered Collection',\n"
    "        self::UPGRADE_REQUIRED => 'Upgrade Required',\n"
    "        self::PRECONDITION_REQUIRED => 'Precondition Required',\n"
    "        self::TOO_MANY_REQUESTS => 'Too Many Requests',\n"
    "        self::REQUEST_HEADER_FIELDS_TOO_LARGE => 'Request Header Fields Too Large',\n"
    "        self::UNAVAILABLE_FOR_LEGAL_REASONS => 'Unavailable For Legal Reasons',\n"
    "        self::INTERNAL_SERVER_ERROR => 'Internal Server Error',\n"
    "        self::NOT_IMPLEMENTED => 'Not Implemented',\n"
    "        self::BAD_GATEWAY => 'Bad Gateway',\n"
    "        self::SERVICE_UNAVAILABLE => 'Service Unavailable',\n"
    "        self::GATEWAY_TIME_OUT => 'Gateway Time-out',\n"
    "        self::HTTP_VERSION_NOT_SUPPORTED => 'HTTP Version not supported',\n"
    "        self::VARIANT_ALSO_NEGOTIATES => 'Variant Also Negotiates',\n"
    "        self::INSUFFICIENT_STORAGE => 'Insufficient Storage',\n"
    "        self::LOOP_DETECTED => 'Loop Detected',\n"
    "        self::NOT_EXTENDED => 'Not Extended',\n"
    "        self::NETWORK_AUTHENTICATION_REQUIRED => 'Network Authentication Required',\n"
    "    ];\n"
    "\n"
    "    public static function getReasonPhrases(): array\n"
    "    {\n"
    "        return static::$reasonPhrases;\n"
    "    }\n"
    "\n"
    "    public static function getReasonPhrase(int $value): string\n"
    "    {\n"
    "        return static::$reasonPhrases[$value] ?? 'Unknown';\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_curl_exception =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Curl;\n"
    "\n"
    "use Swoole;\n"
    "\n"
    "class Exception extends Swoole\\Exception\n"
    "{\n"
    "}\n";

static const char* swoole_library_source_core_curl_handler =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "/* @noinspection PhpComposerExtensionStubsInspection, PhpDuplicateSwitchCaseBodyInspection, PhpInconsistentReturnPointsInspection */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Curl;\n"
    "\n"
    "use CURLFile;\n"
    "use ReflectionClass;\n"
    "use Swoole;\n"
    "use Swoole\\Constant;\n"
    "use Swoole\\Coroutine\\Http\\Client;\n"
    "use Swoole\\Curl\\Exception as CurlException;\n"
    "use Swoole\\Http\\Status;\n"
    "\n"
    "final class Handler\n"
    "{\n"
    "    /**\n"
    "     * @var Client\n"
    "     */\n"
    "    private $client;\n"
    "\n"
    "    private $info = [\n"
    "        'url' => '',\n"
    "        'content_type' => '',\n"
    "        'http_code' => 0,\n"
    "        'header_size' => 0,\n"
    "        'request_size' => 0,\n"
    "        'filetime' => -1,\n"
    "        'ssl_verify_result' => 0,\n"
    "        'redirect_count' => 0,\n"
    "        'total_time' => 5.3E-5,\n"
    "        'namelookup_time' => 0.0,\n"
    "        'connect_time' => 0.0,\n"
    "        'pretransfer_time' => 0.0,\n"
    "        'size_upload' => 0.0,\n"
    "        'size_download' => 0.0,\n"
    "        'speed_download' => 0.0,\n"
    "        'speed_upload' => 0.0,\n"
    "        'download_content_length' => -1.0,\n"
    "        'upload_content_length' => -1.0,\n"
    "        'starttransfer_time' => 0.0,\n"
    "        'redirect_time' => 0.0,\n"
    "        'redirect_url' => '',\n"
    "        'primary_ip' => '',\n"
    "        'certinfo' => [],\n"
    "        'primary_port' => 0,\n"
    "        'local_ip' => '',\n"
    "        'local_port' => 0,\n"
    "        'http_version' => 0,\n"
    "        'protocol' => 0,\n"
    "        'ssl_verifyresult' => 0,\n"
    "        'scheme' => '',\n"
    "    ];\n"
    "\n"
    "    private $withHeaderOut = false;\n"
    "\n"
    "    private $withFileTime = false;\n"
    "\n"
    "    private $urlInfo;\n"
    "\n"
    "    private $postData;\n"
    "\n"
    "    private $infile;\n"
    "\n"
    "    private $infileSize = PHP_INT_MAX;\n"
    "\n"
    "    private $outputStream;\n"
    "\n"
    "    private $proxyType;\n"
    "\n"
    "    private $proxy;\n"
    "\n"
    "    private $proxyPort = 1080;\n"
    "\n"
    "    private $proxyUsername;\n"
    "\n"
    "    private $proxyPassword;\n"
    "\n"
    "    private $clientOptions = [];\n"
    "\n"
    "    private $followLocation = false;\n"
    "\n"
    "    private $autoReferer = false;\n"
    "\n"
    "    private $maxRedirects;\n"
    "\n"
    "    private $withHeader = false;\n"
    "\n"
    "    private $nobody = false;\n"
    "\n"
    "    /** @var callable */\n"
    "    private $headerFunction;\n"
    "\n"
    "    /** @var callable */\n"
    "    private $readFunction;\n"
    "\n"
    "    /** @var callable */\n"
    "    private $writeFunction;\n"
    "\n"
    "    /** @var callable */\n"
    "    private $progressFunction;\n"
    "\n"
    "    private $returnTransfer = false;\n"
    "\n"
    "    private $method = '';\n"
    "\n"
    "    private $headers = [];\n"
    "\n"
    "    private $transfer;\n"
    "\n"
    "    private $errCode = 0;\n"
    "\n"
    "    private $errMsg = '';\n"
    "\n"
    "    private $failOnError = false;\n"
    "\n"
    "    private $closed = false;\n"
    "\n"
    "    public function __construct(string $url = '')\n"
    "    {\n"
    "        if ($url) {\n"
    "            $this->setUrl($url);\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function __toString()\n"
    "    {\n"
    "        if (PHP_VERSION_ID < 70200) {\n"
    "            $id = spl_object_hash($this);\n"
    "        } else {\n"
    "            $id = spl_object_id($this);\n"
    "        }\n"
    "        return \"Object({$id}) of type (curl)\";\n"
    "    }\n"
    "\n"
    "    /* ====== Public APIs ====== */\n"
    "\n"
    "    public function isAvailable(): bool\n"
    "    {\n"
    "        if ($this->closed) {\n"
    "            trigger_error('supplied resource is not a valid cURL handle resource', E_USER_WARNING);\n"
    "            return false;\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    public function setOpt(int $opt, $value): bool\n"
    "    {\n"
    "        return $this->isAvailable() and $this->setOption($opt, $value);\n"
    "    }\n"
    "\n"
    "    public function exec()\n"
    "    {\n"
    "        if (!$this->isAvailable()) {\n"
    "            return false;\n"
    "        }\n"
    "        return $this->execute();\n"
    "    }\n"
    "\n"
    "    public function getInfo()\n"
    "    {\n"
    "        return $this->isAvailable() ? $this->info : false;\n"
    "    }\n"
    "\n"
    "    public function errno()\n"
    "    {\n"
    "        return $this->isAvailable() ? $this->errCode : false;\n"
    "    }\n"
    "\n"
    "    public function error()\n"
    "    {\n"
    "        return $this->isAvailable() ? $this->errMsg : false;\n"
    "    }\n"
    "\n"
    "    public function reset()\n"
    "    {\n"
    "        if (!$this->isAvailable()) {\n"
    "            return false;\n"
    "        }\n"
    "        foreach ((new ReflectionClass(static::class))->getDefaultProperties() as $name => $value) {\n"
    "            $this->{$name} = $value;\n"
    "        }\n"
    "    }\n"
    "\n"
    "    public function getContent()\n"
    "    {\n"
    "        if (!$this->isAvailable()) {\n"
    "            return false;\n"
    "        }\n"
    "        return $this->transfer;\n"
    "    }\n"
    "\n"
    "    public function close()\n"
    "    {\n"
    "        if (!$this->isAvailable()) {\n"
    "            return false;\n"
    "        }\n"
    "        foreach ($this as &$property) {\n"
    "            $property = null;\n"
    "        }\n"
    "        $this->closed = true;\n"
    "    }\n"
    "\n"
    "    private function create(?array $urlInfo = null): void\n"
    "    {\n"
    "        if ($urlInfo === null) {\n"
    "            $urlInfo = $this->urlInfo;\n"
    "        }\n"
    "        $this->client = new Client($urlInfo['host'], $urlInfo['port'], $urlInfo['scheme'] === 'https');\n"
    "    }\n"
    "\n"
    "    private function getUrl(): string\n"
    "    {\n"
    "        if (empty($this->urlInfo['path'])) {\n"
    "            $url = '/';\n"
    "        } else {\n"
    "            $url = $this->urlInfo['path'];\n"
    "        }\n"
    "        if (!empty($this->urlInfo['query'])) {\n"
    "            $url .= '?' . $this->urlInfo['query'];\n"
    "        }\n"
    "        if (!empty($this->urlInfo['fragment'])) {\n"
    "            $url .= '#' . $this->urlInfo['fragment'];\n"
    "        }\n"
    "        return $url;\n"
    "    }\n"
    "\n"
    "    private function setUrl(string $url, bool $setInfo = true): bool\n"
    "    {\n"
    "        if (strlen($url) === 0) {\n"
    "            $this->setError(CURLE_URL_MALFORMAT, 'No URL set!');\n"
    "            return false;\n"
    "        }\n"
    "        if (strpos($url, '://') === false) {\n"
    "            $url = 'http://' . $url;\n"
    "        }\n"
    "        if ($setInfo) {\n"
    "            $urlInfo = parse_url($url);\n"
    "            if (!is_array($urlInfo)) {\n"
    "                $this->setError(CURLE_URL_MALFORMAT, \"URL[{$url}] using bad/illegal format\");\n"
    "                return false;\n"
    "            }\n"
    "            if (!$this->setUrlInfo($urlInfo)) {\n"
    "                return false;\n"
    "            }\n"
    "        }\n"
    "        $this->info['url'] = $url;\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    private function setUrlInfo(array $urlInfo): bool\n"
    "    {\n"
    "        if (empty($urlInfo['scheme'])) {\n"
    "            $urlInfo['scheme'] = 'http';\n"
    "        }\n"
    "        $scheme = $urlInfo['scheme'];\n"
    "        if ($scheme !== 'http' and $scheme !== 'https') {\n"
    "            $this->setError(CURLE_UNSUPPORTED_PROTOCOL, \"Protocol \\\"{$scheme}\\\" not supported or disabled in libcurl\");\n"
    "            return false;\n"
    "        }\n"
    "        $host = $urlInfo['host'];\n"
    "        if ($this->info['primary_port'] !== 0) {\n"
    "            /* keep same with cURL, primary_port has the highest priority */\n"
    "            $urlInfo['port'] = $this->info['primary_port'];\n"
    "        } elseif (empty($urlInfo['port'])) {\n"
    "            $urlInfo['port'] = $scheme === 'https' ? 443 : 80;\n"
    "        } else {\n"
    "            $urlInfo['port'] = intval($urlInfo['port']);\n"
    "        }\n"
    "        $port = $urlInfo['port'];\n"
    "        if ($this->client) {\n"
    "            $oldUrlInfo = $this->urlInfo;\n"
    "            if (\n"
    "                $host !== $oldUrlInfo['host'] or\n"
    "                $port !== $oldUrlInfo['port'] or\n"
    "                $scheme !== $oldUrlInfo['scheme']\n"
    "            ) {\n"
    "                /* target changed */\n"
    "                $this->create($urlInfo);\n"
    "            }\n"
    "        }\n"
    "        $this->urlInfo = $urlInfo;\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    private function setPort(int $port): void\n"
    "    {\n"
    "        $this->info['primary_port'] = $port;\n"
    "        if ($this->urlInfo['port'] !== $port) {\n"
    "            $this->urlInfo['port'] = $port;\n"
    "            if ($this->client) {\n"
    "                /* target changed */\n"
    "                $this->create();\n"
    "            }\n"
    "        }\n"
    "    }\n"
    "\n"
    "    private function setError($code, $msg = ''): void\n"
    "    {\n"
    "        $this->errCode = $code;\n"
    "        $this->errMsg = $msg ? $msg : curl_strerror($code);\n"
    "    }\n"
    "\n"
    "    /**\n"
    "     * @param mixed $value\n"
    "     * @throws Swoole\\Curl\\Exception\n"
    "     */\n"
    "    private function setOption(int $opt, $value): bool\n"
    "    {\n"
    "        switch ($opt) {\n"
    "            // case CURLOPT_STDERR:\n"
    "            // case CURLOPT_WRITEHEADER:\n"
    "            case CURLOPT_FILE:\n"
    "            case CURLOPT_INFILE:\n"
    "                if (!is_resource($value)) {\n"
    "                    trigger_error(E_USER_WARNING, 'swoole_curl_setopt(): supplied argument is not a valid File-Handle resource');\n"
    "                    return false;\n"
    "                }\n"
    "                break;\n"
    "        }\n"
    "\n"
    "        switch ($opt) {\n"
    "            /*\n"
    "             * Basic\n"
    "             */\n"
    "            case CURLOPT_URL:\n"
    "                return $this->setUrl((string) $value);\n"
    "            case CURLOPT_PORT:\n"
    "                $this->setPort((int) $value);\n"
    "                break;\n"
    "            case CURLOPT_FORBID_REUSE:\n"
    "                $this->clientOptions[Constant::OPTION_KEEP_ALIVE] = !$value;\n"
    "                break;\n"
    "            case CURLOPT_RETURNTRANSFER:\n"
    "                $this->returnTransfer = $value;\n"
    "                $this->transfer = '';\n"
    "                break;\n"
    "            case CURLOPT_ENCODING:\n"
    "                if (empty($value)) {\n"
    "                    if (defined('SWOOLE_HAVE_ZLIB')) {\n"
    "                        $value = 'gzip, deflate';\n"
    "                    }\n"
    "                    if (defined('SWOOLE_HAVE_BROTLI')) {\n"
    "                        if (!empty($value)) {\n"
    "                            $value = 'br, ' . $value;\n"
    "                        } else {\n"
    "                            $value = 'br';\n"
    "                        }\n"
    "                    }\n"
    "                    if (empty($value)) {\n"
    "                        break;\n"
    "                    }\n"
    "                }\n"
    "                $this->headers['Accept-Encoding'] = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXYTYPE:\n"
    "                if ($value !== CURLPROXY_HTTP and $value !== CURLPROXY_SOCKS5) {\n"
    "                    throw new Swoole\\Curl\\Exception(\n"
    "                        'swoole_curl_setopt(): Only support following CURLOPT_PROXYTYPE values: CURLPROXY_HTTP, CURLPROXY_SOCKS5'\n"
    "                    );\n"
    "                }\n"
    "                $this->proxyType = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXY:\n"
    "                $this->proxy = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXYPORT:\n"
    "                $this->proxyPort = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXYUSERNAME:\n"
    "                $this->proxyUsername = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXYPASSWORD:\n"
    "                $this->proxyPassword = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROXYUSERPWD:\n"
    "                $usernamePassword = explode(':', $value);\n"
    "                $this->proxyUsername = urldecode($usernamePassword[0]);\n"
    "                $this->proxyPassword = urldecode($usernamePassword[1] ?? null);\n"
    "                break;\n"
    "            case CURLOPT_PROXYAUTH:\n"
    "                /* ignored temporarily */\n"
    "                break;\n"
    "            case CURLOPT_NOBODY:\n"
    "                $this->nobody = boolval($value);\n"
    "                $this->method = 'HEAD';\n"
    "                break;\n"
    "            case CURLOPT_IPRESOLVE:\n"
    "                if ($value !== CURL_IPRESOLVE_WHATEVER and $value !== CURL_IPRESOLVE_V4) {\n"
    "                    throw new Swoole\\Curl\\Exception(\n"
    "                        'swoole_curl_setopt(): Only support following CURLOPT_IPRESOLVE values: CURL_IPRESOLVE_WHATEVER, CURL_IPRESOLVE_V4'\n"
    "                    );\n"
    "                }\n"
    "                break;\n"
    "            /*\n"
    "             * Ignore options\n"
    "             */\n"
    "            case CURLOPT_VERBOSE:\n"
    "                // trigger_error(E_USER_WARNING, 'swoole_curl_setopt(): CURLOPT_VERBOSE is not supported');\n"
    "            case CURLOPT_SSLVERSION:\n"
    "            case CURLOPT_NOSIGNAL:\n"
    "            case CURLOPT_FRESH_CONNECT:\n"
    "                /*\n"
    "                 * From PHP 5.1.3, this option has no effect: the raw output will always be returned when CURLOPT_RETURNTRANSFER is used.\n"
    "                 */\n"
    "            case CURLOPT_BINARYTRANSFER: /* TODO */\n"
    "            case CURLOPT_DNS_USE_GLOBAL_CACHE:\n"
    "            case CURLOPT_DNS_CACHE_TIMEOUT:\n"
    "            case CURLOPT_STDERR:\n"
    "            case CURLOPT_WRITEHEADER:\n"
    "            case CURLOPT_BUFFERSIZE:\n"
    "            case CURLOPT_SSLCERTTYPE:\n"
    "            case CURLOPT_SSLKEYTYPE:\n"
    "                break;\n"
    "            /*\n"
    "             * SSL\n"
    "             */\n"
    "            case CURLOPT_SSL_VERIFYHOST:\n"
    "                break;\n"
    "            case CURLOPT_SSL_VERIFYPEER:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_VERIFY_PEER] = $value;\n"
    "                break;\n"
    "            case CURLOPT_SSLCERT:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_CERT_FILE] = $value;\n"
    "                break;\n"
    "            case CURLOPT_SSLKEY:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_KEY_FILE] = $value;\n"
    "                break;\n"
    "            case CURLOPT_CAINFO:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_CAFILE] = $value;\n"
    "                break;\n"
    "            case CURLOPT_CAPATH:\n"
    "                $this->clientOptions[Constant::OPTION_SSL_CAPATH] = $value;\n"
    "                break;\n"
    "            /*\n"
    "             * Http POST\n"
    "             */\n"
    "            case CURLOPT_POST:\n"
    "                $this->method = 'POST';\n"
    "                break;\n"
    "            case CURLOPT_POSTFIELDS:\n"
    "                $this->postData = $value;\n"
    "                if (!$this->method) {\n"
    "                    $this->method = 'POST';\n"
    "                }\n"
    "                break;\n"
    "            /*\n"
    "             * Upload\n"
    "             */\n"
    "            case CURLOPT_SAFE_UPLOAD:\n"
    "                if (!$value) {\n"
    "                    trigger_error('swoole_curl_setopt(): Disabling safe uploads is no longer supported', E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                break;\n"
    "            /*\n"
    "             * Http Header\n"
    "             */\n"
    "            case CURLOPT_HTTPHEADER:\n"
    "                if (!is_array($value) and !is_iterable($value)) {\n"
    "                    trigger_error('swoole_curl_setopt(): You must pass either an object or an array with the CURLOPT_HTTPHEADER argument', E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                foreach ($value as $header) {\n"
    "                    $header = explode(':', $header, 2);\n"
    "                    $headerName = $header[0];\n"
    "                    $headerValue = trim($header[1] ?? '');\n"
    "                    if (strlen($headerValue) === 0) {\n"
    "                        continue;\n"
    "                    }\n"
    "                    $this->headers[$headerName] = $headerValue;\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_REFERER:\n"
    "                $this->headers['Referer'] = $value;\n"
    "                break;\n"
    "            case CURLINFO_HEADER_OUT:\n"
    "                $this->withHeaderOut = boolval($value);\n"
    "                break;\n"
    "            case CURLOPT_FILETIME:\n"
    "                $this->withFileTime = boolval($value);\n"
    "                break;\n"
    "            case CURLOPT_USERAGENT:\n"
    "                $this->headers['User-Agent'] = $value;\n"
    "                break;\n"
    "            case CURLOPT_CUSTOMREQUEST:\n"
    "                $this->method = (string) $value;\n"
    "                break;\n"
    "            case CURLOPT_PROTOCOLS:\n"
    "                if (($value & ~(CURLPROTO_HTTP | CURLPROTO_HTTPS)) != 0) {\n"
    "                    throw new CurlException(\"swoole_curl_setopt(): CURLOPT_PROTOCOLS[{$value}] is not supported\");\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_REDIR_PROTOCOLS:\n"
    "                if (($value & ~(CURLPROTO_HTTP | CURLPROTO_HTTPS)) != 0) {\n"
    "                    throw new CurlException(\"swoole_curl_setopt(): CURLOPT_REDIR_PROTOCOLS[{$value}] is not supported\");\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_HTTP_VERSION:\n"
    "                if ($value != CURL_HTTP_VERSION_1_1) {\n"
    "                    trigger_error(\"swoole_curl_setopt(): CURLOPT_HTTP_VERSION[{$value}] is not supported\", E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_FAILONERROR:\n"
    "                $this->failOnError = $value;\n"
    "                break;\n"
    "            /*\n"
    "             * Http Cookie\n"
    "             */\n"
    "            case CURLOPT_COOKIE:\n"
    "                $this->headers['Cookie'] = $value;\n"
    "                break;\n"
    "            case CURLOPT_CONNECTTIMEOUT:\n"
    "                $this->clientOptions[Constant::OPTION_CONNECT_TIMEOUT] = $value;\n"
    "                break;\n"
    "            case CURLOPT_CONNECTTIMEOUT_MS:\n"
    "                $this->clientOptions[Constant::OPTION_CONNECT_TIMEOUT] = $value / 1000;\n"
    "                break;\n"
    "            case CURLOPT_TIMEOUT:\n"
    "                $this->clientOptions[Constant::OPTION_TIMEOUT] = $value;\n"
    "                break;\n"
    "            case CURLOPT_TIMEOUT_MS:\n"
    "                $this->clientOptions[Constant::OPTION_TIMEOUT] = $value / 1000;\n"
    "                break;\n"
    "            case CURLOPT_FILE:\n"
    "                $this->outputStream = $value;\n"
    "                break;\n"
    "            case CURLOPT_HEADER:\n"
    "                $this->withHeader = $value;\n"
    "                break;\n"
    "            case CURLOPT_HEADERFUNCTION:\n"
    "                $this->headerFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_READFUNCTION:\n"
    "                $this->readFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_WRITEFUNCTION:\n"
    "                $this->writeFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_PROGRESSFUNCTION:\n"
    "                $this->progressFunction = $value;\n"
    "                break;\n"
    "            case CURLOPT_HTTPAUTH:\n"
    "                if (!($value & CURLAUTH_BASIC)) {\n"
    "                    trigger_error(\"swoole_curl_setopt(): CURLOPT_HTTPAUTH[{$value}] is not supported\", E_USER_WARNING);\n"
    "                    return false;\n"
    "                }\n"
    "                break;\n"
    "            case CURLOPT_USERPWD:\n"
    "                $this->headers['Authorization'] = 'Basic ' . base64_encode($value);\n"
    "                break;\n"
    "            case CURLOPT_FOLLOWLOCATION:\n"
    "                $this->followLocation = $value;\n"
    "                break;\n"
    "            case CURLOPT_AUTOREFERER:\n"
    "                $this->autoReferer = $value;\n"
    "                break;\n"
    "            case CURLOPT_MAXREDIRS:\n"
    "                $this->maxRedirects = $value;\n"
    "                break;\n"
    "            case CURLOPT_PUT:\n"
    "            case CURLOPT_UPLOAD:\n"
    "                /* after libcurl 7.12, CURLOPT_PUT is replaced by CURLOPT_UPLOAD */\n"
    "                $this->method = 'PUT';\n"
    "                break;\n"
    "            case CURLOPT_INFILE:\n"
    "                $this->infile = $value;\n"
    "                break;\n"
    "            case CURLOPT_INFILESIZE:\n"
    "                $this->infileSize = $value;\n"
    "                break;\n"
    "            case CURLOPT_HTTPGET:\n"
    "                /* Since GET is the default, this is only necessary if the request method has been changed. */\n"
    "                $this->method = 'GET';\n"
    "                break;\n"
    "            default:\n"
    "                throw new Swoole\\Curl\\Exception(\"swoole_curl_setopt(): option[{$opt}] is not supported\");\n"
    "        }\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    private function execute()\n"
    "    {\n"
    "        $this->info['redirect_count'] = $this->info['starttransfer_time'] = 0;\n"
    "        $this->info['redirect_url'] = '';\n"
    "        $timeBegin = microtime(true);\n"
    "        /*\n"
    "         * Socket\n"
    "         */\n"
    "        if (!$this->urlInfo) {\n"
    "            $this->setError(CURLE_URL_MALFORMAT, 'No URL set or URL using bad/illegal format');\n"
    "            return false;\n"
    "        }\n"
    "        if (!$this->client) {\n"
    "            $this->create();\n"
    "        }\n"
    "        do {\n"
    "            $client = $this->client;\n"
    "            /*\n"
    "             * Http Proxy\n"
    "             */\n"
    "            if ($this->proxy) {\n"
    "                $proxy = explode(':', $this->proxy);\n"
    "                $proxyPort = $proxy[1] ?? $this->proxyPort;\n"
    "                $proxy = $proxy[0];\n"
    "                if (!filter_var($proxy, FILTER_VALIDATE_IP)) {\n"
    "                    $ip = Swoole\\Coroutine::gethostbyname($proxy, AF_INET, $this->clientOptions['connect_timeout'] ?? -1);\n"
    "                    if (!$ip) {\n"
    "                        $this->setError(CURLE_COULDNT_RESOLVE_PROXY, 'Could not resolve proxy: ' . $proxy);\n"
    "                        return false;\n"
    "                    }\n"
    "                    $this->proxy = $proxy = $ip;\n"
    "                }\n"
    "                switch ($this->proxyType) {\n"
    "                    case CURLPROXY_HTTP:\n"
    "                        $proxyOptions = [\n"
    "                            'http_proxy_host' => $proxy,\n"
    "                            'http_proxy_port' => $proxyPort,\n"
    "                            'http_proxy_username' => $this->proxyUsername,\n"
    "                            'http_proxy_password' => $this->proxyPassword,\n"
    "                        ];\n"
    "                        break;\n"
    "                    case CURLPROXY_SOCKS5:\n"
    "                        $proxyOptions = [\n"
    "                            'socks5_host' => $proxy,\n"
    "                            'socks5_port' => $proxyPort,\n"
    "                            'socks5_username' => $this->proxyUsername,\n"
    "                            'socks5_password' => $this->proxyPassword,\n"
    "                        ];\n"
    "                        break;\n"
    "                    default:\n"
    "                        throw new CurlException(\"Unexpected proxy type [{$this->proxyType}]\");\n"
    "                }\n"
    "            }\n"
    "            /*\n"
    "             * Client Options\n"
    "             */\n"
    "            $client->set(\n"
    "                $this->clientOptions +\n"
    "                ($proxyOptions ?? [])\n"
    "            );\n"
    "            /*\n"
    "             * Method\n"
    "             */\n"
    "            if ($this->method) {\n"
    "                $client->setMethod($this->method);\n"
    "            }\n"
    "            /*\n"
    "             * Data\n"
    "             */\n"
    "            if ($this->infile) {\n"
    "                // Infile\n"
    "                // Notice: we make its priority higher than postData but raw cURL will send both of them\n"
    "                $data = '';\n"
    "                while (true) {\n"
    "                    $nLength = $this->infileSize - strlen($data);\n"
    "                    if ($nLength === 0) {\n"
    "                        break;\n"
    "                    }\n"
    "                    if (feof($this->infile)) {\n"
    "                        break;\n"
    "                    }\n"
    "                    $data .= fread($this->infile, $nLength);\n"
    "                }\n"
    "                $client->setData($data);\n"
    "                // Notice: although we reset it, raw cURL never do this\n"
    "                $this->infile = null;\n"
    "                $this->infileSize = PHP_INT_MAX;\n"
    "            } else {\n"
    "                // POST data\n"
    "                if ($this->postData) {\n"
    "                    if (is_string($this->postData)) {\n"
    "                        if (empty($this->headers['Content-Type'])) {\n"
    "                            $this->headers['Content-Type'] = 'application/x-www-form-urlencoded';\n"
    "                        }\n"
    "                    } elseif (is_array($this->postData)) {\n"
    "                        foreach ($this->postData as $k => $v) {\n"
    "                            if ($v instanceof CURLFile) {\n"
    "                                $client->addFile($v->getFilename(), $k, $v->getMimeType() ?: 'application/octet-stream', $v->getPostFilename());\n"
    "                                unset($this->postData[$k]);\n"
    "                            }\n"
    "                        }\n"
    "                    }\n"
    "                }\n"
    "                $client->setData($this->postData);\n"
    "            }\n"
    "            /*\n"
    "             * Headers\n"
    "             */\n"
    "            // Notice: setHeaders must be placed last, because headers may be changed by other parts\n"
    "            // As much as possible to ensure that Host is the first header.\n"
    "            // See: http://tools.ietf.org/html/rfc7230#section-5.4\n"
    "            foreach ($this->headers as $headerName => $headerValue) {\n"
    "                if ($headerValue === '') {\n"
    "                    // remove empty headers (keep same with raw cURL)\n"
    "                    unset($this->headers[$headerName]);\n"
    "                }\n"
    "            }\n"
    "            $client->setHeaders($this->headers);\n"
    "            /**\n"
    "             * Execute.\n"
    "             */\n"
    "            $executeResult = $client->execute($this->getUrl());\n"
    "            if (!$executeResult) {\n"
    "                $errCode = $client->errCode;\n"
    "                if ($errCode == SWOOLE_ERROR_DNSLOOKUP_RESOLVE_FAILED or $errCode == SWOOLE_ERROR_DNSLOOKUP_RESOLVE_TIMEOUT) {\n"
    "                    $this->setError(CURLE_COULDNT_RESOLVE_HOST, 'Could not resolve host: ' . $client->host);\n"
    "                } else {\n"
    "                    $this->setError($errCode, $client->errMsg);\n"
    "                }\n"
    "                $this->info['total_time'] = microtime(true) - $timeBegin;\n"
    "                return false;\n"
    "            }\n"
    "            if ($client->statusCode >= 300 and $client->statusCode < 400 and isset($client->headers['location'])) {\n"
    "                $redirectParsedUrl = $this->getRedirectUrl($client->headers['location']);\n"
    "                $redirectUrl = static::unparseUrl($redirectParsedUrl);\n"
    "                if ($this->followLocation and ($this->maxRedirects === null or $this->info['redirect_count'] < $this->maxRedirects)) {\n"
    "                    if ($this->info['redirect_count'] === 0) {\n"
    "                        $this->info['starttransfer_time'] = microtime(true) - $timeBegin;\n"
    "                        $redirectBeginTime = microtime(true);\n"
    "                    }\n"
    "                    // force GET\n"
    "                    if (in_array($client->statusCode, [Status::MOVED_PERMANENTLY, Status::FOUND, Status::SEE_OTHER])) {\n"
    "                        $this->method = 'GET';\n"
    "                    }\n"
    "                    if ($this->autoReferer) {\n"
    "                        $this->headers['Referer'] = $this->info['url'];\n"
    "                    }\n"
    "                    $this->setUrl($redirectUrl, false);\n"
    "                    $this->setUrlInfo($redirectParsedUrl);\n"
    "                    $this->info['redirect_count']++;\n"
    "                } else {\n"
    "                    $this->info['redirect_url'] = $redirectUrl;\n"
    "                    break;\n"
    "                }\n"
    "            } elseif ($this->failOnError && $client->statusCode >= 400) {\n"
    "                $this->setError(CURLE_HTTP_RETURNED_ERROR, \"The requested URL returned error: {$client->statusCode} \" . Status::getReasonPhrase($client->statusCode));\n"
    "                return false;\n"
    "            } else {\n"
    "                break;\n"
    "            }\n"
    "        } while (true);\n"
    "        $this->info['total_time'] = microtime(true) - $timeBegin;\n"
    "        $this->info['http_code'] = $client->statusCode;\n"
    "        $this->info['content_type'] = $client->headers['content-type'] ?? '';\n"
    "        $this->info['size_download'] = $this->info['download_content_length'] = strlen($client->body);\n"
    "        $this->info['speed_download'] = 1 / $this->info['total_time'] * $this->info['size_download'];\n"
    "        if (isset($redirectBeginTime)) {\n"
    "            $this->info['redirect_time'] = microtime(true) - $redirectBeginTime;\n"
    "        }\n"
    "\n"
    "        $headerContent = '';\n"
    "        if ($client->headers) {\n"
    "            $cb = $this->headerFunction;\n"
    "            if ($client->statusCode > 0) {\n"
    "                $row = \"HTTP/1.1 {$client->statusCode} \" . Status::getReasonPhrase($client->statusCode) . \"\\r\\n\";\n"
    "                if ($cb) {\n"
    "                    $cb($this, $row);\n"
    "                }\n"
    "                $headerContent .= $row;\n"
    "            }\n"
    "            foreach ($client->headers as $k => $v) {\n"
    "                $row = \"{$k}: {$v}\\r\\n\";\n"
    "                if ($cb) {\n"
    "                    $cb($this, $row);\n"
    "                }\n"
    "                $headerContent .= $row;\n"
    "            }\n"
    "            $headerContent .= \"\\r\\n\";\n"
    "            $this->info['header_size'] = strlen($headerContent);\n"
    "            if ($cb) {\n"
    "                $cb($this, '');\n"
    "            }\n"
    "        } else {\n"
    "            $this->info['header_size'] = 0;\n"
    "        }\n"
    "\n"
    "        if ($client->body and $this->readFunction) {\n"
    "            $cb = $this->readFunction;\n"
    "            $cb($this, $this->outputStream, strlen($client->body));\n"
    "        }\n"
    "\n"
    "        if ($this->withHeader) {\n"
    "            $transfer = $headerContent . $client->body;\n"
    "        } else {\n"
    "            $transfer = $client->body;\n"
    "        }\n"
    "\n"
    "        if ($this->withHeaderOut) {\n"
    "            $headerOutContent = $client->getHeaderOut();\n"
    "            $this->info['request_header'] = $headerOutContent ? $headerOutContent . \"\\r\\n\\r\\n\" : '';\n"
    "        }\n"
    "        if ($this->withFileTime) {\n"
    "            if (isset($client->headers['last-modified'])) {\n"
    "                $this->info['filetime'] = strtotime($client->headers['last-modified']);\n"
    "            } else {\n"
    "                $this->info['filetime'] = -1;\n"
    "            }\n"
    "        }\n"
    "\n"
    "        if ($this->returnTransfer) {\n"
    "            return $this->transfer = $transfer;\n"
    "        }\n"
    "        if ($this->outputStream) {\n"
    "            return fwrite($this->outputStream, $transfer) === strlen($transfer);\n"
    "        }\n"
    "        echo $transfer;\n"
    "\n"
    "        return true;\n"
    "    }\n"
    "\n"
    "    /* ====== Redirect helper ====== */\n"
    "\n"
    "    private static function unparseUrl(array $parsedUrl): string\n"
    "    {\n"
    "        $scheme = ($parsedUrl['scheme'] ?? 'http') . '://';\n"
    "        $host = $parsedUrl['host'] ?? '';\n"
    "        $port = isset($parsedUrl['port']) ? ':' . $parsedUrl['port'] : '';\n"
    "        $user = $parsedUrl['user'] ?? '';\n"
    "        $pass = isset($parsedUrl['pass']) ? ':' . $parsedUrl['pass'] : '';\n"
    "        $pass = ($user or $pass) ? \"{$pass}@\" : '';\n"
    "        $path = $parsedUrl['path'] ?? '';\n"
    "        $query = (isset($parsedUrl['query']) and $parsedUrl['query'] !== '') ? '?' . $parsedUrl['query'] : '';\n"
    "        $fragment = isset($parsedUrl['fragment']) ? '#' . $parsedUrl['fragment'] : '';\n"
    "        return $scheme . $user . $pass . $host . $port . $path . $query . $fragment;\n"
    "    }\n"
    "\n"
    "    private function getRedirectUrl(string $location): array\n"
    "    {\n"
    "        $uri = parse_url($location);\n"
    "        if (isset($uri['host'])) {\n"
    "            $redirectUri = $uri;\n"
    "        } else {\n"
    "            if (!isset($location[0])) {\n"
    "                return [];\n"
    "            }\n"
    "            $redirectUri = $this->urlInfo;\n"
    "            $redirectUri['query'] = '';\n"
    "            if ($location[0] === '/') {\n"
    "                $redirectUri['path'] = $location;\n"
    "            } else {\n"
    "                $path = dirname($redirectUri['path'] ?? '');\n"
    "                if ($path === '.') {\n"
    "                    $path = '/';\n"
    "                }\n"
    "                if (isset($location[1]) and substr($location, 0, 2) === './') {\n"
    "                    $location = substr($location, 2);\n"
    "                }\n"
    "                $redirectUri['path'] = $path . $location;\n"
    "            }\n"
    "            foreach ($uri as $k => $v) {\n"
    "                if (!in_array($k, ['path', 'query'])) {\n"
    "                    $redirectUri[$k] = $v;\n"
    "                }\n"
    "            }\n"
    "        }\n"
    "        return $redirectUri;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_core_coroutine_functions =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine;\n"
    "\n"
    "use Swoole\\Coroutine;\n"
    "\n"
    "function batch(array $tasks, float $timeout = -1): array\n"
    "{\n"
    "    $wg = new WaitGroup();\n"
    "    $wg->add(count($tasks));\n"
    "    foreach ($tasks as $id => $task) {\n"
    "        Coroutine::create(function () use ($wg, &$tasks, $id, $task) {\n"
    "            $tasks[$id] = null;\n"
    "            $tasks[$id] = $task();\n"
    "            $wg->done();\n"
    "        });\n"
    "    }\n"
    "    $wg->wait($timeout);\n"
    "    return $tasks;\n"
    "}\n"
    "\n"
    "function parallel(int $n, callable $fn): void\n"
    "{\n"
    "    $count = $n;\n"
    "    $wg = new WaitGroup();\n"
    "    $wg->add($n);\n"
    "    while ($count--) {\n"
    "        Coroutine::create(function () use ($fn, $wg) {\n"
    "            $fn();\n"
    "            $wg->done();\n"
    "        });\n"
    "    }\n"
    "    $wg->wait();\n"
    "}\n";

static const char* swoole_library_source_ext_curl =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "/* @noinspection PhpComposerExtensionStubsInspection */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "function swoole_curl_init(string $url = ''): Swoole\\Curl\\Handler\n"
    "{\n"
    "    return new Swoole\\Curl\\Handler($url);\n"
    "}\n"
    "\n"
    "function swoole_curl_setopt(Swoole\\Curl\\Handler $obj, int $opt, $value): bool\n"
    "{\n"
    "    return $obj->setOpt($opt, $value);\n"
    "}\n"
    "\n"
    "function swoole_curl_setopt_array(Swoole\\Curl\\Handler $obj, $array): bool\n"
    "{\n"
    "    foreach ($array as $k => $v) {\n"
    "        if ($obj->setOpt($k, $v) !== true) {\n"
    "            return false;\n"
    "        }\n"
    "    }\n"
    "    return true;\n"
    "}\n"
    "\n"
    "function swoole_curl_exec(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->exec();\n"
    "}\n"
    "\n"
    "function swoole_curl_getinfo(Swoole\\Curl\\Handler $obj, int $opt = 0)\n"
    "{\n"
    "    $info = $obj->getInfo();\n"
    "    if (is_array($info) and $opt) {\n"
    "        switch ($opt) {\n"
    "            case CURLINFO_EFFECTIVE_URL:\n"
    "                return $info['url'];\n"
    "            case CURLINFO_HTTP_CODE:\n"
    "                return $info['http_code'];\n"
    "            case CURLINFO_CONTENT_TYPE:\n"
    "                return $info['content_type'];\n"
    "            case CURLINFO_REDIRECT_COUNT:\n"
    "                return $info['redirect_count'];\n"
    "            case CURLINFO_REDIRECT_URL:\n"
    "                return $info['redirect_url'];\n"
    "            case CURLINFO_TOTAL_TIME:\n"
    "                return $info['total_time'];\n"
    "            case CURLINFO_STARTTRANSFER_TIME:\n"
    "                return $info['starttransfer_time'];\n"
    "            case CURLINFO_SIZE_DOWNLOAD:\n"
    "                return $info['size_download'];\n"
    "            case CURLINFO_SPEED_DOWNLOAD:\n"
    "                return $info['speed_download'];\n"
    "            case CURLINFO_REDIRECT_TIME:\n"
    "                return $info['redirect_time'];\n"
    "            case CURLINFO_HEADER_SIZE:\n"
    "                return $info['header_size'];\n"
    "            default:\n"
    "                return null;\n"
    "        }\n"
    "    }\n"
    "    return $info;\n"
    "}\n"
    "\n"
    "function swoole_curl_errno(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->errno();\n"
    "}\n"
    "\n"
    "function swoole_curl_error(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->error();\n"
    "}\n"
    "\n"
    "function swoole_curl_reset(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->reset();\n"
    "}\n"
    "\n"
    "function swoole_curl_close(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->close();\n"
    "}\n"
    "\n"
    "function swoole_curl_multi_getcontent(Swoole\\Curl\\Handler $obj)\n"
    "{\n"
    "    return $obj->getContent();\n"
    "}\n";

static const char* swoole_library_source_functions =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "if (SWOOLE_USE_SHORTNAME) {\n"
    "    function _string(string $string = ''): Swoole\\StringObject\n"
    "    {\n"
    "        return new Swoole\\StringObject($string);\n"
    "    }\n"
    "\n"
    "    function _mbstring(string $string = ''): Swoole\\MultibyteStringObject\n"
    "    {\n"
    "        return new Swoole\\MultibyteStringObject($string);\n"
    "    }\n"
    "\n"
    "    function _array(array $array = []): Swoole\\ArrayObject\n"
    "    {\n"
    "        return new Swoole\\ArrayObject($array);\n"
    "    }\n"
    "}\n"
    "\n"
    "function swoole_string(string $string = ''): Swoole\\StringObject\n"
    "{\n"
    "    return new Swoole\\StringObject($string);\n"
    "}\n"
    "\n"
    "function swoole_mbstring(string $string = ''): Swoole\\MultibyteStringObject\n"
    "{\n"
    "    return new Swoole\\MultibyteStringObject($string);\n"
    "}\n"
    "\n"
    "function swoole_array(array $array = []): Swoole\\ArrayObject\n"
    "{\n"
    "    return new Swoole\\ArrayObject($array);\n"
    "}\n"
    "\n"
    "function swoole_array_list(...$arrray): Swoole\\ArrayObject\n"
    "{\n"
    "    return new Swoole\\ArrayObject($arrray);\n"
    "}\n"
    "\n"
    "function swoole_array_default_value(array $array, $key, $default_value = null)\n"
    "{\n"
    "    return array_key_exists($key, $array) ? $array[$key] : $default_value;\n"
    "}\n"
    "\n"
    "if (!function_exists('array_key_last')) {\n"
    "    function array_key_last(array $array)\n"
    "    {\n"
    "        if (!empty($array)) {\n"
    "            return key(array_slice($array, -1, 1, true));\n"
    "        }\n"
    "        return null;\n"
    "    }\n"
    "}\n"
    "\n"
    "if (!function_exists('array_key_first')) {\n"
    "    function array_key_first(array $array)\n"
    "    {\n"
    "        foreach ($array as $key => $unused) {\n"
    "            return $key;\n"
    "        }\n"
    "        return null;\n"
    "    }\n"
    "}\n";

static const char* swoole_library_source_alias =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "if (SWOOLE_USE_SHORTNAME) {\n"
    "    class_alias(Swoole\\Coroutine\\WaitGroup::class, Co\\WaitGroup::class, true);\n"
    "    class_alias(Swoole\\Coroutine\\Server::class, Co\\Server::class, true);\n"
    "    class_alias(Swoole\\Coroutine\\Server\\Connection::class, Co\\Server\\Connection::class, true);\n"
    "}\n";

static const char* swoole_library_source_alias_ns =
    "\n"
    "/**\n"
    " * This file is part of Swoole.\n"
    " *\n"
    " * @link     https://www.swoole.com\n"
    " * @contact  team@swoole.com\n"
    " * @license  https://github.com/swoole/library/blob/master/LICENSE\n"
    " */\n"
    "\n"
    "declare(strict_types=1);\n"
    "\n"
    "namespace Swoole\\Coroutine {\n"
    "    function run(callable $fn, ...$args)\n"
    "    {\n"
    "        $s = new Scheduler();\n"
    "        $s->add($fn, ...$args);\n"
    "        return $s->start();\n"
    "    }\n"
    "}\n"
    "\n"
    "namespace Co {\n"
    "    if (SWOOLE_USE_SHORTNAME) {\n"
    "        function run(callable $fn, ...$args)\n"
    "        {\n"
    "            return \\Swoole\\Coroutine\\Run($fn, ...$args);\n"
    "        }\n"
    "    }\n"
    "}\n";

static void php_swoole_load_library()
{
    zend::eval(swoole_library_source_constants, "@swoole-src/library/constants.php");
    zend::eval(swoole_library_source_std_exec, "@swoole-src/library/std/exec.php");
    zend::eval(swoole_library_source_core_constant, "@swoole-src/library/core/Constant.php");
    zend::eval(swoole_library_source_core_exception_array_key_not_exists, "@swoole-src/library/core/Exception/ArrayKeyNotExists.php");
    zend::eval(swoole_library_source_core_string_object, "@swoole-src/library/core/StringObject.php");
    zend::eval(swoole_library_source_core_multibyte_string_object, "@swoole-src/library/core/MultibyteStringObject.php");
    zend::eval(swoole_library_source_core_array_object, "@swoole-src/library/core/ArrayObject.php");
    zend::eval(swoole_library_source_core_object_proxy, "@swoole-src/library/core/ObjectProxy.php");
    zend::eval(swoole_library_source_core_coroutine_wait_group, "@swoole-src/library/core/Coroutine/WaitGroup.php");
    zend::eval(swoole_library_source_core_coroutine_server, "@swoole-src/library/core/Coroutine/Server.php");
    zend::eval(swoole_library_source_core_coroutine_server_connection, "@swoole-src/library/core/Coroutine/Server/Connection.php");
    zend::eval(swoole_library_source_core_connection_pool, "@swoole-src/library/core/ConnectionPool.php");
    zend::eval(swoole_library_source_core_database_object_proxy, "@swoole-src/library/core/Database/ObjectProxy.php");
    zend::eval(swoole_library_source_core_database_mysqli_config, "@swoole-src/library/core/Database/MysqliConfig.php");
    zend::eval(swoole_library_source_core_database_mysqli_exception, "@swoole-src/library/core/Database/MysqliException.php");
    zend::eval(swoole_library_source_core_database_mysqli_pool, "@swoole-src/library/core/Database/MysqliPool.php");
    zend::eval(swoole_library_source_core_database_mysqli_proxy, "@swoole-src/library/core/Database/MysqliProxy.php");
    zend::eval(swoole_library_source_core_database_mysqli_statement_proxy, "@swoole-src/library/core/Database/MysqliStatementProxy.php");
    zend::eval(swoole_library_source_core_database_pdo_config, "@swoole-src/library/core/Database/PDOConfig.php");
    zend::eval(swoole_library_source_core_database_pdo_pool, "@swoole-src/library/core/Database/PDOPool.php");
    zend::eval(swoole_library_source_core_database_pdo_proxy, "@swoole-src/library/core/Database/PDOProxy.php");
    zend::eval(swoole_library_source_core_database_pdo_statement_proxy, "@swoole-src/library/core/Database/PDOStatementProxy.php");
    zend::eval(swoole_library_source_core_database_redis_config, "@swoole-src/library/core/Database/RedisConfig.php");
    zend::eval(swoole_library_source_core_database_redis_pool, "@swoole-src/library/core/Database/RedisPool.php");
    zend::eval(swoole_library_source_core_http_status, "@swoole-src/library/core/Http/Status.php");
    zend::eval(swoole_library_source_core_curl_exception, "@swoole-src/library/core/Curl/Exception.php");
    zend::eval(swoole_library_source_core_curl_handler, "@swoole-src/library/core/Curl/Handler.php");
    zend::eval(swoole_library_source_core_coroutine_functions, "@swoole-src/library/core/Coroutine/functions.php");
    zend::eval(swoole_library_source_ext_curl, "@swoole-src/library/ext/curl.php");
    zend::eval(swoole_library_source_functions, "@swoole-src/library/functions.php");
    zend::eval(swoole_library_source_alias, "@swoole-src/library/alias.php");
    zend::eval(swoole_library_source_alias_ns, "@swoole-src/library/alias_ns.php");
}
