const { app } = require('electron');
const http = require('http');
const v8 = require('v8');

app.whenReady().then(() => {
  const server = http.createServer((req, res) => {
    const chunks = [];
    req.on('data', chunk => { chunks.push(chunk); });
    req.on('end', () => {
      const js = Buffer.concat(chunks).toString('utf8');
      (async () => {
        try {
          const result = await Promise.resolve(eval(js)); // eslint-disable-line no-eval
          res.end(v8.serialize({ result }));
        } catch (e) {
          res.end(v8.serialize({ error: e.stack }));
        }
      })();
    });
  }).listen(0, '127.0.0.1', () => {
    process.stdout.write(`Listening: ${server.address().port}\n`);
  });
});

setTimeout(() => {
  process.exit(0);
}, 30000);
