/******************************************************************************
 * Copyright (C) 2014-2020 Zhifeng Gong <gozfree@163.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 ******************************************************************************/
#ifndef LIBHASH_H
#define LIBHASH_H

#include <stdio.h>
#include <stdint.h>

#define LIBHASH_VERSION "0.1.1"

#ifdef __cplusplus
extern "C" {
#endif

struct hash {
    int bucket;
    void *opaque_list;
    void (*destory)(void *val);
};

struct hash *hash_create(int bucket);
void hash_destroy(struct hash *h);
void hash_set_destory(struct hash *h, void (*destory)(void *val));

uint32_t hash_gen32(const char *key, size_t len);
void *hash_get(struct hash *h, const char *key);
void *hash_get32(struct hash *h, uint32_t key);
int hash_set(struct hash *h, const char *key, void *val);
int hash_set32(struct hash *h, uint32_t key, void *val);
int hash_del(struct hash *h, const char *key);
int hash_del32(struct hash *h, uint32_t key);
void *hash_get_and_del(struct hash *h, const char *key);
void *hash_get_and_del32(struct hash *h, uint32_t key);

#ifdef __cplusplus
}
#endif
#endif
