package icon

import (
	"html/template"

	"github.com/GoAdminGroup/html"
)

func Icon(class string, num ...int) template.HTML {
	space := template.HTML("")
	if len(num) > 0 {
		for i := 0; i < num[0]; i++ {
			space += "&nbsp;"
		}
	}
	return html.IEl().SetClass("icon fa", class).Get() + space
}

func IconWithStyle(class string, style html.Style, num ...int) template.HTML {
	space := template.HTML("")
	if len(num) > 0 {
		for i := 0; i < num[0]; i++ {
			space += "&nbsp;"
		}
	}

	i := html.IEl().SetClass("icon fa", class)
	for k, s := range style {
		i.SetStyle(k, s)
	}

	return i.Get() + space
}

const (
	Adjust                           = "fa-adjust"                              // https://fontawesome.com/icons/adjust
	Adn                              = "fa-adn"                                 // https://fontawesome.com/icons/adn
	AlignCenter                      = "fa-align-center"                        // https://fontawesome.com/icons/align-center
	AlignJustify                     = "fa-align-justify"                       // https://fontawesome.com/icons/align-justify
	AlignLeft                        = "fa-align-left"                          // https://fontawesome.com/icons/align-left
	AlignRight                       = "fa-align-right"                         // https://fontawesome.com/icons/align-right
	Amazon                           = "fa-amazon"                              // https://fontawesome.com/icons/amazon
	Ambulance                        = "fa-ambulance"                           // https://fontawesome.com/icons/ambulance
	AmericanSignLanguageInterpreting = "fa-american-sign-language-interpreting" // https://fontawesome.com/icons/american-sign-language-interpreting
	Anchor                           = "fa-anchor"                              // https://fontawesome.com/icons/anchor
	Android                          = "fa-android"                             // https://fontawesome.com/icons/android
	Angellist                        = "fa-angellist"                           // https://fontawesome.com/icons/angellist
	AngleDoubleDown                  = "fa-angle-double-down"                   // https://fontawesome.com/icons/angle-double-down
	AngleDoubleLeft                  = "fa-angle-double-left"                   // https://fontawesome.com/icons/angle-double-left
	AngleDoubleRight                 = "fa-angle-double-right"                  // https://fontawesome.com/icons/angle-double-right
	AngleDoubleUp                    = "fa-angle-double-up"                     // https://fontawesome.com/icons/angle-double-up
	AngleDown                        = "fa-angle-down"                          // https://fontawesome.com/icons/angle-down
	AngleLeft                        = "fa-angle-left"                          // https://fontawesome.com/icons/angle-left
	AngleRight                       = "fa-angle-right"                         // https://fontawesome.com/icons/angle-right
	AngleUp                          = "fa-angle-up"                            // https://fontawesome.com/icons/angle-up
	Apple                            = "fa-apple"                               // https://fontawesome.com/icons/apple
	Archive                          = "fa-archive"                             // https://fontawesome.com/icons/archive
	AreaChart                        = "fa-area-chart"                          // https://fontawesome.com/icons/area-chart
	ArrowCircleDown                  = "fa-arrow-circle-down"                   // https://fontawesome.com/icons/arrow-circle-down
	ArrowCircleLeft                  = "fa-arrow-circle-left"                   // https://fontawesome.com/icons/arrow-circle-left
	ArrowCircleODown                 = "fa-arrow-circle-o-down"                 // https://fontawesome.com/icons/arrow-circle-o-down
	ArrowCircleOLeft                 = "fa-arrow-circle-o-left"                 // https://fontawesome.com/icons/arrow-circle-o-left
	ArrowCircleORight                = "fa-arrow-circle-o-right"                // https://fontawesome.com/icons/arrow-circle-o-right
	ArrowCircleOUp                   = "fa-arrow-circle-o-up"                   // https://fontawesome.com/icons/arrow-circle-o-up
	ArrowCircleRight                 = "fa-arrow-circle-right"                  // https://fontawesome.com/icons/arrow-circle-right
	ArrowCircleUp                    = "fa-arrow-circle-up"                     // https://fontawesome.com/icons/arrow-circle-up
	ArrowDown                        = "fa-arrow-down"                          // https://fontawesome.com/icons/arrow-down
	ArrowLeft                        = "fa-arrow-left"                          // https://fontawesome.com/icons/arrow-left
	ArrowRight                       = "fa-arrow-right"                         // https://fontawesome.com/icons/arrow-right
	ArrowUp                          = "fa-arrow-up"                            // https://fontawesome.com/icons/arrow-up
	Arrows                           = "fa-arrows"                              // https://fontawesome.com/icons/arrows
	ArrowsAlt                        = "fa-arrows-alt"                          // https://fontawesome.com/icons/arrows-alt
	ArrowsH                          = "fa-arrows-h"                            // https://fontawesome.com/icons/arrows-h
	ArrowsV                          = "fa-arrows-v"                            // https://fontawesome.com/icons/arrows-v
	AslInterpreting                  = "fa-asl-interpreting"                    // https://fontawesome.com/icons/asl-interpreting
	AssistiveListeningSystems        = "fa-assistive-listening-systems"         // https://fontawesome.com/icons/assistive-listening-systems
	Asterisk                         = "fa-asterisk"                            // https://fontawesome.com/icons/asterisk
	At                               = "fa-at"                                  // https://fontawesome.com/icons/at
	AudioDescription                 = "fa-audio-description"                   // https://fontawesome.com/icons/audio-description
	Automobile                       = "fa-automobile"                          // https://fontawesome.com/icons/automobile
	Backward                         = "fa-backward"                            // https://fontawesome.com/icons/backward
	BalanceScale                     = "fa-balance-scale"                       // https://fontawesome.com/icons/balance-scale
	Ban                              = "fa-ban"                                 // https://fontawesome.com/icons/ban
	Bank                             = "fa-bank"                                // https://fontawesome.com/icons/bank
	BarChart                         = "fa-bar-chart"                           // https://fontawesome.com/icons/bar-chart
	BarChartO                        = "fa-bar-chart-o"                         // https://fontawesome.com/icons/bar-chart-o
	Barcode                          = "fa-barcode"                             // https://fontawesome.com/icons/barcode
	Bars                             = "fa-bars"                                // https://fontawesome.com/icons/bars
	Battery0                         = "fa-battery-0"                           // https://fontawesome.com/icons/battery-0
	Battery1                         = "fa-battery-1"                           // https://fontawesome.com/icons/battery-1
	Battery2                         = "fa-battery-2"                           // https://fontawesome.com/icons/battery-2
	Battery3                         = "fa-battery-3"                           // https://fontawesome.com/icons/battery-3
	Battery4                         = "fa-battery-4"                           // https://fontawesome.com/icons/battery-4
	BatteryEmpty                     = "fa-battery-empty"                       // https://fontawesome.com/icons/battery-empty
	BatteryFull                      = "fa-battery-full"                        // https://fontawesome.com/icons/battery-full
	BatteryHalf                      = "fa-battery-half"                        // https://fontawesome.com/icons/battery-half
	BatteryQuarter                   = "fa-battery-quarter"                     // https://fontawesome.com/icons/battery-quarter
	BatteryThreeQuarters             = "fa-battery-three-quarters"              // https://fontawesome.com/icons/battery-three-quarters
	Bed                              = "fa-bed"                                 // https://fontawesome.com/icons/bed
	Beer                             = "fa-beer"                                // https://fontawesome.com/icons/beer
	Behance                          = "fa-behance"                             // https://fontawesome.com/icons/behance
	BehanceSquare                    = "fa-behance-square"                      // https://fontawesome.com/icons/behance-square
	Bell                             = "fa-bell"                                // https://fontawesome.com/icons/bell
	BellO                            = "fa-bell-o"                              // https://fontawesome.com/icons/bell-o
	BellSlash                        = "fa-bell-slash"                          // https://fontawesome.com/icons/bell-slash
	BellSlashO                       = "fa-bell-slash-o"                        // https://fontawesome.com/icons/bell-slash-o
	Bicycle                          = "fa-bicycle"                             // https://fontawesome.com/icons/bicycle
	Binoculars                       = "fa-binoculars"                          // https://fontawesome.com/icons/binoculars
	BirthdayCake                     = "fa-birthday-cake"                       // https://fontawesome.com/icons/birthday-cake
	Bitbucket                        = "fa-bitbucket"                           // https://fontawesome.com/icons/bitbucket
	BitbucketSquare                  = "fa-bitbucket-square"                    // https://fontawesome.com/icons/bitbucket-square
	Bitcoin                          = "fa-bitcoin"                             // https://fontawesome.com/icons/bitcoin
	BlackTie                         = "fa-black-tie"                           // https://fontawesome.com/icons/black-tie
	Blind                            = "fa-blind"                               // https://fontawesome.com/icons/blind
	Bluetooth                        = "fa-bluetooth"                           // https://fontawesome.com/icons/bluetooth
	BluetoothB                       = "fa-bluetooth-b"                         // https://fontawesome.com/icons/bluetooth-b
	Bold                             = "fa-bold"                                // https://fontawesome.com/icons/bold
	Bolt                             = "fa-bolt"                                // https://fontawesome.com/icons/bolt
	Bomb                             = "fa-bomb"                                // https://fontawesome.com/icons/bomb
	Book                             = "fa-book"                                // https://fontawesome.com/icons/book
	Bookmark                         = "fa-bookmark"                            // https://fontawesome.com/icons/bookmark
	BookmarkO                        = "fa-bookmark-o"                          // https://fontawesome.com/icons/bookmark-o
	Braille                          = "fa-braille"                             // https://fontawesome.com/icons/braille
	Briefcase                        = "fa-briefcase"                           // https://fontawesome.com/icons/briefcase
	Btc                              = "fa-btc"                                 // https://fontawesome.com/icons/btc
	Bug                              = "fa-bug"                                 // https://fontawesome.com/icons/bug
	Building                         = "fa-building"                            // https://fontawesome.com/icons/building
	BuildingO                        = "fa-building-o"                          // https://fontawesome.com/icons/building-o
	Bullhorn                         = "fa-bullhorn"                            // https://fontawesome.com/icons/bullhorn
	Bullseye                         = "fa-bullseye"                            // https://fontawesome.com/icons/bullseye
	Bus                              = "fa-bus"                                 // https://fontawesome.com/icons/bus
	Buysellads                       = "fa-buysellads"                          // https://fontawesome.com/icons/buysellads
	Cab                              = "fa-cab"                                 // https://fontawesome.com/icons/cab
	Calculator                       = "fa-calculator"                          // https://fontawesome.com/icons/calculator
	Calendar                         = "fa-calendar"                            // https://fontawesome.com/icons/calendar
	CalendarCheckO                   = "fa-calendar-check-o"                    // https://fontawesome.com/icons/calendar-check-o
	CalendarMinusO                   = "fa-calendar-minus-o"                    // https://fontawesome.com/icons/calendar-minus-o
	CalendarO                        = "fa-calendar-o"                          // https://fontawesome.com/icons/calendar-o
	CalendarPlusO                    = "fa-calendar-plus-o"                     // https://fontawesome.com/icons/calendar-plus-o
	CalendarTimesO                   = "fa-calendar-times-o"                    // https://fontawesome.com/icons/calendar-times-o
	Camera                           = "fa-camera"                              // https://fontawesome.com/icons/camera
	CameraRetro                      = "fa-camera-retro"                        // https://fontawesome.com/icons/camera-retro
	Car                              = "fa-car"                                 // https://fontawesome.com/icons/car
	CaretDown                        = "fa-caret-down"                          // https://fontawesome.com/icons/caret-down
	CaretLeft                        = "fa-caret-left"                          // https://fontawesome.com/icons/caret-left
	CaretRight                       = "fa-caret-right"                         // https://fontawesome.com/icons/caret-right
	CaretSquareODown                 = "fa-caret-square-o-down"                 // https://fontawesome.com/icons/caret-square-o-down
	CaretSquareOLeft                 = "fa-caret-square-o-left"                 // https://fontawesome.com/icons/caret-square-o-left
	CaretSquareORight                = "fa-caret-square-o-right"                // https://fontawesome.com/icons/caret-square-o-right
	CaretSquareOUp                   = "fa-caret-square-o-up"                   // https://fontawesome.com/icons/caret-square-o-up
	CaretUp                          = "fa-caret-up"                            // https://fontawesome.com/icons/caret-up
	CartArrowDown                    = "fa-cart-arrow-down"                     // https://fontawesome.com/icons/cart-arrow-down
	CartPlus                         = "fa-cart-plus"                           // https://fontawesome.com/icons/cart-plus
	Cc                               = "fa-cc"                                  // https://fontawesome.com/icons/cc
	CcAmex                           = "fa-cc-amex"                             // https://fontawesome.com/icons/cc-amex
	CcDinersClub                     = "fa-cc-diners-club"                      // https://fontawesome.com/icons/cc-diners-club
	CcDiscover                       = "fa-cc-discover"                         // https://fontawesome.com/icons/cc-discover
	CcJcb                            = "fa-cc-jcb"                              // https://fontawesome.com/icons/cc-jcb
	CcMastercard                     = "fa-cc-mastercard"                       // https://fontawesome.com/icons/cc-mastercard
	CcPaypal                         = "fa-cc-paypal"                           // https://fontawesome.com/icons/cc-paypal
	CcStripe                         = "fa-cc-stripe"                           // https://fontawesome.com/icons/cc-stripe
	CcVisa                           = "fa-cc-visa"                             // https://fontawesome.com/icons/cc-visa
	Certificate                      = "fa-certificate"                         // https://fontawesome.com/icons/certificate
	Chain                            = "fa-chain"                               // https://fontawesome.com/icons/chain
	ChainBroken                      = "fa-chain-broken"                        // https://fontawesome.com/icons/chain-broken
	Check                            = "fa-check"                               // https://fontawesome.com/icons/check
	CheckCircle                      = "fa-check-circle"                        // https://fontawesome.com/icons/check-circle
	CheckCircleO                     = "fa-check-circle-o"                      // https://fontawesome.com/icons/check-circle-o
	CheckSquare                      = "fa-check-square"                        // https://fontawesome.com/icons/check-square
	CheckSquareO                     = "fa-check-square-o"                      // https://fontawesome.com/icons/check-square-o
	ChevronCircleDown                = "fa-chevron-circle-down"                 // https://fontawesome.com/icons/chevron-circle-down
	ChevronCircleLeft                = "fa-chevron-circle-left"                 // https://fontawesome.com/icons/chevron-circle-left
	ChevronCircleRight               = "fa-chevron-circle-right"                // https://fontawesome.com/icons/chevron-circle-right
	ChevronCircleUp                  = "fa-chevron-circle-up"                   // https://fontawesome.com/icons/chevron-circle-up
	ChevronDown                      = "fa-chevron-down"                        // https://fontawesome.com/icons/chevron-down
	ChevronLeft                      = "fa-chevron-left"                        // https://fontawesome.com/icons/chevron-left
	ChevronRight                     = "fa-chevron-right"                       // https://fontawesome.com/icons/chevron-right
	ChevronUp                        = "fa-chevron-up"                          // https://fontawesome.com/icons/chevron-up
	Child                            = "fa-child"                               // https://fontawesome.com/icons/child
	Chrome                           = "fa-chrome"                              // https://fontawesome.com/icons/chrome
	Circle                           = "fa-circle"                              // https://fontawesome.com/icons/circle
	CircleO                          = "fa-circle-o"                            // https://fontawesome.com/icons/circle-o
	CircleONotch                     = "fa-circle-o-notch"                      // https://fontawesome.com/icons/circle-o-notch
	CircleThin                       = "fa-circle-thin"                         // https://fontawesome.com/icons/circle-thin
	Clipboard                        = "fa-clipboard"                           // https://fontawesome.com/icons/clipboard
	ClockO                           = "fa-clock-o"                             // https://fontawesome.com/icons/clock-o
	Clone                            = "fa-clone"                               // https://fontawesome.com/icons/clone
	Close                            = "fa-close"                               // https://fontawesome.com/icons/close
	Cloud                            = "fa-cloud"                               // https://fontawesome.com/icons/cloud
	CloudDownload                    = "fa-cloud-download"                      // https://fontawesome.com/icons/cloud-download
	CloudUpload                      = "fa-cloud-upload"                        // https://fontawesome.com/icons/cloud-upload
	Cny                              = "fa-cny"                                 // https://fontawesome.com/icons/cny
	Code                             = "fa-code"                                // https://fontawesome.com/icons/code
	CodeFork                         = "fa-code-fork"                           // https://fontawesome.com/icons/code-fork
	Codepen                          = "fa-codepen"                             // https://fontawesome.com/icons/codepen
	Codiepie                         = "fa-codiepie"                            // https://fontawesome.com/icons/codiepie
	Coffee                           = "fa-coffee"                              // https://fontawesome.com/icons/coffee
	Cog                              = "fa-cog"                                 // https://fontawesome.com/icons/cog
	Cogs                             = "fa-cogs"                                // https://fontawesome.com/icons/cogs
	Columns                          = "fa-columns"                             // https://fontawesome.com/icons/columns
	Comment                          = "fa-comment"                             // https://fontawesome.com/icons/comment
	CommentO                         = "fa-comment-o"                           // https://fontawesome.com/icons/comment-o
	Commenting                       = "fa-commenting"                          // https://fontawesome.com/icons/commenting
	CommentingO                      = "fa-commenting-o"                        // https://fontawesome.com/icons/commenting-o
	Comments                         = "fa-comments"                            // https://fontawesome.com/icons/comments
	CommentsO                        = "fa-comments-o"                          // https://fontawesome.com/icons/comments-o
	Compass                          = "fa-compass"                             // https://fontawesome.com/icons/compass
	Compress                         = "fa-compress"                            // https://fontawesome.com/icons/compress
	Connectdevelop                   = "fa-connectdevelop"                      // https://fontawesome.com/icons/connectdevelop
	Contao                           = "fa-contao"                              // https://fontawesome.com/icons/contao
	Copy                             = "fa-copy"                                // https://fontawesome.com/icons/copy
	Copyright                        = "fa-copyright"                           // https://fontawesome.com/icons/copyright
	CreativeCommons                  = "fa-creative-commons"                    // https://fontawesome.com/icons/creative-commons
	CreditCard                       = "fa-credit-card"                         // https://fontawesome.com/icons/credit-card
	CreditCardAlt                    = "fa-credit-card-alt"                     // https://fontawesome.com/icons/credit-card-alt
	Crop                             = "fa-crop"                                // https://fontawesome.com/icons/crop
	Crosshairs                       = "fa-crosshairs"                          // https://fontawesome.com/icons/crosshairs
	Css3                             = "fa-css3"                                // https://fontawesome.com/icons/css3
	Cube                             = "fa-cube"                                // https://fontawesome.com/icons/cube
	Cubes                            = "fa-cubes"                               // https://fontawesome.com/icons/cubes
	Cut                              = "fa-cut"                                 // https://fontawesome.com/icons/cut
	Cutlery                          = "fa-cutlery"                             // https://fontawesome.com/icons/cutlery
	Dashboard                        = "fa-dashboard"                           // https://fontawesome.com/icons/dashboard
	Dashcube                         = "fa-dashcube"                            // https://fontawesome.com/icons/dashcube
	Database                         = "fa-database"                            // https://fontawesome.com/icons/database
	Deaf                             = "fa-deaf"                                // https://fontawesome.com/icons/deaf
	Deafness                         = "fa-deafness"                            // https://fontawesome.com/icons/deafness
	Dedent                           = "fa-dedent"                              // https://fontawesome.com/icons/dedent
	Delicious                        = "fa-delicious"                           // https://fontawesome.com/icons/delicious
	Desktop                          = "fa-desktop"                             // https://fontawesome.com/icons/desktop
	Deviantart                       = "fa-deviantart"                          // https://fontawesome.com/icons/deviantart
	Diamond                          = "fa-diamond"                             // https://fontawesome.com/icons/diamond
	Digg                             = "fa-digg"                                // https://fontawesome.com/icons/digg
	Dollar                           = "fa-dollar"                              // https://fontawesome.com/icons/dollar
	DotCircleO                       = "fa-dot-circle-o"                        // https://fontawesome.com/icons/dot-circle-o
	Download                         = "fa-download"                            // https://fontawesome.com/icons/download
	Dribbble                         = "fa-dribbble"                            // https://fontawesome.com/icons/dribbble
	Dropbox                          = "fa-dropbox"                             // https://fontawesome.com/icons/dropbox
	Drupal                           = "fa-drupal"                              // https://fontawesome.com/icons/drupal
	Edge                             = "fa-edge"                                // https://fontawesome.com/icons/edge
	Edit                             = "fa-edit"                                // https://fontawesome.com/icons/edit
	Eject                            = "fa-eject"                               // https://fontawesome.com/icons/eject
	EllipsisH                        = "fa-ellipsis-h"                          // https://fontawesome.com/icons/ellipsis-h
	EllipsisV                        = "fa-ellipsis-v"                          // https://fontawesome.com/icons/ellipsis-v
	Empire                           = "fa-empire"                              // https://fontawesome.com/icons/empire
	Envelope                         = "fa-envelope"                            // https://fontawesome.com/icons/envelope
	EnvelopeO                        = "fa-envelope-o"                          // https://fontawesome.com/icons/envelope-o
	EnvelopeSquare                   = "fa-envelope-square"                     // https://fontawesome.com/icons/envelope-square
	Envira                           = "fa-envira"                              // https://fontawesome.com/icons/envira
	Eraser                           = "fa-eraser"                              // https://fontawesome.com/icons/eraser
	Eur                              = "fa-eur"                                 // https://fontawesome.com/icons/eur
	Euro                             = "fa-euro"                                // https://fontawesome.com/icons/euro
	Exchange                         = "fa-exchange"                            // https://fontawesome.com/icons/exchange
	Exclamation                      = "fa-exclamation"                         // https://fontawesome.com/icons/exclamation
	ExclamationCircle                = "fa-exclamation-circle"                  // https://fontawesome.com/icons/exclamation-circle
	ExclamationTriangle              = "fa-exclamation-triangle"                // https://fontawesome.com/icons/exclamation-triangle
	Expand                           = "fa-expand"                              // https://fontawesome.com/icons/expand
	Expeditedssl                     = "fa-expeditedssl"                        // https://fontawesome.com/icons/expeditedssl
	ExternalLink                     = "fa-external-link"                       // https://fontawesome.com/icons/external-link
	ExternalLinkSquare               = "fa-external-link-square"                // https://fontawesome.com/icons/external-link-square
	Eye                              = "fa-eye"                                 // https://fontawesome.com/icons/eye
	EyeSlash                         = "fa-eye-slash"                           // https://fontawesome.com/icons/eye-slash
	Eyedropper                       = "fa-eyedropper"                          // https://fontawesome.com/icons/eyedropper
	Fa                               = "fa-fa"                                  // https://fontawesome.com/icons/fa
	Facebook                         = "fa-facebook"                            // https://fontawesome.com/icons/facebook
	FacebookF                        = "fa-facebook-f"                          // https://fontawesome.com/icons/facebook-f
	FacebookOfficial                 = "fa-facebook-official"                   // https://fontawesome.com/icons/facebook-official
	FacebookSquare                   = "fa-facebook-square"                     // https://fontawesome.com/icons/facebook-square
	FastBackward                     = "fa-fast-backward"                       // https://fontawesome.com/icons/fast-backward
	FastForward                      = "fa-fast-forward"                        // https://fontawesome.com/icons/fast-forward
	Fax                              = "fa-fax"                                 // https://fontawesome.com/icons/fax
	Feed                             = "fa-feed"                                // https://fontawesome.com/icons/feed
	Female                           = "fa-female"                              // https://fontawesome.com/icons/female
	FighterJet                       = "fa-fighter-jet"                         // https://fontawesome.com/icons/fighter-jet
	File                             = "fa-file"                                // https://fontawesome.com/icons/file
	FileArchiveO                     = "fa-file-archive-o"                      // https://fontawesome.com/icons/file-archive-o
	FileAudioO                       = "fa-file-audio-o"                        // https://fontawesome.com/icons/file-audio-o
	FileCodeO                        = "fa-file-code-o"                         // https://fontawesome.com/icons/file-code-o
	FileExcelO                       = "fa-file-excel-o"                        // https://fontawesome.com/icons/file-excel-o
	FileImageO                       = "fa-file-image-o"                        // https://fontawesome.com/icons/file-image-o
	FileMovieO                       = "fa-file-movie-o"                        // https://fontawesome.com/icons/file-movie-o
	FileO                            = "fa-file-o"                              // https://fontawesome.com/icons/file-o
	FilePdfO                         = "fa-file-pdf-o"                          // https://fontawesome.com/icons/file-pdf-o
	FilePhotoO                       = "fa-file-photo-o"                        // https://fontawesome.com/icons/file-photo-o
	FilePictureO                     = "fa-file-picture-o"                      // https://fontawesome.com/icons/file-picture-o
	FilePowerpointO                  = "fa-file-powerpoint-o"                   // https://fontawesome.com/icons/file-powerpoint-o
	FileSoundO                       = "fa-file-sound-o"                        // https://fontawesome.com/icons/file-sound-o
	FileText                         = "fa-file-text"                           // https://fontawesome.com/icons/file-text
	FileTextO                        = "fa-file-text-o"                         // https://fontawesome.com/icons/file-text-o
	FileVideoO                       = "fa-file-video-o"                        // https://fontawesome.com/icons/file-video-o
	FileWordO                        = "fa-file-word-o"                         // https://fontawesome.com/icons/file-word-o
	FileZipO                         = "fa-file-zip-o"                          // https://fontawesome.com/icons/file-zip-o
	FilesO                           = "fa-files-o"                             // https://fontawesome.com/icons/files-o
	Film                             = "fa-film"                                // https://fontawesome.com/icons/film
	Filter                           = "fa-filter"                              // https://fontawesome.com/icons/filter
	Fire                             = "fa-fire"                                // https://fontawesome.com/icons/fire
	FireExtinguisher                 = "fa-fire-extinguisher"                   // https://fontawesome.com/icons/fire-extinguisher
	Firefox                          = "fa-firefox"                             // https://fontawesome.com/icons/firefox
	FirstOrder                       = "fa-first-order"                         // https://fontawesome.com/icons/first-order
	Flag                             = "fa-flag"                                // https://fontawesome.com/icons/flag
	FlagCheckered                    = "fa-flag-checkered"                      // https://fontawesome.com/icons/flag-checkered
	FlagO                            = "fa-flag-o"                              // https://fontawesome.com/icons/flag-o
	Flash                            = "fa-flash"                               // https://fontawesome.com/icons/flash
	Flask                            = "fa-flask"                               // https://fontawesome.com/icons/flask
	Flickr                           = "fa-flickr"                              // https://fontawesome.com/icons/flickr
	FloppyO                          = "fa-floppy-o"                            // https://fontawesome.com/icons/floppy-o
	Folder                           = "fa-folder"                              // https://fontawesome.com/icons/folder
	FolderO                          = "fa-folder-o"                            // https://fontawesome.com/icons/folder-o
	FolderOpen                       = "fa-folder-open"                         // https://fontawesome.com/icons/folder-open
	FolderOpenO                      = "fa-folder-open-o"                       // https://fontawesome.com/icons/folder-open-o
	Font                             = "fa-font"                                // https://fontawesome.com/icons/font
	FontAwesome                      = "fa-font-awesome"                        // https://fontawesome.com/icons/font-awesome
	Fonticons                        = "fa-fonticons"                           // https://fontawesome.com/icons/fonticons
	FortAwesome                      = "fa-fort-awesome"                        // https://fontawesome.com/icons/fort-awesome
	Forumbee                         = "fa-forumbee"                            // https://fontawesome.com/icons/forumbee
	Forward                          = "fa-forward"                             // https://fontawesome.com/icons/forward
	Foursquare                       = "fa-foursquare"                          // https://fontawesome.com/icons/foursquare
	FrownO                           = "fa-frown-o"                             // https://fontawesome.com/icons/frown-o
	FutbolO                          = "fa-futbol-o"                            // https://fontawesome.com/icons/futbol-o
	Gamepad                          = "fa-gamepad"                             // https://fontawesome.com/icons/gamepad
	Gavel                            = "fa-gavel"                               // https://fontawesome.com/icons/gavel
	Gbp                              = "fa-gbp"                                 // https://fontawesome.com/icons/gbp
	Ge                               = "fa-ge"                                  // https://fontawesome.com/icons/ge
	Gear                             = "fa-gear"                                // https://fontawesome.com/icons/gear
	Gears                            = "fa-gears"                               // https://fontawesome.com/icons/gears
	Genderless                       = "fa-genderless"                          // https://fontawesome.com/icons/genderless
	GetPocket                        = "fa-get-pocket"                          // https://fontawesome.com/icons/get-pocket
	Gg                               = "fa-gg"                                  // https://fontawesome.com/icons/gg
	GgCircle                         = "fa-gg-circle"                           // https://fontawesome.com/icons/gg-circle
	Gift                             = "fa-gift"                                // https://fontawesome.com/icons/gift
	Git                              = "fa-git"                                 // https://fontawesome.com/icons/git
	GitSquare                        = "fa-git-square"                          // https://fontawesome.com/icons/git-square
	Github                           = "fa-github"                              // https://fontawesome.com/icons/github
	GithubAlt                        = "fa-github-alt"                          // https://fontawesome.com/icons/github-alt
	GithubSquare                     = "fa-github-square"                       // https://fontawesome.com/icons/github-square
	Gitlab                           = "fa-gitlab"                              // https://fontawesome.com/icons/gitlab
	Gittip                           = "fa-gittip"                              // https://fontawesome.com/icons/gittip
	Glass                            = "fa-glass"                               // https://fontawesome.com/icons/glass
	Glide                            = "fa-glide"                               // https://fontawesome.com/icons/glide
	GlideG                           = "fa-glide-g"                             // https://fontawesome.com/icons/glide-g
	Globe                            = "fa-globe"                               // https://fontawesome.com/icons/globe
	Google                           = "fa-google"                              // https://fontawesome.com/icons/google
	GooglePlus                       = "fa-google-plus"                         // https://fontawesome.com/icons/google-plus
	GooglePlusCircle                 = "fa-google-plus-circle"                  // https://fontawesome.com/icons/google-plus-circle
	GooglePlusOfficial               = "fa-google-plus-official"                // https://fontawesome.com/icons/google-plus-official
	GooglePlusSquare                 = "fa-google-plus-square"                  // https://fontawesome.com/icons/google-plus-square
	GoogleWallet                     = "fa-google-wallet"                       // https://fontawesome.com/icons/google-wallet
	GraduationCap                    = "fa-graduation-cap"                      // https://fontawesome.com/icons/graduation-cap
	Gratipay                         = "fa-gratipay"                            // https://fontawesome.com/icons/gratipay
	Group                            = "fa-group"                               // https://fontawesome.com/icons/group
	HSquare                          = "fa-h-square"                            // https://fontawesome.com/icons/h-square
	HackerNews                       = "fa-hacker-news"                         // https://fontawesome.com/icons/hacker-news
	HandGrabO                        = "fa-hand-grab-o"                         // https://fontawesome.com/icons/hand-grab-o
	HandLizardO                      = "fa-hand-lizard-o"                       // https://fontawesome.com/icons/hand-lizard-o
	HandODown                        = "fa-hand-o-down"                         // https://fontawesome.com/icons/hand-o-down
	HandOLeft                        = "fa-hand-o-left"                         // https://fontawesome.com/icons/hand-o-left
	HandORight                       = "fa-hand-o-right"                        // https://fontawesome.com/icons/hand-o-right
	HandOUp                          = "fa-hand-o-up"                           // https://fontawesome.com/icons/hand-o-up
	HandPaperO                       = "fa-hand-paper-o"                        // https://fontawesome.com/icons/hand-paper-o
	HandPeaceO                       = "fa-hand-peace-o"                        // https://fontawesome.com/icons/hand-peace-o
	HandPointerO                     = "fa-hand-pointer-o"                      // https://fontawesome.com/icons/hand-pointer-o
	HandRockO                        = "fa-hand-rock-o"                         // https://fontawesome.com/icons/hand-rock-o
	HandScissorsO                    = "fa-hand-scissors-o"                     // https://fontawesome.com/icons/hand-scissors-o
	HandSpockO                       = "fa-hand-spock-o"                        // https://fontawesome.com/icons/hand-spock-o
	HandStopO                        = "fa-hand-stop-o"                         // https://fontawesome.com/icons/hand-stop-o
	HardOfHearing                    = "fa-hard-of-hearing"                     // https://fontawesome.com/icons/hard-of-hearing
	Hashtag                          = "fa-hashtag"                             // https://fontawesome.com/icons/hashtag
	HddO                             = "fa-hdd-o"                               // https://fontawesome.com/icons/hdd-o
	Header                           = "fa-header"                              // https://fontawesome.com/icons/header
	Headphones                       = "fa-headphones"                          // https://fontawesome.com/icons/headphones
	Heart                            = "fa-heart"                               // https://fontawesome.com/icons/heart
	HeartO                           = "fa-heart-o"                             // https://fontawesome.com/icons/heart-o
	Heartbeat                        = "fa-heartbeat"                           // https://fontawesome.com/icons/heartbeat
	History                          = "fa-history"                             // https://fontawesome.com/icons/history
	Home                             = "fa-home"                                // https://fontawesome.com/icons/home
	HospitalO                        = "fa-hospital-o"                          // https://fontawesome.com/icons/hospital-o
	Hotel                            = "fa-hotel"                               // https://fontawesome.com/icons/hotel
	Hourglass                        = "fa-hourglass"                           // https://fontawesome.com/icons/hourglass
	Hourglass1                       = "fa-hourglass-1"                         // https://fontawesome.com/icons/hourglass-1
	Hourglass2                       = "fa-hourglass-2"                         // https://fontawesome.com/icons/hourglass-2
	Hourglass3                       = "fa-hourglass-3"                         // https://fontawesome.com/icons/hourglass-3
	HourglassEnd                     = "fa-hourglass-end"                       // https://fontawesome.com/icons/hourglass-end
	HourglassHalf                    = "fa-hourglass-half"                      // https://fontawesome.com/icons/hourglass-half
	HourglassO                       = "fa-hourglass-o"                         // https://fontawesome.com/icons/hourglass-o
	HourglassStart                   = "fa-hourglass-start"                     // https://fontawesome.com/icons/hourglass-start
	Houzz                            = "fa-houzz"                               // https://fontawesome.com/icons/houzz
	Html5                            = "fa-html5"                               // https://fontawesome.com/icons/html5
	ICursor                          = "fa-i-cursor"                            // https://fontawesome.com/icons/i-cursor
	Ils                              = "fa-ils"                                 // https://fontawesome.com/icons/ils
	Image                            = "fa-image"                               // https://fontawesome.com/icons/image
	Inbox                            = "fa-inbox"                               // https://fontawesome.com/icons/inbox
	Indent                           = "fa-indent"                              // https://fontawesome.com/icons/indent
	Industry                         = "fa-industry"                            // https://fontawesome.com/icons/industry
	Info                             = "fa-info"                                // https://fontawesome.com/icons/info
	InfoCircle                       = "fa-info-circle"                         // https://fontawesome.com/icons/info-circle
	Inr                              = "fa-inr"                                 // https://fontawesome.com/icons/inr
	Instagram                        = "fa-instagram"                           // https://fontawesome.com/icons/instagram
	Institution                      = "fa-institution"                         // https://fontawesome.com/icons/institution
	InternetExplorer                 = "fa-internet-explorer"                   // https://fontawesome.com/icons/internet-explorer
	Intersex                         = "fa-intersex"                            // https://fontawesome.com/icons/intersex
	Ioxhost                          = "fa-ioxhost"                             // https://fontawesome.com/icons/ioxhost
	Italic                           = "fa-italic"                              // https://fontawesome.com/icons/italic
	Joomla                           = "fa-joomla"                              // https://fontawesome.com/icons/joomla
	Jpy                              = "fa-jpy"                                 // https://fontawesome.com/icons/jpy
	Jsfiddle                         = "fa-jsfiddle"                            // https://fontawesome.com/icons/jsfiddle
	Key                              = "fa-key"                                 // https://fontawesome.com/icons/key
	KeyboardO                        = "fa-keyboard-o"                          // https://fontawesome.com/icons/keyboard-o
	Krw                              = "fa-krw"                                 // https://fontawesome.com/icons/krw
	Language                         = "fa-language"                            // https://fontawesome.com/icons/language
	Laptop                           = "fa-laptop"                              // https://fontawesome.com/icons/laptop
	Lastfm                           = "fa-lastfm"                              // https://fontawesome.com/icons/lastfm
	LastfmSquare                     = "fa-lastfm-square"                       // https://fontawesome.com/icons/lastfm-square
	Leaf                             = "fa-leaf"                                // https://fontawesome.com/icons/leaf
	Leanpub                          = "fa-leanpub"                             // https://fontawesome.com/icons/leanpub
	Legal                            = "fa-legal"                               // https://fontawesome.com/icons/legal
	LemonO                           = "fa-lemon-o"                             // https://fontawesome.com/icons/lemon-o
	LevelDown                        = "fa-level-down"                          // https://fontawesome.com/icons/level-down
	LevelUp                          = "fa-level-up"                            // https://fontawesome.com/icons/level-up
	LifeBouy                         = "fa-life-bouy"                           // https://fontawesome.com/icons/life-bouy
	LifeBuoy                         = "fa-life-buoy"                           // https://fontawesome.com/icons/life-buoy
	LifeRing                         = "fa-life-ring"                           // https://fontawesome.com/icons/life-ring
	LifeSaver                        = "fa-life-saver"                          // https://fontawesome.com/icons/life-saver
	LightbulbO                       = "fa-lightbulb-o"                         // https://fontawesome.com/icons/lightbulb-o
	LineChart                        = "fa-line-chart"                          // https://fontawesome.com/icons/line-chart
	Link                             = "fa-link"                                // https://fontawesome.com/icons/link
	Linkedin                         = "fa-linkedin"                            // https://fontawesome.com/icons/linkedin
	LinkedinSquare                   = "fa-linkedin-square"                     // https://fontawesome.com/icons/linkedin-square
	Linux                            = "fa-linux"                               // https://fontawesome.com/icons/linux
	List                             = "fa-list"                                // https://fontawesome.com/icons/list
	ListAlt                          = "fa-list-alt"                            // https://fontawesome.com/icons/list-alt
	ListOl                           = "fa-list-ol"                             // https://fontawesome.com/icons/list-ol
	ListUl                           = "fa-list-ul"                             // https://fontawesome.com/icons/list-ul
	LocationArrow                    = "fa-location-arrow"                      // https://fontawesome.com/icons/location-arrow
	Lock                             = "fa-lock"                                // https://fontawesome.com/icons/lock
	LongArrowDown                    = "fa-long-arrow-down"                     // https://fontawesome.com/icons/long-arrow-down
	LongArrowLeft                    = "fa-long-arrow-left"                     // https://fontawesome.com/icons/long-arrow-left
	LongArrowRight                   = "fa-long-arrow-right"                    // https://fontawesome.com/icons/long-arrow-right
	LongArrowUp                      = "fa-long-arrow-up"                       // https://fontawesome.com/icons/long-arrow-up
	LowVision                        = "fa-low-vision"                          // https://fontawesome.com/icons/low-vision
	Magic                            = "fa-magic"                               // https://fontawesome.com/icons/magic
	Magnet                           = "fa-magnet"                              // https://fontawesome.com/icons/magnet
	MailForward                      = "fa-mail-forward"                        // https://fontawesome.com/icons/mail-forward
	MailReply                        = "fa-mail-reply"                          // https://fontawesome.com/icons/mail-reply
	MailReplyAll                     = "fa-mail-reply-all"                      // https://fontawesome.com/icons/mail-reply-all
	Male                             = "fa-male"                                // https://fontawesome.com/icons/male
	Map                              = "fa-map"                                 // https://fontawesome.com/icons/map
	MapMarker                        = "fa-map-marker"                          // https://fontawesome.com/icons/map-marker
	MapO                             = "fa-map-o"                               // https://fontawesome.com/icons/map-o
	MapPin                           = "fa-map-pin"                             // https://fontawesome.com/icons/map-pin
	MapSigns                         = "fa-map-signs"                           // https://fontawesome.com/icons/map-signs
	Mars                             = "fa-mars"                                // https://fontawesome.com/icons/mars
	MarsDouble                       = "fa-mars-double"                         // https://fontawesome.com/icons/mars-double
	MarsStroke                       = "fa-mars-stroke"                         // https://fontawesome.com/icons/mars-stroke
	MarsStrokeH                      = "fa-mars-stroke-h"                       // https://fontawesome.com/icons/mars-stroke-h
	MarsStrokeV                      = "fa-mars-stroke-v"                       // https://fontawesome.com/icons/mars-stroke-v
	Maxcdn                           = "fa-maxcdn"                              // https://fontawesome.com/icons/maxcdn
	Meanpath                         = "fa-meanpath"                            // https://fontawesome.com/icons/meanpath
	Medium                           = "fa-medium"                              // https://fontawesome.com/icons/medium
	Medkit                           = "fa-medkit"                              // https://fontawesome.com/icons/medkit
	MehO                             = "fa-meh-o"                               // https://fontawesome.com/icons/meh-o
	Mercury                          = "fa-mercury"                             // https://fontawesome.com/icons/mercury
	Microphone                       = "fa-microphone"                          // https://fontawesome.com/icons/microphone
	MicrophoneSlash                  = "fa-microphone-slash"                    // https://fontawesome.com/icons/microphone-slash
	Minus                            = "fa-minus"                               // https://fontawesome.com/icons/minus
	MinusCircle                      = "fa-minus-circle"                        // https://fontawesome.com/icons/minus-circle
	MinusSquare                      = "fa-minus-square"                        // https://fontawesome.com/icons/minus-square
	MinusSquareO                     = "fa-minus-square-o"                      // https://fontawesome.com/icons/minus-square-o
	Mixcloud                         = "fa-mixcloud"                            // https://fontawesome.com/icons/mixcloud
	Mobile                           = "fa-mobile"                              // https://fontawesome.com/icons/mobile
	MobilePhone                      = "fa-mobile-phone"                        // https://fontawesome.com/icons/mobile-phone
	Modx                             = "fa-modx"                                // https://fontawesome.com/icons/modx
	Money                            = "fa-money"                               // https://fontawesome.com/icons/money
	MoonO                            = "fa-moon-o"                              // https://fontawesome.com/icons/moon-o
	MortarBoard                      = "fa-mortar-board"                        // https://fontawesome.com/icons/mortar-board
	Motorcycle                       = "fa-motorcycle"                          // https://fontawesome.com/icons/motorcycle
	MousePointer                     = "fa-mouse-pointer"                       // https://fontawesome.com/icons/mouse-pointer
	Music                            = "fa-music"                               // https://fontawesome.com/icons/music
	Navicon                          = "fa-navicon"                             // https://fontawesome.com/icons/navicon
	Neuter                           = "fa-neuter"                              // https://fontawesome.com/icons/neuter
	NewspaperO                       = "fa-newspaper-o"                         // https://fontawesome.com/icons/newspaper-o
	ObjectGroup                      = "fa-object-group"                        // https://fontawesome.com/icons/object-group
	ObjectUngroup                    = "fa-object-ungroup"                      // https://fontawesome.com/icons/object-ungroup
	Odnoklassniki                    = "fa-odnoklassniki"                       // https://fontawesome.com/icons/odnoklassniki
	OdnoklassnikiSquare              = "fa-odnoklassniki-square"                // https://fontawesome.com/icons/odnoklassniki-square
	Opencart                         = "fa-opencart"                            // https://fontawesome.com/icons/opencart
	Openid                           = "fa-openid"                              // https://fontawesome.com/icons/openid
	Opera                            = "fa-opera"                               // https://fontawesome.com/icons/opera
	OptinMonster                     = "fa-optin-monster"                       // https://fontawesome.com/icons/optin-monster
	Outdent                          = "fa-outdent"                             // https://fontawesome.com/icons/outdent
	Pagelines                        = "fa-pagelines"                           // https://fontawesome.com/icons/pagelines
	PaintBrush                       = "fa-paint-brush"                         // https://fontawesome.com/icons/paint-brush
	PaperPlane                       = "fa-paper-plane"                         // https://fontawesome.com/icons/paper-plane
	PaperPlaneO                      = "fa-paper-plane-o"                       // https://fontawesome.com/icons/paper-plane-o
	Paperclip                        = "fa-paperclip"                           // https://fontawesome.com/icons/paperclip
	Paragraph                        = "fa-paragraph"                           // https://fontawesome.com/icons/paragraph
	Paste                            = "fa-paste"                               // https://fontawesome.com/icons/paste
	Pause                            = "fa-pause"                               // https://fontawesome.com/icons/pause
	PauseCircle                      = "fa-pause-circle"                        // https://fontawesome.com/icons/pause-circle
	PauseCircleO                     = "fa-pause-circle-o"                      // https://fontawesome.com/icons/pause-circle-o
	Paw                              = "fa-paw"                                 // https://fontawesome.com/icons/paw
	Paypal                           = "fa-paypal"                              // https://fontawesome.com/icons/paypal
	Pencil                           = "fa-pencil"                              // https://fontawesome.com/icons/pencil
	PencilSquare                     = "fa-pencil-square"                       // https://fontawesome.com/icons/pencil-square
	PencilSquareO                    = "fa-pencil-square-o"                     // https://fontawesome.com/icons/pencil-square-o
	Percent                          = "fa-percent"                             // https://fontawesome.com/icons/percent
	Phone                            = "fa-phone"                               // https://fontawesome.com/icons/phone
	PhoneSquare                      = "fa-phone-square"                        // https://fontawesome.com/icons/phone-square
	Photo                            = "fa-photo"                               // https://fontawesome.com/icons/photo
	PictureO                         = "fa-picture-o"                           // https://fontawesome.com/icons/picture-o
	PieChart                         = "fa-pie-chart"                           // https://fontawesome.com/icons/pie-chart
	PiedPiper                        = "fa-pied-piper"                          // https://fontawesome.com/icons/pied-piper
	PiedPiperAlt                     = "fa-pied-piper-alt"                      // https://fontawesome.com/icons/pied-piper-alt
	PiedPiperPp                      = "fa-pied-piper-pp"                       // https://fontawesome.com/icons/pied-piper-pp
	Pinterest                        = "fa-pinterest"                           // https://fontawesome.com/icons/pinterest
	PinterestP                       = "fa-pinterest-p"                         // https://fontawesome.com/icons/pinterest-p
	PinterestSquare                  = "fa-pinterest-square"                    // https://fontawesome.com/icons/pinterest-square
	Plane                            = "fa-plane"                               // https://fontawesome.com/icons/plane
	Play                             = "fa-play"                                // https://fontawesome.com/icons/play
	PlayCircle                       = "fa-play-circle"                         // https://fontawesome.com/icons/play-circle
	PlayCircleO                      = "fa-play-circle-o"                       // https://fontawesome.com/icons/play-circle-o
	Plug                             = "fa-plug"                                // https://fontawesome.com/icons/plug
	Plus                             = "fa-plus"                                // https://fontawesome.com/icons/plus
	PlusCircle                       = "fa-plus-circle"                         // https://fontawesome.com/icons/plus-circle
	PlusSquare                       = "fa-plus-square"                         // https://fontawesome.com/icons/plus-square
	PlusSquareO                      = "fa-plus-square-o"                       // https://fontawesome.com/icons/plus-square-o
	PowerOff                         = "fa-power-off"                           // https://fontawesome.com/icons/power-off
	Print                            = "fa-print"                               // https://fontawesome.com/icons/print
	ProductHunt                      = "fa-product-hunt"                        // https://fontawesome.com/icons/product-hunt
	PuzzlePiece                      = "fa-puzzle-piece"                        // https://fontawesome.com/icons/puzzle-piece
	Qq                               = "fa-qq"                                  // https://fontawesome.com/icons/qq
	Qrcode                           = "fa-qrcode"                              // https://fontawesome.com/icons/qrcode
	Question                         = "fa-question"                            // https://fontawesome.com/icons/question
	QuestionCircle                   = "fa-question-circle"                     // https://fontawesome.com/icons/question-circle
	QuestionCircleO                  = "fa-question-circle-o"                   // https://fontawesome.com/icons/question-circle-o
	QuoteLeft                        = "fa-quote-left"                          // https://fontawesome.com/icons/quote-left
	QuoteRight                       = "fa-quote-right"                         // https://fontawesome.com/icons/quote-right
	Ra                               = "fa-ra"                                  // https://fontawesome.com/icons/ra
	Random                           = "fa-random"                              // https://fontawesome.com/icons/random
	Rebel                            = "fa-rebel"                               // https://fontawesome.com/icons/rebel
	Recycle                          = "fa-recycle"                             // https://fontawesome.com/icons/recycle
	Reddit                           = "fa-reddit"                              // https://fontawesome.com/icons/reddit
	RedditAlien                      = "fa-reddit-alien"                        // https://fontawesome.com/icons/reddit-alien
	RedditSquare                     = "fa-reddit-square"                       // https://fontawesome.com/icons/reddit-square
	Refresh                          = "fa-refresh"                             // https://fontawesome.com/icons/refresh
	Registered                       = "fa-registered"                          // https://fontawesome.com/icons/registered
	Remove                           = "fa-remove"                              // https://fontawesome.com/icons/remove
	Renren                           = "fa-renren"                              // https://fontawesome.com/icons/renren
	Reorder                          = "fa-reorder"                             // https://fontawesome.com/icons/reorder
	Repeat                           = "fa-repeat"                              // https://fontawesome.com/icons/repeat
	Reply                            = "fa-reply"                               // https://fontawesome.com/icons/reply
	ReplyAll                         = "fa-reply-all"                           // https://fontawesome.com/icons/reply-all
	Resistance                       = "fa-resistance"                          // https://fontawesome.com/icons/resistance
	Retweet                          = "fa-retweet"                             // https://fontawesome.com/icons/retweet
	Rmb                              = "fa-rmb"                                 // https://fontawesome.com/icons/rmb
	Road                             = "fa-road"                                // https://fontawesome.com/icons/road
	Rocket                           = "fa-rocket"                              // https://fontawesome.com/icons/rocket
	RotateLeft                       = "fa-rotate-left"                         // https://fontawesome.com/icons/rotate-left
	RotateRight                      = "fa-rotate-right"                        // https://fontawesome.com/icons/rotate-right
	Rouble                           = "fa-rouble"                              // https://fontawesome.com/icons/rouble
	Rss                              = "fa-rss"                                 // https://fontawesome.com/icons/rss
	RssSquare                        = "fa-rss-square"                          // https://fontawesome.com/icons/rss-square
	Rub                              = "fa-rub"                                 // https://fontawesome.com/icons/rub
	Ruble                            = "fa-ruble"                               // https://fontawesome.com/icons/ruble
	Rupee                            = "fa-rupee"                               // https://fontawesome.com/icons/rupee
	Safari                           = "fa-safari"                              // https://fontawesome.com/icons/safari
	Save                             = "fa-save"                                // https://fontawesome.com/icons/save
	Scissors                         = "fa-scissors"                            // https://fontawesome.com/icons/scissors
	Scribd                           = "fa-scribd"                              // https://fontawesome.com/icons/scribd
	Search                           = "fa-search"                              // https://fontawesome.com/icons/search
	SearchMinus                      = "fa-search-minus"                        // https://fontawesome.com/icons/search-minus
	SearchPlus                       = "fa-search-plus"                         // https://fontawesome.com/icons/search-plus
	Sellsy                           = "fa-sellsy"                              // https://fontawesome.com/icons/sellsy
	Send                             = "fa-send"                                // https://fontawesome.com/icons/send
	SendO                            = "fa-send-o"                              // https://fontawesome.com/icons/send-o
	Server                           = "fa-server"                              // https://fontawesome.com/icons/server
	Share                            = "fa-share"                               // https://fontawesome.com/icons/share
	ShareAlt                         = "fa-share-alt"                           // https://fontawesome.com/icons/share-alt
	ShareAltSquare                   = "fa-share-alt-square"                    // https://fontawesome.com/icons/share-alt-square
	ShareSquare                      = "fa-share-square"                        // https://fontawesome.com/icons/share-square
	ShareSquareO                     = "fa-share-square-o"                      // https://fontawesome.com/icons/share-square-o
	Shekel                           = "fa-shekel"                              // https://fontawesome.com/icons/shekel
	Sheqel                           = "fa-sheqel"                              // https://fontawesome.com/icons/sheqel
	Shield                           = "fa-shield"                              // https://fontawesome.com/icons/shield
	Ship                             = "fa-ship"                                // https://fontawesome.com/icons/ship
	Shirtsinbulk                     = "fa-shirtsinbulk"                        // https://fontawesome.com/icons/shirtsinbulk
	ShoppingBag                      = "fa-shopping-bag"                        // https://fontawesome.com/icons/shopping-bag
	ShoppingBasket                   = "fa-shopping-basket"                     // https://fontawesome.com/icons/shopping-basket
	ShoppingCart                     = "fa-shopping-cart"                       // https://fontawesome.com/icons/shopping-cart
	SignIn                           = "fa-sign-in"                             // https://fontawesome.com/icons/sign-in
	SignLanguage                     = "fa-sign-language"                       // https://fontawesome.com/icons/sign-language
	SignOut                          = "fa-sign-out"                            // https://fontawesome.com/icons/sign-out
	Signal                           = "fa-signal"                              // https://fontawesome.com/icons/signal
	Signing                          = "fa-signing"                             // https://fontawesome.com/icons/signing
	Simplybuilt                      = "fa-simplybuilt"                         // https://fontawesome.com/icons/simplybuilt
	Sitemap                          = "fa-sitemap"                             // https://fontawesome.com/icons/sitemap
	Skyatlas                         = "fa-skyatlas"                            // https://fontawesome.com/icons/skyatlas
	Skype                            = "fa-skype"                               // https://fontawesome.com/icons/skype
	Slack                            = "fa-slack"                               // https://fontawesome.com/icons/slack
	Sliders                          = "fa-sliders"                             // https://fontawesome.com/icons/sliders
	Slideshare                       = "fa-slideshare"                          // https://fontawesome.com/icons/slideshare
	SmileO                           = "fa-smile-o"                             // https://fontawesome.com/icons/smile-o
	Snapchat                         = "fa-snapchat"                            // https://fontawesome.com/icons/snapchat
	SnapchatGhost                    = "fa-snapchat-ghost"                      // https://fontawesome.com/icons/snapchat-ghost
	SnapchatSquare                   = "fa-snapchat-square"                     // https://fontawesome.com/icons/snapchat-square
	SoccerBallO                      = "fa-soccer-ball-o"                       // https://fontawesome.com/icons/soccer-ball-o
	Sort                             = "fa-sort"                                // https://fontawesome.com/icons/sort
	SortAlphaAsc                     = "fa-sort-alpha-asc"                      // https://fontawesome.com/icons/sort-alpha-asc
	SortAlphaDesc                    = "fa-sort-alpha-desc"                     // https://fontawesome.com/icons/sort-alpha-desc
	SortAmountAsc                    = "fa-sort-amount-asc"                     // https://fontawesome.com/icons/sort-amount-asc
	SortAmountDesc                   = "fa-sort-amount-desc"                    // https://fontawesome.com/icons/sort-amount-desc
	SortAsc                          = "fa-sort-asc"                            // https://fontawesome.com/icons/sort-asc
	SortDesc                         = "fa-sort-desc"                           // https://fontawesome.com/icons/sort-desc
	SortDown                         = "fa-sort-down"                           // https://fontawesome.com/icons/sort-down
	SortNumericAsc                   = "fa-sort-numeric-asc"                    // https://fontawesome.com/icons/sort-numeric-asc
	SortNumericDesc                  = "fa-sort-numeric-desc"                   // https://fontawesome.com/icons/sort-numeric-desc
	SortUp                           = "fa-sort-up"                             // https://fontawesome.com/icons/sort-up
	Soundcloud                       = "fa-soundcloud"                          // https://fontawesome.com/icons/soundcloud
	SpaceShuttle                     = "fa-space-shuttle"                       // https://fontawesome.com/icons/space-shuttle
	Spinner                          = "fa-spinner"                             // https://fontawesome.com/icons/spinner
	Spoon                            = "fa-spoon"                               // https://fontawesome.com/icons/spoon
	Spotify                          = "fa-spotify"                             // https://fontawesome.com/icons/spotify
	Square                           = "fa-square"                              // https://fontawesome.com/icons/square
	SquareO                          = "fa-square-o"                            // https://fontawesome.com/icons/square-o
	StackExchange                    = "fa-stack-exchange"                      // https://fontawesome.com/icons/stack-exchange
	StackOverflow                    = "fa-stack-overflow"                      // https://fontawesome.com/icons/stack-overflow
	Star                             = "fa-star"                                // https://fontawesome.com/icons/star
	StarHalf                         = "fa-star-half"                           // https://fontawesome.com/icons/star-half
	StarHalfEmpty                    = "fa-star-half-empty"                     // https://fontawesome.com/icons/star-half-empty
	StarHalfFull                     = "fa-star-half-full"                      // https://fontawesome.com/icons/star-half-full
	StarHalfO                        = "fa-star-half-o"                         // https://fontawesome.com/icons/star-half-o
	StarO                            = "fa-star-o"                              // https://fontawesome.com/icons/star-o
	Steam                            = "fa-steam"                               // https://fontawesome.com/icons/steam
	SteamSquare                      = "fa-steam-square"                        // https://fontawesome.com/icons/steam-square
	StepBackward                     = "fa-step-backward"                       // https://fontawesome.com/icons/step-backward
	StepForward                      = "fa-step-forward"                        // https://fontawesome.com/icons/step-forward
	Stethoscope                      = "fa-stethoscope"                         // https://fontawesome.com/icons/stethoscope
	StickyNote                       = "fa-sticky-note"                         // https://fontawesome.com/icons/sticky-note
	StickyNoteO                      = "fa-sticky-note-o"                       // https://fontawesome.com/icons/sticky-note-o
	Stop                             = "fa-stop"                                // https://fontawesome.com/icons/stop
	StopCircle                       = "fa-stop-circle"                         // https://fontawesome.com/icons/stop-circle
	StopCircleO                      = "fa-stop-circle-o"                       // https://fontawesome.com/icons/stop-circle-o
	StreetView                       = "fa-street-view"                         // https://fontawesome.com/icons/street-view
	Strikethrough                    = "fa-strikethrough"                       // https://fontawesome.com/icons/strikethrough
	Stumbleupon                      = "fa-stumbleupon"                         // https://fontawesome.com/icons/stumbleupon
	StumbleuponCircle                = "fa-stumbleupon-circle"                  // https://fontawesome.com/icons/stumbleupon-circle
	Subscript                        = "fa-subscript"                           // https://fontawesome.com/icons/subscript
	Subway                           = "fa-subway"                              // https://fontawesome.com/icons/subway
	Suitcase                         = "fa-suitcase"                            // https://fontawesome.com/icons/suitcase
	SunO                             = "fa-sun-o"                               // https://fontawesome.com/icons/sun-o
	Superscript                      = "fa-superscript"                         // https://fontawesome.com/icons/superscript
	Support                          = "fa-support"                             // https://fontawesome.com/icons/support
	Table                            = "fa-table"                               // https://fontawesome.com/icons/table
	Tablet                           = "fa-tablet"                              // https://fontawesome.com/icons/tablet
	Tachometer                       = "fa-tachometer"                          // https://fontawesome.com/icons/tachometer
	Tag                              = "fa-tag"                                 // https://fontawesome.com/icons/tag
	Tags                             = "fa-tags"                                // https://fontawesome.com/icons/tags
	Tasks                            = "fa-tasks"                               // https://fontawesome.com/icons/tasks
	Taxi                             = "fa-taxi"                                // https://fontawesome.com/icons/taxi
	Television                       = "fa-television"                          // https://fontawesome.com/icons/television
	TencentWeibo                     = "fa-tencent-weibo"                       // https://fontawesome.com/icons/tencent-weibo
	Terminal                         = "fa-terminal"                            // https://fontawesome.com/icons/terminal
	TextHeight                       = "fa-text-height"                         // https://fontawesome.com/icons/text-height
	TextWidth                        = "fa-text-width"                          // https://fontawesome.com/icons/text-width
	Th                               = "fa-th"                                  // https://fontawesome.com/icons/th
	ThLarge                          = "fa-th-large"                            // https://fontawesome.com/icons/th-large
	ThList                           = "fa-th-list"                             // https://fontawesome.com/icons/th-list
	Themeisle                        = "fa-themeisle"                           // https://fontawesome.com/icons/themeisle
	ThumbTack                        = "fa-thumb-tack"                          // https://fontawesome.com/icons/thumb-tack
	ThumbsDown                       = "fa-thumbs-down"                         // https://fontawesome.com/icons/thumbs-down
	ThumbsODown                      = "fa-thumbs-o-down"                       // https://fontawesome.com/icons/thumbs-o-down
	ThumbsOUp                        = "fa-thumbs-o-up"                         // https://fontawesome.com/icons/thumbs-o-up
	ThumbsUp                         = "fa-thumbs-up"                           // https://fontawesome.com/icons/thumbs-up
	Ticket                           = "fa-ticket"                              // https://fontawesome.com/icons/ticket
	Times                            = "fa-times"                               // https://fontawesome.com/icons/times
	TimesCircle                      = "fa-times-circle"                        // https://fontawesome.com/icons/times-circle
	TimesCircleO                     = "fa-times-circle-o"                      // https://fontawesome.com/icons/times-circle-o
	Tint                             = "fa-tint"                                // https://fontawesome.com/icons/tint
	ToggleDown                       = "fa-toggle-down"                         // https://fontawesome.com/icons/toggle-down
	ToggleLeft                       = "fa-toggle-left"                         // https://fontawesome.com/icons/toggle-left
	ToggleOff                        = "fa-toggle-off"                          // https://fontawesome.com/icons/toggle-off
	ToggleOn                         = "fa-toggle-on"                           // https://fontawesome.com/icons/toggle-on
	ToggleRight                      = "fa-toggle-right"                        // https://fontawesome.com/icons/toggle-right
	ToggleUp                         = "fa-toggle-up"                           // https://fontawesome.com/icons/toggle-up
	Trademark                        = "fa-trademark"                           // https://fontawesome.com/icons/trademark
	Train                            = "fa-train"                               // https://fontawesome.com/icons/train
	Transgender                      = "fa-transgender"                         // https://fontawesome.com/icons/transgender
	TransgenderAlt                   = "fa-transgender-alt"                     // https://fontawesome.com/icons/transgender-alt
	Trash                            = "fa-trash"                               // https://fontawesome.com/icons/trash
	TrashO                           = "fa-trash-o"                             // https://fontawesome.com/icons/trash-o
	Tree                             = "fa-tree"                                // https://fontawesome.com/icons/tree
	Trello                           = "fa-trello"                              // https://fontawesome.com/icons/trello
	Tripadvisor                      = "fa-tripadvisor"                         // https://fontawesome.com/icons/tripadvisor
	Trophy                           = "fa-trophy"                              // https://fontawesome.com/icons/trophy
	Truck                            = "fa-truck"                               // https://fontawesome.com/icons/truck
	Try                              = "fa-try"                                 // https://fontawesome.com/icons/try
	Tty                              = "fa-tty"                                 // https://fontawesome.com/icons/tty
	Tumblr                           = "fa-tumblr"                              // https://fontawesome.com/icons/tumblr
	TumblrSquare                     = "fa-tumblr-square"                       // https://fontawesome.com/icons/tumblr-square
	TurkishLira                      = "fa-turkish-lira"                        // https://fontawesome.com/icons/turkish-lira
	Tv                               = "fa-tv"                                  // https://fontawesome.com/icons/tv
	Twitch                           = "fa-twitch"                              // https://fontawesome.com/icons/twitch
	Twitter                          = "fa-twitter"                             // https://fontawesome.com/icons/twitter
	TwitterSquare                    = "fa-twitter-square"                      // https://fontawesome.com/icons/twitter-square
	Umbrella                         = "fa-umbrella"                            // https://fontawesome.com/icons/umbrella
	Underline                        = "fa-underline"                           // https://fontawesome.com/icons/underline
	Undo                             = "fa-undo"                                // https://fontawesome.com/icons/undo
	UniversalAccess                  = "fa-universal-access"                    // https://fontawesome.com/icons/universal-access
	University                       = "fa-university"                          // https://fontawesome.com/icons/university
	Unlink                           = "fa-unlink"                              // https://fontawesome.com/icons/unlink
	Unlock                           = "fa-unlock"                              // https://fontawesome.com/icons/unlock
	UnlockAlt                        = "fa-unlock-alt"                          // https://fontawesome.com/icons/unlock-alt
	Unsorted                         = "fa-unsorted"                            // https://fontawesome.com/icons/unsorted
	Upload                           = "fa-upload"                              // https://fontawesome.com/icons/upload
	Usb                              = "fa-usb"                                 // https://fontawesome.com/icons/usb
	Usd                              = "fa-usd"                                 // https://fontawesome.com/icons/usd
	User                             = "fa-user"                                // https://fontawesome.com/icons/user
	UserMd                           = "fa-user-md"                             // https://fontawesome.com/icons/user-md
	UserPlus                         = "fa-user-plus"                           // https://fontawesome.com/icons/user-plus
	UserSecret                       = "fa-user-secret"                         // https://fontawesome.com/icons/user-secret
	UserTimes                        = "fa-user-times"                          // https://fontawesome.com/icons/user-times
	Users                            = "fa-users"                               // https://fontawesome.com/icons/users
	Venus                            = "fa-venus"                               // https://fontawesome.com/icons/venus
	VenusDouble                      = "fa-venus-double"                        // https://fontawesome.com/icons/venus-double
	VenusMars                        = "fa-venus-mars"                          // https://fontawesome.com/icons/venus-mars
	Viacoin                          = "fa-viacoin"                             // https://fontawesome.com/icons/viacoin
	Viadeo                           = "fa-viadeo"                              // https://fontawesome.com/icons/viadeo
	ViadeoSquare                     = "fa-viadeo-square"                       // https://fontawesome.com/icons/viadeo-square
	VideoCamera                      = "fa-video-camera"                        // https://fontawesome.com/icons/video-camera
	Vimeo                            = "fa-vimeo"                               // https://fontawesome.com/icons/vimeo
	VimeoSquare                      = "fa-vimeo-square"                        // https://fontawesome.com/icons/vimeo-square
	Vine                             = "fa-vine"                                // https://fontawesome.com/icons/vine
	Vk                               = "fa-vk"                                  // https://fontawesome.com/icons/vk
	VolumeControlPhone               = "fa-volume-control-phone"                // https://fontawesome.com/icons/volume-control-phone
	VolumeDown                       = "fa-volume-down"                         // https://fontawesome.com/icons/volume-down
	VolumeOff                        = "fa-volume-off"                          // https://fontawesome.com/icons/volume-off
	VolumeUp                         = "fa-volume-up"                           // https://fontawesome.com/icons/volume-up
	Warning                          = "fa-warning"                             // https://fontawesome.com/icons/warning
	Wechat                           = "fa-wechat"                              // https://fontawesome.com/icons/wechat
	Weibo                            = "fa-weibo"                               // https://fontawesome.com/icons/weibo
	Weixin                           = "fa-weixin"                              // https://fontawesome.com/icons/weixin
	Whatsapp                         = "fa-whatsapp"                            // https://fontawesome.com/icons/whatsapp
	Wheelchair                       = "fa-wheelchair"                          // https://fontawesome.com/icons/wheelchair
	WheelchairAlt                    = "fa-wheelchair-alt"                      // https://fontawesome.com/icons/wheelchair-alt
	Wifi                             = "fa-wifi"                                // https://fontawesome.com/icons/wifi
	WikipediaW                       = "fa-wikipedia-w"                         // https://fontawesome.com/icons/wikipedia-w
	Windows                          = "fa-windows"                             // https://fontawesome.com/icons/windows
	Won                              = "fa-won"                                 // https://fontawesome.com/icons/won
	Wordpress                        = "fa-wordpress"                           // https://fontawesome.com/icons/wordpress
	Wpbeginner                       = "fa-wpbeginner"                          // https://fontawesome.com/icons/wpbeginner
	Wpforms                          = "fa-wpforms"                             // https://fontawesome.com/icons/wpforms
	Wrench                           = "fa-wrench"                              // https://fontawesome.com/icons/wrench
	Xing                             = "fa-xing"                                // https://fontawesome.com/icons/xing
	XingSquare                       = "fa-xing-square"                         // https://fontawesome.com/icons/xing-square
	YCombinator                      = "fa-y-combinator"                        // https://fontawesome.com/icons/y-combinator
	YCombinatorSquare                = "fa-y-combinator-square"                 // https://fontawesome.com/icons/y-combinator-square
	Yahoo                            = "fa-yahoo"                               // https://fontawesome.com/icons/yahoo
	Yc                               = "fa-yc"                                  // https://fontawesome.com/icons/yc
	YcSquare                         = "fa-yc-square"                           // https://fontawesome.com/icons/yc-square
	Yelp                             = "fa-yelp"                                // https://fontawesome.com/icons/yelp
	Yen                              = "fa-yen"                                 // https://fontawesome.com/icons/yen
	Yoast                            = "fa-yoast"                               // https://fontawesome.com/icons/yoast
	Youtube                          = "fa-youtube"                             // https://fontawesome.com/icons/youtube
	YoutubePlay                      = "fa-youtube-play"                        // https://fontawesome.com/icons/youtube-play
	YoutubeSquare                    = "fa-youtube-square"                      // https://fontawesome.com/icons/youtube-square
	IonIosGearOutline                = "ion-ios-gear-outline"                   // https://fontawesome.com/icons/ion-ios-gear-outline
	IonIosCartOutline                = "ion-ios-cart-outline"                   // https://fontawesome.com/icons/ion-ios-cart-outline
	IonIosPeopleOutline              = "ion-ios-people-outline"                 // https://fontawesome.com/icons/ion-ios-people-outline
)
