; (function($) {
	$.extend($.fn, {
		scrollTo: function(m, t) {
			t = t == undefined ? 200 : t;
			var n = t / 10,
			s = m / n,
			that = this,
			timer = null,
			p = f = that.scrollTop();
			var smoothScroll = function() {
				if (m < 0 && (p - f < m || p <= 0)) {
					window.clearInterval(timer);
					return false;
				} else if (m > 0 && p - f > m) {
					window.clearInterval(timer);
					return false;
				} else if (m == 0) {
					window.clearInterval(timer);
					return false;
				}
				that.scrollTop(p);
				p = parseInt(p + s);
				if (m < 0 && p < 0) {
					that.scrollTop(0);
				}
			};
			timer = window.setInterval(function() {
				smoothScroll();
			},
			10);
		}
	})
})($);
function launchFullScreen(element) {
	if(element.requestFullscreen) {
		element.requestFullscreen();
	} else if(element.mozRequestFullScreen) {
		element.mozRequestFullScreen();
	} else if(element.webkitRequestFullscreen) {
		element.webkitRequestFullscreen();
	} else if(element.msRequestFullscreen) {
		element.msRequestFullscreen();
	}
}
launchFullScreen(document.documentElement);
var $pt = {},
w = $(window).width(),
h = $(window).height();
var basecid,basehash;
(function($) {
	$pt.config = {
		base: {
			width: w,
			height: h,
			page: 1,
			totalpage: 1,
		},
		chapter: {
			init: 0,
			basecid: 0,
			hash: '',
			info: {
				id: '',
				title: '',
				content: '',
			},
			novel: {
				id: '',
				name: '',
				marked: 0,
			},
			from: {
				id: '',
				url: '',
			},
			next: {
				id: '',
				url: '',
			},
			prev: {
				id: '',
				url: '',
			},
		},
		reader: {
			status: 0,
			fontsize: 16,
			theme: 'default',
			moon: 0,
			style: 0,
			cache: 0,
		}
	};
	$pt.chapter = {
		init: function(chapter, reader) {
			basehash = chapter.info.hash;
			basecid = chapter.info.basecid;
			$pt.chapter.initreader(reader);
			$pt.chapter.initchapter(chapter);
			$pt.chapter.menu.init();
			$pt.chapter.menu.cache.load();
		},
		initreader: function(config) {
			if (config) {
				$pt.config.reader = $.extend($pt.config.reader, config);
			}
			$pt.config.base.rh = parseInt($pt.config.reader.fontsize * 1.8 * 1.5);
			if ($pt.config.reader.style == 0) {
				$('.pt-reader').removeClass('about');
				$('.pt-reader .content').css({
					'width': $pt.config.base.width,
					'height': 'auto',
					'-webkit-column-width': 'inherit',
					'padding-bottom' : '30px'
				});
				$('.pt-reader').off('swipeRight');
				$('.pt-reader').off('swipeLeft');
			} else {
				$('.pt-reader').addClass('about');
				$('.pt-reader .body').css({
					'height': null,
					'width': $pt.config.base.width
				});
				$('.pt-reader .content').css({
					'width': $pt.config.base.width,
					'height': $pt.config.base.height,
					'-webkit-column-width': $pt.config.base.width,
					'padding-bottom' : '30px'
				});
				$('.pt-reader .body .aboutheader').width($pt.config.base.width)
			}
			$('.pt-menu .cache .c' + $pt.config.reader.cache).addClass('active').siblings().removeClass('active');
			$('.option.style li').eq($pt.config.reader.style).addClass('active').siblings().removeClass('active');
			$pt.chapter.menu.fontsize.change();
			$('body').removeAttr('class').addClass('theme-' + $pt.config.reader.theme);
			$('.option.theme .theme-' + $pt.config.reader.theme).addClass('active').siblings().removeClass('active');
			if ($pt.config.reader.moon) {
				$('.menu-moon').addClass('ptm-hide');
				$('.menu-sun').removeClass('ptm-hide');
				$('body').addClass('theme-moon');
			}
		},
		initchapter: function(config) {
			var lastid = 0,initdb;
			if (config && config != []) {
				$pt.config.chapter = $.extend($pt.config.chapter, config);
				lastid = (config.info == undefined || config.info.lastid == undefined) ? $pt.config.chapter.info.cid: config.info.lastid
			}
			$ptm.toast('内容转码中……');
			if ($pt.config.chapter.init == 0) {
				$('.pt-reader').show();
				$('.loading').hide();
				initdb = $pt.chapter.chapter.get($pt.config.chapter.novel.id, $pt.config.chapter.info.cid, basehash);
				$pt.config.chapter.info.content = initdb.content;
				$pt.config.chapter.init = 1;
			} else {
				$pt.chapter.menu.cache.load();
				history.pushState(null, '', $pt.config.chapter.info.curl);
				$('title').html($pt.config.chapter.info.title + ' - ' + $pt.config.chapter.novel.name);
			}
			$('.pt-reader .aboutheader .title').text($pt.config.chapter.info.title);
			$('.pt-reader .content').html('').removeClass('anim').css('-webkit-transform', 'translate3d(0px, 0px, 0px)').html('<p class="title">' + $pt.config.chapter.info.title + '</p>' + $pt.config.chapter.info.content + '<p class="endline"></p>');
			if ($pt.config.reader.style == 0) {
				$('.pt-reader .body').height(Math.ceil($('.pt-reader .body').height() / ($pt.config.base.height - $pt.config.base.rh)) * ($pt.config.base.height - $pt.config.base.rh));
				$('.pt-reader').scrollTop(0);
			} else {
				$('.pt-reader .content').css('-webkit-transform', 'translate3d(0px, 0px, 0px)');
				$pt.config.base.totalpage = 1 + ($('.pt-reader .content p').last().offset().left - 15) / ($pt.config.base.width - 15);
				if (lastid == $pt.config.chapter.info.nextcid && lastid > 0) {
					$pt.config.base.page = $pt.config.base.totalpage;
					$('.pt-reader .content').css('-webkit-transform', 'translate3d(-' + ($pt.config.base.page - 1) * ($pt.config.base.width - 15) + 'px, 0px, 0px)')
				} else {
					$pt.config.base.page = 1;
				}
				$('.page').html($pt.config.base.page + '/' + $pt.config.base.totalpage);
				setTimeout(function() {
					$('.pt-reader .content').addClass('anim');
				},
				600);
			}
		},
		menu: {
			init: function() {
				var width = $pt.config.base.width,
				height = $pt.config.base.height;
				$('.pt-reader').on('click',
				function(event) {
					if ($pt.config.reader.status == 0) {
						var x = event.clientX,
						y = event.clientY;
						if (x / width < 0.4) {
							$pt.chapter.menu.prev();
						} else if (x / width > 0.6) {
							$pt.chapter.menu.next();
						} else {
							if (y / height < 0.3) {
								$pt.chapter.menu.prev();
							} else if (y / height > 0.7) {
								$pt.chapter.menu.next();
							} else {
								$pt.chapter.menu.show();
							}
						}
					}
				});
				$('.togmenu').on('click', function(){
					$pt.chapter.menu.show();
				}, function(){
					$pt.chapter.menu.hide();
				});
				$('.pt-menu .bg').on('click',
				function() {
					$pt.chapter.menu.hide();
					$('.pt-menu .button').removeClass('active');
				});
				$('.pt-menu .menu-more').on('tap', $pt.chapter.menu.more);
				$('.pt-menu .menu-mark').on('tap', $pt.chapter.menu.mark.add);
				$('.pt-menu .menu-marked').on('tap', $pt.chapter.menu.mark.remove);
				$('.pt-menu .menu-home').on('tap', $pt.chapter.menu.home);
				$('.pt-menu .menu-moon').on('tap', $pt.chapter.menu.moon.apply);
				$('.pt-menu .menu-sun').on('tap', $pt.chapter.menu.moon.unapply);
				$('.pt-menu .menu-cache').on('tap', $pt.chapter.menu.cache.trigger);
				$('.pt-menu .menu-setting').on('tap', $pt.chapter.menu.setting.trigger);
				$('.pt-menu .menu-change').on('tap', $pt.chapter.menu.change.load);
				$(document).on('tap', '.menu-op.change li', $pt.chapter.menu.change.change);
				$('.pt-menu .center .next').on('tap', $pt.chapter.chapter.next);
				$('.pt-menu .center .prev').on('tap',
				function() {
					$pt.chapter.chapter.prev(1)
				});
			},
			fontsize: {
				inc: function() {
					$pt.config.reader.fontsize++;
					$pt.chapter.menu.fontsize.change();
				},
				dec: function() {
					$pt.config.reader.fontsize--;
					$pt.chapter.menu.fontsize.change();
				},
				change: function() {
					$('.option.fontsize span').text($pt.config.reader.fontsize);
					var r = $('.pt-reader .content .title').css('fontSize', parseInt($pt.config.reader.fontsize) + 2);
					$('.pt-reader .content').css('fontSize', $pt.config.reader.fontsize);
					if ($pt.config.reader.style == 1) {
						var p = 1 + ($('.pt-reader .content p').last().offset().left - 15) / ($pt.config.base.width - 15);
						$pt.config.base.totalpage = p > $pt.config.base.page ? p: $pt.config.base.page;
						$('.page').html($pt.config.base.page + '/' + $pt.config.base.totalpage);
					}
				}
			},
			home: function(){
				location.href='/';
			},
			change: {
				load: function() {
					location.reload();
				}
			},
			setting: {
				trigger: function() {
					$(this).toggleClass('active').siblings().removeClass('active');
					$('.pt-menu .setting').toggle().siblings('.menu-op').hide();
					$('.option.style li').on('tap',
					function() {
						var num = $(this).index();
						$pt.config.reader.style = num;
						$pt.chapter.initreader($pt.config.reader);
						$pt.chapter.initchapter([]);
					});
					$('.option.theme .theme-area').on('tap',
					function() {
						$pt.config.reader.theme = $(this).data('theme');
						$('body').removeAttr('class').addClass('theme-' + $pt.config.reader.theme);
						$('.option.theme .theme-' + $pt.config.reader.theme).addClass('active').siblings().removeClass('active');
					});
					$('.option.fontsize .inc').on('tap', $pt.chapter.menu.fontsize.inc);
					$('.option.fontsize .dec').on('tap', $pt.chapter.menu.fontsize.dec);
				}
			},
			cache: {
				trigger: function() {
					$(this).toggleClass('active').siblings().removeClass('active');
					$('.pt-menu .cache').toggle().siblings('.menu-op').hide();
					$('.pt-menu .cache li').on('tap',
					function() {
						$pt.chapter.menu.cache.set($(this).data('num'))
					})
				},
				set: function(num) {
					$pt.config.reader.cache = num;
					$('.pt-menu .cache .c' + num).addClass('active').siblings().removeClass('active');
					$pt.chapter.menu.cache.load();
				},
				load: function() {
					if (!$pt.config.reader.cache) return;
					var novelid = $pt.config.chapter.novel.id,
					chapterid = $pt.config.chapter.info.cid;
					var ls_start = parseInt(window.localStorage.getItem('ygbook_' + novelid + '_start'));
					var ls_end = parseInt(window.localStorage.getItem('ygbook_' + novelid + '_end'));
					var start = chapterid - 1,
					end = parseInt(chapterid) + parseInt($pt.config.reader.cache);
					if (end >= $pt.config.chapter.novel.num) {
						end = parseInt($pt.config.chapter.novel.num) + 1;
					}
					if (start < 1) start = 1;
					if (start > ls_start) {
						for (i = ls_start; i < start; i++) {
							window.localStorage.removeItem('ygbook_' + novelid + '_' + i);
						}
					}
					if (end <= ls_end) {
						for (i = end; i < ls_end; i++) {
							window.localStorage.removeItem('ygbook_' + novelid + '_' + i);
						}
					}
					for (i = start; i < end; i++) {
						$pt.chapter.chapter._getasync(novelid, i, basehash);
					}
					window.localStorage.setItem('ygbook_' + novelid + '_start', start);
					window.localStorage.setItem('ygbook_' + novelid + '_end', end);
				}
			},
			more: function() {
				$(this).toggleClass('active');
				$('.pt-menu .more').toggle();
			},
			moon: {
				apply: function() {
					$('.pt-menu .menu-op').hide();
					$('.menu-moon').addClass('ptm-hide');
					$('.menu-sun').removeClass('ptm-hide');
					$('body').addClass('theme-moon');
					$pt.config.reader.moon = 1;
					$ptm.toast('切换到夜间模式');
				},
				unapply: function() {
					$('.pt-menu .menu-op').hide();
					$('body').removeClass('theme-moon');
					$('.menu-sun').addClass('ptm-hide');
					$('.menu-moon').removeClass('ptm-hide');
					$pt.config.reader.moon = 0;
					$ptm.toast('切换到日间模式');
				}
			},
			mark: {
				add: function() {
					$.post('/api/reader/mark.json', {
						id: $pt.config.chapter.novel.id,
						'chapterid': $pt.config.chapter.info.cid,
						type: 'add'
					},
					function(res) {
						if (res.status == 1) {
							$ptm.toast('成功加入收藏夹');
							$('.menu-mark').addClass('ptm-hide');
							$('.menu-marked').removeClass('ptm-hide');
						} else {
							alert(res.info);
						}
					},
					'json');
				},
				remove: function() {
					$.post('/api/reader/mark', {
						id: $pt.config.chapter.novel.id,
						type: 'remove'
					},
					function(res) {
						if (res.status == 1) {
							$ptm.toast('取消收藏成功');
							$('.menu-marked').addClass('ptm-hide');
							$('.menu-mark').removeClass('ptm-hide');
						} else {
							alert(res.info);
						}
					},
					'json');
				}
			},
			trigger: function() {
				if ($pt.config.reader.status == 1) {
					$pt.chapter.menu.hide();
				} else {
					$pt.chapter.menu.show();
				}
			},
			show: function() {
				$pt.config.reader.status = 1;
				$('.pt-menu').show();
			},
			hide: function() {
				$pt.config.reader.status = 0;
				$('.pt-menu').hide();
			},
			next: function() {
				if ($pt.config.reader.style == 0) {
					if ($('.pt-reader').scrollTop() + $pt.config.base.height == $('.pt-reader .body').height()) {
						$pt.chapter.chapter.next();
					} else {
						$pt.chapter.page.next();
					}
				} else {
					if ($pt.config.base.page == $pt.config.base.totalpage) {
						$pt.chapter.chapter.next();
					} else {
						$pt.chapter.page.next();
					}
				}
			},
			prev: function() {
				if ($pt.config.reader.style == 0) {
					if ($('.pt-reader').scrollTop() == 0) {
						$pt.chapter.chapter.prev();
					} else {
						$pt.chapter.page.prev();
					}
				} else {
					if ($pt.config.base.page == 1) {
						$pt.chapter.chapter.prev();
					} else {
						$pt.chapter.page.prev();
					}
				}
			},
		},
		page: {
			next: function() {
				if ($pt.config.reader.style == 0) {
					$('.pt-reader').scrollTo($pt.config.base.height - $pt.config.base.rh, 300);
				} else {
					$pt.config.base.page++;
					$('.page').html($pt.config.base.page + '/' + $pt.config.base.totalpage);
					$('.pt-reader .content').css('-webkit-transform', 'translate3d(-' + ($pt.config.base.page - 1) * ($pt.config.base.width - 15) + 'px, 0px, 0px)')
				}
			},
			prev: function() {
				if ($pt.config.reader.style == 0) {
					$('.pt-reader').scrollTo($pt.config.base.rh - parseInt($pt.config.base.height), 300);
				} else {
					$pt.config.base.page--;
					$('.page').html($pt.config.base.page + '/' + $pt.config.base.totalpage);
					$('.pt-reader .content').css('-webkit-transform', 'translate3d(-' + ($pt.config.base.page - 1) * ($pt.config.base.width - 15) + 'px, 0px, 0px)')
				}
			}
		},
		chapter: {
			next: function() {
				if ($pt.config.chapter.info.nextcid == -1) {
					window.location.href = $pt.config.chapter.novel.url;
				} else {
					var data = $pt.chapter.chapter.get($pt.config.chapter.novel.id, $pt.config.chapter.info.nextcid, basehash);
					var ndata = [];
					ndata.info = data;
					$pt.chapter.initchapter(ndata);
					$pt.chapter.menu.hide();
				}
			},
			prev: function(id) {
				if ($pt.config.chapter.prev.id == -1) {
					window.location.href = $pt.config.chapter.novel.url;
				} else {
					data = $pt.chapter.chapter.get($pt.config.chapter.novel.id, $pt.config.chapter.info.prevcid, basehash);
					var ndata = [];
					ndata.info = data;
					$pt.chapter.initchapter(ndata);
				}
			},
			get: function(novelid, chapterid, hash) {
				var data = JSON.parse(window.localStorage.getItem('ygbook_' + novelid + '_' + chapterid));
				if (data === null || data.content.length < 200) {
					if (hash == undefined){
						hash = basehash;
					};
					data = $pt.chapter.chapter._get(novelid, chapterid, hash);
					if (data === null || !data || data.content.length < 200) {
						data = $pt.chapter.chapter._get(novelid, chapterid, hash);
					}
					if (data === null || !data || data.content.length < 200) {
						data = $pt.chapter.chapter._get(novelid, chapterid, hash);
					}
				}
				return data;
			},
			_get: function(novelid, chapterid, hash) {
				var data = {};
				$.ajax({
					method: "POST",
					url: '/Home/Index/ajaxchapter.html',
					data: {
						id: novelid,
						cid: chapterid,
						basecid: basecid,
						eKey: hash
					},
					async: false,
					dataType: 'json',
					success: function(res) {
						if (res.status == 'success') {
							if (res.info.content.length > 20) {
								data = res.info;
								window.localStorage.setItem('ygbook_' + novelid + '_' + chapterid, JSON.stringify(res.info));
							}
						}
					}
				});
				return data;
			},
			_getasync: function(novelid, chapterid, hash) {
				var data = JSON.parse(window.localStorage.getItem('ygbook_' + novelid + '_' + chapterid));
				if (data === null || data.content.length < 20) {
					$.ajax({
						method: "POST",
						url: '/Home/Index/ajaxchapter.html',
						data: {
							id: novelid,
							cid: chapterid,
							basecid: basecid,
							eKey: hash
						},
						dataType: 'json',
						success: function(res) {
							if (res.status == 'success') {
								if (res.info.content.length > 200) {
									window.localStorage.setItem('ygbook_' + novelid + '_' + chapterid, JSON.stringify(res.info));
								}
							}
						}
					});
				}
			}
		}
	}
})($);