/*
 * cloudbeaver - Cloud Database Manager
 * Copyright (C) 2020 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0.
 * you may not use this file except in compliance with the License.
 */

export function Logo({ className }: { className?: string }) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="1755.653"
      height="681.132"
      version="1.1"
      viewBox="0 0 1755.653 681.132"
      xmlSpace="preserve"
      className={className}
    >
      <defs>
        <clipPath id="a" clipPathUnits="userSpaceOnUse">
          <path d="M0 510.849h1316.744V0H0z" />
        </clipPath>
      </defs>
      <g clipPath="url(#a)" transform="matrix(1.33333 0 0 -1.33333 0 681.132)">
        <path
          fill="#fff"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0c-11.554-43.547-23.476-80.873-52.434-80.873-6.928 0-49.101-124.76-78.318-144.295-31.844-21.29-50.706 63.057-52.989 77.931-3.745 24.4 9.109 66.364 43.598 153.652 9.618 43.617 35.719 84.078 85.487 87.189C-23.349 95.561 11.454 43.171 0 0"
          transform="translate(378.274 336.36)"
        />
        <path
          fill="#8a7363"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0s-10.356 29.535-11.507 52.549C-12.658 75.563-6.521 89.37-6.521 89.37S.767 68.274 28 47.945c27.233-20.328 25.699-8.438 26.849-6.136C56 44.11 54.466 57.535 48.712 72.11c-5.753 14.576-10.356 22.63-11.89 52.164-1.534 29.535 13.425 50.247 20.329 63.671 4.363 8.485 1.436 22.018-1.309 30.834a68.22 68.22 0 00-2.303 6.616 64.252 64.252 0 01-.833 2.057s.135-.156.391-.442a87.088 87.088 0 00-1.158 4.765c7.896-8.052 35.513-28.104 55.11-26.152 19.597 1.951 21.827 38.706 21.827 38.706 5.385-8.749 1.618-24.725.613-28.515.952.76 2.438 1.888 4.758 3.583 9.972 7.288 15.031 27.617 15.031 27.617-1.184 14.915-5.278 24.185-9.049 29.812-3.08-8.962-9.991-19.206-14.805-20.607-10.1-2.938-35.159 13.041-31.068 22.247 1.491 3.354 5.83 6.158 11.298 8.292-9.022-1.553-15.362.115-24.408-1.565-4.621-1.205-7.371-1.141-15.601-5.527-10.101-5.382-11.506-8.038-15.071-11.358-12.638-11.769-27.376-29.065-31.141-35.87-7.415-13.402-14.675-28.307 14.448-32.58-6.904-7.1-26.798 2.279-26.798 2.279S-20.41 156.206-25.06 100.771C-29.708 45.337-6.137 6.115 0 0"
          transform="translate(237.008 111.191)"
        />
        <path
          fill="#382924"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0c-6.176 2.316-22.046.755-33.195-3.598-5.469-2.135-9.807-4.939-11.298-8.293-4.091-9.205 20.968-25.185 31.068-22.246C-8.611-32.737-1.7-22.493 1.379-13.53 3.568-7.159 3.825-1.435 0 0"
          transform="translate(375.857 401.548)"
        />
        <path
          fill="#382924"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0c-2.862.365-8.778 1.164-10.667 3.304-4.224 4.784-10.995 6.069-15.917 4.986-5.217-1.147-7.993-7.218-4.412-14.767 1.611-3.397 1.203-7.489-.439-10.542 5.129 4.778 9.923 8.67 13.48 10.542C-10.945-2.79-4.727-.877 0 0"
          transform="translate(319.018 396.518)"
        />
        <path
          fill="#382924"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0s-5.114-17.388-8.694-25.315c-3.155-6.986-4.155-6.427-6.435-7.246.857 2.166 1.475 5.008 2.599 9.803 1.353 5.769 0 7.288 0 7.288-1.773-8.633-4.53-14.802-6.871-18.85-3.039-1.016-6.774-1.672-9.494-.584-3.835 1.534-4.487 19.562-4.487 20.585C-16.691-15.47-7.799-8.694 0 0m15.287 17.75c1.038 7.979.275 13.95.055 15.387-.033.218-.055.339-.055.339s-.031-.446-.113-1.211l.113 1.978S10.228 13.914.256 6.626c-2.32-1.695-3.806-2.823-4.758-3.583 1.005 3.79 4.772 19.766-.612 28.515 0 0-2.231-36.755-21.828-38.706-19.597-1.952-47.213 18.1-55.11 26.152a87.088 87.088 0 011.158-4.765c-.255.286-.391.442-.391.442s.328-.757.833-2.057a68.489 68.489 0 012.303-6.616c2.746-8.816 5.672-22.349 1.309-30.834-6.904-13.424-21.863-34.136-20.329-63.671 1.534-29.534 6.137-37.588 11.891-52.164 5.753-14.575 7.287-28 6.136-30.301-1.15-2.302.384-14.192-26.849 6.136-27.233 20.329-34.52 41.425-34.52 41.425s-6.137-13.807-4.987-36.821c1.151-23.014 11.507-52.549 11.507-52.549s-35.671 28.88-37.589 86.686c-1.765 53.187 29.362 114.639 34.35 124.125 2.071-4.425 5.538-7.337 10.323-8.674 0 0-13.864 7.606-3.697 37.237 10.166 29.631 30.52 55.982 51.156 67.61 20.635 11.628 38.023 11.117 57.201 2.934 0 0-25.059 23.547-58.317 3.435-19.109-11.557-31.831-24.379-40.588-37.521-7.343-1.311-16.272-.127-19.891-.127-4.577 0-11.637-3.103-8.445-14.337 3.125-11 11.75-22.125 11.049-28.378-.789-4.402-1.126-8.365-1.004-11.857-4.403-6.981-24.964-40.482-31.237-67.108 0 0 11.758 117.544-24.297 137.677-36.055 20.134-65.103 4.031-74.794-22.442-20.713-56.575 9.972-144.986 53.314-216.328 43.343-71.342 84.413-84.248 113.535-85.535 48.712-2.151 34.52 8.439 52.164 9.589 17.644 1.152 14.959-9.589 44.11-5.369 21.288 3.081 24.931 17.26 16.876 23.78-8.055 6.521-5.37 21.864 2.302 54.85C20.201-129.538 9.206-71.47 1.534-56.511-6.137-41.552-5.37-33.934 2.813-19.178 10.826-4.727 13.561 4.475 15.287 17.75"
          transform="translate(370.999 323.962)"
        />
        <path
          fill="#d03e16"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0h-27.64v178.376H0c9.697 0 14.618-7.162 14.618-18.122V18.125C14.618 6.915 10.363 0 0 0m7.999 206.608h-67.377V-28.231H7.999c21.149 0 38.357 17.208 38.357 38.357v158.127c0 21.15-17.208 38.355-38.357 38.355"
          transform="translate(520.257 148.031)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0h24.771c9.321 0 16.528-6.501 16.528-17.805v-49.804c0-10.876-6.207-18.125-14.617-18.125H0zm34.6 46.356c0-12.532-4.507-18.122-14.615-18.122H0v64.408h19.985c9.108 0 14.615-7.496 14.615-18.122zm25.399-28.948c4.1 6.264 6.342 13.515 6.342 20.949v44.162c0 21.079-16.627 37.927-38.039 38.355h-60.043s-.043-8.4 0-31.061c.1-53.195 0-203.779 0-203.779h68.539c5.327 0 11.999 2.703 11.999 2.703 14.414 5.843 24.241 19.801 24.241 35.655v65.802c0 9.986-4.895 19.88-13.039 27.214"
          transform="translate(620.837 233.765)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0v-44.021h-29.497V0c0 .216.084.344.151.412.224.062.407.122.404.143H-.474c.159-.047.289-.128.401-.078C-.052.44 0 .284 0 0m2.953 28.786h-35.402c-15.697 0-28.468-12.914-28.468-28.786v-117.157c0-15.697 12.771-28.469 28.468-28.469h64.19s0 28.185-21.189 28.231c-12.095.028-39.236-.017-39.236-.017-.227.039-.445.1-.677.166a.62.62 0 01-.136.089v44.905h61.238V0c0 15.872-12.914 28.786-28.788 28.786"
          transform="translate(770.255 265.426)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0v-61.717l-28.687-.012c-.227.039-.445.1-.677.166-.071.051-.141.09-.136.088l-.015 61.136a.615.615 0 00.156.193c.227.063.417.123.417.146zm2.952 84.469h-37.114c-21.71 0-22-28.232-22-28.232H-.474c.154-.047.305-.127.401-.078.021-.036.073-.192.073-.476V28.231h-32.452c-15.697 0-28.468-12.771-28.468-28.468v-61.238c0-15.697 12.771-28.468 28.468-28.468h64.19V55.683c0 15.872-12.914 28.786-28.786 28.786"
          transform="translate(877.959 209.743)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0l-19.673 104.809H-50.13l32.394-174.413h34.733l32.392 174.413H19.902z"
          transform="translate(963.251 189.403)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0c-1.286 0-3.419.023-5.931.052-9.126.099-16.976.167-20.723-.089-16.02-1.413-27.648-13.505-27.648-28.749v-145.626h31.421s.396 95.969 0 135.962c-.104 10.504-.111 10.328 7.756 10.554 7.133.206 10.09.412 13.456.436C15.332-27.343 15.332 0 15.332 0z"
          transform="translate(1182.488 294.212)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0v-8.893h8.893A8.893 8.893 0 000 0"
          transform="translate(848.445 156.877)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0v-8.893h8.893A8.893 8.893 0 000 0"
          transform="translate(740.687 156.877)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0h-8.893v-8.893A8.893 8.893 0 000 0"
          transform="translate(857.337 209.913)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0h-8.893v-8.893A8.893 8.893 0 000 0"
          transform="translate(749.58 266.09)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0v8.893h-8.893A8.893 8.893 0 000 0"
          transform="translate(770.255 257.197)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0v8.893h-8.893A8.893 8.893 0 000 0"
          transform="translate(878.019 257.197)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0v-44.021h-29.497V0c0 .216.084.344.151.412.224.062.407.122.404.143H-.474c.159-.047.289-.128.401-.078C-.052.44 0 .284 0 0m2.953 28.786h-35.402c-15.697 0-28.468-12.914-28.468-28.786v-117.157c0-15.697 12.771-28.469 28.468-28.469h64.19s0 28.185-21.189 28.231c-12.095.028-39.236-.017-39.236-.017-.227.039-.445.1-.677.166a.62.62 0 01-.136.089v44.905h61.238V0c0 15.872-12.914 28.786-28.788 28.786"
          transform="translate(1080.588 265.426)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0v-8.893h8.893A8.893 8.893 0 000 0"
          transform="translate(1051.02 156.877)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0h-8.893v-8.893A8.893 8.893 0 000 0"
          transform="translate(1059.913 266.09)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0h-8.893v-8.893A8.893 8.893 0 000 0"
          transform="translate(1164.437 266.34)"
        />
        <path
          fill="#382923"
          fillOpacity="1"
          fillRule="nonzero"
          stroke="none"
          d="M0 0v8.893h-8.893A8.893 8.893 0 000 0"
          transform="translate(1080.589 257.197)"
        />
      </g>
    </svg>
  );
}
