/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.Serializable;
import java.math.BigInteger;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.VerifyFunction;

public class BitcointVerifyFunction
implements VerifyFunction,
Serializable {
    private static final long serialVersionUID = -4137684978866266729L;

    @Override
    public boolean verify(Block block, boolean throwException) {
        BigInteger target = block.getDifficultyTargetAsInteger();
        BigInteger h = block.getHash().toBigInteger();
        if (h.compareTo(target) > 0) {
            if (throwException) {
                throw new VerificationException("Hash is higher than target: " + block.getHashAsString() + " vs " + target.toString(16));
            }
            return false;
        }
        return true;
    }
}

