/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VarInt;

public class GetBlocksMessage
extends Message {
    private static final long serialVersionUID = 3479412877853645644L;
    protected long version;
    protected List<Sha256Hash> locator;
    protected Sha256Hash stopHash;

    public GetBlocksMessage(NetworkParameters params, List<Sha256Hash> locator, Sha256Hash stopHash) {
        super(params);
        this.version = this.protocolVersion;
        this.locator = locator;
        this.stopHash = stopHash;
    }

    public GetBlocksMessage(NetworkParameters params, byte[] payload) throws ProtocolException {
        super(params, payload, 0);
    }

    @Override
    protected void parseLite() throws ProtocolException {
        this.cursor = this.offset;
        this.version = this.readUint32();
        int startCount = (int)this.readVarInt();
        if (startCount > 500) {
            throw new ProtocolException("Number of locators cannot be > 500, received: " + startCount);
        }
        this.length = this.cursor - this.offset + (startCount + 1) * 32;
    }

    @Override
    public void parse() throws ProtocolException {
        this.cursor = this.offset;
        this.version = this.readUint32();
        int startCount = (int)this.readVarInt();
        if (startCount > 500) {
            throw new ProtocolException("Number of locators cannot be > 500, received: " + startCount);
        }
        this.locator = new ArrayList<Sha256Hash>(startCount);
        for (int i = 0; i < startCount; ++i) {
            this.locator.add(this.readHash());
        }
        this.stopHash = this.readHash();
    }

    public List<Sha256Hash> getLocator() {
        return this.locator;
    }

    public Sha256Hash getStopHash() {
        return this.stopHash;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("getblocks: ");
        for (Sha256Hash hash : this.locator) {
            b.append(hash.toString());
            b.append(" ");
        }
        return b.toString();
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        Utils.uint32ToByteStreamLE(70002L, stream);
        stream.write(new VarInt(this.locator.size()).encode());
        for (Sha256Hash hash : this.locator) {
            stream.write(Utils.reverseBytes(hash.getBytes()));
        }
        stream.write(Utils.reverseBytes(this.stopHash.getBytes()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetBlocksMessage other = (GetBlocksMessage)o;
        return this.version == other.version && this.locator.size() == other.locator.size() && this.locator.containsAll(other.locator) && this.stopHash.equals(other.stopHash);
    }

    public int hashCode() {
        int hashCode = (int)this.version ^ "getblocks".hashCode();
        for (Sha256Hash aLocator : this.locator) {
            hashCode ^= aLocator.hashCode();
        }
        return hashCode ^= this.stopHash.hashCode();
    }
}

