/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import org.bitcoinj.core.Sha256Hash;

public class InventoryItem {
    static final int MESSAGE_LENGTH = 36;
    public final Type type;
    public final Sha256Hash hash;

    public InventoryItem(Type type, Sha256Hash hash) {
        this.type = type;
        this.hash = hash;
    }

    public String toString() {
        return this.type.toString() + ": " + this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryItem other = (InventoryItem)o;
        return this.type == other.type && this.hash.equals(other.hash);
    }

    public int hashCode() {
        return this.hash.hashCode() + this.type.ordinal();
    }

    public static enum Type {
        Error,
        Transaction,
        Block,
        FilteredBlock;

    }
}

