/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.subgraph.orchid.TorClient;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.AbstractPeerEventListener;
import org.bitcoinj.core.AbstractWalletEventListener;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.DownloadListener;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.GetDataMessage;
import org.bitcoinj.core.InventoryItem;
import org.bitcoinj.core.MemoryPool;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerEventListener;
import org.bitcoinj.core.PeerFilterProvider;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBroadcast;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.VersionMessage;
import org.bitcoinj.core.Wallet;
import org.bitcoinj.crypto.DRMWorkaround;
import org.bitcoinj.net.BlockingClientManager;
import org.bitcoinj.net.ClientConnectionManager;
import org.bitcoinj.net.FilterMerger;
import org.bitcoinj.net.NioClientManager;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.net.discovery.TorDiscovery;
import org.bitcoinj.script.Script;
import org.bitcoinj.utils.ExponentialBackoff;
import org.bitcoinj.utils.ListenerRegistration;
import org.bitcoinj.utils.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerGroup
extends AbstractExecutionThreadService
implements TransactionBroadcaster {
    private static final Logger log = LoggerFactory.getLogger(PeerGroup.class);
    private static final int DEFAULT_CONNECTIONS = 4;
    private static final int TOR_TIMEOUT_SECONDS = 60;
    private int maxPeersToDiscoverCount = 100;
    protected final ReentrantLock lock = Threading.lock("peergroup");
    @GuardedBy(value="lock")
    private final PriorityQueue<PeerAddress> inactives;
    @GuardedBy(value="lock")
    private final Map<PeerAddress, ExponentialBackoff> backoffMap;
    private final CopyOnWriteArrayList<Peer> peers;
    private final CopyOnWriteArrayList<Peer> pendingPeers;
    private final ClientConnectionManager channels;
    @Nullable
    private final TorClient torClient;
    @GuardedBy(value="lock")
    private Peer downloadPeer;
    @Nullable
    @GuardedBy(value="lock")
    private PeerEventListener downloadListener;
    private final CopyOnWriteArrayList<ListenerRegistration<PeerEventListener>> peerEventListeners;
    private final CopyOnWriteArraySet<PeerDiscovery> peerDiscoverers;
    @GuardedBy(value="lock")
    private VersionMessage versionMessage;
    @GuardedBy(value="lock")
    private boolean downloadTxDependencies;
    private final MemoryPool memoryPool;
    @GuardedBy(value="lock")
    private int maxConnections;
    private volatile int vMinRequiredProtocolVersion = 70000;
    private volatile Timer vPingTimer;
    public static final long DEFAULT_PING_INTERVAL_MSEC = 2000L;
    private long pingIntervalMsec = 2000L;
    @GuardedBy(value="lock")
    private boolean useLocalhostPeerWhenPossible = true;
    @GuardedBy(value="lock")
    private boolean ipv6Unreachable = false;
    private final NetworkParameters params;
    private final AbstractBlockChain chain;
    @GuardedBy(value="lock")
    private long fastCatchupTimeSecs;
    private final CopyOnWriteArrayList<Wallet> wallets;
    private final CopyOnWriteArrayList<PeerFilterProvider> peerFilterProviders;
    private final AbstractPeerEventListener peerListener = new AbstractPeerEventListener(){

        @Override
        public List<Message> getData(Peer peer, GetDataMessage m) {
            return PeerGroup.this.handleGetData(m);
        }

        @Override
        public void onBlocksDownloaded(Peer peer, Block block, int blocksLeft) {
            double target;
            double rate = ((AbstractBlockChain)Preconditions.checkNotNull((Object)PeerGroup.this.chain)).getFalsePositiveRate();
            if (rate > (target = PeerGroup.this.bloomFilterMerger.getBloomFilterFPRate() * 2.0)) {
                if (log.isDebugEnabled()) {
                    log.debug("Force update Bloom filter due to high false positive rate ({} vs {})", (Object)rate, (Object)target);
                }
                PeerGroup.this.recalculateFastCatchupAndFilter(FilterRecalculateMode.FORCE_SEND_FOR_REFRESH);
            }
        }
    };
    private int minBroadcastConnections = 0;
    private final AbstractWalletEventListener walletEventListener = new AbstractWalletEventListener(){
        @GuardedBy(value="this")
        private boolean sendIfChangedQueued;
        @GuardedBy(value="this")
        private boolean dontSendQueued;
        private Runnable bloomSendIfChanged = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PeerGroup.this.recalculateFastCatchupAndFilter(FilterRecalculateMode.SEND_IF_CHANGED);
                AbstractWalletEventListener abstractWalletEventListener = PeerGroup.this.walletEventListener;
                synchronized (abstractWalletEventListener) {
                    sendIfChangedQueued = false;
                }
            }
        };
        private Runnable bloomDontSend = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PeerGroup.this.recalculateFastCatchupAndFilter(FilterRecalculateMode.DONT_SEND);
                AbstractWalletEventListener abstractWalletEventListener = PeerGroup.this.walletEventListener;
                synchronized (abstractWalletEventListener) {
                    dontSendQueued = false;
                }
            }
        };

        private synchronized void queueRecalc(boolean andTransmit) {
            if (andTransmit) {
                if (!this.sendIfChangedQueued) {
                    log.info("Queuing recalc of the Bloom filter due to new keys or scripts becoming available");
                    this.sendIfChangedQueued = true;
                    Uninterruptibles.putUninterruptibly((BlockingQueue)PeerGroup.this.jobQueue, (Object)this.bloomSendIfChanged);
                }
            } else if (!this.dontSendQueued) {
                log.info("Queuing recalc of the Bloom filter due to observing a pay to pubkey output on a relevant tx");
                this.dontSendQueued = true;
                Uninterruptibles.putUninterruptibly((BlockingQueue)PeerGroup.this.jobQueue, (Object)this.bloomDontSend);
            }
        }

        @Override
        public void onScriptsChanged(Wallet wallet, List<Script> scripts, boolean isAddingScripts) {
            this.queueRecalc(true);
        }

        @Override
        public void onKeysAdded(List<ECKey> keys) {
            this.queueRecalc(true);
        }

        @Override
        public void onCoinsReceived(Wallet wallet, Transaction tx, Coin prevBalance, Coin newBalance) {
            for (TransactionOutput output : tx.getOutputs()) {
                if (!output.getScriptPubKey().isSentToRawPubKey() || !output.isMine(wallet)) continue;
                if (tx.getConfidence().getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING) {
                    this.queueRecalc(true);
                } else {
                    this.queueRecalc(false);
                }
                return;
            }
        }
    };
    private ExponentialBackoff.Params peerBackoffParams = new ExponentialBackoff.Params(1000L, 1.5f, 600000L);
    private ExponentialBackoff groupBackoff = new ExponentialBackoff(new ExponentialBackoff.Params(1000L, 1.5f, 10000L));
    private LinkedBlockingQueue<Runnable> jobQueue = new LinkedBlockingQueue();
    private final Set<TransactionBroadcast> runningBroadcasts;
    @VisibleForTesting
    PeerEventListener startupListener = new PeerStartupListener();
    public static final double DEFAULT_BLOOM_FILTER_FP_RATE = 5.0E-4;
    public static final double MAX_FP_RATE_INCREASE = 2.0;
    private FilterMerger bloomFilterMerger;
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 5000;
    private volatile int vConnectTimeoutMillis = 5000;
    private Runnable triggerConnectionsJob = new Runnable(){

        @Override
        public void run() {
            do {
                try {
                    PeerGroup.this.connectToAnyPeer();
                }
                catch (PeerDiscoveryException e) {
                    PeerGroup.this.groupBackoff.trackFailure();
                }
            } while (PeerGroup.this.isRunning() && PeerGroup.this.countConnectedAndPendingPeers() < PeerGroup.this.getMaxConnections());
        }
    };
    private LocalhostCheckState localhostCheckState = LocalhostCheckState.NOT_TRIED;

    public PeerGroup(NetworkParameters params) {
        this(params, null);
    }

    public PeerGroup(NetworkParameters params, @Nullable AbstractBlockChain chain) {
        this(params, chain, new NioClientManager());
    }

    public static PeerGroup newWithTor(NetworkParameters params, @Nullable AbstractBlockChain chain, TorClient torClient) throws TimeoutException {
        Preconditions.checkNotNull((Object)torClient);
        DRMWorkaround.maybeDisableExportControls();
        BlockingClientManager manager = new BlockingClientManager(torClient.getSocketFactory());
        int CONNECT_TIMEOUT_MSEC = 60000;
        manager.setConnectTimeoutMillis(60000);
        PeerGroup result = new PeerGroup(params, chain, manager, torClient);
        result.setConnectTimeoutMillis(60000);
        result.addPeerDiscovery(new TorDiscovery(params, torClient));
        return result;
    }

    public PeerGroup(NetworkParameters params, @Nullable AbstractBlockChain chain, ClientConnectionManager connectionManager) {
        this(params, chain, connectionManager, null);
    }

    private PeerGroup(NetworkParameters params, @Nullable AbstractBlockChain chain, ClientConnectionManager connectionManager, @Nullable TorClient torClient) {
        this.params = (NetworkParameters)Preconditions.checkNotNull((Object)params);
        this.chain = chain;
        this.fastCatchupTimeSecs = params.getGenesisBlock().getTimeSeconds();
        this.wallets = new CopyOnWriteArrayList();
        this.peerFilterProviders = new CopyOnWriteArrayList();
        this.torClient = torClient;
        this.maxConnections = 0;
        int height = chain == null ? 0 : chain.getBestChainHeight();
        this.versionMessage = new VersionMessage(params, height);
        this.versionMessage.relayTxesBeforeFilter = true;
        this.downloadTxDependencies = true;
        this.memoryPool = new MemoryPool();
        this.inactives = new PriorityQueue<PeerAddress>(1, new Comparator<PeerAddress>(){

            @Override
            public int compare(PeerAddress a, PeerAddress b) {
                int result = ((ExponentialBackoff)PeerGroup.this.backoffMap.get(a)).compareTo((ExponentialBackoff)PeerGroup.this.backoffMap.get(b));
                if (result == 0) {
                    result = Ints.compare((int)a.getPort(), (int)b.getPort());
                }
                return result;
            }
        });
        this.backoffMap = new HashMap<PeerAddress, ExponentialBackoff>();
        this.peers = new CopyOnWriteArrayList();
        this.pendingPeers = new CopyOnWriteArrayList();
        this.channels = connectionManager;
        this.peerDiscoverers = new CopyOnWriteArraySet();
        this.peerEventListeners = new CopyOnWriteArrayList();
        this.runningBroadcasts = Collections.synchronizedSet(new HashSet());
        this.bloomFilterMerger = new FilterMerger(5.0E-4);
    }

    public void setMaxConnections(int maxConnections) {
        this.lock.lock();
        try {
            this.maxConnections = maxConnections;
            if (!this.isRunning()) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        int adjustment = maxConnections - this.channels.getConnectedClientCount();
        if (adjustment > 0) {
            this.triggerConnections();
        }
        if (adjustment < 0) {
            this.channels.closeConnections(-adjustment);
        }
    }

    public void setDownloadTxDependencies(boolean downloadTxDependencies) {
        this.lock.lock();
        try {
            this.downloadTxDependencies = downloadTxDependencies;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void triggerConnections() {
        Uninterruptibles.putUninterruptibly(this.jobQueue, (Object)this.triggerConnectionsJob);
    }

    public int getMaxConnections() {
        this.lock.lock();
        try {
            int n = this.maxConnections;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message> handleGetData(GetDataMessage m) {
        this.lock.lock();
        try {
            LinkedList<Message> transactions = new LinkedList<Message>();
            LinkedList<InventoryItem> items = new LinkedList<InventoryItem>(m.getItems());
            Iterator it = items.iterator();
            block3: while (it.hasNext()) {
                InventoryItem item = (InventoryItem)it.next();
                Transaction tx = this.memoryPool.get(item.hash);
                if (tx != null) {
                    transactions.add(tx);
                    it.remove();
                    continue;
                }
                for (Wallet w : this.wallets) {
                    tx = w.getTransaction(item.hash);
                    if (tx == null) continue;
                    transactions.add(tx);
                    it.remove();
                    continue block3;
                }
            }
            LinkedList<Message> linkedList = transactions;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setVersionMessage(VersionMessage ver) {
        this.lock.lock();
        try {
            this.versionMessage = ver;
        }
        finally {
            this.lock.unlock();
        }
    }

    public VersionMessage getVersionMessage() {
        this.lock.lock();
        try {
            VersionMessage versionMessage = this.versionMessage;
            return versionMessage;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUserAgent(String name, String version, @Nullable String comments) {
        int height = this.chain == null ? 0 : this.chain.getBestChainHeight();
        VersionMessage ver = new VersionMessage(this.params, height);
        ver.relayTxesBeforeFilter = false;
        this.updateVersionMessageRelayTxesBeforeFilter(ver);
        ver.appendToSubVer(name, version, comments);
        this.setVersionMessage(ver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVersionMessageRelayTxesBeforeFilter(VersionMessage ver) {
        this.lock.lock();
        try {
            boolean spvMode = this.chain != null && !this.chain.shouldVerifyTransactions();
            boolean willSendFilter = spvMode && this.peerFilterProviders.size() > 0;
            ver.relayTxesBeforeFilter = !willSendFilter;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUserAgent(String name, String version) {
        this.setUserAgent(name, version, null);
    }

    public void addEventListener(PeerEventListener listener, Executor executor) {
        this.peerEventListeners.add(new ListenerRegistration<Object>(Preconditions.checkNotNull((Object)listener), executor));
        for (Peer peer : this.getConnectedPeers()) {
            peer.addEventListener(listener, executor);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.addEventListener(listener, executor);
        }
    }

    public void addEventListener(PeerEventListener listener) {
        this.addEventListener(listener, Threading.USER_THREAD);
    }

    public boolean removeEventListener(PeerEventListener listener) {
        boolean result = ListenerRegistration.removeFromList(listener, this.peerEventListeners);
        for (Peer peer : this.getConnectedPeers()) {
            peer.removeEventListener(listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.removeEventListener(listener);
        }
        return result;
    }

    public void clearEventListeners() {
        this.peerEventListeners.clear();
    }

    public List<Peer> getConnectedPeers() {
        this.lock.lock();
        try {
            ArrayList<Peer> arrayList = new ArrayList<Peer>(this.peers);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Peer> getPendingPeers() {
        this.lock.lock();
        try {
            ArrayList<Peer> arrayList = new ArrayList<Peer>(this.pendingPeers);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addAddress(PeerAddress peerAddress) {
        int newMax;
        this.lock.lock();
        try {
            this.addInactive(peerAddress);
            newMax = this.getMaxConnections() + 1;
        }
        finally {
            this.lock.unlock();
        }
        this.setMaxConnections(newMax);
    }

    private void addInactive(PeerAddress peerAddress) {
        if (this.backoffMap.containsKey(peerAddress)) {
            return;
        }
        this.backoffMap.put(peerAddress, new ExponentialBackoff(this.peerBackoffParams));
        this.inactives.offer(peerAddress);
    }

    public void addAddress(InetAddress address) {
        this.addAddress(new PeerAddress(address, this.params.getPort()));
    }

    public void addPeerDiscovery(PeerDiscovery peerDiscovery) {
        this.lock.lock();
        try {
            if (this.getMaxConnections() == 0) {
                this.setMaxConnections(4);
            }
            this.peerDiscoverers.add(peerDiscovery);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discoverPeers() throws PeerDiscoveryException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (this.peerDiscoverers.isEmpty()) {
            throw new PeerDiscoveryException("No peer discoverers registered");
        }
        long start = System.currentTimeMillis();
        LinkedList addressList = Lists.newLinkedList();
        for (PeerDiscovery peerDiscovery : this.peerDiscoverers) {
            InetSocketAddress[] addresses;
            this.lock.unlock();
            try {
                addresses = peerDiscovery.getPeers(5L, TimeUnit.SECONDS);
            }
            finally {
                this.lock.lock();
            }
            for (InetSocketAddress address : addresses) {
                addressList.add(new PeerAddress(address));
            }
            if (addressList.size() < this.maxPeersToDiscoverCount) continue;
            break;
        }
        for (PeerAddress address : addressList) {
            this.addInactive(address);
        }
        final ImmutableSet peersDiscoveredSet = ImmutableSet.copyOf((Collection)addressList);
        for (final ListenerRegistration<PeerEventListener> registration : this.peerEventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((PeerEventListener)registration.listener).onPeersDiscovered((Set<PeerAddress>)peersDiscoveredSet);
                }
            });
        }
        log.info("Peer discovery took {}msec and returned {} items", (Object)(System.currentTimeMillis() - start), (Object)addressList.size());
    }

    protected void run() throws Exception {
        while (this.isRunning()) {
            this.jobQueue.take().run();
        }
    }

    @VisibleForTesting
    void waitForJobQueue() {
        final CountDownLatch latch = new CountDownLatch(1);
        Uninterruptibles.putUninterruptibly(this.jobQueue, (Object)new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
    }

    private int countConnectedAndPendingPeers() {
        this.lock.lock();
        try {
            int n = this.peers.size() + this.pendingPeers.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean maybeCheckForLocalhostPeer() {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (this.localhostCheckState == LocalhostCheckState.NOT_TRIED) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(InetAddresses.forString((String)"127.0.0.1"), this.params.getPort()), this.vConnectTimeoutMillis);
                this.localhostCheckState = LocalhostCheckState.FOUND;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            catch (IOException e) {
                log.info("Localhost peer not detected.");
                this.localhostCheckState = LocalhostCheckState.NOT_THERE;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectToAnyPeer() throws PeerDiscoveryException {
        long retryTime;
        long nowMillis;
        PeerAddress addr;
        block12: {
            block11: {
                Service.State state = this.state();
                if (state != Service.State.STARTING && state != Service.State.RUNNING) {
                    return;
                }
                addr = null;
                nowMillis = Utils.currentTimeMillis();
                retryTime = 0L;
                this.lock.lock();
                if (!this.useLocalhostPeerWhenPossible || !this.maybeCheckForLocalhostPeer()) break block11;
                log.info("Localhost peer detected, trying to use it instead of P2P discovery");
                this.maxConnections = 0;
                this.connectToLocalHost();
                retryTime = Math.max(retryTime, this.groupBackoff.getRetryTime());
                this.lock.unlock();
                if (retryTime > nowMillis) {
                    long millis = retryTime - nowMillis;
                    log.info("Waiting {} msec before next connect attempt {}", (Object)millis, (Object)(addr == null ? "" : "to " + addr));
                    Utils.sleep(millis);
                }
                return;
            }
            if (!this.haveReadyInactivePeer(nowMillis)) {
                this.discoverPeers();
                this.groupBackoff.trackSuccess();
                nowMillis = Utils.currentTimeMillis();
            }
            if (this.inactives.size() != 0) break block12;
            log.debug("Peer discovery didn't provide us any more peers, not trying to build new connection.");
            retryTime = Math.max(retryTime, this.groupBackoff.getRetryTime());
            this.lock.unlock();
            if (retryTime > nowMillis) {
                long millis = retryTime - nowMillis;
                log.info("Waiting {} msec before next connect attempt {}", (Object)millis, (Object)(addr == null ? "" : "to " + addr));
                Utils.sleep(millis);
            }
            return;
        }
        try {
            while (addr == null || this.ipv6Unreachable && addr.getAddr() instanceof Inet6Address) {
                addr = this.inactives.poll();
            }
            retryTime = this.backoffMap.get(addr).getRetryTime();
        }
        catch (Throwable throwable) {
            retryTime = Math.max(retryTime, this.groupBackoff.getRetryTime());
            this.lock.unlock();
            if (retryTime > nowMillis) {
                long millis = retryTime - nowMillis;
                log.info("Waiting {} msec before next connect attempt {}", (Object)millis, (Object)(addr == null ? "" : "to " + addr));
                Utils.sleep(millis);
            }
            throw throwable;
        }
        retryTime = Math.max(retryTime, this.groupBackoff.getRetryTime());
        this.lock.unlock();
        if (retryTime > nowMillis) {
            long millis = retryTime - nowMillis;
            log.info("Waiting {} msec before next connect attempt {}", (Object)millis, (Object)(addr == null ? "" : "to " + addr));
            Utils.sleep(millis);
        }
        Preconditions.checkNotNull((Object)addr);
        this.connectTo(addr, false, this.vConnectTimeoutMillis);
    }

    private boolean haveReadyInactivePeer(long nowMillis) {
        if (this.inactives.size() == 0) {
            return false;
        }
        return this.backoffMap.get(this.inactives.peek()).getRetryTime() <= nowMillis;
    }

    protected void startUp() throws Exception {
        if (this.chain == null) {
            log.warn("Starting up with no attached block chain. Did you forget to pass one to the constructor?");
        }
        this.vPingTimer = new Timer("Peer pinging thread", true);
        if (this.torClient != null) {
            log.info("Starting Tor/Orchid ...");
            this.torClient.start();
            this.torClient.waitUntilReady(60000L);
            log.info("Tor ready");
        }
        this.channels.startAsync();
        this.channels.awaitRunning();
        this.triggerConnections();
    }

    protected void shutDown() throws Exception {
        this.vPingTimer.cancel();
        this.channels.stopAsync();
        this.channels.awaitTerminated();
        for (PeerDiscovery peerDiscovery : this.peerDiscoverers) {
            peerDiscovery.shutdown();
        }
        if (this.torClient != null) {
            this.torClient.stop();
        }
    }

    protected void triggerShutdown() {
        Uninterruptibles.putUninterruptibly(this.jobQueue, (Object)new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWallet(Wallet wallet) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)wallet);
            Preconditions.checkState((!this.wallets.contains(wallet) ? 1 : 0) != 0);
            this.wallets.add(wallet);
            wallet.setTransactionBroadcaster(this);
            wallet.addEventListener(this.walletEventListener, Threading.SAME_THREAD);
            this.addPeerFilterProvider(wallet);
            for (Peer peer : this.peers) {
                peer.addWallet(wallet);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addPeerFilterProvider(PeerFilterProvider provider) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)provider);
            Preconditions.checkState((!this.peerFilterProviders.contains(provider) ? 1 : 0) != 0);
            this.peerFilterProviders.add(0, provider);
            this.recalculateFastCatchupAndFilter(FilterRecalculateMode.SEND_IF_CHANGED);
            this.updateVersionMessageRelayTxesBeforeFilter(this.getVersionMessage());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removePeerFilterProvider(PeerFilterProvider provider) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)provider);
            Preconditions.checkArgument((boolean)this.peerFilterProviders.remove(provider));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeWallet(Wallet wallet) {
        this.wallets.remove(Preconditions.checkNotNull((Object)wallet));
        this.peerFilterProviders.remove(wallet);
        wallet.removeEventListener(this.walletEventListener);
        wallet.setTransactionBroadcaster(null);
        for (Peer peer : this.peers) {
            peer.removeWallet(wallet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculateFastCatchupAndFilter(FilterRecalculateMode mode) {
        this.lock.lock();
        try {
            boolean send;
            if (this.chain != null && this.chain.shouldVerifyTransactions()) {
                return;
            }
            FilterMerger.Result result = this.bloomFilterMerger.calculate((ImmutableList<PeerFilterProvider>)ImmutableList.copyOf(this.peerFilterProviders));
            switch (mode) {
                case SEND_IF_CHANGED: {
                    send = result.changed;
                    break;
                }
                case DONT_SEND: {
                    send = false;
                    break;
                }
                case FORCE_SEND_FOR_REFRESH: {
                    send = true;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (send) {
                for (Peer peer : this.peers) {
                    peer.setBloomFilter(result.filter, mode != FilterRecalculateMode.FORCE_SEND_FOR_REFRESH);
                }
                if (this.chain != null) {
                    this.chain.resetFalsePositiveEstimate();
                }
            }
            this.setFastCatchupTimeSecs(result.earliestKeyTimeSecs);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setBloomFilterFalsePositiveRate(double bloomFilterFPRate) {
        this.lock.lock();
        try {
            this.bloomFilterMerger.setBloomFilterFPRate(bloomFilterFPRate);
            this.recalculateFastCatchupAndFilter(FilterRecalculateMode.SEND_IF_CHANGED);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int numConnectedPeers() {
        return this.peers.size();
    }

    @Nullable
    public Peer connectTo(InetSocketAddress address) {
        PeerAddress peerAddress = new PeerAddress(address);
        this.backoffMap.put(peerAddress, new ExponentialBackoff(this.peerBackoffParams));
        return this.connectTo(peerAddress, true, this.vConnectTimeoutMillis);
    }

    @Nullable
    public Peer connectToLocalHost() {
        PeerAddress localhost = PeerAddress.localhost(this.params);
        this.backoffMap.put(localhost, new ExponentialBackoff(this.peerBackoffParams));
        return this.connectTo(localhost, true, this.vConnectTimeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Peer connectTo(PeerAddress address, boolean incrementMaxConnections, int connectTimeoutMillis) {
        VersionMessage ver = this.getVersionMessage().duplicate();
        ver.bestHeight = this.chain == null ? 0L : (long)this.chain.getBestChainHeight();
        ver.time = Utils.currentTimeSeconds();
        Peer peer = new Peer(this.params, ver, address, this.chain, this.memoryPool, this.downloadTxDependencies);
        peer.addEventListener(this.startupListener, Threading.SAME_THREAD);
        peer.setMinProtocolVersion(this.vMinRequiredProtocolVersion);
        this.pendingPeers.add(peer);
        try {
            this.channels.openConnection(address.toSocketAddress(), peer);
        }
        catch (Exception e) {
            log.warn("Failed to connect to " + address + ": " + e.getMessage());
            this.handlePeerDeath(peer, e);
            return null;
        }
        peer.setSocketTimeout(connectTimeoutMillis);
        if (incrementMaxConnections) {
            this.lock.lock();
            try {
                ++this.maxConnections;
            }
            finally {
                this.lock.unlock();
            }
        }
        return peer;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.vConnectTimeoutMillis = connectTimeoutMillis;
    }

    public void startBlockChainDownload(PeerEventListener listener) {
        this.lock.lock();
        try {
            if (this.downloadPeer != null && this.downloadListener != null) {
                this.downloadPeer.removeEventListener(this.downloadListener);
            }
            if (this.downloadPeer != null && listener != null) {
                this.downloadPeer.addEventListener(listener);
            }
            this.downloadListener = listener;
            if (!this.peers.isEmpty()) {
                this.startBlockChainDownloadFromPeer(this.peers.iterator().next());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void downloadBlockChain() {
        DownloadListener listener = new DownloadListener();
        this.startBlockChainDownload(listener);
        try {
            listener.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewPeer(final Peer peer) {
        int newSize = -1;
        this.lock.lock();
        try {
            this.groupBackoff.trackSuccess();
            this.backoffMap.get(peer.getAddress()).trackSuccess();
            log.info("{}: New peer", (Object)peer);
            this.pendingPeers.remove(peer);
            this.peers.add(peer);
            newSize = this.peers.size();
            if (this.bloomFilterMerger.getLastFilter() != null) {
                peer.setBloomFilter(this.bloomFilterMerger.getLastFilter());
            }
            peer.setDownloadData(false);
            for (Wallet wallet : this.wallets) {
                peer.addWallet(wallet);
            }
            Peer newDownloadPeer = this.selectDownloadPeer(this.peers);
            if (this.downloadPeer != newDownloadPeer) {
                boolean shouldDownloadChain;
                this.setDownloadPeer(newDownloadPeer);
                boolean bl = shouldDownloadChain = this.downloadListener != null && this.chain != null;
                if (shouldDownloadChain) {
                    this.startBlockChainDownloadFromPeer(this.downloadPeer);
                }
            }
            peer.addEventListener(this.peerListener, Threading.SAME_THREAD);
            for (final ListenerRegistration<PeerEventListener> registration : this.peerEventListeners) {
                peer.addEventListenerWithoutOnDisconnect((PeerEventListener)registration.listener, registration.executor);
            }
            this.setupPingingForNewPeer(peer);
        }
        finally {
            this.lock.unlock();
        }
        final int fNewSize = newSize;
        for (final ListenerRegistration<PeerEventListener> registration : this.peerEventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((PeerEventListener)registration.listener).onPeerConnected(peer, fNewSize);
                }
            });
        }
    }

    private void setupPingingForNewPeer(final Peer peer) {
        Runnable[] pingRunnable;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (peer.getPeerVersionMessage().clientVersion < 60001) {
            return;
        }
        if (this.getPingIntervalMsec() <= 0L) {
            return;
        }
        pingRunnable = new Runnable[]{new Runnable(){
            private boolean firstRun = true;

            @Override
            public void run() {
                if (this.firstRun) {
                    this.firstRun = false;
                    try {
                        peer.ping().addListener((Runnable)this, Threading.SAME_THREAD);
                    }
                    catch (Exception e) {
                        log.warn("{}: Exception whilst trying to ping peer: {}", (Object)peer, (Object)e.toString());
                        return;
                    }
                    return;
                }
                long interval = PeerGroup.this.getPingIntervalMsec();
                if (interval <= 0L) {
                    return;
                }
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            if (!PeerGroup.this.peers.contains(peer) || !PeerGroup.this.isRunning()) {
                                return;
                            }
                            peer.ping().addListener(pingRunnable[0], Threading.SAME_THREAD);
                        }
                        catch (Exception e) {
                            log.warn("{}: Exception whilst trying to ping peer: {}", (Object)peer, (Object)e.toString());
                        }
                    }
                };
                try {
                    PeerGroup.this.vPingTimer.schedule(task, interval);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }};
        pingRunnable[0].run();
    }

    private void setDownloadPeer(@Nullable Peer peer) {
        this.lock.lock();
        try {
            if (this.downloadPeer == peer) {
                return;
            }
            if (this.chain == null) {
                this.downloadPeer = peer;
                return;
            }
            if (this.downloadPeer != null) {
                log.info("Unsetting download peer: {}", (Object)this.downloadPeer);
                if (this.downloadListener != null) {
                    this.downloadPeer.removeEventListener(this.downloadListener);
                }
                this.downloadPeer.setDownloadData(false);
            }
            this.downloadPeer = peer;
            if (this.downloadPeer != null) {
                log.info("Setting download peer: {}", (Object)this.downloadPeer);
                if (this.downloadListener != null) {
                    peer.addEventListener(this.downloadListener, Threading.SAME_THREAD);
                }
                this.downloadPeer.setDownloadData(true);
                this.downloadPeer.setDownloadParameters(this.fastCatchupTimeSecs, this.bloomFilterMerger.getLastFilter() != null);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public MemoryPool getMemoryPool() {
        return this.memoryPool;
    }

    public void setFastCatchupTimeSecs(long secondsSinceEpoch) {
        this.lock.lock();
        try {
            Preconditions.checkState((this.chain == null || !this.chain.shouldVerifyTransactions() ? 1 : 0) != 0, (Object)"Fast catchup is incompatible with fully verifying");
            this.fastCatchupTimeSecs = secondsSinceEpoch;
            if (this.downloadPeer != null) {
                this.downloadPeer.setDownloadParameters(secondsSinceEpoch, this.bloomFilterMerger.getLastFilter() != null);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getFastCatchupTimeSecs() {
        this.lock.lock();
        try {
            long l = this.fastCatchupTimeSecs;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePeerDeath(final Peer peer, @Nullable Exception exception) {
        Service.State state = this.state();
        if (state != Service.State.RUNNING && state != Service.State.STARTING) {
            return;
        }
        int numConnectedPeers = 0;
        this.lock.lock();
        try {
            this.pendingPeers.remove(peer);
            this.peers.remove(peer);
            PeerAddress address = peer.getAddress();
            log.info("{}: Peer died", (Object)address);
            if (peer == this.downloadPeer) {
                log.info("Download peer died. Picking a new one.");
                this.setDownloadPeer(null);
                Peer newDownloadPeer = this.selectDownloadPeer(this.peers);
                if (newDownloadPeer != null) {
                    this.setDownloadPeer(newDownloadPeer);
                    if (this.downloadListener != null) {
                        this.startBlockChainDownloadFromPeer(newDownloadPeer);
                    }
                }
            }
            int numPeers = this.peers.size() + this.pendingPeers.size();
            numConnectedPeers = this.peers.size();
            this.groupBackoff.trackFailure();
            if (!(exception instanceof NoRouteToHostException)) {
                if (address.getAddr() instanceof Inet6Address && !this.ipv6Unreachable) {
                    this.ipv6Unreachable = true;
                    log.warn("IPv6 peer connect failed due to routing failure, ignoring IPv6 addresses from now on");
                }
                this.backoffMap.get(address).trackFailure();
                this.inactives.offer(address);
            }
            if (numPeers < this.getMaxConnections()) {
                this.triggerConnections();
            }
        }
        finally {
            this.lock.unlock();
        }
        peer.removeEventListener(this.peerListener);
        for (Wallet wallet : this.wallets) {
            peer.removeWallet(wallet);
        }
        final int fNumConnectedPeers = numConnectedPeers;
        for (final ListenerRegistration<PeerEventListener> registration : this.peerEventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((PeerEventListener)registration.listener).onPeerDisconnected(peer, fNumConnectedPeers);
                }
            });
            peer.removeEventListener((PeerEventListener)registration.listener);
        }
    }

    private void startBlockChainDownloadFromPeer(Peer peer) {
        this.lock.lock();
        try {
            this.setDownloadPeer(peer);
            peer.startBlockChainDownload();
        }
        finally {
            this.lock.unlock();
        }
    }

    public ListenableFuture<List<Peer>> waitForPeers(int numPeers) {
        return this.waitForPeersOfVersion(numPeers, 0L);
    }

    public ListenableFuture<List<Peer>> waitForPeersOfVersion(final int numPeers, final long protocolVersion) {
        List<Peer> foundPeers = this.findPeersOfAtLeastVersion(protocolVersion);
        if (foundPeers.size() >= numPeers) {
            return Futures.immediateFuture(foundPeers);
        }
        final SettableFuture future = SettableFuture.create();
        this.addEventListener(new AbstractPeerEventListener(){

            @Override
            public void onPeerConnected(Peer peer, int peerCount) {
                List<Peer> peers = PeerGroup.this.findPeersOfAtLeastVersion(protocolVersion);
                if (peers.size() >= numPeers) {
                    future.set(peers);
                    PeerGroup.this.removeEventListener(this);
                }
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Peer> findPeersOfAtLeastVersion(long protocolVersion) {
        this.lock.lock();
        try {
            ArrayList<Peer> results = new ArrayList<Peer>(this.peers.size());
            for (Peer peer : this.peers) {
                if ((long)peer.getPeerVersionMessage().clientVersion < protocolVersion) continue;
                results.add(peer);
            }
            ArrayList<Peer> arrayList = results;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getMinBroadcastConnections() {
        this.lock.lock();
        try {
            if (this.minBroadcastConnections == 0) {
                int max = this.getMaxConnections();
                if (max <= 1) {
                    int n = max;
                    return n;
                }
                int n = (int)Math.round((double)this.getMaxConnections() / 2.0);
                return n;
            }
            int n = this.minBroadcastConnections;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMinBroadcastConnections(int value) {
        this.lock.lock();
        try {
            this.minBroadcastConnections = value;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ListenableFuture<Transaction> broadcastTransaction(Transaction tx) {
        return this.broadcastTransaction(tx, Math.max(1, this.getMinBroadcastConnections()));
    }

    public ListenableFuture<Transaction> broadcastTransaction(Transaction tx, int minConnections) {
        final TransactionBroadcast broadcast = new TransactionBroadcast(this, tx);
        broadcast.setMinConnections(minConnections);
        Futures.addCallback(broadcast.future(), (FutureCallback)new FutureCallback<Transaction>(){

            public void onSuccess(Transaction transaction) {
                PeerGroup.this.runningBroadcasts.remove(broadcast);
                for (Wallet wallet : PeerGroup.this.wallets) {
                    try {
                        wallet.receivePending(transaction, null);
                    }
                    catch (VerificationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void onFailure(Throwable throwable) {
                PeerGroup.this.runningBroadcasts.remove(broadcast);
                throw new RuntimeException(throwable);
            }
        });
        this.runningBroadcasts.add(broadcast);
        broadcast.broadcast();
        return broadcast.future();
    }

    public long getPingIntervalMsec() {
        this.lock.lock();
        try {
            long l = this.pingIntervalMsec;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setPingIntervalMsec(long pingIntervalMsec) {
        this.lock.lock();
        try {
            this.pingIntervalMsec = pingIntervalMsec;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMinRequiredProtocolVersion(int minRequiredProtocolVersion) {
        this.vMinRequiredProtocolVersion = minRequiredProtocolVersion;
    }

    public int getMinRequiredProtocolVersion() {
        return this.vMinRequiredProtocolVersion;
    }

    public int getMostCommonChainHeight() {
        this.lock.lock();
        try {
            int n = PeerGroup.getMostCommonChainHeight(this.peers);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static int getMostCommonChainHeight(List<Peer> peers) {
        if (peers.isEmpty()) {
            return 0;
        }
        ArrayList<Integer> heights = new ArrayList<Integer>(peers.size());
        for (Peer peer : peers) {
            heights.add((int)peer.getBestHeight());
        }
        return Utils.maxOfMostFreq(heights);
    }

    @Nullable
    protected Peer selectDownloadPeer(List<Peer> peers) {
        if (peers.isEmpty()) {
            return null;
        }
        int mostCommonChainHeight = PeerGroup.getMostCommonChainHeight(peers);
        ArrayList<Peer> candidates = new ArrayList<Peer>();
        for (Peer peer : peers) {
            if (peer.getBestHeight() != (long)mostCommonChainHeight) continue;
            candidates.add(peer);
        }
        int highestVersion = 0;
        int preferredVersion = 0;
        int PREFERRED_VERSION = 70000;
        for (Peer peer : candidates) {
            highestVersion = Math.max(peer.getPeerVersionMessage().clientVersion, highestVersion);
            preferredVersion = Math.min(highestVersion, 70000);
        }
        ArrayList<PeerAndPing> candidates2 = new ArrayList<PeerAndPing>();
        for (Peer peer : candidates) {
            if (peer.getPeerVersionMessage().clientVersion < preferredVersion) continue;
            PeerAndPing pap = new PeerAndPing();
            pap.peer = peer;
            pap.pingTime = peer.getPingTime();
            candidates2.add(pap);
        }
        Collections.sort(candidates2, new Comparator<PeerAndPing>(){

            @Override
            public int compare(PeerAndPing peerAndPing, PeerAndPing peerAndPing2) {
                return Longs.compare((long)peerAndPing.pingTime, (long)peerAndPing2.pingTime);
            }
        });
        return ((PeerAndPing)candidates2.get((int)0)).peer;
    }

    public Peer getDownloadPeer() {
        this.lock.lock();
        try {
            Peer peer = this.downloadPeer;
            return peer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public TorClient getTorClient() {
        return this.torClient;
    }

    public int getMaxPeersToDiscoverCount() {
        return this.maxPeersToDiscoverCount;
    }

    public void setMaxPeersToDiscoverCount(int maxPeersToDiscoverCount) {
        this.maxPeersToDiscoverCount = maxPeersToDiscoverCount;
    }

    public boolean getUseLocalhostPeerWhenPossible() {
        this.lock.lock();
        try {
            boolean bl = this.useLocalhostPeerWhenPossible;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUseLocalhostPeerWhenPossible(boolean useLocalhostPeerWhenPossible) {
        this.lock.lock();
        try {
            this.useLocalhostPeerWhenPossible = useLocalhostPeerWhenPossible;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class PeerAndPing {
        Peer peer;
        long pingTime;

        private PeerAndPing() {
        }
    }

    public static enum FilterRecalculateMode {
        SEND_IF_CHANGED,
        FORCE_SEND_FOR_REFRESH,
        DONT_SEND;

    }

    private static enum LocalhostCheckState {
        NOT_TRIED,
        FOUND,
        FOUND_AND_CONNECTED,
        NOT_THERE;

    }

    private class PeerStartupListener
    extends AbstractPeerEventListener {
        private PeerStartupListener() {
        }

        @Override
        public void onPeerConnected(Peer peer, int peerCount) {
            PeerGroup.this.handleNewPeer(peer);
        }

        @Override
        public void onPeerDisconnected(Peer peer, int peerCount) {
            PeerGroup.this.handlePeerDeath(peer, null);
        }
    }
}

