/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.Utils;

public class StoredTransactionOutput
implements Serializable {
    private static final long serialVersionUID = -8744924157056340509L;
    private Coin value;
    private byte[] scriptBytes;
    private Sha256Hash hash;
    private long index;
    private int height;
    private boolean coinbase;

    public StoredTransactionOutput(Sha256Hash hash, long index, Coin value, int height, boolean coinbase, byte[] scriptBytes) {
        this.hash = hash;
        this.index = index;
        this.value = value;
        this.height = height;
        this.scriptBytes = scriptBytes;
        this.coinbase = coinbase;
    }

    public StoredTransactionOutput(Sha256Hash hash, TransactionOutput out, int height, boolean coinbase) {
        this.hash = hash;
        this.index = out.getIndex();
        this.value = out.getValue();
        this.height = height;
        this.scriptBytes = out.getScriptBytes();
        this.coinbase = coinbase;
    }

    public StoredTransactionOutput(InputStream in) throws IOException {
        byte[] valueBytes = new byte[8];
        if (in.read(valueBytes, 0, 8) != 8) {
            throw new EOFException();
        }
        this.value = Coin.valueOf(Utils.readInt64(valueBytes, 0));
        int scriptBytesLength = (in.read() & 0xFF) << 0 | (in.read() & 0xFF) << 8 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 24;
        this.scriptBytes = new byte[scriptBytesLength];
        if (in.read(this.scriptBytes) != scriptBytesLength) {
            throw new EOFException();
        }
        byte[] hashBytes = new byte[32];
        if (in.read(hashBytes) != 32) {
            throw new EOFException();
        }
        this.hash = new Sha256Hash(hashBytes);
        byte[] indexBytes = new byte[4];
        if (in.read(indexBytes) != 4) {
            throw new EOFException();
        }
        this.index = Utils.readUint32(indexBytes, 0);
        this.height = (in.read() & 0xFF) << 0 | (in.read() & 0xFF) << 8 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 24;
        byte[] coinbaseByte = new byte[1];
        in.read(coinbaseByte);
        this.coinbase = coinbaseByte[0] == 1;
    }

    public Coin getValue() {
        return this.value;
    }

    public byte[] getScriptBytes() {
        return this.scriptBytes;
    }

    public Sha256Hash getHash() {
        return this.hash;
    }

    public long getIndex() {
        return this.index;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isCoinbase() {
        return this.coinbase;
    }

    public String toString() {
        return String.format("Stored TxOut of %s (%s:%d)", this.value.toFriendlyString(), this.hash.toString(), this.index);
    }

    public int hashCode() {
        return this.hash.hashCode() + (int)this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredTransactionOutput other = (StoredTransactionOutput)o;
        return this.getHash().equals(other.getHash()) && this.getIndex() == other.getIndex();
    }

    public void serializeToStream(OutputStream bos) throws IOException {
        Utils.uint64ToByteStreamLE(BigInteger.valueOf(this.value.value), bos);
        bos.write(0xFF & this.scriptBytes.length >> 0);
        bos.write(0xFF & this.scriptBytes.length >> 8);
        bos.write(0xFF & this.scriptBytes.length >> 16);
        bos.write(0xFF & this.scriptBytes.length >> 24);
        bos.write(this.scriptBytes);
        bos.write(this.hash.getBytes());
        Utils.uint32ToByteStreamLE(this.index, bos);
        bos.write(0xFF & this.height >> 0);
        bos.write(0xFF & this.height >> 8);
        bos.write(0xFF & this.height >> 16);
        bos.write(0xFF & this.height >> 24);
        byte[] coinbaseByte = new byte[]{this.coinbase ? (byte)1 : 0};
        bos.write(coinbaseByte);
    }
}

