/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.bitcoinj.core.AbstractPeerEventListener;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerEventListener;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.RejectMessage;
import org.bitcoinj.core.RejectedTransactionException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.utils.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBroadcast {
    private static final Logger log = LoggerFactory.getLogger(TransactionBroadcast.class);
    private final SettableFuture<Transaction> future = SettableFuture.create();
    private final PeerGroup peerGroup;
    private final Transaction tx;
    private int minConnections;
    private int numWaitingFor;
    private int numToBroadcastTo;
    @VisibleForTesting
    public static Random random = new Random();
    private Transaction pinnedTx;
    private PeerEventListener rejectionListener = new AbstractPeerEventListener(){

        @Override
        public Message onPreMessageReceived(Peer peer, Message m) {
            if (m instanceof RejectMessage) {
                RejectMessage rejectMessage = (RejectMessage)m;
                if (TransactionBroadcast.this.tx.getHash().equals(rejectMessage.getRejectedObjectHash())) {
                    TransactionBroadcast.this.future.setException((Throwable)new RejectedTransactionException(TransactionBroadcast.this.tx, rejectMessage));
                    TransactionBroadcast.this.peerGroup.removeEventListener(this);
                }
            }
            return m;
        }
    };

    public TransactionBroadcast(PeerGroup peerGroup, Transaction tx) {
        this.peerGroup = peerGroup;
        this.tx = tx;
        this.minConnections = Math.max(1, peerGroup.getMinBroadcastConnections());
    }

    public ListenableFuture<Transaction> future() {
        return this.future;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public ListenableFuture<Transaction> broadcast() {
        this.peerGroup.addEventListener(this.rejectionListener, Threading.SAME_THREAD);
        log.info("Waiting for {} peers required for broadcast ...", (Object)this.minConnections);
        this.peerGroup.waitForPeers(this.minConnections).addListener((Runnable)new EnoughAvailablePeers(), Threading.SAME_THREAD);
        return this.future;
    }

    private class ConfidenceChange
    implements TransactionConfidence.Listener {
        private ConfidenceChange() {
        }

        @Override
        public void onConfidenceChanged(Transaction tx, TransactionConfidence.Listener.ChangeReason reason) {
            TransactionConfidence conf = tx.getConfidence();
            int numSeenPeers = conf.numBroadcastPeers();
            boolean mined = tx.getAppearsInHashes() != null;
            log.info("broadcastTransaction: {}:  TX {} seen by {} peers{}", new Object[]{reason, TransactionBroadcast.this.pinnedTx.getHashAsString(), numSeenPeers, mined ? " and mined" : ""});
            if (numSeenPeers >= TransactionBroadcast.this.numWaitingFor || mined) {
                log.info("broadcastTransaction: {} complete", (Object)TransactionBroadcast.this.pinnedTx.getHashAsString());
                tx.getConfidence().removeEventListener(this);
                TransactionBroadcast.this.peerGroup.removeEventListener(TransactionBroadcast.this.rejectionListener);
                TransactionBroadcast.this.future.set((Object)TransactionBroadcast.this.pinnedTx);
            }
        }
    }

    private class EnoughAvailablePeers
    implements Runnable {
        private EnoughAvailablePeers() {
        }

        @Override
        public void run() {
            List<Peer> peers = TransactionBroadcast.this.peerGroup.getConnectedPeers();
            TransactionBroadcast.this.pinnedTx = TransactionBroadcast.this.peerGroup.getMemoryPool().intern(TransactionBroadcast.this.tx);
            if (TransactionBroadcast.this.minConnections > 1) {
                TransactionBroadcast.this.pinnedTx.getConfidence().addEventListener(new ConfidenceChange());
            }
            int numConnected = peers.size();
            TransactionBroadcast.this.numToBroadcastTo = (int)Math.max(1L, Math.round(Math.ceil((double)peers.size() / 2.0)));
            TransactionBroadcast.this.numWaitingFor = (int)Math.ceil((double)(peers.size() - TransactionBroadcast.this.numToBroadcastTo) / 2.0);
            Collections.shuffle(peers, random);
            peers = peers.subList(0, TransactionBroadcast.this.numToBroadcastTo);
            log.info("broadcastTransaction: We have {} peers, adding {} to the memory pool and sending to {} peers, will wait for {}: {}", new Object[]{numConnected, TransactionBroadcast.this.tx.getHashAsString(), TransactionBroadcast.this.numToBroadcastTo, TransactionBroadcast.this.numWaitingFor, Joiner.on((String)",").join(peers)});
            for (Peer peer : peers) {
                try {
                    peer.sendMessage(TransactionBroadcast.this.pinnedTx);
                }
                catch (Exception e) {
                    log.error("Caught exception sending to {}", (Object)peer, (Object)e);
                }
            }
            if (TransactionBroadcast.this.minConnections == 1) {
                TransactionBroadcast.this.peerGroup.removeEventListener(TransactionBroadcast.this.rejectionListener);
                TransactionBroadcast.this.future.set((Object)TransactionBroadcast.this.pinnedTx);
            }
        }
    }
}

