/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import org.bitcoinj.core.Utils;

public class VarInt {
    public final long value;
    private final int originallyEncodedSize;

    public VarInt(long value) {
        this.value = value;
        this.originallyEncodedSize = this.getSizeInBytes();
    }

    public VarInt(byte[] buf, int offset) {
        int first = 0xFF & buf[offset];
        if (first < 253) {
            this.value = first;
            this.originallyEncodedSize = 1;
        } else if (first == 253) {
            this.value = 0xFF & buf[offset + 1] | (0xFF & buf[offset + 2]) << 8;
            this.originallyEncodedSize = 3;
        } else if (first == 254) {
            this.value = Utils.readUint32(buf, offset + 1);
            this.originallyEncodedSize = 5;
        } else {
            this.value = Utils.readUint32(buf, offset + 1) | Utils.readUint32(buf, offset + 5) << 32;
            this.originallyEncodedSize = 9;
        }
    }

    public int getOriginalSizeInBytes() {
        return this.originallyEncodedSize;
    }

    public int getSizeInBytes() {
        return VarInt.sizeOf(this.value);
    }

    public static int sizeOf(int value) {
        if (value < 253) {
            return 1;
        }
        if (value < 65536) {
            return 3;
        }
        return 5;
    }

    public static int sizeOf(long value) {
        if (Utils.isLessThanUnsigned(value, 253L)) {
            return 1;
        }
        if (Utils.isLessThanOrEqualToUnsigned(value, 65535L)) {
            return 3;
        }
        if (Utils.isLessThanOrEqualToUnsigned(value, 0xFFFFFFFFL)) {
            return 5;
        }
        return 9;
    }

    public byte[] encode() {
        if (Utils.isLessThanUnsigned(this.value, 253L)) {
            return new byte[]{(byte)this.value};
        }
        if (Utils.isLessThanOrEqualToUnsigned(this.value, 65535L)) {
            return new byte[]{-3, (byte)this.value, (byte)(this.value >> 8)};
        }
        if (Utils.isLessThanOrEqualToUnsigned(this.value, 0xFFFFFFFFL)) {
            byte[] bytes = new byte[5];
            bytes[0] = -2;
            Utils.uint32ToByteArrayLE(this.value, bytes, 1);
            return bytes;
        }
        byte[] bytes = new byte[9];
        bytes[0] = -1;
        Utils.uint32ToByteArrayLE(this.value, bytes, 1);
        Utils.uint32ToByteArrayLE(this.value >>> 32, bytes, 5);
        return bytes;
    }
}

