/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net.discovery;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.utils.DaemonThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsDiscovery
implements PeerDiscovery {
    private static final Logger log = LoggerFactory.getLogger(DnsDiscovery.class);
    private final String[] dnsSeeds;
    private final NetworkParameters netParams;

    public DnsDiscovery(NetworkParameters netParams) {
        this(netParams.getDnsSeeds(), netParams);
    }

    public DnsDiscovery(String[] dnsSeeds, NetworkParameters netParams) {
        this.dnsSeeds = dnsSeeds;
        this.netParams = netParams;
    }

    @Override
    public InetSocketAddress[] getPeers(long timeoutValue, TimeUnit timeoutUnit) throws PeerDiscoveryException {
        if (this.dnsSeeds == null || this.dnsSeeds.length == 0) {
            throw new PeerDiscoveryException("No DNS seeds configured; unable to find any peers");
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(this.dnsSeeds.length, new DaemonThreadFactory());
        try {
            ArrayList tasks = Lists.newArrayList();
            for (final String seed : this.dnsSeeds) {
                tasks.add(new Callable<InetAddress[]>(){

                    @Override
                    public InetAddress[] call() throws Exception {
                        return InetAddress.getAllByName(seed);
                    }
                });
            }
            List futures = threadPool.invokeAll(tasks, timeoutValue, timeoutUnit);
            ArrayList addrs = Lists.newArrayList();
            for (int i = 0; i < futures.size(); ++i) {
                InetAddress[] inetAddresses;
                Future future = futures.get(i);
                if (future.isCancelled()) {
                    log.warn("DNS seed {}: timed out", (Object)this.dnsSeeds[i]);
                    continue;
                }
                try {
                    inetAddresses = (InetAddress[])future.get();
                    log.info("DNS seed {}: got {} peers", (Object)this.dnsSeeds[i], (Object)inetAddresses.length);
                }
                catch (ExecutionException e) {
                    log.error("DNS seed {}: failed to look up: {}", (Object)this.dnsSeeds[i], (Object)e.getMessage());
                    continue;
                }
                for (InetAddress addr : inetAddresses) {
                    addrs.add(new InetSocketAddress(addr, this.netParams.getPort()));
                }
            }
            if (addrs.size() == 0) {
                throw new PeerDiscoveryException("Unable to find any peers via DNS");
            }
            Collections.shuffle(addrs);
            threadPool.shutdownNow();
            InetSocketAddress[] inetSocketAddressArray = addrs.toArray(new InetSocketAddress[addrs.size()]);
            return inetSocketAddressArray;
        }
        catch (InterruptedException e) {
            throw new PeerDiscoveryException(e);
        }
        finally {
            threadPool.shutdown();
        }
    }

    @Override
    public void shutdown() {
    }
}

