/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.params;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Set;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.TestNet3Params;

public class Networks {
    private static Set<NetworkParameters> networks = ImmutableSet.of((Object)TestNet3Params.get(), (Object)MainNetParams.get());

    public static Set<NetworkParameters> get() {
        return networks;
    }

    public static void register(NetworkParameters network) {
        Networks.register(Lists.newArrayList((Object[])new NetworkParameters[]{network}));
    }

    public static void register(Collection<? extends NetworkParameters> networks) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(Networks.networks);
        builder.addAll(networks);
        Networks.networks = builder.build();
    }

    public static void unregister(NetworkParameters network) {
        if (networks.contains(network)) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (NetworkParameters parameters : networks) {
                if (parameters.equals(network)) continue;
                builder.add((Object)parameters);
            }
            networks = builder.build();
        }
    }
}

