/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.store;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.store.DatabaseFullPrunedBlockStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2FullPrunedBlockStore
extends DatabaseFullPrunedBlockStore {
    private static final Logger log = LoggerFactory.getLogger(H2FullPrunedBlockStore.class);
    private static final String H2_DUPLICATE_KEY_ERROR_CODE = "23505";
    private static final String DATABASE_DRIVER_CLASS = "org.h2.Driver";
    private static final String DATABASE_CONNECTION_URL_PREFIX = "jdbc:h2:";
    private static final String CREATE_SETTINGS_TABLE = "CREATE TABLE settings ( name VARCHAR(32) NOT NULL CONSTRAINT settings_pk PRIMARY KEY,value BLOB)";
    private static final String CREATE_HEADERS_TABLE = "CREATE TABLE headers ( hash BINARY(28) NOT NULL CONSTRAINT headers_pk PRIMARY KEY,chainWork BLOB NOT NULL,height INT NOT NULL,header BLOB NOT NULL,wasUndoable BOOL NOT NULL)";
    private static final String CREATE_UNDOABLE_TABLE = "CREATE TABLE undoableBlocks ( hash BINARY(28) NOT NULL CONSTRAINT undoableBlocks_pk PRIMARY KEY,height INT NOT NULL,txOutChanges BLOB,transactions BLOB)";
    private static final String CREATE_OPEN_OUTPUT_TABLE = "CREATE TABLE openOutputs (hash BINARY(32) NOT NULL,index INT NOT NULL,height INT NOT NULL,value BIGINT NOT NULL,scriptBytes BLOB NOT NULL,toaddress VARCHAR(35),addresstargetable TINYINT,coinbase BOOLEAN,PRIMARY KEY (hash, index),)";
    private static final String CREATE_OUTPUTS_ADDRESS_MULTI_INDEX = "CREATE INDEX openoutputs_hash_index_height_toaddress_idx ON openoutputs (hash, index, height, toaddress)";
    private static final String CREATE_OUTPUTS_TOADDRESS_INDEX = "CREATE INDEX openoutputs_toaddress_idx ON openoutputs (toaddress)";
    private static final String CREATE_OUTPUTS_ADDRESSTARGETABLE_INDEX = "CREATE INDEX openoutputs_addresstargetable_idx ON openoutputs (addresstargetable)";
    private static final String CREATE_OUTPUTS_HASH_INDEX = "CREATE INDEX openoutputs_hash_idx ON openoutputs (hash)";
    private static final String CREATE_UNDOABLE_TABLE_INDEX = "CREATE INDEX undoableblocks_height_idx ON undoableBlocks (height)";

    public H2FullPrunedBlockStore(NetworkParameters params, String dbName, int fullStoreDepth) throws BlockStoreException {
        super(params, DATABASE_CONNECTION_URL_PREFIX + dbName + ";create=true;LOCK_TIMEOUT=60000;DB_CLOSE_ON_EXIT=FALSE", fullStoreDepth, null, null, null);
    }

    public H2FullPrunedBlockStore(NetworkParameters params, String dbName, int fullStoreDepth, int cacheSize) throws BlockStoreException {
        this(params, dbName, fullStoreDepth);
        try {
            Statement s = ((Connection)this.conn.get()).createStatement();
            s.executeUpdate("SET CACHE_SIZE " + cacheSize);
            s.close();
        }
        catch (SQLException e) {
            throw new BlockStoreException(e);
        }
    }

    @Override
    protected String getDuplicateKeyErrorCode() {
        return H2_DUPLICATE_KEY_ERROR_CODE;
    }

    @Override
    protected List<String> getCreateTablesSQL() {
        ArrayList<String> sqlStatements = new ArrayList<String>();
        sqlStatements.add(CREATE_SETTINGS_TABLE);
        sqlStatements.add(CREATE_HEADERS_TABLE);
        sqlStatements.add(CREATE_UNDOABLE_TABLE);
        sqlStatements.add(CREATE_OPEN_OUTPUT_TABLE);
        return sqlStatements;
    }

    @Override
    protected List<String> getCreateIndexesSQL() {
        ArrayList<String> sqlStatements = new ArrayList<String>();
        sqlStatements.add(CREATE_UNDOABLE_TABLE_INDEX);
        sqlStatements.add(CREATE_OUTPUTS_ADDRESS_MULTI_INDEX);
        sqlStatements.add(CREATE_OUTPUTS_ADDRESSTARGETABLE_INDEX);
        sqlStatements.add(CREATE_OUTPUTS_HASH_INDEX);
        sqlStatements.add(CREATE_OUTPUTS_TOADDRESS_INDEX);
        return sqlStatements;
    }

    @Override
    protected List<String> getCreateSchemeSQL() {
        return Collections.emptyList();
    }

    @Override
    protected String getDatabaseDriverClass() {
        return DATABASE_DRIVER_CLASS;
    }
}

