/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.testing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.BitcoinSerializer;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;

public class FakeTxBuilder {
    public static Transaction createFakeTxWithChangeAddress(NetworkParameters params, Coin value, Address to, Address changeOutput) {
        Transaction t = new Transaction(params);
        TransactionOutput outputToMe = new TransactionOutput(params, t, value, to);
        t.addOutput(outputToMe);
        TransactionOutput change = new TransactionOutput(params, t, Coin.valueOf(1, 11), changeOutput);
        t.addOutput(change);
        Transaction prevTx = new Transaction(params);
        TransactionOutput prevOut = new TransactionOutput(params, prevTx, value, to);
        prevTx.addOutput(prevOut);
        t.addInput(prevOut).setScriptSig(ScriptBuilder.createInputScript(TransactionSignature.dummy()));
        return FakeTxBuilder.roundTripTransaction(params, t);
    }

    public static Transaction createFakeTx(NetworkParameters params, Coin value, Address to) {
        return FakeTxBuilder.createFakeTxWithChangeAddress(params, value, to, new ECKey().toAddress(params));
    }

    public static Transaction createFakeTx(NetworkParameters params, Coin value, ECKey to) {
        Transaction t = new Transaction(params);
        TransactionOutput outputToMe = new TransactionOutput(params, t, value, to);
        t.addOutput(outputToMe);
        TransactionOutput change = new TransactionOutput(params, t, Coin.valueOf(1, 11), new ECKey());
        t.addOutput(change);
        Transaction prevTx = new Transaction(params);
        TransactionOutput prevOut = new TransactionOutput(params, prevTx, value, to);
        prevTx.addOutput(prevOut);
        t.addInput(prevOut);
        return FakeTxBuilder.roundTripTransaction(params, t);
    }

    public static Transaction[] createFakeTx(NetworkParameters params, Coin value, Address to, Address from) {
        Transaction t = new Transaction(params);
        TransactionOutput outputToMe = new TransactionOutput(params, t, value, to);
        t.addOutput(outputToMe);
        TransactionOutput change = new TransactionOutput(params, t, Coin.valueOf(1, 11), new ECKey().toAddress(params));
        t.addOutput(change);
        Transaction feederTx = new Transaction(params);
        TransactionOutput feederOut = new TransactionOutput(params, feederTx, value, from);
        feederTx.addOutput(feederOut);
        Transaction prevTx = new Transaction(params);
        TransactionOutput prevOut = new TransactionOutput(params, prevTx, value, to);
        prevTx.addOutput(prevOut);
        prevTx.addInput(feederOut);
        t.addInput(prevOut);
        return new Transaction[]{FakeTxBuilder.roundTripTransaction(params, prevTx), FakeTxBuilder.roundTripTransaction(params, t)};
    }

    public static Transaction roundTripTransaction(NetworkParameters params, Transaction tx) {
        try {
            BitcoinSerializer bs = new BitcoinSerializer(params);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bs.serialize(tx, bos);
            return (Transaction)bs.deserialize(ByteBuffer.wrap(bos.toByteArray()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DoubleSpends createFakeDoubleSpendTxns(NetworkParameters params, Address to) {
        DoubleSpends doubleSpends = new DoubleSpends();
        Coin value = Coin.COIN;
        Address someBadGuy = new ECKey().toAddress(params);
        doubleSpends.t1 = new Transaction(params);
        TransactionOutput o1 = new TransactionOutput(params, doubleSpends.t1, value, to);
        doubleSpends.t1.addOutput(o1);
        doubleSpends.prevTx = new Transaction(params);
        TransactionOutput prevOut = new TransactionOutput(params, doubleSpends.prevTx, value, someBadGuy);
        doubleSpends.prevTx.addOutput(prevOut);
        doubleSpends.t1.addInput(prevOut);
        doubleSpends.t2 = new Transaction(params);
        doubleSpends.t2.addInput(prevOut);
        TransactionOutput o2 = new TransactionOutput(params, doubleSpends.t2, value, someBadGuy);
        doubleSpends.t2.addOutput(o2);
        try {
            doubleSpends.t1 = new Transaction(params, doubleSpends.t1.bitcoinSerialize());
            doubleSpends.t2 = new Transaction(params, doubleSpends.t2.bitcoinSerialize());
        }
        catch (ProtocolException e) {
            throw new RuntimeException(e);
        }
        return doubleSpends;
    }

    public static BlockPair createFakeBlock(BlockStore blockStore, long timeSeconds, Transaction ... transactions) {
        try {
            Block chainHead = blockStore.getChainHead().getHeader();
            Address to = new ECKey().toAddress(chainHead.getParams());
            Block b = chainHead.createNextBlock(to, timeSeconds);
            for (Transaction tx : transactions) {
                tx.getConfidence().setSource(TransactionConfidence.Source.NETWORK);
                b.addTransaction(tx);
            }
            b.solve();
            BlockPair pair = new BlockPair();
            pair.block = b;
            pair.storedBlock = blockStore.getChainHead().build(b);
            blockStore.put(pair.storedBlock);
            blockStore.setChainHead(pair.storedBlock);
            return pair;
        }
        catch (VerificationException e) {
            throw new RuntimeException(e);
        }
        catch (BlockStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static BlockPair createFakeBlock(BlockStore blockStore, Transaction ... transactions) {
        return FakeTxBuilder.createFakeBlock(blockStore, Utils.currentTimeSeconds(), transactions);
    }

    public static Block makeSolvedTestBlock(BlockStore blockStore, Address coinsTo) throws BlockStoreException {
        Block b = blockStore.getChainHead().getHeader().createNextBlock(coinsTo);
        b.solve();
        return b;
    }

    public static Block makeSolvedTestBlock(Block prev, Transaction ... transactions) throws BlockStoreException {
        Address to = new ECKey().toAddress(prev.getParams());
        Block b = prev.createNextBlock(to);
        for (Transaction tx : transactions) {
            b.addTransaction(tx);
        }
        b.solve();
        return b;
    }

    public static Block makeSolvedTestBlock(Block prev, Address to, Transaction ... transactions) throws BlockStoreException {
        Block b = prev.createNextBlock(to);
        for (Transaction tx : transactions) {
            b.addTransaction(tx);
        }
        b.solve();
        return b;
    }

    public static class BlockPair {
        public StoredBlock storedBlock;
        public Block block;
    }

    public static class DoubleSpends {
        public Transaction t1;
        public Transaction t2;
        public Transaction prevTx;
    }
}

