/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.testing;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.signers.CustomTransactionSigner;
import org.bitcoinj.wallet.DeterministicKeyChain;

public class KeyChainTransactionSigner
extends CustomTransactionSigner {
    private DeterministicKeyChain keyChain;

    public KeyChainTransactionSigner() {
    }

    public KeyChainTransactionSigner(DeterministicKeyChain keyChain) {
        this.keyChain = keyChain;
    }

    @Override
    protected CustomTransactionSigner.SignatureAndKey getSignature(Sha256Hash sighash, List<ChildNumber> derivationPath) {
        ImmutableList keyPath = ImmutableList.copyOf(derivationPath);
        DeterministicKey key = this.keyChain.getKeyByPath((List<ChildNumber>)keyPath, true);
        return new CustomTransactionSigner.SignatureAndKey(key.sign(sighash), key.getPubOnly());
    }
}

