/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.testing;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.MemoryPoolMessage;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.NotFoundMessage;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VersionAck;
import org.bitcoinj.core.VersionMessage;
import org.bitcoinj.net.BlockingClientManager;
import org.bitcoinj.net.NioClientManager;
import org.bitcoinj.params.UnitTestParams;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.MemoryBlockStore;
import org.bitcoinj.testing.InboundMessageQueuer;
import org.bitcoinj.testing.TestWithNetworkConnections;

public class TestWithPeerGroup
extends TestWithNetworkConnections {
    protected static final NetworkParameters params = UnitTestParams.get();
    protected PeerGroup peerGroup;
    protected VersionMessage remoteVersionMessage;
    private final TestWithNetworkConnections.ClientType clientType;

    public TestWithPeerGroup(TestWithNetworkConnections.ClientType clientType) {
        super(clientType);
        if (clientType != TestWithNetworkConnections.ClientType.NIO_CLIENT_MANAGER && clientType != TestWithNetworkConnections.ClientType.BLOCKING_CLIENT_MANAGER) {
            throw new RuntimeException();
        }
        this.clientType = clientType;
    }

    @Override
    public void setUp() throws Exception {
        this.setUp(new MemoryBlockStore(params));
    }

    @Override
    public void setUp(BlockStore blockStore) throws Exception {
        super.setUp(blockStore);
        this.remoteVersionMessage = new VersionMessage(this.unitTestParams, 1);
        this.remoteVersionMessage.localServices = 1L;
        this.remoteVersionMessage.clientVersion = NotFoundMessage.MIN_PROTOCOL_VERSION;
        this.initPeerGroup();
    }

    @Override
    public void tearDown() {
        try {
            super.tearDown();
            Utils.finishMockSleep();
            this.peerGroup.stopAsync();
            this.peerGroup.awaitTerminated();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initPeerGroup() {
        this.peerGroup = this.clientType == TestWithNetworkConnections.ClientType.NIO_CLIENT_MANAGER ? new PeerGroup(this.unitTestParams, this.blockChain, new NioClientManager()) : new PeerGroup(this.unitTestParams, this.blockChain, new BlockingClientManager());
        this.peerGroup.setPingIntervalMsec(0L);
        this.peerGroup.addWallet(this.wallet);
        this.peerGroup.setUseLocalhostPeerWhenPossible(false);
    }

    protected InboundMessageQueuer connectPeerWithoutVersionExchange(int id) throws Exception {
        Preconditions.checkArgument((id < 5 ? 1 : 0) != 0);
        InetSocketAddress remoteAddress = new InetSocketAddress("127.0.0.1", 2000 + id);
        Peer peer = (Peer)this.peerGroup.connectTo(remoteAddress).getConnectionOpenFuture().get();
        InboundMessageQueuer writeTarget = (InboundMessageQueuer)this.newPeerWriteTargetQueue.take();
        writeTarget.peer = peer;
        return writeTarget;
    }

    protected InboundMessageQueuer connectPeer(int id) throws Exception {
        return this.connectPeer(id, this.remoteVersionMessage);
    }

    protected InboundMessageQueuer connectPeer(int id, VersionMessage versionMessage) throws Exception {
        Preconditions.checkArgument((boolean)versionMessage.hasBlockChain());
        InboundMessageQueuer writeTarget = this.connectPeerWithoutVersionExchange(id);
        writeTarget.sendMessage(versionMessage);
        writeTarget.sendMessage(new VersionAck());
        this.stepThroughInit(versionMessage, writeTarget);
        return writeTarget;
    }

    protected InboundMessageQueuer handleConnectToPeer(int id) throws Exception {
        return this.handleConnectToPeer(id, this.remoteVersionMessage);
    }

    protected InboundMessageQueuer handleConnectToPeer(int id, VersionMessage versionMessage) throws Exception {
        InboundMessageQueuer writeTarget = (InboundMessageQueuer)this.newPeerWriteTargetQueue.take();
        Preconditions.checkArgument((boolean)versionMessage.hasBlockChain());
        writeTarget.sendMessage(versionMessage);
        writeTarget.sendMessage(new VersionAck());
        this.stepThroughInit(versionMessage, writeTarget);
        return writeTarget;
    }

    private void stepThroughInit(VersionMessage versionMessage, InboundMessageQueuer writeTarget) throws InterruptedException {
        Preconditions.checkState((boolean)(writeTarget.nextMessageBlocking() instanceof VersionMessage));
        Preconditions.checkState((boolean)(writeTarget.nextMessageBlocking() instanceof VersionAck));
        if (versionMessage.isBloomFilteringSupported()) {
            Preconditions.checkState((boolean)(writeTarget.nextMessageBlocking() instanceof BloomFilter));
            Preconditions.checkState((boolean)(writeTarget.nextMessageBlocking() instanceof MemoryPoolMessage));
        }
    }
}

