/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.testing;

import javax.annotation.Nullable;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.Wallet;
import org.bitcoinj.params.UnitTestParams;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.MemoryBlockStore;
import org.bitcoinj.testing.FakeTxBuilder;
import org.bitcoinj.utils.BriefLogFormatter;

public class TestWithWallet {
    protected static final NetworkParameters params = UnitTestParams.get();
    protected ECKey myKey;
    protected Address myAddress;
    protected Wallet wallet;
    protected BlockChain chain;
    protected BlockStore blockStore;

    public void setUp() throws Exception {
        BriefLogFormatter.init();
        Wallet.SendRequest.DEFAULT_FEE_PER_KB = Coin.ZERO;
        this.wallet = new Wallet(params);
        this.myKey = this.wallet.currentReceiveKey();
        this.myAddress = this.myKey.toAddress(params);
        this.blockStore = new MemoryBlockStore(params);
        this.chain = new BlockChain(params, this.wallet, this.blockStore);
    }

    public void tearDown() throws Exception {
        Wallet.SendRequest.DEFAULT_FEE_PER_KB = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE;
    }

    @Nullable
    protected Transaction sendMoneyToWallet(Wallet wallet, Transaction tx, AbstractBlockChain.NewBlockType type) throws VerificationException {
        if (type == null) {
            if (wallet.isPendingTransactionRelevant(tx)) {
                wallet.receivePending(tx, null);
            }
        } else {
            FakeTxBuilder.BlockPair bp = FakeTxBuilder.createFakeBlock(this.blockStore, tx);
            wallet.receiveFromBlock(tx, bp.storedBlock, type, 0);
            if (type == AbstractBlockChain.NewBlockType.BEST_CHAIN) {
                wallet.notifyNewBestBlock(bp.storedBlock);
            }
        }
        return wallet.getTransaction(tx.getHash());
    }

    @Nullable
    protected Transaction sendMoneyToWallet(Transaction tx, AbstractBlockChain.NewBlockType type) throws VerificationException {
        return this.sendMoneyToWallet(this.wallet, tx, type);
    }

    @Nullable
    protected Transaction sendMoneyToWallet(Wallet wallet, Coin value, Address toAddress, AbstractBlockChain.NewBlockType type) throws VerificationException {
        return this.sendMoneyToWallet(wallet, FakeTxBuilder.createFakeTx(params, value, toAddress), type);
    }

    @Nullable
    protected Transaction sendMoneyToWallet(Wallet wallet, Coin value, ECKey toPubKey, AbstractBlockChain.NewBlockType type) throws VerificationException {
        return this.sendMoneyToWallet(wallet, FakeTxBuilder.createFakeTx(params, value, toPubKey), type);
    }

    @Nullable
    protected Transaction sendMoneyToWallet(Coin value, AbstractBlockChain.NewBlockType type) throws VerificationException {
        return this.sendMoneyToWallet(this.wallet, FakeTxBuilder.createFakeTx(params, value, this.myAddress), type);
    }
}

