/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.script.Script;

public class RedeemData {
    public final Script redeemScript;
    public final List<ECKey> keys;

    private RedeemData(List<ECKey> keys, Script redeemScript) {
        this.redeemScript = redeemScript;
        ArrayList<ECKey> sortedKeys = new ArrayList<ECKey>(keys);
        Collections.sort(sortedKeys, ECKey.PUBKEY_COMPARATOR);
        this.keys = sortedKeys;
    }

    public static RedeemData of(List<ECKey> keys, Script redeemScript) {
        return new RedeemData(keys, redeemScript);
    }

    public static RedeemData of(ECKey key, Script program) {
        Preconditions.checkArgument((program.isSentToAddress() || program.isSentToRawPubKey() ? 1 : 0) != 0);
        return key != null ? new RedeemData(Arrays.asList(key), program) : null;
    }

    public ECKey getFullKey() {
        for (ECKey key : this.keys) {
            try {
                if (key.getPrivKey() == null) continue;
                return key;
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (ECKey.MissingPrivateKeyException missingPrivateKeyException) {
            }
        }
        return null;
    }
}

