/*
 * Decompiled with CFR 0.152.
 */
package com.aqmd.netty.dispatcher;

import com.aqmd.netty.Dispatcher;
import com.aqmd.netty.annotation.HawkMethodHandler;
import com.aqmd.netty.common.constant.NettyResponseCode;
import com.aqmd.netty.context.HawkContext;
import com.aqmd.netty.entity.HawkResponseMessage;
import com.aqmd.netty.entity.RequestPacket;
import com.aqmd.netty.entity.ResponsePacket;
import com.aqmd.netty.exception.NettyException;
import com.aqmd.netty.filter.DefaultFilterChain;
import com.google.common.base.Throwables;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HawkRequestDispatcher
implements Dispatcher<RequestPacket, ResponsePacket> {
    private final Logger logger = LoggerFactory.getLogger(HawkRequestDispatcher.class);
    @Autowired
    private HawkContext hawkContext;

    public ResponsePacket dispatch(RequestPacket request, ChannelHandlerContext ctx) throws NettyException {
        HawkMethodHandler HawkMethodHandler2 = this.hawkContext.getHawkMethodHandler((int)request.getCmd(), request.getVersion());
        ResponsePacket response = new ResponsePacket();
        response.setSequenceId(request.getSequenceId());
        response.setRequestId(request.getRequestId());
        response.setCmd(request.getCmd());
        if (HawkMethodHandler2 == null) {
            this.logger.error("\u6307\u4ee4{}#{}\u4e0d\u5b58\u5728", (Object)request.getCmd(), (Object)request.getVersion());
            response.setCode(NettyResponseCode.CMD_NOT_FOUND.getResponseCode());
            response.setBody(HawkResponseMessage.CommonResult.newBuilder().setResultCode(NettyResponseCode.CMD_NOT_FOUND.getResponseCode()).setResultMsg(NettyResponseCode.CMD_NOT_FOUND.getResponseMessage()).build().toByteArray());
            return response;
        }
        if (HawkMethodHandler2.getHawkMethodValue().isObsoleted()) {
            this.logger.error("\u6307\u4ee4{}#{}\u5df2\u8fc7\u671f", (Object)request.getCmd(), (Object)request.getVersion());
            response.setCode(NettyResponseCode.OBSOLETED_METHOD.getResponseCode());
            response.setBody(HawkResponseMessage.CommonResult.newBuilder().setResultCode(NettyResponseCode.OBSOLETED_METHOD.getResponseCode()).setResultMsg(NettyResponseCode.OBSOLETED_METHOD.getResponseMessage()).build().toByteArray());
            return response;
        }
        return this.doInvoke(request, ctx, HawkMethodHandler2, response);
    }

    private ResponsePacket doInvoke(RequestPacket request, ChannelHandlerContext ctx, HawkMethodHandler hawkMethodHandler, ResponsePacket response) {
        try {
            DefaultFilterChain chain = new DefaultFilterChain(this.hawkContext.getFilters(), hawkMethodHandler);
            chain.doFilter(request, response, ctx);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.logger.error("\u6307\u4ee4{}#{}\u4e1a\u52a1\u5f02\u5e38\uff0cmessage={}", new Object[]{request.getCmd(), request.getVersion(), e.getMessage()});
            response.setCode(NettyResponseCode.REQUEST_ERROR.getResponseCode());
            this.buildExceptionBody(response, e.getMessage());
        }
        catch (Exception e) {
            response.setCode(NettyResponseCode.REQUEST_ERROR.getResponseCode());
            if (e instanceof InvalidProtocolBufferException || e.getCause() instanceof InvalidProtocolBufferException) {
                this.logger.error("\u6307\u4ee4{}#{}\u6570\u636e\u5305\u683c\u5f0f\u9519\u8bef\uff0c{}", new Object[]{request.getCmd(), request.getVersion(), Throwables.getStackTraceAsString((Throwable)e)});
                response.setBody(HawkResponseMessage.CommonResult.newBuilder().setResultCode(NettyResponseCode.BODY_FORMAT_ERROR.getResponseCode()).setResultMsg(e.getMessage()).build().toByteArray());
            }
            this.logger.error("\u6307\u4ee4{}#{}\u672a\u77e5\u9519\u8bef, {}", new Object[]{request.getCmd(), request.getVersion(), Throwables.getStackTraceAsString((Throwable)e), e});
            response.setBody(HawkResponseMessage.CommonResult.newBuilder().setResultCode(NettyResponseCode.UNKNOW_ERROR.getResponseCode()).setResultMsg(e.getMessage()).build().toByteArray());
        }
        return response;
    }

    private void buildExceptionBody(ResponsePacket response, String message) {
        String[] results = message.split("~");
        response.setBody(HawkResponseMessage.CommonResult.newBuilder().setResultCode(Integer.parseInt(results[0])).setResultMsg(results[1]).build().toByteArray());
    }
}

