/*
 * Decompiled with CFR 0.152.
 */
package com.aqmd.netty.server;

import com.aqmd.netty.exception.NettyException;
import com.aqmd.netty.server.Server;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
implements Server,
Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int port;
    private int bossThreadSize;
    private int workerThreadSize;
    private ChannelInitializer channelInitializer;

    NettyServer(int port, int bossThreadSize, int workerThreadSize, ChannelInitializer channelInitializer) {
        this.port = port;
        this.bossThreadSize = bossThreadSize;
        this.workerThreadSize = workerThreadSize;
        this.channelInitializer = channelInitializer;
    }

    @Override
    public void open() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(this.bossThreadSize);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(this.workerThreadSize);
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.SO_RCVBUF, (Object)0x100000)).childOption(ChannelOption.SO_SNDBUF, (Object)0xA00000).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)this.channelInitializer);
        InetSocketAddress localAddress = new InetSocketAddress(this.port);
        try {
            ChannelFuture f = b.bind((SocketAddress)localAddress).sync();
            this.logger.info("Server started at port {}", (Object)localAddress.getPort());
            Channel serverChannel = f.channel();
            serverChannel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            throw new NettyException(e.getMessage());
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    @Override
    public void run() {
        this.open();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean isAvailable() {
        return false;
    }
}

