/*
 * Decompiled with CFR 0.152.
 */
package com.aqmd.netty.shiro.subject;

import com.aqmd.netty.entity.RequestPacket;
import com.aqmd.netty.entity.ResponsePacket;
import com.aqmd.netty.shiro.subject.HawkSubject;
import com.aqmd.netty.shiro.subject.HawkSubjectContext;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.subject.support.DefaultSubjectContext;

public class DefaultHawkSubjectContext
extends DefaultSubjectContext
implements HawkSubjectContext {
    private static final long serialVersionUID = 8188555355305827739L;
    private static final String HAWK_REQUEST = DefaultHawkSubjectContext.class.getName() + ".HAWK_REQUEST";
    private static final String HAWK_RESPONSE = DefaultHawkSubjectContext.class.getName() + ".HAWK_RESPONSE";

    public DefaultHawkSubjectContext() {
    }

    public DefaultHawkSubjectContext(HawkSubjectContext context) {
        super((SubjectContext)context);
    }

    @Override
    public RequestPacket getHawkRequest() {
        return (RequestPacket)this.getTypedValue(HAWK_REQUEST, RequestPacket.class);
    }

    @Override
    public void setHawkRequest(RequestPacket request) {
        if (request != null) {
            this.put(HAWK_REQUEST, request);
        }
    }

    @Override
    public RequestPacket resolveHawkRequest() {
        Subject existing;
        RequestPacket request = this.getHawkRequest();
        if (request == null && (existing = this.getSubject()) instanceof HawkSubject) {
            request = ((HawkSubject)existing).getHawkRequest();
        }
        return request;
    }

    @Override
    public ResponsePacket getHawkResponse() {
        return (ResponsePacket)this.getTypedValue(HAWK_RESPONSE, ResponsePacket.class);
    }

    @Override
    public void setHawkResponse(ResponsePacket response) {
        if (response != null) {
            this.put(HAWK_RESPONSE, response);
        }
    }

    @Override
    public ResponsePacket resolveHawkResponse() {
        Subject existing;
        ResponsePacket response = this.getHawkResponse();
        if (response == null && (existing = this.getSubject()) instanceof HawkSubject) {
            response = ((HawkSubject)existing).getHawkResponse();
        }
        return response;
    }
}

