/*
 * Decompiled with CFR 0.152.
 */
package com.spark.blockchain.rpcclient;

import com.spark.blockchain.rpcclient.Bitcoin;
import com.spark.blockchain.rpcclient.BitcoinException;
import com.spark.blockchain.rpcclient.BitcoinUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class BitcoinRawTxBuilder {
    public final Bitcoin bitcoin;
    public LinkedHashSet<Bitcoin.TxInput> inputs = new LinkedHashSet();
    public List<Bitcoin.TxOutput> outputs = new ArrayList<Bitcoin.TxOutput>();
    private HashMap<String, Bitcoin.RawTransaction> txCache = new HashMap();

    public BitcoinRawTxBuilder(Bitcoin bitcoin) {
        this.bitcoin = bitcoin;
    }

    public BitcoinRawTxBuilder in(Bitcoin.TxInput in) {
        this.inputs.add(new Input(in.txid(), in.vout()));
        return this;
    }

    public BitcoinRawTxBuilder in(String txid, int vout) {
        this.in(new Bitcoin.BasicTxInput(txid, vout));
        return this;
    }

    public BitcoinRawTxBuilder out(String address, BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            return this;
        }
        this.outputs.add(new Bitcoin.BasicTxOutput(address, amount));
        System.out.println("outputs=" + address + "," + amount.toPlainString());
        return this;
    }

    public BitcoinRawTxBuilder in(double value) throws BitcoinException {
        return this.in(value, 6);
    }

    public BitcoinRawTxBuilder in(double value, int minConf) throws BitcoinException {
        List<Bitcoin.Unspent> unspent = this.bitcoin.listUnspent(minConf);
        double v = value;
        for (Bitcoin.Unspent o : unspent) {
            if (!this.inputs.contains(new Input(o))) {
                this.in(o);
                v = BitcoinUtil.normalizeAmount(v - o.amount().doubleValue());
            }
            if (!(v < 0.0)) continue;
            break;
        }
        if (v > 0.0) {
            throw new BitcoinException("Not enough bitcoins (" + v + "/" + value + ")");
        }
        return this;
    }

    private Bitcoin.RawTransaction tx(String txId) throws BitcoinException {
        Bitcoin.RawTransaction tx = this.txCache.get(txId);
        if (tx != null) {
            return tx;
        }
        tx = this.bitcoin.getRawTransaction(txId);
        this.txCache.put(txId, tx);
        return tx;
    }

    public BitcoinRawTxBuilder outChange(String address) throws BitcoinException {
        return this.outChange(address, 0.0);
    }

    public BitcoinRawTxBuilder outChange(String address, double fee) throws BitcoinException {
        double is = 0.0;
        for (Bitcoin.TxInput i : this.inputs) {
            is = BitcoinUtil.normalizeAmount(is + this.tx(i.txid()).vOut().get(i.vout()).value());
        }
        double os = fee;
        for (Bitcoin.TxOutput o : this.outputs) {
            os = BitcoinUtil.normalizeAmount(os + o.amount().doubleValue());
        }
        if (os < is) {
            this.out(address, new BigDecimal(BitcoinUtil.normalizeAmount(is - os)));
        }
        return this;
    }

    public String create() throws BitcoinException {
        return this.bitcoin.createRawTransaction(new ArrayList<Bitcoin.TxInput>(this.inputs), this.outputs);
    }

    public String sign() throws BitcoinException {
        return this.bitcoin.signRawTransaction(this.create());
    }

    public String send() throws BitcoinException {
        return this.bitcoin.sendRawTransaction(this.sign());
    }

    private class Input
    extends Bitcoin.BasicTxInput {
        public Input(String txid, int vout) {
            super(txid, vout);
        }

        public Input(Bitcoin.TxInput copy) {
            this(copy.txid(), copy.vout());
        }

        public int hashCode() {
            return this.txid.hashCode() + this.vout;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Bitcoin.TxInput)) {
                return false;
            }
            Bitcoin.TxInput other = (Bitcoin.TxInput)obj;
            return this.vout == other.vout() && this.txid.equals(other.txid());
        }
    }
}

