/*
 * Decompiled with CFR 0.152.
 */
package com.spark.blockchain.rpcclient;

import com.spark.blockchain.rpcclient.Bitcoin;
import com.spark.blockchain.rpcclient.BitcoinException;
import com.spark.blockchain.rpcclient.BitcoinRawTxBuilder;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class BitcoinUtil {
    public static double normalizeAmount(double amount) {
        return (double)((long)(0.5 + amount / 1.0E-8)) * 1.0E-8;
    }

    public static String sendTransaction(Bitcoin bitcoin, String targetAddress, BigDecimal amount, BigDecimal txFee) throws BitcoinException {
        List<Bitcoin.Unspent> unspents = bitcoin.listUnspent(2);
        System.out.println("target=" + targetAddress + ",amount=" + amount.toPlainString() + ",+fee=" + txFee.toPlainString());
        BigDecimal moneySpent = BigDecimal.ZERO;
        BigDecimal moneyChange = BigDecimal.ZERO;
        if (unspents.size() == 0) {
            throw new BitcoinException("insufficient coin");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String account = "acct-change-" + df.format(new Date());
        String changeAddress = bitcoin.getAccountAddress(account);
        if (changeAddress == null) {
            changeAddress = bitcoin.getNewAddress(account);
        }
        System.out.println("change address:" + changeAddress);
        BitcoinRawTxBuilder builder = new BitcoinRawTxBuilder(bitcoin);
        for (Bitcoin.Unspent unspent : unspents) {
            moneySpent = moneySpent.add(unspent.amount());
            System.out.println("unspent=" + unspent.amount());
            builder.in(new Bitcoin.BasicTxInput(unspent.txid(), unspent.vout()));
            if (moneySpent.compareTo(amount.add(txFee)) < 0) continue;
            break;
        }
        if (moneySpent.compareTo(amount.add(txFee)) < 0) {
            throw new BitcoinException("insufficient coin");
        }
        moneyChange = moneySpent.subtract(amount.add(txFee));
        System.out.println("moneyChange:" + moneyChange.toPlainString());
        builder.out(targetAddress, amount);
        if (moneyChange.compareTo(BigDecimal.ZERO) > 0) {
            builder.out(changeAddress, moneyChange);
        }
        return builder.send();
    }

    public static String sendTransaction(Bitcoin bitcoin, String fromAddress, String targetAddress, BigDecimal amount, BigDecimal txFee) throws BitcoinException {
        List<Bitcoin.Unspent> unspents = bitcoin.listUnspent(1, 99999999, fromAddress);
        System.out.println("target=" + targetAddress + ",amount=" + amount.toPlainString() + ",fee=" + txFee.toPlainString());
        BigDecimal moneySpent = BigDecimal.ZERO;
        BigDecimal moneyChange = BigDecimal.ZERO;
        if (unspents.size() == 0) {
            throw new BitcoinException("insufficient coin");
        }
        String changeAddress = fromAddress;
        System.out.println("change address:" + changeAddress);
        BitcoinRawTxBuilder builder = new BitcoinRawTxBuilder(bitcoin);
        for (Bitcoin.Unspent unspent : unspents) {
            moneySpent = moneySpent.add(unspent.amount());
            System.out.println("unspent=" + unspent.amount());
            builder.in(new Bitcoin.BasicTxInput(unspent.txid(), unspent.vout()));
            if (moneySpent.compareTo(amount.add(txFee)) < 0) continue;
            break;
        }
        if (moneySpent.compareTo(amount.add(txFee)) < 0) {
            throw new BitcoinException("insufficient coin");
        }
        moneyChange = moneySpent.subtract(amount.add(txFee));
        System.out.println("moneyChange:" + moneyChange.toPlainString());
        builder.out(targetAddress, amount);
        if (moneyChange.compareTo(BigDecimal.ZERO) > 0) {
            builder.out(changeAddress, moneyChange);
        }
        return builder.send();
    }
}

