/*
 * Decompiled with CFR 0.152.
 */
package com.spark.blockchain.rpcclient;

import com.spark.blockchain.rpcclient.Bitcoin;
import com.spark.blockchain.rpcclient.BitcoinException;
import com.spark.blockchain.rpcclient.BitcoinPaymentListener;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BitcoinAcceptor
implements Runnable {
    private static final Logger logger = Logger.getLogger(BitcoinAcceptor.class.getCanonicalName());
    public final Bitcoin bitcoin;
    private String lastBlock;
    private String monitorBlock = null;
    int monitorDepth;
    private final LinkedHashSet<BitcoinPaymentListener> listeners = new LinkedHashSet();
    private HashSet<String> seen = new HashSet();
    private boolean stop = false;
    private long checkInterval = 5000L;

    public BitcoinAcceptor(Bitcoin bitcoin, String lastBlock, int monitorDepth) {
        this.bitcoin = bitcoin;
        this.lastBlock = lastBlock;
        this.monitorDepth = monitorDepth;
    }

    public BitcoinAcceptor(Bitcoin bitcoin) {
        this(bitcoin, null, 6);
    }

    public BitcoinAcceptor(Bitcoin bitcoin, String lastBlock, int monitorDepth, BitcoinPaymentListener listener) {
        this(bitcoin, lastBlock, monitorDepth);
        this.listeners.add(listener);
    }

    public BitcoinAcceptor(Bitcoin bitcoin, BitcoinPaymentListener listener) {
        this(bitcoin, null, 12);
        this.listeners.add(listener);
    }

    public String getAccountAddress(String account) throws BitcoinException {
        List<String> a = this.bitcoin.getAddressesByAccount(account);
        if (a.isEmpty()) {
            return this.bitcoin.getNewAddress(account);
        }
        return a.get(0);
    }

    public synchronized String getLastBlock() {
        return this.lastBlock;
    }

    public synchronized void setLastBlock(String lastBlock) throws BitcoinException {
        if (this.lastBlock != null) {
            throw new IllegalStateException("lastBlock already set");
        }
        this.lastBlock = lastBlock;
        this.updateMonitorBlock();
    }

    public synchronized BitcoinPaymentListener[] getListeners() {
        return this.listeners.toArray(new BitcoinPaymentListener[0]);
    }

    public synchronized void addListener(BitcoinPaymentListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(BitcoinPaymentListener listener) {
        this.listeners.remove(listener);
    }

    private void updateMonitorBlock() throws BitcoinException {
        this.monitorBlock = this.lastBlock;
        for (int i = 0; i < this.monitorDepth && this.monitorBlock != null; ++i) {
            Bitcoin.Block b = this.bitcoin.getBlock(this.monitorBlock);
            this.monitorBlock = b == null ? null : b.previousHash();
        }
    }

    public synchronized void checkPayments() throws BitcoinException {
        Bitcoin.TransactionsSinceBlock t = this.monitorBlock == null ? this.bitcoin.listSinceBlock() : this.bitcoin.listSinceBlock(this.monitorBlock);
        for (Bitcoin.Transaction transaction : t.transactions()) {
            if (!"receive".equals(transaction.category())) continue;
            for (BitcoinPaymentListener listener : this.listeners) {
                try {
                    listener.transaction(transaction);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        if (!t.lastBlock().equals(this.lastBlock)) {
            this.seen.clear();
            this.lastBlock = t.lastBlock();
            this.updateMonitorBlock();
            for (BitcoinPaymentListener listener : this.listeners) {
                try {
                    listener.block(this.lastBlock);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void stopAccepting() {
        this.stop = true;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    @Override
    public void run() {
        this.stop = false;
        long nextCheck = 0L;
        while (!Thread.interrupted() && !this.stop) {
            if (nextCheck <= System.currentTimeMillis()) {
                try {
                    nextCheck = System.currentTimeMillis() + this.checkInterval;
                    System.out.println("check...");
                    this.checkPayments();
                }
                catch (BitcoinException ex) {
                    Logger.getLogger(BitcoinAcceptor.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            try {
                Thread.sleep(Math.max(nextCheck - System.currentTimeMillis(), 100L));
            }
            catch (InterruptedException ex) {
                Logger.getLogger(BitcoinAcceptor.class.getName()).log(Level.WARNING, null, ex);
            }
        }
    }
}

