/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoin;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class NativeSecp256k1 {
    public static boolean enabled = false;
    private static ThreadLocal<ByteBuffer> nativeECDSABuffer;

    public static boolean verify(byte[] data, byte[] signature, byte[] pub) {
        Preconditions.checkArgument((data.length == 32 && signature.length <= 520 && pub.length <= 520 ? 1 : 0) != 0);
        ByteBuffer byteBuff = nativeECDSABuffer.get();
        if (byteBuff == null) {
            byteBuff = ByteBuffer.allocateDirect(1080);
            byteBuff.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuff);
        }
        byteBuff.rewind();
        byteBuff.put(data);
        byteBuff.putInt(signature.length);
        byteBuff.putInt(pub.length);
        byteBuff.put(signature);
        byteBuff.put(pub);
        return NativeSecp256k1.secp256k1_ecdsa_verify(byteBuff) == 1;
    }

    private static native int secp256k1_ecdsa_verify(ByteBuffer var0);

    static {
        try {
            System.loadLibrary("javasecp256k1");
        }
        catch (UnsatisfiedLinkError e) {
            enabled = false;
        }
        nativeECDSABuffer = new ThreadLocal();
    }
}

