/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.VarInt;

public class AddressMessage
extends Message {
    private static final long serialVersionUID = 8058283864924679460L;
    private static final long MAX_ADDRESSES = 1024L;
    private List<PeerAddress> addresses;
    private transient long numAddresses = -1L;

    AddressMessage(NetworkParameters params, byte[] payload, int offset, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        super(params, payload, offset, parseLazy, parseRetain, length);
    }

    AddressMessage(NetworkParameters params, byte[] payload, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        super(params, payload, 0, parseLazy, parseRetain, length);
    }

    AddressMessage(NetworkParameters params, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset, false, false, Integer.MIN_VALUE);
    }

    AddressMessage(NetworkParameters params, byte[] payload) throws ProtocolException {
        super(params, payload, 0, false, false, Integer.MIN_VALUE);
    }

    @Override
    protected void parseLite() throws ProtocolException {
    }

    @Override
    void parse() throws ProtocolException {
        this.numAddresses = this.readVarInt();
        if (this.numAddresses > 1024L) {
            throw new ProtocolException("Address message too large.");
        }
        this.addresses = new ArrayList<PeerAddress>((int)this.numAddresses);
        int i = 0;
        while ((long)i < this.numAddresses) {
            PeerAddress addr = new PeerAddress(this.params, this.payload, this.cursor, this.protocolVersion, this, this.parseLazy, this.parseRetain);
            this.addresses.add(addr);
            this.cursor += addr.getMessageSize();
            ++i;
        }
        this.length = this.cursor - this.offset;
    }

    @Override
    void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        if (this.addresses == null) {
            return;
        }
        stream.write(new VarInt(this.addresses.size()).encode());
        for (PeerAddress addr : this.addresses) {
            addr.bitcoinSerialize(stream);
        }
    }

    @Override
    public int getMessageSize() {
        if (this.length != Integer.MIN_VALUE) {
            return this.length;
        }
        if (this.addresses != null) {
            this.length = new VarInt(this.addresses.size()).getSizeInBytes();
            this.length += this.addresses.size() * (this.protocolVersion > 31402 ? 30 : 26);
        }
        return this.length;
    }

    @Override
    void setChecksum(byte[] checksum) {
        if (this.parseRetain) {
            super.setChecksum(checksum);
        } else {
            this.checksum = null;
        }
    }

    public List<PeerAddress> getAddresses() {
        this.maybeParse();
        return Collections.unmodifiableList(this.addresses);
    }

    public void addAddress(PeerAddress address) {
        this.unCache();
        this.maybeParse();
        address.setParent(this);
        this.addresses.add(address);
        if (this.length == Integer.MIN_VALUE) {
            this.getMessageSize();
        } else {
            this.length += address.getMessageSize();
        }
    }

    public void removeAddress(int index) {
        this.unCache();
        PeerAddress address = this.addresses.remove(index);
        address.setParent(null);
        if (this.length == Integer.MIN_VALUE) {
            this.getMessageSize();
        } else {
            this.length -= address.getMessageSize();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("addr: ");
        for (PeerAddress a : this.addresses) {
            builder.append(a.toString());
            builder.append(" ");
        }
        return builder.toString();
    }
}

