/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.Semaphore;
import org.bitcoinj.core.AbstractPeerEventListener;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Peer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadListener
extends AbstractPeerEventListener {
    private static final Logger log = LoggerFactory.getLogger(DownloadListener.class);
    private int originalBlocksLeft = -1;
    private int lastPercent = 0;
    private Semaphore done = new Semaphore(0);
    private boolean caughtUp = false;

    @Override
    public void onChainDownloadStarted(Peer peer, int blocksLeft) {
        this.startDownload(blocksLeft);
        if (this.originalBlocksLeft == -1) {
            this.originalBlocksLeft = blocksLeft;
        } else {
            log.info("Chain download switched to {}", (Object)peer);
        }
        if (blocksLeft == 0) {
            this.doneDownload();
            this.done.release();
        }
    }

    @Override
    public void onBlocksDownloaded(Peer peer, Block block, int blocksLeft) {
        if (this.caughtUp) {
            return;
        }
        if (blocksLeft == 0) {
            this.caughtUp = true;
            this.doneDownload();
            this.done.release();
        }
        if (blocksLeft < 0 || this.originalBlocksLeft <= 0) {
            return;
        }
        double pct = 100.0 - 100.0 * ((double)blocksLeft / (double)this.originalBlocksLeft);
        if ((int)pct != this.lastPercent) {
            this.progress(pct, blocksLeft, new Date(block.getTimeSeconds() * 1000L));
            this.lastPercent = (int)pct;
        }
    }

    protected void progress(double pct, int blocksSoFar, Date date) {
        log.info(String.format("Chain download %d%% done with %d blocks to go, block date %s", (int)pct, blocksSoFar, DateFormat.getDateTimeInstance().format(date)));
    }

    protected void startDownload(int blocks) {
        if (blocks > 0 && this.originalBlocksLeft == -1) {
            log.info("Downloading block chain of size " + blocks + ". " + (blocks > 1000 ? "This may take a while." : ""));
        }
    }

    protected void doneDownload() {
    }

    public void await() throws InterruptedException {
        this.done.acquire();
    }
}

