/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.bitcoinj.core.ChildMessage;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Utils;
import org.bitcoinj.params.MainNetParams;

public class PeerAddress
extends ChildMessage {
    private static final long serialVersionUID = 7501293709324197411L;
    static final int MESSAGE_SIZE = 30;
    private InetAddress addr;
    private int port;
    private BigInteger services;
    private long time;

    public PeerAddress(NetworkParameters params, byte[] payload, int offset, int protocolVersion) throws ProtocolException {
        super(params, payload, offset, protocolVersion);
    }

    public PeerAddress(NetworkParameters params, byte[] payload, int offset, int protocolVersion, Message parent, boolean parseLazy, boolean parseRetain) throws ProtocolException {
        super(params, payload, offset, protocolVersion, parent, parseLazy, parseRetain, Integer.MIN_VALUE);
    }

    public PeerAddress(InetAddress addr, int port, int protocolVersion) {
        this.addr = (InetAddress)Preconditions.checkNotNull((Object)addr);
        this.port = port;
        this.protocolVersion = protocolVersion;
        this.services = BigInteger.ZERO;
        this.length = protocolVersion > 31402 ? 30 : 26;
    }

    public PeerAddress(InetAddress addr, int port) {
        this(addr, port, 70002);
    }

    public PeerAddress(InetAddress addr) {
        this(addr, MainNetParams.get().getPort());
    }

    public PeerAddress(InetSocketAddress addr) {
        this(addr.getAddress(), addr.getPort());
    }

    public static PeerAddress localhost(NetworkParameters params) {
        return new PeerAddress(InetAddresses.forString((String)"127.0.0.1"), params.getPort());
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        if (this.protocolVersion >= 31402) {
            int secs = (int)Utils.currentTimeSeconds();
            Utils.uint32ToByteStreamLE(secs, stream);
        }
        Utils.uint64ToByteStreamLE(this.services, stream);
        byte[] ipBytes = this.addr.getAddress();
        if (ipBytes.length == 4) {
            byte[] v6addr = new byte[16];
            System.arraycopy(ipBytes, 0, v6addr, 12, 4);
            v6addr[10] = -1;
            v6addr[11] = -1;
            ipBytes = v6addr;
        }
        stream.write(ipBytes);
        stream.write((byte)(0xFF & this.port >> 8));
        stream.write((byte)(0xFF & this.port));
    }

    @Override
    protected void parseLite() {
        this.length = this.protocolVersion > 31402 ? 30 : 26;
    }

    @Override
    protected void parse() throws ProtocolException {
        this.time = this.protocolVersion > 31402 ? this.readUint32() : -1L;
        this.services = this.readUint64();
        byte[] addrBytes = this.readBytes(16);
        try {
            this.addr = InetAddress.getByAddress(addrBytes);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.port = (0xFF & this.payload[this.cursor++]) << 8 | 0xFF & this.payload[this.cursor++];
    }

    @Override
    public int getMessageSize() {
        this.length = this.protocolVersion > 31402 ? 30 : 26;
        return this.length;
    }

    public InetAddress getAddr() {
        this.maybeParse();
        return this.addr;
    }

    public void setAddr(InetAddress addr) {
        this.unCache();
        this.addr = addr;
    }

    public int getPort() {
        this.maybeParse();
        return this.port;
    }

    public void setPort(int port) {
        this.unCache();
        this.port = port;
    }

    public BigInteger getServices() {
        this.maybeParse();
        return this.services;
    }

    public void setServices(BigInteger services) {
        this.unCache();
        this.services = services;
    }

    public long getTime() {
        this.maybeParse();
        return this.time;
    }

    public void setTime(long time) {
        this.unCache();
        this.time = time;
    }

    public String toString() {
        return "[" + this.addr.getHostAddress() + "]:" + this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeerAddress other = (PeerAddress)o;
        return other.addr.equals(this.addr) && other.port == this.port && other.services.equals(this.services) && other.time == this.time;
    }

    public int hashCode() {
        return this.addr.hashCode() ^ this.port ^ (int)this.time ^ this.services.hashCode();
    }

    public InetSocketAddress toSocketAddress() {
        return new InetSocketAddress(this.addr, this.port);
    }
}

