/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Utils;

public class Pong
extends Message {
    public static final int MIN_PROTOCOL_VERSION = 60001;
    private long nonce;

    public Pong(NetworkParameters params, byte[] payloadBytes) throws ProtocolException {
        super(params, payloadBytes, 0);
    }

    public Pong(long nonce) {
        this.nonce = nonce;
    }

    @Override
    void parse() throws ProtocolException {
        this.nonce = this.readInt64();
        this.length = 8;
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        Utils.int64ToByteStreamLE(this.nonce, stream);
    }

    @Override
    protected void parseLite() {
    }

    public long getNonce() {
        return this.nonce;
    }
}

