/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Nullable;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VarInt;

public class VersionMessage
extends Message {
    private static final long serialVersionUID = 7313594258967483180L;
    public static final int NODE_NETWORK = 1;
    public static final int NODE_GETUTXOS = 2;
    public int clientVersion;
    public long localServices;
    public long time;
    public PeerAddress myAddr;
    public PeerAddress theirAddr;
    public String subVer;
    public long bestHeight;
    public boolean relayTxesBeforeFilter;
    public static final String BITCOINJ_VERSION = "0.13-SNAPSHOT";
    public static final String LIBRARY_SUBVER = "/bitcoinj:0.13-SNAPSHOT/";

    public VersionMessage(NetworkParameters params, byte[] payload) throws ProtocolException {
        super(params, payload, 0);
    }

    public VersionMessage(NetworkParameters params, int newBestHeight) {
        super(params);
        this.clientVersion = 70002;
        this.localServices = 0L;
        this.time = System.currentTimeMillis() / 1000L;
        try {
            byte[] localhost = new byte[]{127, 0, 0, 1};
            this.myAddr = new PeerAddress(InetAddress.getByAddress(localhost), params.getPort(), 0);
            this.theirAddr = new PeerAddress(InetAddress.getByAddress(localhost), params.getPort(), 0);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.subVer = LIBRARY_SUBVER;
        this.bestHeight = newBestHeight;
        this.relayTxesBeforeFilter = true;
        this.length = 85;
        if (this.protocolVersion > 31402) {
            this.length += 8;
        }
        this.length += VarInt.sizeOf(this.subVer.length()) + this.subVer.length();
    }

    @Override
    protected void parseLite() throws ProtocolException {
    }

    @Override
    public void parse() throws ProtocolException {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        this.clientVersion = (int)this.readUint32();
        this.localServices = this.readUint64().longValue();
        this.time = this.readUint64().longValue();
        this.myAddr = new PeerAddress(this.params, this.payload, this.cursor, 0);
        this.cursor += this.myAddr.getMessageSize();
        this.theirAddr = new PeerAddress(this.params, this.payload, this.cursor, 0);
        this.cursor += this.theirAddr.getMessageSize();
        this.readUint64();
        try {
            this.subVer = "";
            this.bestHeight = 0L;
            this.relayTxesBeforeFilter = true;
            if (!this.hasMoreBytes()) {
                return;
            }
            this.subVer = this.readStr();
            if (!this.hasMoreBytes()) {
                return;
            }
            this.bestHeight = this.readUint32();
            if (!this.hasMoreBytes()) {
                return;
            }
            this.relayTxesBeforeFilter = this.readBytes(1)[0] != 0;
        }
        finally {
            this.length = this.cursor - this.offset;
        }
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream buf) throws IOException {
        Utils.uint32ToByteStreamLE(this.clientVersion, buf);
        Utils.uint32ToByteStreamLE(this.localServices, buf);
        Utils.uint32ToByteStreamLE(this.localServices >> 32, buf);
        Utils.uint32ToByteStreamLE(this.time, buf);
        Utils.uint32ToByteStreamLE(this.time >> 32, buf);
        try {
            this.myAddr.bitcoinSerialize(buf);
            this.theirAddr.bitcoinSerialize(buf);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Utils.uint32ToByteStreamLE(0L, buf);
        Utils.uint32ToByteStreamLE(0L, buf);
        byte[] subVerBytes = this.subVer.getBytes("UTF-8");
        buf.write(new VarInt(subVerBytes.length).encode());
        buf.write(subVerBytes);
        Utils.uint32ToByteStreamLE(this.bestHeight, buf);
        buf.write(this.relayTxesBeforeFilter ? 1 : 0);
    }

    public boolean hasBlockChain() {
        return (this.localServices & 1L) == 1L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionMessage other = (VersionMessage)o;
        return other.bestHeight == this.bestHeight && other.clientVersion == this.clientVersion && other.localServices == this.localServices && other.time == this.time && other.subVer.equals(this.subVer) && other.myAddr.equals(this.myAddr) && other.theirAddr.equals(this.theirAddr) && other.relayTxesBeforeFilter == this.relayTxesBeforeFilter;
    }

    public int hashCode() {
        return (int)this.bestHeight ^ this.clientVersion ^ (int)this.localServices ^ (int)this.time ^ this.subVer.hashCode() ^ this.myAddr.hashCode() ^ this.theirAddr.hashCode() * (this.relayTxesBeforeFilter ? 1 : 2);
    }

    @Override
    byte[] getChecksum() {
        throw new UnsupportedOperationException();
    }

    @Override
    void setChecksum(byte[] checksum) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("client version: ").append(this.clientVersion).append("\n");
        sb.append("local services: ").append(this.localServices).append("\n");
        sb.append("time:           ").append(this.time).append("\n");
        sb.append("my addr:        ").append(this.myAddr).append("\n");
        sb.append("their addr:     ").append(this.theirAddr).append("\n");
        sb.append("sub version:    ").append(this.subVer).append("\n");
        sb.append("best height:    ").append(this.bestHeight).append("\n");
        sb.append("delay tx relay: ").append(!this.relayTxesBeforeFilter).append("\n");
        return sb.toString();
    }

    public VersionMessage duplicate() {
        VersionMessage v = new VersionMessage(this.params, (int)this.bestHeight);
        v.clientVersion = this.clientVersion;
        v.localServices = this.localServices;
        v.time = this.time;
        v.myAddr = this.myAddr;
        v.theirAddr = this.theirAddr;
        v.subVer = this.subVer;
        v.relayTxesBeforeFilter = this.relayTxesBeforeFilter;
        return v;
    }

    public void appendToSubVer(String name, String version, @Nullable String comments) {
        VersionMessage.checkSubVerComponent(name);
        VersionMessage.checkSubVerComponent(version);
        if (comments != null) {
            VersionMessage.checkSubVerComponent(comments);
            this.subVer = this.subVer.concat(String.format("%s:%s(%s)/", name, version, comments));
        } else {
            this.subVer = this.subVer.concat(String.format("%s:%s/", name, version));
        }
    }

    private static void checkSubVerComponent(String component) {
        if (component.contains("/") || component.contains("(") || component.contains(")")) {
            throw new IllegalArgumentException("name contains invalid characters");
        }
    }

    public boolean isPingPongSupported() {
        return this.clientVersion >= 60001;
    }

    public boolean isBloomFilteringSupported() {
        return this.clientVersion >= 70000;
    }

    public boolean isGetUTXOsSupported() {
        return this.clientVersion >= 70003 && (this.localServices & 2L) == 2L;
    }
}

