/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.Utils;

public class VersionedChecksummedBytes
implements Serializable {
    protected final int version;
    protected byte[] bytes;

    protected VersionedChecksummedBytes(String encoded) throws AddressFormatException {
        byte[] versionAndDataBytes = Base58.decodeChecked(encoded);
        byte versionByte = versionAndDataBytes[0];
        this.version = versionByte & 0xFF;
        this.bytes = new byte[versionAndDataBytes.length - 1];
        System.arraycopy(versionAndDataBytes, 1, this.bytes, 0, versionAndDataBytes.length - 1);
    }

    protected VersionedChecksummedBytes(int version, byte[] bytes) {
        Preconditions.checkArgument((version >= 0 && version < 256 ? 1 : 0) != 0);
        this.version = version;
        this.bytes = bytes;
    }

    public String toString() {
        byte[] addressBytes = new byte[1 + this.bytes.length + 4];
        addressBytes[0] = (byte)this.version;
        System.arraycopy(this.bytes, 0, addressBytes, 1, this.bytes.length);
        byte[] checksum = Utils.doubleDigest(addressBytes, 0, this.bytes.length + 1);
        System.arraycopy(checksum, 0, addressBytes, this.bytes.length + 1, 4);
        return Base58.encode(addressBytes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.version, Arrays.hashCode(this.bytes)});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedChecksummedBytes other = (VersionedChecksummedBytes)o;
        return this.version == other.version && Arrays.equals(this.bytes, other.bytes);
    }

    public int getVersion() {
        return this.version;
    }
}

