/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.bitcoinj.net.MessageWriteTarget;
import org.bitcoinj.net.StreamParser;
import org.bitcoinj.net.StreamParserFactory;
import org.bitcoinj.utils.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionHandler
implements MessageWriteTarget {
    private static final Logger log = LoggerFactory.getLogger(ConnectionHandler.class);
    private static final int BUFFER_SIZE_LOWER_BOUND = 4096;
    private static final int BUFFER_SIZE_UPPER_BOUND = 65536;
    private static final int OUTBOUND_BUFFER_BYTE_COUNT = 33554456;
    private final ReentrantLock lock = Threading.lock("nioConnectionHandler");
    @GuardedBy(value="lock")
    private final ByteBuffer readBuff;
    @GuardedBy(value="lock")
    private final SocketChannel channel;
    @GuardedBy(value="lock")
    private final SelectionKey key;
    @GuardedBy(value="lock")
    StreamParser parser;
    @GuardedBy(value="lock")
    private boolean closeCalled = false;
    @GuardedBy(value="lock")
    private long bytesToWriteRemaining = 0L;
    @GuardedBy(value="lock")
    private final LinkedList<ByteBuffer> bytesToWrite = new LinkedList();
    private Set<ConnectionHandler> connectedHandlers;

    public ConnectionHandler(StreamParserFactory parserFactory, SelectionKey key) throws IOException {
        this(parserFactory.getNewParser(((SocketChannel)key.channel()).socket().getInetAddress(), ((SocketChannel)key.channel()).socket().getPort()), key);
        if (this.parser == null) {
            throw new IOException("Parser factory.getNewParser returned null");
        }
    }

    private ConnectionHandler(@Nullable StreamParser parser, SelectionKey key) {
        this.key = key;
        this.channel = (SocketChannel)Preconditions.checkNotNull((Object)((SocketChannel)key.channel()));
        if (parser == null) {
            this.readBuff = null;
            return;
        }
        this.parser = parser;
        this.readBuff = ByteBuffer.allocateDirect(Math.min(Math.max(parser.getMaxMessageSize(), 4096), 65536));
        parser.setWriteTarget(this);
        this.connectedHandlers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionHandler(StreamParser parser, SelectionKey key, Set<ConnectionHandler> connectedHandlers) {
        this((StreamParser)Preconditions.checkNotNull((Object)parser), key);
        this.lock.lock();
        boolean alreadyClosed = false;
        try {
            alreadyClosed = this.closeCalled;
            this.connectedHandlers = connectedHandlers;
            if (!alreadyClosed) {
                Preconditions.checkState((boolean)connectedHandlers.add(this));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private void setWriteOps() {
        this.key.interestOps(this.key.interestOps() | 4);
        this.key.selector().wakeup();
    }

    private void tryWriteBytes() throws IOException {
        this.lock.lock();
        try {
            Iterator bytesIterator = this.bytesToWrite.iterator();
            while (bytesIterator.hasNext()) {
                ByteBuffer buff = (ByteBuffer)bytesIterator.next();
                this.bytesToWriteRemaining -= (long)this.channel.write(buff);
                if (!buff.hasRemaining()) {
                    bytesIterator.remove();
                    continue;
                }
                this.setWriteOps();
                break;
            }
            if (this.bytesToWrite.isEmpty()) {
                this.key.interestOps(this.key.interestOps() & 0xFFFFFFFB);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void writeBytes(byte[] message) throws IOException {
        this.lock.lock();
        try {
            if (this.bytesToWriteRemaining + (long)message.length > 33554456L) {
                throw new IOException("Outbound buffer overflowed");
            }
            this.bytesToWrite.offer(ByteBuffer.wrap(Arrays.copyOf(message, message.length)));
            this.bytesToWriteRemaining += (long)message.length;
            this.setWriteOps();
        }
        catch (IOException e) {
            this.lock.unlock();
            log.error("Error writing message to connection, closing connection", (Throwable)e);
            this.closeConnection();
            throw e;
        }
        catch (CancelledKeyException e) {
            this.lock.unlock();
            log.error("Error writing message to connection, closing connection", (Throwable)e);
            this.closeConnection();
            throw new IOException(e);
        }
        this.lock.unlock();
    }

    @Override
    public void closeConnection() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.connectionClosed();
    }

    private void connectionClosed() {
        boolean callClosed = false;
        this.lock.lock();
        try {
            callClosed = !this.closeCalled;
            this.closeCalled = true;
        }
        finally {
            this.lock.unlock();
        }
        if (callClosed) {
            Preconditions.checkState((this.connectedHandlers == null || this.connectedHandlers.remove(this) ? 1 : 0) != 0);
            this.parser.connectionClosed();
        }
    }

    public static void handleKey(SelectionKey key) {
        ConnectionHandler handler = (ConnectionHandler)key.attachment();
        try {
            if (handler == null) {
                return;
            }
            if (!key.isValid()) {
                handler.closeConnection();
                return;
            }
            if (key.isReadable()) {
                int read = handler.channel.read(handler.readBuff);
                if (read == 0) {
                    return;
                }
                if (read == -1) {
                    key.cancel();
                    handler.closeConnection();
                    return;
                }
                handler.readBuff.flip();
                int bytesConsumed = ((StreamParser)Preconditions.checkNotNull((Object)handler.parser)).receiveBytes(handler.readBuff);
                Preconditions.checkState((handler.readBuff.position() == bytesConsumed ? 1 : 0) != 0);
                handler.readBuff.compact();
            }
            if (key.isWritable()) {
                handler.tryWriteBytes();
            }
        }
        catch (Exception e) {
            Throwable t = Throwables.getRootCause((Throwable)e);
            log.error("Error handling SelectionKey: {}", (Object)(t.getMessage() != null ? t.getMessage() : t.getClass().getName()));
            handler.closeConnection();
        }
    }
}

