/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.bitcoinj.net.AbstractTimeoutHandler;
import org.bitcoinj.net.MessageWriteTarget;
import org.bitcoinj.net.NioClientManager;
import org.bitcoinj.net.StreamParser;

public class NioClient
implements MessageWriteTarget {
    private final Handler handler;
    private final NioClientManager manager = new NioClientManager();

    public NioClient(SocketAddress serverAddress, StreamParser parser, int connectTimeoutMillis) throws IOException {
        this.manager.startAsync();
        this.manager.awaitRunning();
        this.handler = new Handler(parser, connectTimeoutMillis);
        this.manager.openConnection(serverAddress, this.handler);
    }

    @Override
    public void closeConnection() {
        this.handler.writeTarget.closeConnection();
    }

    @Override
    public synchronized void writeBytes(byte[] message) throws IOException {
        this.handler.writeTarget.writeBytes(message);
    }

    class Handler
    extends AbstractTimeoutHandler
    implements StreamParser {
        private final StreamParser upstreamParser;
        private MessageWriteTarget writeTarget;
        private boolean closeOnOpen = false;
        private boolean closeCalled = false;

        Handler(StreamParser upstreamParser, int connectTimeoutMillis) {
            this.upstreamParser = upstreamParser;
            this.setSocketTimeout(connectTimeoutMillis);
            this.setTimeoutEnabled(true);
        }

        @Override
        protected synchronized void timeoutOccurred() {
            this.closeOnOpen = true;
            this.connectionClosed();
        }

        @Override
        public synchronized void connectionClosed() {
            NioClient.this.manager.stopAsync();
            if (!this.closeCalled) {
                this.closeCalled = true;
                this.upstreamParser.connectionClosed();
            }
        }

        @Override
        public synchronized void connectionOpened() {
            if (!this.closeOnOpen) {
                this.upstreamParser.connectionOpened();
            }
        }

        @Override
        public int receiveBytes(ByteBuffer buff) throws Exception {
            return this.upstreamParser.receiveBytes(buff);
        }

        @Override
        public synchronized void setWriteTarget(MessageWriteTarget writeTarget) {
            if (this.closeOnOpen) {
                writeTarget.closeConnection();
            } else {
                this.setTimeoutEnabled(false);
                this.writeTarget = writeTarget;
                this.upstreamParser.setWriteTarget(writeTarget);
            }
        }

        @Override
        public int getMaxMessageSize() {
            return this.upstreamParser.getMaxMessageSize();
        }
    }
}

