/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net.discovery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.subgraph.orchid.Circuit;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.RelayCell;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.TorClient;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.path.CircuitPathChooser;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.utils.DaemonThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorDiscovery
implements PeerDiscovery {
    private static final Logger log = LoggerFactory.getLogger(TorDiscovery.class);
    public static final int MINIMUM_ROUTER_COUNT = 4;
    public static final int ROUTER_LOOKUP_COUNT = 10;
    public static final int MINIMUM_ROUTER_LOOKUP_COUNT = 6;
    public static final int RECEIVE_RETRIES = 3;
    public static final int RESOLVE_STREAM_ID = 4096;
    public static final int RESOLVE_CNAME = 0;
    public static final int RESOLVE_ERROR = 240;
    public static final int RESOLVE_IPV4 = 4;
    public static final int RESOLVE_IPV6 = 6;
    private final String[] hostNames;
    private final NetworkParameters netParams;
    private final CircuitPathChooser pathChooser;
    private final TorClient torClient;
    private ListeningExecutorService threadPool;

    public TorDiscovery(NetworkParameters netParams, TorClient torClient) {
        this(netParams.getDnsSeeds(), netParams, torClient);
    }

    public TorDiscovery(String[] hostNames, NetworkParameters netParams, TorClient torClient) {
        this.hostNames = hostNames;
        this.netParams = netParams;
        this.torClient = torClient;
        this.pathChooser = CircuitPathChooser.create((TorConfig)torClient.getConfig(), (Directory)torClient.getDirectory());
    }

    @Override
    public InetSocketAddress[] getPeers(long timeoutValue, TimeUnit timeoutUnit) throws PeerDiscoveryException {
        if (this.hostNames == null) {
            throw new PeerDiscoveryException("Unable to find any peers via DNS");
        }
        HashSet routers = Sets.newHashSet();
        ArrayList dummyTargets = Lists.newArrayList();
        while (routers.size() < 10) {
            Router router = this.pathChooser.chooseExitNodeForTargets((List)dummyTargets);
            routers.add(router);
        }
        try {
            List<Circuit> circuits = this.getCircuits(this.torClient.getConfig().getCircuitBuildTimeout(), TimeUnit.MILLISECONDS, routers);
            if (circuits.isEmpty()) {
                throw new PeerDiscoveryException("Failed to open any circuit within " + String.valueOf(timeoutValue) + " " + (Object)((Object)timeoutUnit));
            }
            Collection<InetSocketAddress> addresses = this.lookupAddresses(timeoutValue, timeoutUnit, circuits);
            if (addresses.size() < 4) {
                throw new PeerDiscoveryException("Unable to find enough peers via Tor - got " + addresses.size());
            }
            ArrayList addressList = Lists.newArrayList();
            addressList.addAll(addresses);
            Collections.shuffle(addressList);
            return addressList.toArray(new InetSocketAddress[addressList.size()]);
        }
        catch (InterruptedException e) {
            throw new PeerDiscoveryException(e);
        }
    }

    private List<Circuit> getCircuits(long timeoutValue, TimeUnit timeoutUnit, Set<Router> routers) throws InterruptedException {
        Preconditions.checkArgument((routers.size() >= 6 ? 1 : 0) != 0, (String)"Set of {} routers is smaller than required minimum {}", (Object[])new Object[]{routers.size(), 6});
        this.createThreadPool(routers.size());
        try {
            ArrayList circuitFutures = Lists.newArrayList();
            final CountDownLatch doneSignal = new CountDownLatch(6);
            for (final Router router : routers) {
                ListenableFuture openCircuit = this.threadPool.submit((Callable)new Callable<Circuit>(){

                    @Override
                    public Circuit call() throws Exception {
                        return TorDiscovery.this.torClient.getCircuitManager().openInternalCircuitTo((List)Lists.newArrayList((Object[])new Router[]{router}));
                    }
                });
                Futures.addCallback((ListenableFuture)openCircuit, (FutureCallback)new FutureCallback<Circuit>(){

                    public void onSuccess(Circuit circuit) {
                        doneSignal.countDown();
                    }

                    public void onFailure(Throwable thrown) {
                        doneSignal.countDown();
                    }
                });
                circuitFutures.add(openCircuit);
            }
            boolean countedDown = doneSignal.await(timeoutValue, timeoutUnit);
            try {
                ArrayList<Circuit> circuits = new ArrayList<Circuit>((Collection)Futures.successfulAsList((Iterable)circuitFutures).get());
                circuits.removeAll(Collections.singleton(null));
                int failures = routers.size() - circuits.size();
                if (failures > 0) {
                    log.warn("{} failures " + (countedDown ? "" : "(including timeout) ") + "opening DNS lookup circuits", (Object)failures);
                }
                ArrayList<Circuit> arrayList = circuits;
                return arrayList;
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.shutdownThreadPool();
        }
    }

    private Collection<InetSocketAddress> lookupAddresses(long timeoutValue, TimeUnit timeoutUnit, List<Circuit> circuits) throws InterruptedException {
        this.createThreadPool(circuits.size() * this.hostNames.length);
        try {
            ArrayList lookupFutures = Lists.newArrayList();
            for (final Circuit circuit : circuits) {
                for (final String seed : this.hostNames) {
                    lookupFutures.add(this.threadPool.submit((Callable)new Callable<Lookup>(){

                        @Override
                        public Lookup call() throws Exception {
                            return new Lookup(circuit.getFinalCircuitNode().getRouter(), TorDiscovery.this.lookup(circuit, seed));
                        }
                    }));
                }
            }
            this.threadPool.awaitTermination(timeoutValue, timeoutUnit);
            int timeouts = 0;
            for (ListenableFuture future : lookupFutures) {
                if (future.isDone()) continue;
                ++timeouts;
                future.cancel(true);
            }
            if (timeouts > 0) {
                log.warn("{} DNS lookups timed out", (Object)timeouts);
            }
            try {
                ArrayList arrayList = new ArrayList((Collection)Futures.successfulAsList((Iterable)lookupFutures).get());
                arrayList.removeAll(Collections.singleton(null));
                HashMap lookupMap = Maps.newHashMap();
                for (Lookup lookup : arrayList) {
                    InetSocketAddress address = new InetSocketAddress(lookup.address, this.netParams.getPort());
                    lookupMap.put(lookup.router.getIdentityHash(), address);
                }
                Collection collection = lookupMap.values();
                return collection;
            }
            catch (ExecutionException executionException) {
                throw new RuntimeException(executionException);
            }
        }
        finally {
            this.shutdownThreadPool();
        }
    }

    private synchronized void shutdownThreadPool() {
        this.threadPool.shutdownNow();
        this.threadPool = null;
    }

    private synchronized void createThreadPool(int size) {
        this.threadPool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(size, new DaemonThreadFactory()));
    }

    private InetAddress lookup(Circuit circuit, String seed) throws UnknownHostException {
        RelayCell cell = circuit.createRelayCell(11, 4096, circuit.getFinalCircuitNode());
        cell.putString(seed);
        circuit.sendRelayCell(cell);
        for (int i = 0; i < 3; ++i) {
            RelayCell res = circuit.receiveRelayCell();
            if (res == null) continue;
            while (res.cellBytesRemaining() > 0) {
                int type = res.getByte();
                int len = res.getByte();
                byte[] value = new byte[len];
                res.getByteArray(value);
                int ttl = res.getInt();
                if (type == 0 || type >= 240) {
                    throw new RuntimeException(new String(value));
                }
                if (type != 4 && type != 6) continue;
                return InetAddress.getByAddress(value);
            }
            break;
        }
        throw new RuntimeException("Could not look up " + seed);
    }

    @Override
    public synchronized void shutdown() {
        if (this.threadPool != null) {
            this.shutdownThreadPool();
        }
    }

    private static class Lookup {
        final Router router;
        final InetAddress address;

        Lookup(Router router, InetAddress address) {
            this.router = router;
            this.address = address;
        }
    }
}

