/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.params;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.bitcoinj.core.BitcointVerifyFunction;
import org.bitcoinj.core.Block;
import org.bitcoinj.params.TestNet2Params;

public class RegTestParams
extends TestNet2Params {
    private static final BigInteger MAX_TARGET = new BigInteger("7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", 16);
    private static Block genesis;
    private static RegTestParams instance;

    public RegTestParams() {
        this.blockVerifyFunction = new BitcointVerifyFunction();
        this.interval = 10000;
        this.maxTarget = MAX_TARGET;
        this.subsidyDecreaseBlockCount = 150;
        this.port = 18444;
        this.id = "org.bitcoin.regtest";
    }

    @Override
    public boolean allowEmptyPeerChain() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getGenesisBlock() {
        Class<RegTestParams> clazz = RegTestParams.class;
        synchronized (RegTestParams.class) {
            if (genesis == null) {
                genesis = super.getGenesisBlock();
                genesis.setNonce(2L);
                genesis.setDifficultyTarget(545259519L);
                genesis.setTime(1296688602L);
                Preconditions.checkState((boolean)genesis.getHashAsString().toLowerCase().equals("0f9188f13cb7b2c71f2a335e3a4fc328bf5beb436012afca590b1a11466e2206"));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return genesis;
        }
    }

    public static synchronized RegTestParams get() {
        if (instance == null) {
            instance = new RegTestParams();
        }
        return instance;
    }

    @Override
    public String getPaymentProtocolId() {
        return null;
    }
}

